/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.quartz.adapters;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.ebpm.connectors.quartz.adapters.IQuartzAdapter;
import org.eclipse.ebpm.messaging.api.Message;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DefaultQuartzAdapter
implements IQuartzAdapter {
    private static final String dateFormat = "dd/MM/yyyy HH:mm:ss.SSS";

    protected String asString(Object value) {
        return value != null ? value.toString() : null;
    }

    @Override
    public void populateNormalizedMessage(Message message, JobExecutionContext context) throws JobExecutionException {
        JobDetail detail = context.getJobDetail();
        JobDataMap dataMap = detail.getJobDataMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("org.spagic3.quartz.ComponentName") || key.equals("org.spagic3.quartz.EndpointName")) continue;
            Object value = entry.getValue();
            message.setHeader(key, value);
        }
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("timer");
        Element name = root.addElement("name");
        name.setText(detail.getName());
        Element group = root.addElement("group");
        group.setText(detail.getGroup());
        Element fullname = root.addElement("fullname");
        fullname.setText(detail.getFullName());
        Element description = root.addElement("description");
        description.setText(detail.getDescription());
        Element fireTimeFormat = root.addElement("fireTime_format");
        fireTimeFormat.setText(dateFormat);
        Element fireTime = root.addElement("fireTime");
        fireTime.setText(format.format(context.getFireTime()));
        message.setBody(document.asXML());
    }
}

