/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.messaging.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Type;
import org.eclipse.ebpm.messaging.core.util.StringSource;

public class ExchangeUtils {
    public static final int MAX_MSG_DISPLAY_SIZE = 1500;
    private static TransformerFactory transformerFactory;

    public static String display(Exchange exchange, boolean displayContent) {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        sb.append("  id:        ").append(exchange.getId()).append('\n');
        sb.append("  mep:       ").append(exchange.getPattern()).append('\n');
        sb.append("  status:    ").append(exchange.getStatus()).append('\n');
        if (exchange.getProperties().size() > 0) {
            sb.append("  properties: [").append('\n');
            for (String key : exchange.getProperties().keySet()) {
                sb.append("      ").append(key).append(" = ");
                Object contents = exchange.getProperty(key);
                sb.append(ExchangeUtils.convertDisplay(contents));
                sb.append('\n');
            }
            sb.append("  ]").append('\n');
        }
        ExchangeUtils.display(exchange, Type.In, sb);
        ExchangeUtils.display(exchange, Type.Out, sb);
        ExchangeUtils.display(exchange, Type.Fault, sb);
        if (exchange.getError() != null) {
            sb.append("  error: [").append('\n');
            StringWriter sw = new StringWriter();
            exchange.getError().printStackTrace(new PrintWriter(sw));
            sb.append("    ").append(sw.toString().replace("\n", "\n    ").replace("\t", "  ").trim()).append('\n');
            sb.append("  ]").append('\n');
        }
        sb.append("]\n");
        return sb.toString();
    }

    public static void display(Exchange exchange, Type type, StringBuffer sb) {
        Message message = exchange.getMessage(type, false);
        if (message != null) {
            Object contents;
            sb.append("  ").append(type).append(": [").append('\n');
            sb.append("    content: ");
            try {
                if (message.getBody() != null) {
                    Source contents2 = message.getBody();
                    sb.append(ExchangeUtils.convertDisplay(contents2));
                } else {
                    sb.append("null");
                }
            }
            catch (Exception e) {
                sb.append("Unable to display: ").append(e);
            }
            sb.append('\n');
            if (message.getAttachments().size() > 0) {
                sb.append("    attachments: [").append('\n');
                for (String key : message.getAttachments().keySet()) {
                    contents = message.getAttachment(key);
                    sb.append("      ").append(key).append(" = ").append(ExchangeUtils.convertDisplay(contents)).append('\n');
                }
                sb.append("    ]").append('\n');
            }
            if (message.getHeaders().size() > 0) {
                sb.append("    properties: [").append('\n');
                for (String key : message.getHeaders().keySet()) {
                    sb.append("      ").append(key).append(" = ");
                    contents = message.getHeader(key);
                    sb.append(ExchangeUtils.convertDisplay(contents));
                    sb.append('\n');
                }
                sb.append("    ]").append('\n');
            }
            sb.append("  ]").append('\n');
        }
    }

    private static String convertDisplay(Object object) {
        try {
            String result;
            if (object instanceof ByteArrayInputStream) {
                InputStream is = (InputStream)object;
                byte[] data = new byte[is.available()];
                is.mark(0);
                is.read(data);
                is.reset();
                result = ExchangeUtils.isBinary(data) ? Arrays.toString(data) : new String(data);
            } else if (object instanceof DOMSource) {
                StringWriter buffer = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform((DOMSource)object, new StreamResult(buffer));
                result = buffer.toString();
            } else {
                result = object != null ? object.toString() : "<null>";
            }
            if (result.length() > 1500) {
                result = String.valueOf(result.substring(0, 1500)) + "...";
            }
            return result;
        }
        catch (Throwable t) {
            return "Error display value (" + t.toString() + ")";
        }
    }

    private static boolean isBinary(byte[] data) {
        if (data.length == 0) {
            return true;
        }
        double prob_bin = 0.0;
        int i = 0;
        while (i < data.length) {
            byte j = data[i];
            if (j < 32 || j > 127) {
                prob_bin += 1.0;
            }
            ++i;
        }
        double pb = prob_bin / (double)data.length;
        return pb > 0.5;
    }

    private static Object convert(Object object) throws IOException, TransformerException {
        if (object instanceof InputStream) {
            object = ExchangeUtils.convertInputStream((InputStream)object);
        } else if (object instanceof Source) {
            object = ExchangeUtils.convertSource((Source)object);
        }
        return object;
    }

    private static InputStream convertInputStream(InputStream is) throws IOException {
        if (!(is instanceof ByteArrayInputStream)) {
            int len;
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            is.close();
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        return is;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    private static Source convertSource(Source src) throws TransformerException {
        if (!(src instanceof StringSource)) {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            ExchangeUtils.getTransformerFactory().newTransformer().transform(src, result);
            return new StringSource(writer.toString());
        }
        return src;
    }
}

