/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.utils;

import java.net.URI;
import java.text.ParseException;
import java.util.Properties;
import org.eclipse.ebpm.connectors.mail.utils.MailConnectionConfiguration;

public final class MailUtils {
    public static final String SSL_FACTORY = "org.spagic3.mail.security.CustomSSLSocketFactory";
    public static final int DEFAULT_PORT_SMTP = 25;
    public static final int DEFAULT_PORT_SMTPS = 465;
    public static final int DEFAULT_PORT_POP3 = 110;
    public static final int DEFAULT_PORT_POP3S = 995;
    public static final int DEFAULT_PORT_NNTP = 119;
    public static final int DEFAULT_PORT_IMAP = 143;
    public static final int DEFAULT_PORT_IMAPS = 993;
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTPS = "smtps";
    public static final String PROTOCOL_POP = "pop";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_NNTP = "nntp";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    public static final String CONNECTION_TIMEOUT = "10000";

    private MailUtils() {
    }

    public static int getDefaultPortForProtocol(String protocol) {
        int port = 25;
        if (protocol != null) {
            port = protocol.equalsIgnoreCase(PROTOCOL_IMAP) ? 143 : (protocol.equalsIgnoreCase(PROTOCOL_IMAPS) ? 993 : (protocol.equalsIgnoreCase(PROTOCOL_NNTP) ? 119 : (protocol.equalsIgnoreCase(PROTOCOL_POP) || protocol.equalsIgnoreCase(PROTOCOL_POP3) ? 110 : (protocol.equalsIgnoreCase(PROTOCOL_POP3S) ? 995 : (protocol.equalsIgnoreCase(PROTOCOL_SMTP) ? 25 : (protocol.equalsIgnoreCase(PROTOCOL_SMTPS) ? 465 : 25))))));
        }
        return port;
    }

    public static MailConnectionConfiguration configure(String uriString) throws ParseException {
        int endIndex;
        int beginIndex;
        int port;
        String scheme;
        MailConnectionConfiguration config = new MailConnectionConfiguration();
        if (uriString == null || uriString.length() <= 0) {
            throw new ParseException("The given connection uri (" + uriString + ") is invalid.", 0);
        }
        URI uri = URI.create(uriString);
        String value = uri.getHost();
        if (value != null) {
            config.setHost(value);
        }
        if ((scheme = uri.getScheme()) != null) {
            config.setProtocol(scheme);
        } else {
            config.setProtocol(PROTOCOL_SMTP);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            config.setUsername(userInfo);
        }
        if ((port = uri.getPort()) >= 0) {
            config.setPort(port);
        } else {
            config.setPort(MailUtils.getDefaultPortForProtocol(config.getProtocol()));
        }
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            if (uri.getPath().startsWith("/")) {
                config.setFolderName(uri.getPath().substring(1));
            } else {
                config.setFolderName(uri.getPath());
            }
        } else {
            config.setFolderName("INBOX");
        }
        if (uri.getQuery().indexOf("password=") != -1) {
            beginIndex = uri.getQuery().indexOf("password=") + "password=".length();
            endIndex = uri.getQuery().indexOf(59, beginIndex + 1) != -1 ? uri.getQuery().indexOf(59, beginIndex + 1) : uri.getQuery().length();
            config.setPassword(uri.getQuery().substring(beginIndex, endIndex));
        } else {
            config.setPassword("");
        }
        if (userInfo == null) {
            if (uri.getQuery().indexOf("user=") != -1) {
                beginIndex = uri.getQuery().indexOf("user=") + "user=".length();
                endIndex = uri.getQuery().indexOf(59, beginIndex + 1) != -1 ? uri.getQuery().indexOf(59, beginIndex + 1) : uri.getQuery().length();
                config.setUsername(uri.getQuery().substring(beginIndex, endIndex));
            } else {
                config.setUsername("");
            }
        }
        return config;
    }

    public static Properties getPropertiesForProtocol(MailConnectionConfiguration config, String customTrustManagers) {
        Properties mailConnectionProperties = (Properties)System.getProperties().clone();
        mailConnectionProperties.put("mail." + config.getProtocol() + ".connectiontimeout", CONNECTION_TIMEOUT);
        mailConnectionProperties.put("mail." + config.getProtocol() + ".timeout", CONNECTION_TIMEOUT);
        mailConnectionProperties.put("mail." + config.getProtocol() + ".host", config.getHost());
        mailConnectionProperties.put("mail." + config.getProtocol() + ".port", "" + config.getPort());
        if (config.getUsername() != null) {
            mailConnectionProperties.put("mail." + config.getProtocol() + ".user", config.getUsername());
        }
        mailConnectionProperties.put("mail." + config.getProtocol() + ".rsetbeforequit", "true");
        if (config.getUsername() != null) {
            mailConnectionProperties.put("mail." + config.getProtocol() + ".auth", "true");
        } else {
            mailConnectionProperties.put("mail." + config.getProtocol() + ".auth", "false");
        }
        mailConnectionProperties.put("mail.transport.protocol", config.getProtocol());
        mailConnectionProperties.put("mail.store.protocol", config.getProtocol());
        mailConnectionProperties.put("mail.host", config.getHost());
        if (config.getUsername() != null) {
            mailConnectionProperties.put("mail.user", config.getUsername());
        }
        if (config.isStartTLS()) {
            mailConnectionProperties.put("mail." + config.getProtocol() + ".enable", "true");
            mailConnectionProperties.put("mail." + config.getProtocol() + ".socketFactory.class", SSL_FACTORY);
        }
        if (customTrustManagers != null && customTrustManagers.trim().length() > 0 && config.isSecureProtocol()) {
            mailConnectionProperties.put("mail." + config.getProtocol() + ".socketFactory.class", SSL_FACTORY);
            mailConnectionProperties.put("mail." + config.getProtocol() + ".socketFactory.fallback", "false");
            mailConnectionProperties.put("mail." + config.getProtocol() + ".socketFactory.port", "" + config.getPort());
            System.getProperties().put("custom-trust-managers", customTrustManagers);
        }
        return mailConnectionProperties;
    }
}

