/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc.config;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.dbutils.ResultSetHandler;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResultSetHandler
implements ResultSetHandler {
    private String rowsXmlEnvelopName = "rows";
    private String rowXmlEnvelopName = "row";
    private Boolean columnNameAsAttribute;
    private Boolean valueAsAttribute;
    private static final Logger logger = LoggerFactory.getLogger(XmlResultSetHandler.class);

    public XmlResultSetHandler(String rowsXmlEnvelopName, String rowXmlEnvelopName, Boolean columnNameAsAttribute, Boolean valueAsAttribute) {
        if (rowsXmlEnvelopName != null && !rowsXmlEnvelopName.trim().equals("")) {
            this.rowsXmlEnvelopName = rowsXmlEnvelopName;
        }
        if (rowXmlEnvelopName != null && !rowXmlEnvelopName.trim().equals("")) {
            this.rowXmlEnvelopName = rowXmlEnvelopName;
        }
        logger.debug(" XmlResultSetHandler()::Constructor -> this.rowsXmlEnvelopName --> " + this.rowsXmlEnvelopName);
        logger.debug(" XmlResultSetHandler()::Constructor -> this.rowXmlEnvelopName --> " + this.rowXmlEnvelopName);
        this.columnNameAsAttribute = columnNameAsAttribute;
        this.valueAsAttribute = valueAsAttribute;
    }

    public XmlResultSetHandler(String rowsXmlEnvelopName, String rowXmlEnvelopName) {
        this(rowsXmlEnvelopName, rowXmlEnvelopName, false, false);
    }

    protected String handleBlob(Blob aBlob) {
        try {
            int inByte;
            logger.debug("Handling BLOB");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            logger.debug("Calling Blog get Binary Stream");
            InputStream inputStream = aBlob.getBinaryStream();
            logger.debug("Writing BLOB TO Temporary Array");
            while ((inByte = inputStream.read()) != -1) {
                byteArrayOutputStream.write(inByte);
            }
            byteArrayOutputStream.flush();
            byte[] returnBytes = byteArrayOutputStream.toByteArray();
            logger.debug("BLOB Readed in bytearray of length[" + returnBytes.length + "]");
            byteArrayOutputStream.close();
            if (returnBytes != null && returnBytes.length > 0) {
                return new String(Base64.encodeBase64((byte[])returnBytes));
            }
            logger.debug("BinaryValue is Null returning empty string");
            return "";
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "null";
        }
    }

    public Object handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        logger.debug(" XmlResultSetHandler()::resultSetHandle() -> this.rowsXmlEnvelopName --> " + this.rowsXmlEnvelopName);
        logger.debug(" XmlResultSetHandler()::resultSetHandle() -> this.rowXmlEnvelopName --> " + this.rowXmlEnvelopName);
        Element rows = DocumentHelper.createElement((String)this.rowsXmlEnvelopName);
        Element row = null;
        while (rs.next()) {
            row = DocumentHelper.createElement((String)this.rowXmlEnvelopName);
            Element column = null;
            int i = 1;
            while (i <= cols) {
                Object value = rs.getObject(i);
                if (this.columnNameAsAttribute.booleanValue()) {
                    column = DocumentHelper.createElement((String)"column");
                    column.addAttribute("name", rsmd.getColumnName(i));
                } else {
                    column = DocumentHelper.createElement((String)rsmd.getColumnName(i));
                }
                String text = null;
                int columnType = rsmd.getColumnType(i);
                if (columnType == 2004) {
                    text = value != null ? this.handleBlob((Blob)value) : "";
                } else if (columnType == -2) {
                    text = value != null ? new String(Base64.encodeBase64((byte[])((byte[])value))) : "";
                } else {
                    String string = text = value != null ? value.toString() : "";
                }
                if (this.valueAsAttribute.booleanValue()) {
                    column.addAttribute("value", text);
                } else {
                    column.setText(text);
                }
                row.add(column);
                ++i;
            }
            rows.add(row);
        }
        return rows;
    }

    public String getRowsXmlEnvelopName() {
        return this.rowsXmlEnvelopName;
    }

    public void setRowsXmlEnvelopName(String rowsXmlEnvelopName) {
        this.rowsXmlEnvelopName = rowsXmlEnvelopName;
    }

    public String getRowXmlEnvelopName() {
        return this.rowXmlEnvelopName;
    }

    public void setRowXmlEnvelopName(String rowXmlEnvelopName) {
        this.rowXmlEnvelopName = rowXmlEnvelopName;
    }
}

