/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 			Andrea Zoppello (Engineering Group) - initial API and implementation and/or initial documentation
 * 			Gianfranco Boccalon (Engineering Group) - initial API and implementation and/or initial documentation
 *          Luca Rossato ( Engineering Group ) - initial API and implementation and/or initial documentation
 *          Luca Barozzi ( Engineering Group ) - initial API and implementation and/or initial documentation
 *  		Antonietta Miele ( Engineering Group ) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebpm.connectors.http.util;

public class WSSecurityConstants {

    /**
     * Perform Signature.
     * The signature specific parameters define how to sign, which keys
     * to use, and so on
     */
    public static final String SIGNATURE = "Signature";

    /**
     * Perform Encryption.
     * The encryption specific parameters define how to encrypt, which keys
     * to use, and so on.
     */
    public static final String ENCRYPT = "Encrypt";

    /**
     * Add a timestamp to the security header.
     */
    public static final String TIMESTAMP = "Timestamp";

    /**
     * The user's name. It is used differently by the WS Security functions.
     */
    public static final String USER = "user";

    public static final String PW_CALLBACK_CLASS = "passwordCallbackClass";

    /**
     * The user's name for encryption.
     */
    public static final String ENCRYPTION_USER = "encryptionUser";
    
    /**
     * The name of the crypto property file to use for SOAP Signature.
     */
    public static final String SIG_PROP_FILE = "signaturePropFile";
    
    /**
     * The name of the crypto propterty file to use for SOAP Decryption.
     */
    public static final String DEC_PROP_FILE = "decryptionPropFile";
    
    /**
     * Defines which key identifier type to use. The WS-Security specifications
     * recommends to use the identifier type <code>IssuerSerial</code>.
     */
    public static final String SIG_KEY_ID = "signatureKeyIdentifier";
    
    /**
     * The name of the crypto propterty file to use for SOAP Encryption.
     */
    public static final String ENC_PROP_FILE = "encryptionPropFile";
  

    /**
     * Defines which key identifier type to use. The WS-Security specifications
     * recommends to use the identifier type <code>IssuerSerial</code>. 
     */
    public static final String ENC_KEY_ID = "encryptionKeyIdentifier";

}

