/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolver;
import org.eclipse.m2e.jdt.AbstractClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IMavenClassifierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClassifierManager
implements IMavenClassifierManager {
    private static final String EXTENSION_CLASSIFIER_CLASSPATH_PROVIDERS = "org.eclipse.m2e.jdt.classifierClasspathProviders";
    private static final Logger log = LoggerFactory.getLogger(MavenClassifierManager.class);
    private static final IClassifierClasspathProvider NO_OP_CLASSIFIER_CLASSPATH_PROVIDER = new AbstractClassifierClasspathProvider(){

        @Override
        public String getClassifier() {
            return "(__ignore_classifier__)";
        }

        @Override
        public boolean applies(IMavenProjectFacade mavenProjectFacade, String classifier) {
            return false;
        }

        @Override
        public String toString() {
            return "No-Op Classifier Classpath Provider";
        }
    };
    private Map<String, List<IClassifierClasspathProvider>> classifierClasspathProvidersMap;

    @Override
    public IClassifierClasspathProvider getClassifierClasspathProvider(IMavenProjectFacade project, String classifier) {
        List<IClassifierClasspathProvider> allProviders = this.getClassifierClasspathProviders(classifier);
        ArrayList<IClassifierClasspathProvider> compatibleProviders = new ArrayList<IClassifierClasspathProvider>();
        if (allProviders != null) {
            for (IClassifierClasspathProvider p : allProviders) {
                if (!p.applies(project, classifier)) continue;
                compatibleProviders.add(p);
            }
        }
        switch (compatibleProviders.size()) {
            case 0: {
                break;
            }
            case 1: {
                return (IClassifierClasspathProvider)compatibleProviders.get(0);
            }
        }
        IWorkspaceClassifierResolver resolver = MavenPlugin.getWorkspaceClassifierResolverManager().getResolver();
        IPath resolvedPath = resolver.resolveClassifier(project, classifier);
        if (resolvedPath != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = root.findMember(resolvedPath);
            if (res.getProject().equals((Object)project.getProject())) {
                IPath projectRelativePath = res.getProjectRelativePath();
                return new WorkspaceClassifierResolverDelegatingProvider(projectRelativePath);
            }
            log.error("Project {} classifier {} resolved to wrong project at {}", new Object[]{project.getProject().getName(), classifier, res.toString()});
        }
        return NO_OP_CLASSIFIER_CLASSPATH_PROVIDER;
    }

    protected List<IClassifierClasspathProvider> getClassifierClasspathProviders(String classifier) {
        if (this.classifierClasspathProvidersMap == null) {
            this.classifierClasspathProvidersMap = MavenClassifierManager.readExtensions();
        }
        return this.classifierClasspathProvidersMap.get(classifier);
    }

    protected static synchronized Map<String, List<IClassifierClasspathProvider>> readExtensions() {
        HashMap<String, List<IClassifierClasspathProvider>> map = new HashMap<String, List<IClassifierClasspathProvider>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ccpExtensionPoint = registry.getExtensionPoint(EXTENSION_CLASSIFIER_CLASSPATH_PROVIDERS);
        if (ccpExtensionPoint != null) {
            IExtension[] ccpExtensions;
            IExtension[] iExtensionArray = ccpExtensions = ccpExtensionPoint.getExtensions();
            int n = ccpExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    IClassifierClasspathProvider classifierClasspathProvider = null;
                    try {
                        classifierClasspathProvider = (IClassifierClasspathProvider)element.createExecutableExtension("class");
                        String classifier = classifierClasspathProvider.getClassifier();
                        ArrayList<IClassifierClasspathProvider> providers = (ArrayList<IClassifierClasspathProvider>)map.get(classifier);
                        if (providers == null) {
                            providers = new ArrayList<IClassifierClasspathProvider>(1);
                            map.put(classifier, providers);
                        }
                        providers.add(classifierClasspathProvider);
                    }
                    catch (CoreException ex) {
                        log.debug("Can not instanciate IClassifierClasspathProvider", (Throwable)ex);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return map;
    }

    private static class WorkspaceClassifierResolverDelegatingProvider
    extends AbstractClassifierClasspathProvider {
        private IPath path;

        public WorkspaceClassifierResolverDelegatingProvider(IPath path) {
            this.path = path;
        }

        @Override
        public String getClassifier() {
            return "(__ignore_classifier__)";
        }

        @Override
        public boolean applies(IMavenProjectFacade mavenProjectFacade, String classifier) {
            return false;
        }

        @Override
        public void setRuntimeClasspath(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor, int classpathProperty) {
            this.addFolders(runtimeClasspath, mavenProjectFacade.getProject(), Collections.singleton(this.path), classpathProperty);
        }

        @Override
        public void setTestClasspath(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor, int classpathProperty) {
            this.setRuntimeClasspath(runtimeClasspath, mavenProjectFacade, monitor, classpathProperty);
        }

        @Override
        public String toString() {
            return "Delegates to IWorkspaceClassifierResolver";
        }
    }
}

