/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySuperTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.JvmExecutableBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.JvmFieldBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class JvmDeclaredTypeBuilder
extends ClassVisitor
implements Opcodes {
    protected final Proxies proxies;
    protected JvmDeclaredType result;
    protected int offset = 0;
    private Map<String, JvmTypeParameter> typeParameters;
    private final ClassLoader classLoader;
    private final BinaryClass binaryClass;
    private final ClassFileBytesAccess bytesAccess;

    public JvmDeclaredTypeBuilder(BinaryClass binaryClass, ClassFileBytesAccess bytesAccess, ClassLoader classLoader) {
        this(binaryClass, bytesAccess, classLoader, null, new Proxies());
    }

    protected JvmDeclaredTypeBuilder(BinaryClass binaryClass, ClassFileBytesAccess bytesAccess, ClassLoader classLoader, Map<String, JvmTypeParameter> typeParameters, Proxies proxies) {
        super(327680);
        this.proxies = proxies;
        this.binaryClass = binaryClass;
        this.bytesAccess = bytesAccess;
        this.classLoader = classLoader;
        this.typeParameters = typeParameters;
    }

    public JvmDeclaredType buildType() {
        byte[] bytes = this.bytesAccess.getBytes(this.binaryClass);
        if (bytes == null) {
            return null;
        }
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)this, 7);
        return this.result;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1000) != 0) {
            throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
        }
        if ((0x4000 & access) != 0) {
            this.result = TypesFactory.eINSTANCE.createJvmEnumerationType();
            this.offset = 2;
        } else if ((0x2000 & access) != 0) {
            this.result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        } else {
            JvmGenericType generic = TypesFactory.eINSTANCE.createJvmGenericType();
            this.result = generic;
            generic.setInterface((access & 0x200) != 0);
            generic.setStrictFloatingPoint((access & 0x800) != 0);
        }
        this.setTypeModifiers(access);
        this.proxies.setVisibility(access, this.result);
        this.setNameAndPackage(name);
        BinarySuperTypeSignature genericSignature = null;
        if (signature != null) {
            if ((access & 0x208) != 0) {
                this.typeParameters = Collections.emptyMap();
            }
            genericSignature = BinarySignatures.createSuperTypeSignature(signature);
            if ((0x6000 & access) == 0) {
                this.typeParameters = this.proxies.createTypeParameters(genericSignature, (JvmTypeParameterDeclarator)((Object)this.result), this.typeParameters);
            }
        }
        this.setSuperTypes(name, genericSignature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new JvmAnnotationReferenceBuilder((InternalEList<JvmAnnotationReference>)((InternalEList)this.result.getAnnotations()), desc, this.proxies);
    }

    public void visitEnd() {
    }

    public void visitAttribute(Attribute attr) {
    }

    private void setSuperTypes(String name, BinarySuperTypeSignature signature, String superName, String[] interfaces) {
        InternalEList superTypes = (InternalEList)this.result.getSuperTypes();
        if (signature != null) {
            List<BinaryGenericTypeSignature> superTypeSignatures = signature.getSuperTypes();
            if (this.result.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)this.result).isInterface() && superTypeSignatures.size() > 1) {
                superTypeSignatures = superTypeSignatures.subList(1, superTypeSignatures.size());
            }
            for (int i = 0; i < superTypeSignatures.size(); ++i) {
                superTypes.addUnique((Object)this.proxies.createTypeReference(superTypeSignatures.get(i), this.typeParameters));
            }
        } else {
            if (superName != null && this.result.eClass() != TypesPackage.Literals.JVM_ANNOTATION_TYPE) {
                superTypes.addUnique((Object)this.proxies.createTypeReference(BinarySignatures.createObjectTypeSignature(superName), this.typeParameters));
            }
            this.setInterfaces(interfaces, this.typeParameters, (InternalEList<JvmTypeReference>)superTypes);
            if (superTypes.isEmpty() && !"java/lang/Object".equals(name)) {
                superTypes.addUnique((Object)this.proxies.createObjectTypeReference());
            }
        }
    }

    protected void setInterfaces(String[] interfaces, Map<String, JvmTypeParameter> typeParameters, InternalEList<JvmTypeReference> result) {
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i];
                result.addUnique((Object)this.proxies.createTypeReference(BinarySignatures.createObjectTypeSignature(interfaceName), typeParameters));
            }
        }
    }

    protected void setNameAndPackage(String binaryName) {
        int slash = binaryName.lastIndexOf(47);
        if (slash == -1) {
            this.result.setSimpleName(binaryName);
            this.result.internalSetIdentifier(binaryName);
        } else {
            String identifier = binaryName.replace('/', '.');
            String simpleName = identifier.substring(slash + 1);
            this.result.setSimpleName(simpleName);
            String packageName = identifier.substring(0, slash);
            this.result.setPackageName(packageName);
            this.result.internalSetIdentifier(identifier);
        }
    }

    protected void setTypeModifiers(int accessFlags) {
        this.result.setAbstract((accessFlags & 0x400) != 0);
        this.result.setStatic((accessFlags & 8) != 0);
        this.result.setDeprecated((accessFlags & 0x20000) != 0);
        if (this.result.eClass() != TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            if (this.result.isStatic()) {
                this.offset = 0;
            }
            this.result.setFinal((accessFlags & 0x10) != 0);
        }
    }

    public void visitSource(String file, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
        throw new IllegalStateException("Expected top-level type");
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        BinaryClass binaryClass;
        boolean isStatic;
        NestedJvmDeclaredTypeBuilder builder;
        JvmDeclaredType nestedType;
        if (outerName != null && innerName != null && outerName.replace('/', '.').equals(this.result.getIdentifier()) && (nestedType = (builder = new NestedJvmDeclaredTypeBuilder(innerName, !(isStatic = (access & 8) != 0) ? 1 : 0, binaryClass = new BinaryClass(name, this.classLoader), this.bytesAccess, this.classLoader, this.typeParameters, this.proxies)).buildType()) != null) {
            if (isStatic) {
                nestedType.setStatic(isStatic);
            }
            this.proxies.setVisibility(access, nestedType);
            this.result.getMembers().add((Object)nestedType);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) == 0) {
            JvmFieldBuilder fieldBuilder = new JvmFieldBuilder(this.result, (access & 8) == 0 ? this.typeParameters : null, this.proxies, access, name, desc, signature, value);
            return fieldBuilder;
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1040) == 0 && !this.isClinit(name)) {
            JvmExecutableBuilder builder = new JvmExecutableBuilder(this.result, this.offset, (access & 8) == 0 ? this.typeParameters : null, this.proxies, access, name, desc, signature, exceptions);
            return builder;
        }
        return null;
    }

    private boolean isClinit(String selector) {
        return selector.charAt(0) == '<' && selector.length() == 8;
    }

    static class NestedJvmDeclaredTypeBuilder
    extends JvmDeclaredTypeBuilder {
        private final String innerName;

        protected NestedJvmDeclaredTypeBuilder(String innerName, int offset, BinaryClass binaryClass, ClassFileBytesAccess bytesAccess, ClassLoader classLoader, Map<String, JvmTypeParameter> typeParameters, Proxies proxies) {
            super(binaryClass, bytesAccess, classLoader, typeParameters, proxies);
            this.innerName = innerName;
            this.offset = offset;
        }

        @Override
        protected void setTypeModifiers(int accessFlags) {
            super.setTypeModifiers(accessFlags);
            if (this.result.eClass() != TypesPackage.Literals.JVM_GENERIC_TYPE) {
                this.result.setStatic(true);
            } else if (((JvmGenericType)this.result).isInterface()) {
                this.result.setStatic(true);
            }
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        protected void setNameAndPackage(String binaryName) {
            String identifier = binaryName.replace('/', '.');
            this.result.setSimpleName(this.innerName);
            this.result.internalSetIdentifier(identifier);
        }
    }
}

