/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.p2;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fx.core.ProgressReporter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProgressMonitorAdapter
implements IProgressMonitor {
    private final ProgressReporter reporter;
    private final @NonNull String taskId = UUID.randomUUID().toString();
    private boolean canceled;
    private @Nullable String subTask;

    public ProgressMonitorAdapter(ProgressReporter reporter) {
        this.reporter = reporter;
    }

    public void beginTask(String name, int totalWork) {
        this.reporter.taskStart(this.taskId, null, name, totalWork, true);
    }

    public void done() {
        this.reporter.taskEnd(this.taskId, this.isCanceled());
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean value) {
        this.canceled = value;
    }

    public void setTaskName(String name) {
        if (this.subTask != null) {
            String task = this.subTask;
            this.reporter.taskEnd(task, this.isCanceled());
        }
    }

    public void subTask(String name) {
        String task;
        if (this.subTask != null) {
            task = this.subTask;
            this.reporter.taskEnd(task, this.isCanceled());
        }
        this.subTask = UUID.randomUUID().toString();
        if (this.subTask != null) {
            task = this.subTask;
            this.reporter.taskStart(task, this.taskId, name == null ? "<unknown>" : name, 1, true);
        }
    }

    public void worked(int work) {
        this.reporter.progress(this.taskId, null, work);
    }
}

