/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.buffer.Buffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.cli.app.NorthBoundApis;
import org.eclipse.hono.cli.util.CommandUtils;
import org.eclipse.hono.cli.util.IntegerVariableConverter;
import org.eclipse.hono.cli.util.PropertiesVersionProvider;
import org.eclipse.hono.cli.util.StringVariableConverter;
import org.eclipse.hono.client.ServiceInvocationException;
import org.fusesource.jansi.AnsiConsole;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@Singleton
@CommandLine.Command(name="command", description={"Send one-way and/or request-response commands to devices."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
public class CommandAndControl
implements Callable<Integer> {
    @CommandLine.ParentCommand
    NorthBoundApis appCommand;
    private final AtomicBoolean connected = new AtomicBoolean(false);

    private void printResponse(DownstreamMessage<?> response) {
        System.out.println("res %s %d %s %s".formatted(response.getDeviceId(), response.getStatus(), Optional.ofNullable(response.getContentType()).orElse("-"), Optional.ofNullable(response.getPayload()).map(Buffer::toString).orElse("-")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndExecuteCommands() {
        AnsiConsole.systemInstall();
        try {
            Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
            Builtins builtins = new Builtins(workDir, null, null);
            builtins.rename(Builtins.Command.TTOP, "top");
            builtins.alias("zle", "widget");
            builtins.alias("bindkey", "keymap");
            PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
            CommandLine cmd = new CommandLine(this, factory);
            cmd.setExecutionExceptionHandler(CommandUtils::handleExecutionException);
            PicocliCommands picocliCommands = new PicocliCommands(cmd){

                @Override
                public String name() {
                    return "hono-cli";
                }
            };
            DefaultParser parser = new DefaultParser();
            try (Terminal terminal = TerminalBuilder.builder().build();){
                SystemRegistryImpl systemRegistry = new SystemRegistryImpl(parser, terminal, workDir, null);
                systemRegistry.setCommandRegistries(builtins, picocliCommands);
                systemRegistry.register("help", picocliCommands);
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser(parser).variable("list-max", 50).build();
                builtins.setLineReader(reader);
                factory.setTerminal(terminal);
                String prompt = "hono-cli/app/command> ";
                String rightPrompt = null;
                while (this.connected.get()) {
                    try {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("hono-cli/app/command> ", rightPrompt, (MaskingCallback)null, null);
                        systemRegistry.execute(line);
                    }
                    catch (UserInterruptException e) {
                        this.connected.compareAndSet(true, false);
                    }
                    catch (EndOfFileException e) {
                        this.connected.compareAndSet(true, false);
                    }
                    catch (Exception e) {
                        systemRegistry.trace(e);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    @Override
    public Integer call() {
        try {
            this.appCommand.getApplicationClient().onSuccess(client -> this.connected.set(true)).toCompletionStage().toCompletableFuture().join();
        }
        catch (CompletionException e) {
            System.err.println("Failed to connect to Hono's Command & Control endpoint");
            CommandUtils.printError(e.getCause());
            return 1;
        }
        this.readAndExecuteCommands();
        return 0;
    }

    @CommandLine.Command(name="quit", aliases={"exit", "bye"}, description={"Exit Hono client."})
    void quit() {
        this.connected.set(false);
    }

    private void handleCommandSendingError(Throwable e) {
        if (e instanceof ServiceInvocationException) {
            ServiceInvocationException sie = (ServiceInvocationException)e;
            System.err.println("Error: %d %s".formatted(sie.getErrorCode(), ServiceInvocationException.getErrorMessageForExternalClient(sie)));
            if (sie.getErrorCode() == 503) {
                System.err.println("Cannot send command to device");
                System.err.println("Check if device is connected to a protocol adapter and has subscribed for commands as described in the protocol adapter user guides.\nhttps://www.eclipse.org/hono/docs/user-guide/\n");
            }
        } else {
            System.err.println("Error: failed to send command to device");
        }
    }

    @CommandLine.Command(name="ow", description={"Send a one-way command to a device."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    int sendOneWay(@CommandLine.Mixin CommandSendingOptions options) {
        String ct = Optional.ofNullable(options.contentType).orElseGet(() -> Optional.ofNullable(options.payload).filter(p -> p.startsWith("{") && p.endsWith("}")).map(p -> "application/json").orElse("text/plain"));
        try {
            this.appCommand.getApplicationClient().compose(c -> c.sendOneWayCommand(options.tenantId, options.deviceId, options.commandName, Optional.ofNullable(options.payload).map(Buffer::buffer).orElse(null), ct, null)).toCompletionStage().toCompletableFuture().join();
            return 0;
        }
        catch (CompletionException e) {
            this.handleCommandSendingError(e.getCause());
            return 1;
        }
    }

    @CommandLine.Command(name="req", description={"Send a request-response command to a device."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    int sendRequestResponse(@CommandLine.Mixin CommandSendingOptions options, @CommandLine.Option(names={"-r", "--response-timeout"}, description={"The time (seconds) to wait for a response from the device."}, defaultValue="60", converter={IntegerVariableConverter.class}) int responseTimeout) {
        String ct = Optional.ofNullable(options.contentType).orElseGet(() -> Optional.ofNullable(options.payload).filter(p -> p.startsWith("{") && p.endsWith("}")).map(p -> "application/json").orElse("text/plain"));
        try {
            this.appCommand.getApplicationClient().compose(c -> c.sendCommand(options.tenantId, options.deviceId, options.commandName, Optional.ofNullable(options.payload).map(Buffer::buffer).orElse(null), ct, UUID.randomUUID().toString(), Duration.ofSeconds(responseTimeout), null)).onSuccess(this::printResponse).toCompletionStage().toCompletableFuture().join();
            return 0;
        }
        catch (CompletionException e) {
            this.handleCommandSendingError(e.getCause());
            return 1;
        }
    }

    @CommandLine.Command
    public static class CommandSendingOptions {
        @CommandLine.Option(names={"-t", "--tenant"}, description={"The tenant that the device belongs to.", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, defaultValue="DEFAULT_TENANT", order=19, converter={StringVariableConverter.class})
        String tenantId;
        @CommandLine.Option(names={"-d", "--device"}, description={"The device to send the command to.", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, required=true, order=20, converter={StringVariableConverter.class})
        String deviceId;
        @CommandLine.Option(names={"-n", "--name"}, description={"The name of the command to be executed by the device.", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, required=true, order=23, converter={StringVariableConverter.class})
        String commandName;
        @CommandLine.Option(names={"--payload"}, description={"Arbitrary (text) input data to the command to be executed.", "The values of the '--name=<commandName' and '--content-type=<contentType>' properties may provide a hint to the device regarding the format, encoding and semantics of the payload data.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=25, converter={StringVariableConverter.class})
        String payload;
        @CommandLine.Option(names={"--content-type"}, description={"A Media Type which describes the semantics and format of the command\u2019s input data contained in the message payload.\n", "See https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7", "Not all protocol adapters will support this property as not all transport protocols provide means to convey this information, e.g. MQTT 3.1.1 has no notion of message headers.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=27, converter={StringVariableConverter.class})
        String contentType;
    }
}

