/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

class TypeResolver {
    private final Map<TypeVariable<?>, Type> resolvedTypeVariables;

    public TypeResolver(Map<TypeVariable<?>, Type> resolvedTypeVariables) {
        this.resolvedTypeVariables = resolvedTypeVariables;
    }

    public Type resolveType(TypeVariable<?> variable) {
        Type resolvedType = this.resolvedTypeVariables.get(variable);
        if (resolvedType == null) {
            return variable;
        }
        return resolvedType;
    }

    public Type resolveType(ParameterizedType type) {
        Type[] unresolvedTypeArguments = type.getActualTypeArguments();
        boolean modified = false;
        Type[] resolvedTypeArguments = new Type[unresolvedTypeArguments.length];
        for (int i = 0; i < unresolvedTypeArguments.length; ++i) {
            Type resolvedType = unresolvedTypeArguments[i];
            if (resolvedType instanceof TypeVariable) {
                resolvedType = this.resolveType((TypeVariable)resolvedType);
            }
            if (resolvedType instanceof ParameterizedType) {
                resolvedType = this.resolveType((ParameterizedType)resolvedType);
            }
            resolvedTypeArguments[i] = resolvedType;
            if (unresolvedTypeArguments[i] == resolvedType) continue;
            modified = true;
        }
        if (modified) {
            return new ParameterizedTypeImpl(type.getRawType(), resolvedTypeArguments, type.getOwnerType());
        }
        return type;
    }

    public Type resolveType(GenericArrayType type) {
        Type genericComponentType;
        Type resolvedType = genericComponentType = type.getGenericComponentType();
        if (genericComponentType instanceof TypeVariable) {
            resolvedType = this.resolveType((TypeVariable)genericComponentType);
        }
        if (genericComponentType instanceof ParameterizedType) {
            resolvedType = this.resolveType((ParameterizedType)genericComponentType);
        }
        if (genericComponentType instanceof GenericArrayType) {
            resolvedType = this.resolveType((GenericArrayType)genericComponentType);
        }
        if (resolvedType instanceof Class) {
            Class componentClass = (Class)resolvedType;
            return Array.newInstance(componentClass, 0).getClass();
        }
        if (resolvedType == genericComponentType) {
            return type;
        }
        return new GenericArrayTypeImpl(resolvedType);
    }

    public Type resolveType(Type type) {
        if (type instanceof ParameterizedType) {
            return this.resolveType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return this.resolveType((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveType((GenericArrayType)type);
        }
        return type;
    }

    public Map<TypeVariable<?>, Type> getResolvedTypeVariables() {
        return this.resolvedTypeVariables;
    }
}

