/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ResourceConflictException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.util.RegistrationResult;
import org.eclipse.hono.util.RequestResponseResult;

public abstract class StatusCodeMapper {
    private StatusCodeMapper() {
    }

    public static final boolean isSuccessful(Integer statusCode) {
        return statusCode != null && statusCode >= 200 && statusCode < 300;
    }

    public static final ServiceInvocationException from(RequestResponseResult<?> result) {
        return StatusCodeMapper.from(result.getStatus(), null);
    }

    public static final ServiceInvocationException from(RegistrationResult result) {
        String detailMessage = Optional.ofNullable((JsonObject)result.getPayload()).map(payload -> payload.getString("error")).orElse(null);
        return StatusCodeMapper.from(result.getStatus(), detailMessage);
    }

    public static final ServiceInvocationException from(int statusCode, String detailMessage) {
        return StatusCodeMapper.from(null, statusCode, detailMessage, null);
    }

    public static final ServiceInvocationException from(String tenant, int statusCode, String detailMessage) {
        return StatusCodeMapper.from(tenant, statusCode, detailMessage, null);
    }

    public static final ServiceInvocationException from(String tenant, int statusCode, String detailMessage, Throwable cause) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 409: {
                    return new ResourceConflictException(tenant, detailMessage, cause);
                }
            }
            return new ClientErrorException(tenant, statusCode, detailMessage, cause);
        }
        if (statusCode >= 500 && statusCode < 600) {
            return new ServerErrorException(tenant, statusCode, detailMessage, cause);
        }
        throw new IllegalArgumentException(String.format("illegal error code [%d], must be >= 400 and < 600", statusCode));
    }

    public static final ServiceInvocationException toServerError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof ServiceInvocationException) {
            int errorCode = ((ServiceInvocationException)throwable).getErrorCode();
            if (errorCode >= 400 && errorCode < 500) {
                return new ServerErrorException(503, throwable);
            }
            return (ServiceInvocationException)throwable;
        }
        return new ServerErrorException(500, throwable);
    }
}

