/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public final class MultiSkipFirstOp<T>
extends AbstractMultiOperator<T, T> {
    private final long numberOfItems;

    public MultiSkipFirstOp(Multi<? extends T> upstream, long numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (this.numberOfItems == 0L) {
            this.upstream.subscribe(actual);
        } else {
            this.upstream.subscribe(new SkipFirstProcessor<T>(actual, this.numberOfItems));
        }
    }

    static final class SkipFirstProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final AtomicLong remaining;

        SkipFirstProcessor(MultiSubscriber<? super T> downstream, long items) {
            super(downstream);
            this.remaining = new AtomicLong(items);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                long l = this.remaining.get();
                if (l > 0L) {
                    subscription.request(l);
                }
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T t) {
            long r = this.remaining.getAndDecrement();
            if (r <= 0L) {
                this.downstream.onItem(t);
            }
        }
    }
}

