/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.adapter.amqp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.quarkus.runtime.ShutdownEvent;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.cli.util.ClientCertInfo;
import org.eclipse.hono.cli.util.CommandUtils;
import org.eclipse.hono.cli.util.ConnectionOptions;
import org.eclipse.hono.cli.util.IntegerVariableConverter;
import org.eclipse.hono.cli.util.PropertiesVersionProvider;
import org.eclipse.hono.cli.util.StringVariableConverter;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.command.CommandConsumer;
import org.eclipse.hono.client.device.amqp.AmqpAdapterClient;
import org.eclipse.hono.util.QoS;
import org.fusesource.jansi.AnsiConsole;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@Singleton
@CommandLine.Command(name="amqp-device", aliases={"amqp"}, description={"A client for interacting with Hono's AMQP adapter."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
@SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="We use the default passwords of the Hono Sandbox installation throughout this class\nfor ease of use. The passwords are publicly documented and do not affect any\nprivate installations of Hono.\n")
public class AmqpAdapter
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAdapter.class);
    private static final String SANDBOX_DEFAULT_DEVICE_AUTH_ID = "sensor1@DEFAULT_TENANT";
    private static final String SANDBOX_DEFAULT_DEVICE_PWD = "hono-secret";
    @CommandLine.Mixin
    ConnectionOptions connectionOptions;
    @CommandLine.ArgGroup(exclusive=false)
    ClientCertInfo clientCertInfo;
    @Inject
    Vertx vertx;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final Map<String, CommandConsumer> activeConsumers = new HashMap<String, CommandConsumer>();
    private AmqpAdapterClient client;

    private void validateConnectionOptions() {
        if (this.connectionOptions.useSandbox) {
            if (!this.connectionOptions.trustStorePath.isPresent()) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required option: '--ca-file=<path>' needs to be specified when using '--sandbox'.\n");
            }
        } else if (this.connectionOptions.hostname.isEmpty() || this.connectionOptions.portNumber.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required option: both '--host=<hostname>' and '--port=<portNumber> need to be specified when not using '--sandbox'.\n");
        }
    }

    private Future<AmqpAdapterClient> getClient() {
        if (this.client != null) {
            return Future.succeededFuture(this.client);
        }
        this.validateConnectionOptions();
        ClientConfigProperties clientConfig = new ClientConfigProperties();
        clientConfig.setReconnectAttempts(5);
        clientConfig.setServerRole("Hono AMQP Adapter");
        this.connectionOptions.trustStorePath.ifPresent(path -> {
            clientConfig.setTrustStorePath((String)path);
            this.connectionOptions.trustStorePassword.ifPresent(clientConfig::setTrustStorePassword);
        });
        if (this.connectionOptions.useSandbox) {
            clientConfig.setHost("hono.eclipseprojects.io");
            clientConfig.setPort(5671);
            Optional.ofNullable(this.connectionOptions.credentials).ifPresentOrElse(creds -> {
                clientConfig.setUsername(creds.username);
                clientConfig.setPassword(creds.password);
            }, () -> {
                clientConfig.setUsername(SANDBOX_DEFAULT_DEVICE_AUTH_ID);
                clientConfig.setPassword(SANDBOX_DEFAULT_DEVICE_PWD);
            });
        } else {
            this.connectionOptions.hostname.ifPresent(clientConfig::setHost);
            this.connectionOptions.portNumber.ifPresent(clientConfig::setPort);
            clientConfig.setHostnameVerificationRequired(!this.connectionOptions.disableHostnameVerification);
            if (this.clientCertInfo != null) {
                clientConfig.setCertPath(this.clientCertInfo.certPath);
                clientConfig.setKeyPath(this.clientCertInfo.keyPath);
            } else if (this.connectionOptions.credentials != null) {
                clientConfig.setUsername(this.connectionOptions.credentials.username);
                clientConfig.setPassword(this.connectionOptions.credentials.password);
            }
        }
        AmqpAdapterClient clientFactory = AmqpAdapterClient.create(HonoConnection.newConnection(this.vertx, clientConfig));
        return clientFactory.connect().onSuccess(con -> {
            this.client = clientFactory;
        }).map(clientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndExecuteCommands() {
        AnsiConsole.systemInstall();
        try {
            Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
            Builtins builtins = new Builtins(workDir, null, null);
            builtins.rename(Builtins.Command.TTOP, "top");
            builtins.alias("zle", "widget");
            builtins.alias("bindkey", "keymap");
            PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
            CommandLine cmd = new CommandLine(this, factory);
            cmd.setExecutionExceptionHandler(CommandUtils::handleExecutionException);
            PicocliCommands picocliCommands = new PicocliCommands(cmd){

                @Override
                public String name() {
                    return "hono-cli";
                }
            };
            DefaultParser parser = new DefaultParser();
            try (Terminal terminal = TerminalBuilder.builder().build();){
                SystemRegistryImpl systemRegistry = new SystemRegistryImpl(parser, terminal, workDir, null);
                systemRegistry.setCommandRegistries(builtins, picocliCommands);
                systemRegistry.register("help", picocliCommands);
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser(parser).variable("list-max", 50).build();
                builtins.setLineReader(reader);
                factory.setTerminal(terminal);
                String prompt = "hono-cli/amqp-device> ";
                String rightPrompt = null;
                while (this.connected.get()) {
                    try {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("hono-cli/amqp-device> ", rightPrompt, (MaskingCallback)null, null);
                        systemRegistry.execute(line);
                    }
                    catch (UserInterruptException e) {
                        this.connected.compareAndSet(true, false);
                    }
                    catch (EndOfFileException e) {
                        this.connected.compareAndSet(true, false);
                    }
                    catch (Exception e) {
                        systemRegistry.trace(e);
                    }
                }
            }
        }
        catch (Throwable t) {
            System.err.println("catch Throwable");
            t.printStackTrace();
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    public void disconnectFromAdapter(@Observes ShutdownEvent ev) {
        if (this.client != null) {
            Promise<Void> result = Promise.promise();
            LOG.debug("disconnecting from AMQP adapter");
            this.client.disconnect(result);
            result.future().onComplete(ar -> LOG.debug("closed connection")).toCompletionStage().toCompletableFuture().join();
        }
    }

    private void handleCommandMessage(Message msg, String deviceId, Integer responseStatusCode) {
        String commandPayload = AmqpUtils.getPayloadAsString(msg);
        boolean isOneWay = msg.getReplyTo() == null;
        System.out.println("%s %s %s %s %s".formatted(isOneWay ? "ow" : "req", deviceId, msg.getSubject(), Optional.ofNullable(msg.getContentType()).orElse("-"), Optional.ofNullable(commandPayload).orElse("-")));
        if (!isOneWay && responseStatusCode != null) {
            this.vertx.runOnContext(sendResponse -> this.getClient().compose(client -> client.sendCommandResponse(msg.getReplyTo(), msg.getCorrelationId().toString(), responseStatusCode, Buffer.buffer("automatic response to [%s] command".formatted(msg.getSubject())), "text/plain", null)).onFailure(t -> {
                System.err.println("Could not send command response to Hono's AMQP adapter");
                CommandUtils.printError(t);
            }));
        }
    }

    private String getConsumerKey(String tenantId, String deviceId) {
        if (deviceId == null) {
            return "@@@self@@@";
        }
        StringBuilder b = new StringBuilder();
        b.append(deviceId);
        if (tenantId != null) {
            b.append("@").append(tenantId);
        }
        return b.toString();
    }

    @Override
    public Integer call() {
        try {
            this.getClient().onSuccess(client -> this.connected.set(true)).toCompletionStage().toCompletableFuture().join();
        }
        catch (CompletionException e) {
            System.err.println("Failed to connect to Hono's AMQP adapter");
            CommandUtils.printError(e.getCause());
            return 1;
        }
        this.readAndExecuteCommands();
        return 0;
    }

    private void handleError(Throwable t, String deviceId) {
        if (t instanceof ServiceInvocationException) {
            ServiceInvocationException e = (ServiceInvocationException)t;
            switch (e.getErrorCode()) {
                case 403: {
                    System.err.println("The currently connected device is not authorized to act on behalf of device [id: %1$s].\nIn order to authorize the connected device, its device identifier needs to be added to\nthe list of (gateway) devices that may act on behalf of device [id: %1$s].\nPlease refer to https://www.eclipse.org/hono/docs/concepts/connecting-devices/#connecting-via-a-device-gateway\nfor details regarding connecting devices via gateways.\n".formatted(deviceId));
                    break;
                }
                default: {
                    System.err.println("The AMQP protocol adapter was not able to process the request.");
                }
            }
        }
    }

    private void checkDeviceSpec(String tenantId, String deviceId) {
        if (tenantId != null && deviceId == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required option: '--device=<deviceId>'.\n");
        }
    }

    @CommandLine.Command(name="sub", description={"Start receiving commands for a device."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    void subscribe(@CommandLine.Option(names={"-t", "--tenant"}, description={"The tenant that the device belongs to.", "If not set explicitly, the tenant is determined from the device that has authenticated to the AMQP adapter.\n", "Unauthenticated clients must provide a non-null value to indicate the tenant of the device to start receiving commands for.\n", "It is an error to specify this option but to omit specifying a device identifier using the '-d=<deviceId>' option.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=20, converter={StringVariableConverter.class}) String tenantId, @CommandLine.Option(names={"-d", "--device"}, description={"The identifier of the device to start receiving commands for.", "If not set explicitly, the identifier of the device that has authenticated to the AMQP adapter will be used.\n", "Authenticated gateway devices can use this parameter to start receiving commands for another device that the gateway is authorized to act on behalf of.\n", "Unauthenticated clients must provide a non-{@code null} value to indicate the device to start receiving commands for.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=21, converter={StringVariableConverter.class}) String deviceId, @CommandLine.Option(names={"-s"}, description={"Automatically respond with a status code.", "The status code must be in the range [200,600).", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=25, converter={IntegerVariableConverter.class}) Integer responseStatusCode) {
        if (responseStatusCode != null && (responseStatusCode < 200 || responseStatusCode >= 600)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Unsupported value for option: '-s=<responseStatusCode>' must be an HTTP status code in the range [200,600).\n");
        }
        this.getClient().compose(client -> {
            Consumer<Message> commandHandler = msg -> {
                String id = Optional.ofNullable(AmqpUtils.getDeviceId(msg)).orElseGet(() -> Optional.ofNullable(deviceId).orElse("-"));
                this.handleCommandMessage((Message)msg, id, responseStatusCode);
            };
            return Optional.ofNullable(deviceId).map(id -> client.createDeviceSpecificCommandConsumer(tenantId, (String)id, commandHandler)).orElseGet(() -> client.createCommandConsumer(commandHandler));
        }).onSuccess(consumer -> this.activeConsumers.put(this.getConsumerKey(tenantId, deviceId), (CommandConsumer)consumer)).onFailure(t -> {
            System.err.println("Cannot subscribe to commands for device");
            this.handleError((Throwable)t, deviceId);
        }).toCompletionStage().toCompletableFuture().join();
    }

    @CommandLine.Command(name="unsub", description={"Stop receiving commands for a device."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    void unsubscribe(@CommandLine.Option(names={"-t", "--tenant"}, description={"The tenant that the device belongs to.", "If not set explicitly, the tenant is determined from the device that has authenticated to the AMQP adapter.\n", "Unauthenticated clients must provide a non-null value to indicate the tenant of the device to stop receiving commands for.\n", "It is an error to specify this option but to omit specifying a device identifier using the '-d=<deviceId>' option.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=20, converter={StringVariableConverter.class}) String tenantId, @CommandLine.Option(names={"-d", "--device"}, description={"The identifier of the device to stop receiving commands for.", "If not set explicitly, the identifier of the device that has authenticated to the AMQP adapter will be used.\n", "Authenticated gateway devices can use this parameter to stop receiving commands for another device that the gateway is authorized to act on behalf of.\n", "Unauthenticated clients must provide a non-{@code null} value to indicate the device to stop receiving commands for.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=21, converter={StringVariableConverter.class}) String deviceId) {
        Optional.ofNullable(this.activeConsumers.remove(this.getConsumerKey(tenantId, deviceId))).ifPresent(consumer -> consumer.close(null));
    }

    @CommandLine.Command(name="telemetry", description={"Send a telemetry message."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    void sendTelemetry(@CommandLine.Mixin TelemetrySendingOptions options) {
        this.checkDeviceSpec(options.tenantId, options.deviceId);
        this.getClient().compose(client -> client.sendTelemetry(QoS.AT_MOST_ONCE, Optional.ofNullable(options.payload).map(Buffer::buffer).orElse(null), options.contentType, options.tenantId, options.deviceId, null)).onFailure(t -> {
            System.err.println("Cannot send telemetry message.");
            this.handleError((Throwable)t, options.deviceId);
        }).toCompletionStage().toCompletableFuture().join();
    }

    @CommandLine.Command(name="event", description={"Send an event message."}, mixinStandardHelpOptions=true, versionProvider=PropertiesVersionProvider.class, sortOptions=false)
    void sendEvent(@CommandLine.Mixin TelemetrySendingOptions options) {
        this.checkDeviceSpec(options.tenantId, options.deviceId);
        this.getClient().compose(f -> f.sendEvent(Optional.ofNullable(options.payload).map(Buffer::buffer).orElse(null), options.contentType, options.tenantId, options.deviceId, null)).onFailure(t -> {
            System.err.println("Cannot send event message.");
            this.handleError((Throwable)t, options.deviceId);
        }).toCompletionStage().toCompletableFuture().join();
    }

    @CommandLine.Command
    static class TelemetrySendingOptions {
        @CommandLine.Option(names={"-t", "--tenant"}, description={"The tenant that the device belongs to.", "If not set explicitly, the tenant is determined from the device that has authenticated to the AMQP adapter.\n", "Unauthenticated clients must provide a non-null value to indicate the tenant of the device that the message originates from.\n", "It is an error to specify this option but to omit specifying a device identifier using the '-d=<deviceId>' option.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=20, converter={StringVariableConverter.class})
        String tenantId;
        @CommandLine.Option(names={"-d", "--device"}, description={"The device that the message originates from.", "If not set explicitly, the message is assumed to originate from the device that has authenticated to the AMQP adapter.\n", "This option can be used by authenticated gateway devices to send a message on behalf of another device. It can also be used by unauthenticated clients to indicate the device that the message originates from.\n", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=22, converter={StringVariableConverter.class})
        String deviceId;
        @CommandLine.Option(names={"--payload"}, description={"The (text) payload to include in the message.", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=25, converter={StringVariableConverter.class})
        String payload;
        @CommandLine.Option(names={"--content-type"}, description={"A Media Type describing the content of the message.", "See https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7", "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n"}, order=27, converter={StringVariableConverter.class})
        String contentType;

        TelemetrySendingOptions() {
        }
    }
}

