/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ComputingCacheContextInstances;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.Scopes;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

abstract class AbstractSharedContext
implements InjectableContext,
InjectableContext.ContextState {
    protected final ContextInstances instances;

    public AbstractSharedContext() {
        this(new ComputingCacheContextInstances());
    }

    public AbstractSharedContext(ContextInstances instances) {
        this.instances = Objects.requireNonNull(instances);
    }

    @Override
    public <T> T get(Contextual<T> contextual, final CreationalContext<T> creationalContext) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContext, "CreationalContext must not be null");
        final InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        return this.instances.computeIfAbsent(bean.getIdentifier(), new Supplier<ContextInstanceHandle<?>>(){

            @Override
            public ContextInstanceHandle<?> get() {
                return AbstractSharedContext.createInstanceHandle(bean, creationalContext);
            }
        }).get();
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        ContextInstanceHandle<?> handle = this.instances.getIfPresent(bean.getIdentifier());
        return handle != null ? (T)handle.get() : null;
    }

    @Override
    public InjectableContext.ContextState getState() {
        return this;
    }

    @Override
    public InjectableContext.ContextState getStateIfActive() {
        return this;
    }

    @Override
    public Map<InjectableBean<?>, Object> getContextualInstances() {
        return this.instances.getAllPresent().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle<?> handle = this.instances.remove(bean.getIdentifier());
        if (handle != null) {
            handle.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        Set<ContextInstanceHandle<?>> values = this.instances.getAllPresent();
        if (values.isEmpty()) {
            return;
        }
        Iterator<ContextInstanceHandle<?>> it = values.iterator();
        while (it.hasNext()) {
            ContextInstanceHandle<?> instanceHandle = it.next();
            if (instanceHandle.getBean().getDeclaringBean() == null) continue;
            instanceHandle.destroy();
            it.remove();
        }
        for (ContextInstanceHandle<?> instanceHandle : values) {
            instanceHandle.destroy();
        }
        this.instances.removeEach(null);
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (state != this) {
            throw new IllegalArgumentException("Invalid state: " + state.getClass().getName());
        }
        this.destroy();
    }

    private static <T> ContextInstanceHandle createInstanceHandle(InjectableBean<T> bean, CreationalContext<T> creationalContext) {
        return new ContextInstanceHandleImpl<T>(bean, bean.create(creationalContext), creationalContext);
    }
}

