/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.expression.Expression;
import io.smallrye.common.expression.ResolveContext;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import io.smallrye.config._private.ConfigMessages;
import jakarta.annotation.Priority;
import java.util.function.BiConsumer;

@Priority(value=3300)
public class ExpressionConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -539336551011916218L;
    private static final int MAX_DEPTH = 32;
    private final boolean enabled;

    public ExpressionConfigSourceInterceptor() {
        this(true);
    }

    public ExpressionConfigSourceInterceptor(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        return this.getValue(context, name, 1);
    }

    private ConfigValue getValue(final ConfigSourceInterceptorContext context, String name, final int depth) {
        if (depth >= 32) {
            throw ConfigMessages.msg.expressionExpansionTooDepth(name);
        }
        final ConfigValue configValue = context.proceed(name);
        if (!Expressions.isEnabled() || !this.enabled) {
            return configValue;
        }
        if (configValue == null || configValue.getValue() == null) {
            return null;
        }
        if (configValue.getValue().indexOf(36) == -1) {
            return configValue;
        }
        final ConfigValue.ConfigValueBuilder valueBuilder = configValue.from();
        Expression expression = Expression.compile(this.escapeDollarIfExists(configValue.getValue()), Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM, Expression.Flag.NO_SMART_BRACES, Expression.Flag.DOUBLE_COLON);
        String expanded = expression.evaluate(new BiConsumer<ResolveContext<RuntimeException>, StringBuilder>(){

            @Override
            public void accept(ResolveContext<RuntimeException> resolveContext, StringBuilder stringBuilder) {
                String key = resolveContext.getKey();
                int index = key.indexOf("::");
                if (index != -1) {
                    valueBuilder.withExtendedExpressionHandler(key.substring(0, index));
                    stringBuilder.append(key, index + 2, key.length());
                    return;
                }
                ConfigValue resolve = ExpressionConfigSourceInterceptor.this.getValue(context, key, depth + 1);
                if (resolve != null) {
                    if (!resolve.hasProblems()) {
                        stringBuilder.append(resolve.getValue());
                    } else {
                        valueBuilder.withProblems(resolve.getProblems());
                    }
                } else if (resolveContext.hasDefault()) {
                    resolveContext.expandDefault();
                } else {
                    valueBuilder.addProblem(new ConfigValidationException.Problem(ConfigMessages.msg.expandingElementNotFound(key, configValue.getName())));
                }
            }
        });
        return valueBuilder.withValue(expanded).build();
    }

    private String escapeDollarIfExists(String value) {
        int index = value.indexOf("\\$");
        if (index != -1) {
            int start = 0;
            StringBuilder builder = new StringBuilder();
            while (index != -1) {
                builder.append(value, start, index).append("$$");
                start = index + 2;
                index = value.indexOf("\\$", start);
            }
            builder.append(value.substring(start));
            return builder.toString();
        }
        return value;
    }
}

