/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import java.util.UUID;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.impl.ConnectionFactoryImpl;

public interface ConnectionFactory {
    public String getHost();

    public int getPort();

    public String getPathSeparator();

    default public String getServerRole() {
        return null;
    }

    public Future<ProtonConnection> connect(ProtonClientOptions var1, Handler<AsyncResult<ProtonConnection>> var2, Handler<ProtonConnection> var3);

    public Future<ProtonConnection> connect(ProtonClientOptions var1, String var2, String var3, Handler<AsyncResult<ProtonConnection>> var4, Handler<ProtonConnection> var5);

    public Future<ProtonConnection> connect(ProtonClientOptions var1, String var2, String var3, String var4, Handler<AsyncResult<ProtonConnection>> var5, Handler<ProtonConnection> var6);

    public static ConnectionFactory newConnectionFactory(Vertx vertx, ClientConfigProperties clientConfigProperties) {
        return new ConnectionFactoryImpl(vertx, clientConfigProperties);
    }

    public static String createContainerId(String name, String serverRole, UUID uuid) {
        UUID effectiveUuid;
        UUID uUID = effectiveUuid = uuid == null ? UUID.randomUUID() : uuid;
        if (serverRole == null) {
            return String.format("%s-%s", name, effectiveUuid);
        }
        return String.format("%s-%s-%s", name, serverRole, effectiveUuid);
    }
}

