/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime.handler;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.MultiValueQueryBasedFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.SingleValueQueryBasedFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.SumQueryBasedFeature;

public class QueryBasedFeatures {
    public static final String ANNOTATION_LITERAL = "QueryBasedFeature";
    public static final String ANNOTATION_SOURCE = "org.eclipse.incquery.querybasedfeature";
    public static final String PATTERN_FQN_KEY = "patternFQN";
    public static final String ECORE_ANNOTATION = "http://www.eclipse.org/emf/2002/Ecore";
    public static final String SETTING_DELEGATES_KEY = "settingDelegates";

    public static SingleValueQueryBasedFeature newSingleValueFeature(EStructuralFeature feature, boolean keepCache) {
        return new SingleValueQueryBasedFeature(feature, keepCache);
    }

    public static MultiValueQueryBasedFeature newMultiValueFeatue(EStructuralFeature feature, boolean keepCache) {
        return new MultiValueQueryBasedFeature(feature, keepCache);
    }

    public static SumQueryBasedFeature newSumFeature(EStructuralFeature feature) {
        return new SumQueryBasedFeature(feature, QueryBasedFeatureKind.SUM);
    }

    public static boolean checkEcoreAnnotation(EPackage pckg, EStructuralFeature feature, String patternFQN, boolean useModelCode) {
        boolean annotationsOK = true;
        if (useModelCode) {
            annotationsOK = QueryBasedFeatures.checkEcorePackageAnnotation(pckg);
        }
        return annotationsOK &= QueryBasedFeatures.checkFeatureAnnotation(feature, patternFQN);
    }

    public static boolean checkEcorePackageAnnotation(EPackage pckg) {
        return Iterables.any((Iterable)pckg.getEAnnotations(), (Predicate)new Predicate<EAnnotation>(){

            public boolean apply(EAnnotation annotation) {
                if (QueryBasedFeatures.ECORE_ANNOTATION.equals(annotation.getSource())) {
                    return Iterables.any((Iterable)annotation.getDetails().entrySet(), (Predicate)new Predicate<Map.Entry<String, String>>(){

                        public boolean apply(Map.Entry<String, String> entry) {
                            if (QueryBasedFeatures.SETTING_DELEGATES_KEY.equals(entry.getKey())) {
                                StringTokenizer delegateTokents = new StringTokenizer(entry.getValue());
                                while (delegateTokents.hasMoreTokens()) {
                                    if (!QueryBasedFeatures.ANNOTATION_SOURCE.equals(delegateTokents.nextToken())) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                }
                return false;
            }
        });
    }

    public static boolean checkFeatureAnnotation(EStructuralFeature feature, final String patternFQN) {
        return Iterables.any((Iterable)feature.getEAnnotations(), (Predicate)new Predicate<EAnnotation>(){

            public boolean apply(EAnnotation annotation) {
                if (QueryBasedFeatures.ANNOTATION_SOURCE.equals(annotation.getSource())) {
                    return Iterables.any((Iterable)annotation.getDetails().entrySet(), (Predicate)new Predicate<Map.Entry<String, String>>(){

                        public boolean apply(Map.Entry<String, String> entry) {
                            boolean keyOK = QueryBasedFeatures.PATTERN_FQN_KEY.equals(entry.getKey());
                            boolean valueOK = patternFQN.equals(entry.getValue());
                            return keyOK && valueOK;
                        }
                    });
                }
                return false;
            }
        });
    }
}

