/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public abstract class QueryBasedFeature {
    private IncQueryMatcher<IPatternMatch> matcher;
    private Set<IPatternMatch> matchFoundEvents;
    private Set<IPatternMatch> matchLostEvents;
    private final EStructuralFeature feature;
    private String sourceParamName;
    private String targetParamName;
    private boolean keepCache = true;
    private boolean initialized = false;
    private final List<ENotificationImpl> notifications = new ArrayList<ENotificationImpl>();
    private ModelUpdateListener listener;
    private EngineLifecycleListener engineLifecycleListener;
    private MatchUpdateListener matchUpdateListener;

    protected void initialize(IncQueryMatcher<IPatternMatch> matcher, String sourceParamName, String targetParamName) {
        if (this.initialized) {
            IncQueryLoggingUtil.getLogger(this.getClass()).error((Object)"[QueryBasedFeature] Feature already initialized!");
            return;
        }
        this.initialized = true;
        this.matcher = matcher;
        this.sourceParamName = sourceParamName;
        this.targetParamName = targetParamName;
        if (matcher.getPositionOfParameter(sourceParamName) == null) {
            IncQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Source parameter " + sourceParamName + " not found!"));
        }
        if (targetParamName != null && matcher.getPositionOfParameter(targetParamName) == null) {
            IncQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Target parameter " + targetParamName + " not found!"));
        }
        this.matchFoundEvents = Sets.newHashSet();
        this.matchLostEvents = Sets.newHashSet();
        this.matchUpdateListener = new MatchUpdateListener();
        this.engineLifecycleListener = new EngineLifecycleListener();
        this.listener = new ModelUpdateListener();
    }

    private void sendNotfications() {
        while (!this.notifications.isEmpty()) {
            ENotificationImpl remove = this.notifications.remove(0);
            ((Notifier)remove.getNotifier()).eNotify((Notification)remove);
        }
    }

    public QueryBasedFeature(EStructuralFeature feature, boolean keepCache) {
        this.feature = feature;
        this.keepCache = keepCache;
    }

    protected IncQueryMatcher<IPatternMatch> getMatcher() {
        return this.matcher;
    }

    protected EStructuralFeature getFeature() {
        return this.feature;
    }

    protected String getSourceParamName() {
        return this.sourceParamName;
    }

    protected String getTargetParamName() {
        return this.targetParamName;
    }

    protected boolean isCached() {
        return this.keepCache;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public abstract QueryBasedFeatureKind getKind();

    protected abstract void afterUpdate();

    protected abstract void beforeUpdate();

    protected void startMonitoring() {
        AdvancedIncQueryEngine engine = this.engineForMatcher();
        engine.addMatchUpdateListener(this.matcher, (IMatchUpdateListener)this.matchUpdateListener, true);
        engine.addLifecycleListener((IncQueryEngineLifecycleListener)this.engineLifecycleListener);
        engine.addModelUpdateListener((IncQueryModelUpdateListener)this.listener);
        this.listener.notifyChanged(IncQueryModelUpdateListener.ChangeLevel.MATCHSET);
    }

    protected AdvancedIncQueryEngine engineForMatcher() {
        return (AdvancedIncQueryEngine)this.matcher.getEngine();
    }

    public abstract Object getValue(Object var1);

    private Collection<IPatternMatch> processNewMatches(Collection<IPatternMatch> signatures) {
        ArrayList<IPatternMatch> processed = new ArrayList<IPatternMatch>();
        for (IPatternMatch signature : signatures) {
            this.processAppearedMatch(signature);
            processed.add(signature);
        }
        return processed;
    }

    protected abstract void processAppearedMatch(IPatternMatch var1);

    protected InternalEObject getSourceValue(IPatternMatch signature) {
        return (InternalEObject)signature.get(this.sourceParamName);
    }

    protected Object getTargetValue(IPatternMatch signature) {
        return signature.get(this.targetParamName);
    }

    private Collection<IPatternMatch> processLostMatches(Collection<IPatternMatch> signatures) {
        ArrayList<IPatternMatch> processed = new ArrayList<IPatternMatch>();
        for (IPatternMatch signature : signatures) {
            this.processDisappearedMatch(signature);
            processed.add(signature);
        }
        return processed;
    }

    protected abstract void processDisappearedMatch(IPatternMatch var1);

    protected void appendNotificationToList(ENotificationImpl notification) {
        this.notifications.add(notification);
    }

    private final class EngineLifecycleListener
    implements IncQueryEngineLifecycleListener {
        private EngineLifecycleListener() {
        }

        public void matcherInstantiated(IncQueryMatcher<? extends IPatternMatch> matcher) {
        }

        public void engineWiped() {
            String patternName = QueryBasedFeature.this.matcher.getPatternName();
            try {
                QueryBasedFeature.this.matcher = QuerySpecificationRegistry.getQuerySpecification((String)patternName).getMatcher((IncQueryEngine)QueryBasedFeature.this.engineForMatcher());
            }
            catch (IncQueryException e) {
                IncQueryLoggingUtil.getLogger(this.getClass()).error((Object)("[QueryBasedFeature] Exception during wipe callback: " + e.getMessage()), (Throwable)e);
            }
            QueryBasedFeature.this.matchFoundEvents.clear();
            QueryBasedFeature.this.matchLostEvents.clear();
        }

        public void engineDisposed() {
        }

        public void engineBecameTainted(String description, Throwable t) {
        }
    }

    private final class MatchUpdateListener
    implements IMatchUpdateListener<IPatternMatch> {
        private MatchUpdateListener() {
        }

        public void notifyAppearance(IPatternMatch match) {
            boolean removed = QueryBasedFeature.this.matchLostEvents.remove(match);
            if (!removed) {
                QueryBasedFeature.this.matchFoundEvents.add(match);
            }
        }

        public void notifyDisappearance(IPatternMatch match) {
            boolean removed = QueryBasedFeature.this.matchFoundEvents.remove(match);
            if (!removed) {
                QueryBasedFeature.this.matchLostEvents.add(match);
            }
        }
    }

    private final class ModelUpdateListener
    implements IncQueryModelUpdateListener {
        private ModelUpdateListener() {
        }

        public void notifyChanged(IncQueryModelUpdateListener.ChangeLevel changeLevel) {
            QueryBasedFeature.this.beforeUpdate();
            QueryBasedFeature.this.matchFoundEvents.removeAll(QueryBasedFeature.this.processNewMatches(QueryBasedFeature.this.matchFoundEvents));
            QueryBasedFeature.this.matchLostEvents.removeAll(QueryBasedFeature.this.processLostMatches(QueryBasedFeature.this.matchLostEvents));
            QueryBasedFeature.this.afterUpdate();
            QueryBasedFeature.this.sendNotfications();
        }

        public IncQueryModelUpdateListener.ChangeLevel getLevel() {
            return IncQueryModelUpdateListener.ChangeLevel.MATCHSET;
        }
    }
}

