/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class SingleValueQueryBasedFeature
extends QueryBasedFeature {
    private final Map<InternalEObject, Object> singleRefMemory = new HashMap<InternalEObject, Object>();
    private final Map<InternalEObject, Object> updateMemory = new HashMap<InternalEObject, Object>();

    protected SingleValueQueryBasedFeature(EStructuralFeature feature, boolean keepCache) {
        super(feature, keepCache);
    }

    public Object getSingleReferenceValue(Object source) {
        IPatternMatch patternMatch;
        if (this.isCached()) {
            return this.singleRefMemory.get(source);
        }
        if (!this.isInitialized()) {
            return null;
        }
        IPatternMatch match = this.getMatcher().newEmptyMatch();
        match.set(this.getSourceParamName(), source);
        if (this.getMatcher().countMatches(match) > 1) {
            String message = "[QueryBasedFeature] Single reference derived feature has multiple possible values, returning one arbitrary value";
            this.engineForMatcher().getLogger().warn((Object)message);
        }
        if ((patternMatch = this.getMatcher().getOneArbitraryMatch(match)) != null) {
            return this.getTargetValue(patternMatch);
        }
        return null;
    }

    @Override
    protected void processAppearedMatch(IPatternMatch signature) {
        Object target = this.getTargetValue(signature);
        InternalEObject source = this.getSourceValue(signature);
        if (target != null) {
            if (this.updateMemory.get(source) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[QueryBasedFeature] Space-time continuum breached (should never happen): multiple values for single feature!\n");
                sb.append("\n >> First value: ").append(source).append(" -> ").append(this.updateMemory.get(source));
                sb.append("\n >> Second value: ").append(source).append(" -> ").append(target);
                this.engineForMatcher().getLogger().error((Object)sb.toString());
            } else {
                this.updateMemory.put(source, target);
            }
        }
    }

    @Override
    protected void processDisappearedMatch(IPatternMatch signature) {
        Object target = this.getTargetValue(signature);
        InternalEObject source = this.getSourceValue(signature);
        if (target != null) {
            Object updateValue = this.updateMemory.get(source);
            if (updateValue != null) {
                this.appendNotificationToList(new ENotificationImpl(source, 1, this.getFeature(), target, updateValue));
                this.setSingleRefMemory(source, updateValue);
                this.updateMemory.remove(source);
            } else {
                this.appendNotificationToList(new ENotificationImpl(source, 1, this.getFeature(), target, null));
                this.setSingleRefMemory(source, null);
            }
        }
    }

    private void setSingleRefMemory(InternalEObject source, Object singleRefMemory) {
        if (this.isCached()) {
            this.singleRefMemory.put(source, singleRefMemory);
        }
    }

    @Override
    protected void afterUpdate() {
        if (!this.updateMemory.isEmpty()) {
            for (InternalEObject source : this.updateMemory.keySet()) {
                this.appendNotificationToList(new ENotificationImpl(source, 1, this.getFeature(), null, this.updateMemory.get(source)));
                this.setSingleRefMemory(source, this.updateMemory.get(source));
            }
            this.updateMemory.clear();
        }
    }

    @Override
    protected void beforeUpdate() {
        this.updateMemory.clear();
    }

    @Override
    public QueryBasedFeatureKind getKind() {
        return QueryBasedFeatureKind.SINGLE_REFERENCE;
    }

    @Override
    public Object getValue(Object source) {
        return this.getSingleReferenceValue(source);
    }
}

