/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.apiimpl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.internal.apiimpl.GenericPatternMatcher;

public abstract class GenericPatternMatch
extends BasePatternMatch {
    private final GenericPatternMatcher matcher;
    private final Object[] array;

    private GenericPatternMatch(GenericPatternMatcher matcher, Object[] array) {
        this.matcher = matcher;
        this.array = array;
    }

    @Override
    public Object get(String parameterName) {
        Integer index = this.matcher.getPositionOfParameter(parameterName);
        return index == null ? null : this.array[index];
    }

    @Override
    public boolean set(String parameterName, Object newValue) {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
        Integer index = this.matcher.getPositionOfParameter(parameterName);
        if (index == null) {
            return false;
        }
        this.array[index.intValue()] = newValue;
        return true;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.array.length) {
            result = 31 * result + (this.array[i] == null ? 0 : this.array[i].hashCode());
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericPatternMatch)) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IPatternMatch)) {
                return false;
            }
            IPatternMatch other = (IPatternMatch)obj;
            if (!this.pattern().equals(other.pattern())) {
                return false;
            }
            return Arrays.deepEquals(this.array, other.toArray());
        }
        GenericPatternMatch other = (GenericPatternMatch)obj;
        return this.pattern().equals(other.pattern()) && Arrays.deepEquals(this.array, other.array);
    }

    @Override
    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.array.length) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("\"" + this.parameterNames().get(i) + "\"=" + GenericPatternMatch.prettyPrintValue(this.array[i]));
            ++i;
        }
        return result.toString();
    }

    @Override
    public Pattern pattern() {
        return this.matcher.getPattern();
    }

    @Override
    public String patternName() {
        return this.matcher.getPatternName();
    }

    @Override
    public List<String> parameterNames() {
        return this.matcher.getParameterNames();
    }

    /* synthetic */ GenericPatternMatch(GenericPatternMatcher genericPatternMatcher, Object[] objectArray, GenericPatternMatch genericPatternMatch) {
        this(genericPatternMatcher, objectArray);
    }

    static final class Immutable
    extends GenericPatternMatch {
        Immutable(GenericPatternMatcher matcher, Object[] array) {
            super(matcher, array, null);
        }

        @Override
        public boolean isMutable() {
            return false;
        }
    }

    static final class Mutable
    extends GenericPatternMatch {
        Mutable(GenericPatternMatcher matcher, Object[] array) {
            super(matcher, array, null);
        }

        @Override
        public boolean isMutable() {
            return true;
        }
    }
}

