/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.markers.util;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.validation.Activator;
import org.eclipse.sphinx.emf.validation.markers.util.FeatureAttUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerUtil {
    public static int getSeverity(IMarker marker) {
        Assert.isNotNull((Object)marker);
        return marker.getAttribute("severity", -1);
    }

    public static String getMessage(IMarker marker) {
        Assert.isNotNull((Object)marker);
        return marker.getAttribute("message", "---");
    }

    public static Set<String> getFeatures(IMarker marker) {
        Assert.isNotNull((Object)marker);
        Set<String> result = null;
        try {
            result = FeatureAttUtil.unpackFeatures(marker);
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsInfo((Plugin)Activator.getDefault(), (Object)((Object)ex));
        }
        return result;
    }

    public static EObject getConnectedEObjectFromMarker(IMarker marker) {
        IResource resource;
        if (marker != null && (resource = marker.getResource()) instanceof IFile) {
            URI uri;
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)resource);
            String uriAttribute = marker.getAttribute("uri", null);
            if (editingDomain != null && uriAttribute != null && EcoreResourceUtil.exists((URI)(uri = URI.createURI((String)uriAttribute, (boolean)true)))) {
                return editingDomain.getResourceSet().getEObject(uri, true);
            }
        }
        return null;
    }
}

