/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.emf.validation.ui.util.Messages;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCleanProblemMarkersAction
extends BaseSelectionListenerAction {
    public BasicCleanProblemMarkersAction() {
        super(Messages._UI_Clean_menu_item);
        this.setDescription(Messages._UI_Clean_simple_description);
    }

    public void run() {
        final List<EObject> selectedModelObjects = this.getSelectedModelObjects();
        if (!selectedModelObjects.isEmpty()) {
            WorkspaceJob job = new WorkspaceJob(Messages._Job_Clean_Markers){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    for (EObject eObject : selectedModelObjects) {
                        ValidationMarkerManager.getInstance().removeMarkers(eObject, 2, "org.eclipse.core.resources.problemmarker");
                    }
                    return Status.OK_STATUS;
                }
            };
            ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>();
            for (EObject eObject : selectedModelObjects) {
                IFile file = EcorePlatformUtil.getFile((EObject)eObject);
                if (file == null) continue;
                IResourceRuleFactory ruleFactory = file.getWorkspace().getRuleFactory();
                myRules.add(ruleFactory.modifyRule((IResource)file));
                myRules.add(ruleFactory.createRule((IResource)file));
            }
            job.setRule((ISchedulingRule)new MultiRule(myRules.toArray(new ISchedulingRule[myRules.size()])));
            job.setPriority(40);
            job.schedule();
        }
    }

    protected List<EObject> getSelectedModelObjects() {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<IFile> files = new ArrayList<IFile>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object selectedObject : selection.toList()) {
            Object object;
            if (selectedObject instanceof IProject) {
                IProject project = (IProject)selectedObject;
                if (!project.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IProject)((IProject)selectedObject), (boolean)true));
                continue;
            }
            if (selectedObject instanceof IFolder) {
                IFolder folder = (IFolder)selectedObject;
                if (!folder.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IFolder)((IFolder)selectedObject)));
                continue;
            }
            if (selectedObject instanceof IFile) {
                IFile file = (IFile)selectedObject;
                if (!file.isAccessible()) continue;
                files.add((IFile)selectedObject);
                continue;
            }
            if (selectedObject instanceof EObject) {
                result.add((EObject)selectedObject);
                continue;
            }
            if (!(selectedObject instanceof IWrapperItemProvider) || !((object = AdapterFactoryEditingDomain.unwrap(selectedObject)) instanceof EObject)) continue;
            result.add((EObject)object);
        }
        if (!files.isEmpty()) {
            for (IFile file : files) {
                EObject modelRoot = EcorePlatformUtil.getModelRoot((IFile)file);
                if (modelRoot == null) continue;
                result.add(modelRoot);
            }
        }
        return result;
    }
}

