/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.ui.ICompareInputDetailsProvider;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementCompareInput
extends ModelCompareInput {
    public ModelElementCompareInput(MatchModel matchModel, DiffModel diffModel) {
        super(matchModel, diffModel);
    }

    public ModelElementCompareInput(MatchResourceSet matchResourceset, DiffResourceSet diffResourceSet) {
        super(matchResourceset, diffResourceSet);
    }

    public ModelElementCompareInput(MatchModel matchModel, DiffModel diffModel, ICompareInputDetailsProvider provider) {
        super(matchModel, diffModel, provider);
    }

    public ModelElementCompareInput(MatchResourceSet matchResourceset, DiffResourceSet diffResourceSet, ICompareInputDetailsProvider provider) {
        super(matchResourceset, diffResourceSet, provider);
    }

    protected void doCopy(DiffElement element, boolean leftToRight) {
        this.doTransactionalCopy(leftToRight ? WorkspaceEditingDomainUtil.getEditingDomain((Object)this.getRightResource()) : WorkspaceEditingDomainUtil.getEditingDomain((Object)this.getLeftResource()), Collections.singletonList(element), leftToRight);
    }

    protected void doCopy(List<DiffElement> elements, boolean leftToRight) {
        this.doTransactionalCopy(leftToRight ? WorkspaceEditingDomainUtil.getEditingDomain((Object)this.getRightResource()) : WorkspaceEditingDomainUtil.getEditingDomain((Object)this.getLeftResource()), elements, leftToRight);
    }

    protected void doTransactionalCopy(TransactionalEditingDomain editingDomain, final List<DiffElement> elements, final boolean leftToRight) {
        try {
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable(){

                public void run() {
                    MergeService.merge((List)elements, (boolean)leftToRight);
                }
            }, (String)(leftToRight ? Messages.action_copyLeftToRight : Messages.action_copyRightToLeft));
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }
}

