/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.gmf.runtime.ui.internal.editor;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class ModelEditorUndoContextManager
implements IDisposable {
    protected IWorkbenchPartSite site;
    protected IWorkbenchPart targetPart;
    protected IPropertySheetPage targetPropertySheetPage;
    protected TransactionalEditingDomain editingDomain;
    private IUndoContext undoContext = null;
    private IOperationHistoryListener undoableOperationBeginListener;

    public ModelEditorUndoContextManager(IWorkbenchPartSite site, IWorkbenchPart targetPart, TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)site);
        Assert.isNotNull((Object)targetPart);
        Assert.isNotNull((Object)editingDomain);
        this.site = site;
        this.targetPart = targetPart;
        this.editingDomain = editingDomain;
        this.undoableOperationBeginListener = this.createUndoableOperationBeginListener();
        Assert.isNotNull((Object)this.undoableOperationBeginListener);
        this.getOperationHistory().addOperationHistoryListener(this.undoableOperationBeginListener);
    }

    public void setTargetPropertySheetPage(IPropertySheetPage targetPropertySheetPage) {
        this.targetPropertySheetPage = targetPropertySheetPage;
    }

    protected boolean isTargetPartActive() {
        return this.targetPart == this.site.getWorkbenchWindow().getPartService().getActivePart();
    }

    protected boolean isTargetPropertySheetPageActive() {
        IWorkbenchPart activePart;
        if (this.targetPropertySheetPage != null && (activePart = this.site.getWorkbenchWindow().getPartService().getActivePart()) instanceof PropertySheet) {
            return this.targetPropertySheetPage == ((PropertySheet)activePart).getCurrentPage();
        }
        return false;
    }

    protected IOperationHistory getOperationHistory() {
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)commandStack).getOperationHistory();
        }
        return OperationHistoryFactory.getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        if (this.undoContext == null) {
            this.undoContext = this.createUndoContext(this.targetPart);
        }
        return this.undoContext;
    }

    protected IUndoContext createUndoContext(IWorkbenchPart targetPart) {
        return new ObjectUndoContext((Object)targetPart);
    }

    protected IUndoContext getDefaultUndoContext() {
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)commandStack).getDefaultUndoContext();
        }
        return null;
    }

    protected IOperationHistoryListener createUndoableOperationBeginListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation operation = event.getOperation();
                if (event.getEventType() == 1 && operation.canUndo()) {
                    this.handleUndoableOperationBegin(operation);
                }
            }

            private void handleUndoableOperationBegin(final IUndoableOperation operation) {
                if (ModelEditorUndoContextManager.this.site != null && ModelEditorUndoContextManager.this.site.getShell() != null && !ModelEditorUndoContextManager.this.site.getShell().isDisposed()) {
                    ModelEditorUndoContextManager.this.site.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ModelEditorUndoContextManager.this.isTargetPartActive() || ModelEditorUndoContextManager.this.isTargetPropertySheetPageActive()) {
                                IUndoContext defaultUndoContext = ModelEditorUndoContextManager.this.getDefaultUndoContext();
                                if (defaultUndoContext != null) {
                                    operation.removeContext(defaultUndoContext);
                                }
                                operation.addContext(ModelEditorUndoContextManager.this.undoContext);
                            }
                        }
                    });
                }
            }
        };
    }

    public void dispose() {
        this.getOperationHistory().removeOperationHistoryListener(this.undoableOperationBeginListener);
        if (this.undoContext != null) {
            this.getOperationHistory().dispose(this.undoContext, true, true, true);
        }
    }
}

