/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.stem.model.codegen.CodeGenConstants;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.codegen.ModelGeneratorDescriptors;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.codegen.descriptor.ModelGeneratorDescriptor;

public class STEMGenPackage {
    public static final Map<String, String> FIXED_DEFAULT_PACKAGE_STRING_PROVIDERS = new HashMap<String, String>();
    public static final Map<String, String> FIXED_DEFAULT_PACKAGE_PROPERTY_EDITORS = new HashMap<String, String>();
    protected GenPackage pkg;
    protected List<ModelGeneratorDescriptor> descriptors;

    static {
        FIXED_DEFAULT_PACKAGE_PROPERTY_EDITORS.put("org.eclipse.stem.diseasemodels.multipopulation", "org.eclipse.stem.diseasemodels.multipopulation.presentation.MultiPopulationDiseaseModelPropertyEditor");
        FIXED_DEFAULT_PACKAGE_STRING_PROVIDERS.put("org.eclipse.stem.diseasemodels.multipopulation", "org.eclipse.stem.diseasemodels.multipopulation.presentation.MultiPopulationPropertyStringProviderAdapterFactory.MultiPopulationPropertyStringProviderAdapter");
    }

    public STEMGenPackage(GenPackage pkg) {
        this.pkg = pkg;
    }

    public static STEMGenPackage get(GenPackage pkg) {
        return new STEMGenPackage(pkg);
    }

    public GenPackage getGenPackage() {
        return this.pkg;
    }

    public List<ModelGeneratorDescriptor> getPackageDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = ModelGeneratorDescriptors.getInstance().getDescriptorsForGenPackage(this.pkg);
        }
        return this.descriptors;
    }

    public boolean usesSTEMGenerator() {
        return this.pkg.getEcorePackage().getEAnnotation("http:///org/eclipse/stem/modelgen/generated") != null;
    }

    public String getDefaultStringProviderClassName() {
        String stringProviderAdapter = FIXED_DEFAULT_PACKAGE_STRING_PROVIDERS.get(this.pkg.getNSName());
        if (stringProviderAdapter == null) {
            System.err.println("WARNING: String Provider Adapter is not found through normal procedures.  Trying best guess.  This may cause compile errors.");
            List<ModelGeneratorDescriptor> descriptors = this.getPackageDescriptors();
            if (descriptors != null && descriptors.size() > 0) {
                stringProviderAdapter = GeneratorUtils.getQualifiedJavaNameForDescriptor(descriptors.get(0).getPropertyStringAdapter());
            }
            if (stringProviderAdapter == null) {
                System.err.println("FATAL: String Provider Adapter lookup failed. " + this.pkg.getNSURI());
            }
        }
        return stringProviderAdapter;
    }

    public String getDefaultPropertyEditorClassName() {
        String propertyEditor = FIXED_DEFAULT_PACKAGE_PROPERTY_EDITORS.get(this.pkg.getNSName());
        if (propertyEditor == null) {
            System.err.println("WARNING: Property Editor is not found through normal procedures.  Trying best guess.  This may cause compile errors.");
            List<ModelGeneratorDescriptor> descriptors = this.getPackageDescriptors();
            if (descriptors != null && descriptors.size() > 0) {
                propertyEditor = GeneratorUtils.getQualifiedJavaNameForDescriptor(descriptors.get(0).getPropertyEditor());
            }
            if (propertyEditor == null) {
                System.err.println("FATAL: Property Editor lookup failed. " + this.pkg.getNSURI());
            }
        }
        return propertyEditor;
    }

    public boolean hasComputationalModel() {
        return this.getComputationalModelClasses().size() > 0;
    }

    public List<STEMGenClass> getComputationalModelClasses() {
        return GeneratorUtils.getSTEMGenClasses(GeneratorUtils.findGenClassesThatExtendBaseType(this.pkg, CodeGenConstants.INTEGRATION_DECORATOR_DESCRIPTOR));
    }

    public List<STEMGenClass> getIntegrationLabelClasses() {
        return GeneratorUtils.getSTEMGenClasses(GeneratorUtils.findGenClassesThatExtendBaseType(this.pkg, CodeGenConstants.INTEGRATION_LABEL_DESCRIPTOR));
    }

    public List<STEMGenClass> getIntegrationLabelValueClasses() {
        return GeneratorUtils.getSTEMGenClasses(GeneratorUtils.findGenClassesThatExtendBaseType(this.pkg, CodeGenConstants.INTEGRATION_LABEL_VALUE_DESCRIPTOR));
    }

    public Map<String, String> getPropertyEditorAdapterFactoryBaseTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (ModelGeneratorDescriptor descriptor : this.getPackageDescriptors()) {
            String className = GeneratorUtils.getQualifiedJavaNameForDescriptor(descriptor.getPropertyEditorAdapterFactory());
            if (className == null) continue;
            types.put(descriptor.getModelType(), className);
        }
        return types;
    }

    public Map<String, String> getPropertyEditorAdapterBaseTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (ModelGeneratorDescriptor descriptor : this.getPackageDescriptors()) {
            String className = GeneratorUtils.getQualifiedJavaNameForDescriptor(descriptor.getPropertyEditorAdapter());
            if (className == null) continue;
            types.put(descriptor.getModelType(), className);
        }
        return types;
    }

    public Map<String, String> getPropertyStringAdapterFactoryBaseTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (ModelGeneratorDescriptor descriptor : this.getPackageDescriptors()) {
            String className = GeneratorUtils.getQualifiedJavaNameForDescriptor(descriptor.getPropertyStringAdapterFactory());
            if (className == null) continue;
            types.put(descriptor.getModelType(), className);
        }
        return types;
    }
}

