/* FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/

var path = null;
var WIDTH = 600;
var HEIGHT = 450;
var ratio = 1;
function parsePath(){
	if(window.location.href.match(/\?path=(.+)$/)) {
		path = unescape(RegExp.$1);
	}
}
function window_onLoad() {
	parsePath();
	window.title = "Loading images... - File Manager Image Viewer";
	var left = (screen.availWidth - WIDTH) / 2;
	var top = (screen.availHeight - HEIGHT) / 2;
	window.resizeTo(WIDTH, HEIGHT);
	window.moveTo(left, top);
	
	var src = SERVER_DONWLOADER_PATH + '?contentType=image/jpeg&path=' + encodeURIComponent(path) + '&token=' + (new Date()).getTime();
	window.currentImage = new Image();
	window.currentImage.onload = function() {
//		var image = document.getElementById('image');
//		image.setAttribute('src', window.currentImage.src);
		var description = "Size: " + window.currentImage.naturalWidth + " x " + window.currentImage.naturalHeight;
		var descriptionLabel = document.getElementById('description');
		descriptionLabel.setAttribute("value", description);
		sizeToFix();
	};
	window.currentImage.src = src;
}
function sizeToFix() {
	var box = document.getElementById("box");
	var bw = box.boxObject.width - 10;
	var bh = box.boxObject.height - 10;

	var r1 = bh / window.currentImage.naturalHeight;
	var r2 = bw / window.currentImage.naturalWidth;
	
	var r = r1;
	if(r1 > r2) { 
		r = r2;
	}

	if (r > 1) r = 1;

	resizeByRatio(r);
}
function resizeByRatio(r) {
	var w = window.currentImage.naturalWidth * r;
	var h = window.currentImage.naturalHeight * r;
	var image = document.createElement('image');
	image.setAttribute("src", window.currentImage.src);
	image.setAttribute("width", w);
	image.setAttribute("height", h);
	var imageBox = document.getElementById("imageBox");
	try{
		imageBox.removeChild(imageBox.childNodes[0]);
	}catch(e) {}
	imageBox.appendChild(image);
	ratio = r;
	window.title = path + " - " + (Math.round(ratio * 100)) + "% - File Manager Image Viewer";
}
function zoomIn() {
	if(ratio < 8) resizeByRatio(ratio * 2);
}
function zoomOut() {
	if(ratio > 0.125) resizeByRatio(ratio / 2);
}