/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JRexGreInstaller {
    public static boolean installGRE(String greArchive, String installPath, Object exService, Method update, Method status) {
        JRexGreInstaller.log("installGRE() greArchive<" + greArchive + "> installPath<" + installPath + "> ");
        try {
            boolean madeDirs;
            if (installPath == null) {
                installPath = System.getProperty("user.home");
            }
            if (!installPath.endsWith(File.separator)) {
                installPath = installPath + File.separator;
            }
            JRexGreInstaller.log("installGRE() installPath<" + installPath + ">");
            File installDir = new File(installPath);
            int dotIndex = greArchive.lastIndexOf(".");
            String dirName = greArchive;
            if (dotIndex != -1) {
                dirName = greArchive.substring(0, dotIndex);
            }
            JRexGreInstaller.log("installGRE() dirName<" + dirName + ">");
            File greDirPath = new File(installDir.getAbsolutePath(), dirName);
            JRexGreInstaller.log("installGRE() greDirPath<" + greDirPath + ">");
            status.invoke(exService, (Object[])new String[]{"Using GRE Directory Path <" + greDirPath + ">"});
            update.invoke(exService, new Integer(2));
            if (greDirPath.exists()) {
                JRexGreInstaller.log("installGRE() GRE ALREADY INSTALLED !!!");
                status.invoke(exService, (Object[])new String[]{"Found old GRE Directory, Removing...."});
                greDirPath.delete();
            }
            if (!(madeDirs = installDir.exists())) {
                madeDirs = installDir.mkdirs();
            }
            JRexGreInstaller.log("installGRE() installDir<" + installDir + "> madeDirs <" + madeDirs + ">");
            if (madeDirs) {
                JRexGreInstaller.installToDir(installDir, greArchive, exService, update, status);
                JRexGreInstaller.log("installGRE() GRE InsatlledPath<" + greDirPath.getAbsolutePath() + ">");
                System.setProperty("jrex.gre.path", greDirPath.getAbsolutePath());
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private static final void installToDir(File dir, String greArchive, Object exService, Method update, Method status) throws Exception {
        ZipEntry ze;
        JRexGreInstaller.log("installToDir() dir<" + dir + "> greArchive<" + greArchive + ">");
        URL resURL = JRexGreInstaller.class.getResource(greArchive);
        JRexGreInstaller.log("installToDir() resURL<" + resURL + ">");
        status.invoke(exService, (Object[])new String[]{"Getting GRE Archive From <" + resURL + ">"});
        update.invoke(exService, new Integer(3));
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(resURL.openStream()));
        status.invoke(exService, (Object[])new String[]{"Got GRE Archive"});
        update.invoke(exService, new Integer(6));
        double i = 0.0;
        int len = 0;
        byte[] buff = new byte[2048];
        while ((ze = zin.getNextEntry()) != null) {
            JRexGreInstaller.log("installToDir() ZipEntry <" + ze + ">");
            File destFile = new File(dir.getAbsolutePath() + File.separator + ze.getName().replace('/', File.separatorChar));
            JRexGreInstaller.log("installToDir() destFile <" + destFile + ">");
            if (ze.isDirectory()) {
                JRexGreInstaller.log("installToDir() ZipEntry <" + ze + "> is Directory ");
                zin.closeEntry();
                continue;
            }
            JRexGreInstaller.log("installToDir() ZipEntry <" + ze + "> Parent <" + destFile.getParent() + ">");
            if (destFile.getParent() != null) {
                File destParent = new File(destFile.getParent());
                boolean madeDirs = destParent.mkdirs();
                JRexGreInstaller.log("installToDir() destParent <" + destParent + "> madeDirs <" + madeDirs + ">");
            }
            status.invoke(exService, (Object[])new String[]{"Installing file " + destFile.getName() + "...."});
            FileOutputStream fout = new FileOutputStream(destFile);
            while ((len = zin.read(buff)) != -1) {
                fout.write(buff, 0, len);
            }
            fout.close();
            zin.closeEntry();
            update.invoke(exService, new Integer((int)(i += 0.5)));
            JRexGreInstaller.log("installToDir() destFile<" + destFile + "> Unzipping done!!!!");
        }
        zin.close();
    }

    private static final void log(String str) {
        System.out.println(str);
    }

    public static void main(String[] args) throws Exception {
        JRexGreInstaller.log("main() JRexGreInstaller invoked...");
        if (args.length < 1) {
            return;
        }
        JRexGreInstaller.log("main() JRexGreInstaller args[0]<" + args[0] + ">");
        if (args[0].equals("install")) {
            JRexGreInstaller.log("main() Installing JREX GRE...");
            Class<?> srvMgrClass = Class.forName("javax.jnlp.ServiceManager");
            JRexGreInstaller.log("main() srvMgrClass<" + srvMgrClass + ">");
            Method lookup = srvMgrClass.getMethod("lookup", String.class);
            JRexGreInstaller.log("main() lookup method<" + lookup + ">");
            Object exService = lookup.invoke(null, "javax.jnlp.ExtensionInstallerService");
            JRexGreInstaller.log("main() exService<" + exService + ">");
            Method update = exService.getClass().getMethod("updateProgress", Integer.TYPE);
            Method status = exService.getClass().getMethod("setStatus", String.class);
            JRexGreInstaller.log("main() update<" + update + "> status<" + status + ">");
            update.invoke(exService, new Integer(1));
            boolean success = JRexGreInstaller.installGRE("jrex_gre.zip", null, exService, update, status);
            status.invoke(exService, (Object[])new String[]{"GRE Installation Done."});
            update.invoke(exService, new Integer(100));
            JRexGreInstaller.log("main() Installing JREX GRE success<" + success + ">");
            if (success) {
                Method installSucceeded = exService.getClass().getMethod("installSucceeded", Boolean.TYPE);
                JRexGreInstaller.log("main() installSucceeded<" + installSucceeded + ">");
                installSucceeded.invoke(exService, new Boolean(false));
                Method setNativeLibraryInfo = exService.getClass().getMethod("setNativeLibraryInfo", String.class);
                JRexGreInstaller.log("main() setNativeLibraryInfo<" + setNativeLibraryInfo + ">");
                setNativeLibraryInfo.invoke(exService, System.getProperty("jrex.gre.path"));
            } else {
                Method installFailed = exService.getClass().getMethod("installFailed", null);
                JRexGreInstaller.log("main() installFailed<" + installFailed + ">");
                installFailed.invoke(exService, null);
            }
        } else {
            JRexGreInstaller.log("Invalid Install args passed...");
        }
        System.exit(0);
    }
}

