/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.pref;

import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.jrex.exception.JRexException;

public class JRexPreference {
    private static final String className = JRexPreference.class.getName();
    public static final int PREF_INVALID = 0;
    public static final int PREF_STRING = 32;
    public static final int PREF_INT = 64;
    public static final int PREF_BOOL = 128;
    private static final JRexPreference instance = new JRexPreference();

    private JRexPreference() {
    }

    public static JRexPreference getInstance() {
        return instance;
    }

    public void readUserPrefs(String file) throws JRexException {
        this.ReadUserPrefs(file);
    }

    public void resetPrefs() throws JRexException {
        this.ResetPrefs();
    }

    public void resetUserPrefs() throws JRexException {
        this.ResetUserPrefs();
    }

    public void savePrefFile(String file) throws JRexException {
        this.SavePrefFile(file);
    }

    public String getRoot() throws JRexException {
        return this.GetRoot();
    }

    public long getPrefType(String prefName) throws JRexException {
        return this.GetPrefType(prefName);
    }

    public boolean getBoolPref(String prefName) throws JRexException {
        return this.GetBoolPref(prefName);
    }

    public void setBoolPref(String prefName, boolean value) throws JRexException {
        this.SetBoolPref(prefName, value);
    }

    public String getCharPref(String prefName) throws JRexException {
        return this.GetCharPref(prefName);
    }

    public void setCharPref(String prefName, String value) throws JRexException {
        this.SetCharPref(prefName, value);
    }

    public long getIntPref(String prefName) throws JRexException {
        return this.GetIntPref(prefName);
    }

    public void setIntPref(String prefName, long value) throws JRexException {
        this.SetIntPref(prefName, value);
    }

    public void clearUserPref(String prefName) throws JRexException {
        this.ClearUserPref(prefName);
    }

    public boolean isPrefLocked(String prefName) throws JRexException {
        return this.IsPrefLocked(prefName);
    }

    public void lockPref(String prefName) throws JRexException {
        this.LockPref(prefName);
    }

    public void unlockPref(String prefName) throws JRexException {
        this.UnLockPref(prefName);
    }

    public boolean getDefaultBoolPref(String prefName) throws JRexException {
        return this.GetDefaultBoolPref(prefName);
    }

    public void setDefaultBoolPref(String prefName, boolean value) throws JRexException {
        this.SetDefaultBoolPref(prefName, value);
    }

    public String getDefaultCharPref(String prefName) throws JRexException {
        return this.GetDefaultCharPref(prefName);
    }

    public void setDefaultCharPref(String prefName, String value) throws JRexException {
        this.SetDefaultCharPref(prefName, value);
    }

    public long getDefaultIntPref(String prefName) throws JRexException {
        return this.GetDefaultIntPref(prefName);
    }

    public void setDefaultIntPref(String prefName, long value) throws JRexException {
        this.SetDefaultIntPref(prefName, value);
    }

    public Collection getPrefChildren(String parentPrefName) throws JRexException {
        return this.GetPrefChildren(parentPrefName);
    }

    private native void ReadUserPrefs(String var1) throws JRexException;

    private native void ResetPrefs() throws JRexException;

    private native void ResetUserPrefs() throws JRexException;

    private native void SavePrefFile(String var1) throws JRexException;

    private native String GetRoot() throws JRexException;

    private native long GetPrefType(String var1) throws JRexException;

    private native boolean GetBoolPref(String var1) throws JRexException;

    private native void SetBoolPref(String var1, boolean var2) throws JRexException;

    private native String GetCharPref(String var1) throws JRexException;

    private native void SetCharPref(String var1, String var2) throws JRexException;

    private native long GetIntPref(String var1) throws JRexException;

    private native void SetIntPref(String var1, long var2) throws JRexException;

    private native void ClearUserPref(String var1) throws JRexException;

    private native boolean IsPrefLocked(String var1) throws JRexException;

    private native void LockPref(String var1) throws JRexException;

    private native void UnLockPref(String var1) throws JRexException;

    private native boolean GetDefaultBoolPref(String var1) throws JRexException;

    private native void SetDefaultBoolPref(String var1, boolean var2) throws JRexException;

    private native String GetDefaultCharPref(String var1) throws JRexException;

    private native void SetDefaultCharPref(String var1, String var2) throws JRexException;

    private native long GetDefaultIntPref(String var1) throws JRexException;

    private native void SetDefaultIntPref(String var1, long var2) throws JRexException;

    private native ArrayList GetPrefChildren(String var1) throws JRexException;
}

