/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.window;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.JComponent;
import org.mozilla.jrex.event.window.CreateEventParam;
import org.mozilla.jrex.event.window.WindowEvent;
import org.mozilla.jrex.event.window.WindowListener;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.window.JRexBaseBrowser;
import org.mozilla.jrex.window.JRexBrowserData;
import org.mozilla.jrex.window.JRexForceTabbedBrowser;
import org.mozilla.jrex.window.JRexSingleWindowBrowser;
import org.mozilla.jrex.window.JRexTabbedBrowser;
import org.mozilla.jrex.window.JRexWindowBrowser;
import org.mozilla.jrex.window.JRexWindowManager;

public class JRexWindowManagerImpl
implements JRexWindowManager {
    private static final String className;
    private JRexBaseBrowser browser = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void create(int mode) {
        if (JRexL.on) {
            JRexL.log(className, "**** create()--> mode<" + mode + ">");
        }
        if (mode < 0 || mode > 4) {
            throw new IllegalArgumentException("invalid window mode");
        }
        switch (mode) {
            case 1: {
                this.browser = new JRexSingleWindowBrowser();
                break;
            }
            case 2: {
                this.browser = new JRexTabbedBrowser();
                break;
            }
            case 3: {
                this.browser = new JRexForceTabbedBrowser();
                break;
            }
            default: {
                this.browser = new JRexWindowBrowser();
            }
        }
    }

    public void init(JComponent parentComponent) {
        if (JRexL.on) {
            JRexL.log(className, "**** init()--> parentComponent<" + parentComponent + ">");
        }
        if (this.browser == null) {
            throw new NullPointerException("browser not created!!!");
        }
        this.browser.init(parentComponent);
    }

    public void openNewWindow(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewWindow()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
        if (this.browser != null) {
            this.browser.openNewWindow(parentPeer, uri, loadFlags);
        }
    }

    public void openNewTab(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewTab()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
        if (this.browser != null) {
            this.browser.openNewTab(parentPeer, uri, loadFlags);
        }
    }

    public int createWindow(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->event <" + event + "> ****");
        }
        if (this.browser == null) {
            return 0;
        }
        CreateEventParam wcparam = (CreateEventParam)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->wcparam <" + wcparam + "> ****");
        }
        if (!$assertionsDisabled && wcparam == null) {
            throw new AssertionError();
        }
        int parentPeer = wcparam.getParentWindow();
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->parentPeer <" + parentPeer + ">");
        }
        return this.browser.createWindow(parentPeer, wcparam.getChromeFlags());
    }

    public void addWindow(JRexCanvas browserComp, Container parent, Container rootParent, Window window, long chromeFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** addWindow()-->browserComp<" + browserComp + "> parent<" + parent + "> rootParent<" + rootParent + "> chromeFlags<" + chromeFlags + ">");
        }
        if (this.browser != null) {
            this.browser.addWindow(browserComp, parent, rootParent, window, chromeFlags);
        }
    }

    public void removeWindow(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeWindow()-->peerWindow<" + peerWindow + ">");
        }
        if (this.browser != null) {
            this.browser.removeWindow(peerWindow);
        }
    }

    public void setModal(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->peerWindow <" + peerWindow + ">");
        }
        Boolean modal = (Boolean)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->modal <" + modal + ">");
        }
        if (this.browser != null) {
            this.browser.setModal(peerWindow, modal);
        }
    }

    public void setSize(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->peerWindow <" + peerWindow + ">");
        }
        Dimension dim = (Dimension)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->dim <" + dim + ">");
        }
        if (this.browser != null) {
            this.browser.setSize(peerWindow, dim);
        }
    }

    public void setTitle(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->peerWindow <" + peerWindow + ">");
        }
        String title = (String)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->title <" + title + ">");
        }
        if (this.browser != null) {
            this.browser.setTitle(peerWindow, title);
        }
    }

    public void setChromeFlags(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->peerWindow <" + peerWindow + ">");
        }
        Long chromeFlags = (Long)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->chromeFlags <" + chromeFlags + ">");
        }
        if (this.browser != null) {
            this.browser.setChromeFlags(peerWindow, chromeFlags);
        }
    }

    public void setRealized(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->peerWindow <" + peerWindow + ">");
        }
        if (this.browser != null) {
            this.browser.setRealized(peerWindow);
        }
    }

    public void destroyWindow(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->peerWindow <" + peerWindow + ">");
        }
        if (this.browser != null) {
            this.browser.destroyWindow(peerWindow);
        }
    }

    public void destroyTab(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyTab()-->peerWindow <" + peerWindow + ">");
        }
        if (this.browser != null) {
            this.browser.destroyTab(peerWindow);
        }
    }

    public JRexCanvas getBrowser(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowser()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser != null ? this.browser.getBrowser(peerWindow) : null;
    }

    public Iterator getBrowserForWindow(Window window) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserForWindow()-->window <" + window + ">");
        }
        return this.browser != null ? this.browser.getBrowserForWindow(window) : null;
    }

    public Iterator getBrowserForRootParent(Container rootParent) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserRootParent()-->rootParent <" + rootParent + ">");
        }
        return this.browser != null ? this.browser.getBrowserForRootParent(rootParent) : null;
    }

    public JRexCanvas getBrowserForParent(Container parent) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserForParent()-->parent <" + parent + ">");
        }
        return this.browser != null ? this.browser.getBrowserForParent(parent) : null;
    }

    public Container getBrowserParent(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserParent()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser != null ? this.browser.getBrowserParent(peerWindow) : null;
    }

    public Container getBrowserRootParent(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserParent()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser != null ? this.browser.getBrowserParent(peerWindow) : null;
    }

    public Window getBrowserWindow(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserWindow()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser != null ? this.browser.getBrowserWindow(peerWindow) : null;
    }

    public JRexBrowserData getBrowserData(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserData()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser != null ? this.browser.getBrowserData(peerWindow) : null;
    }

    public void addJRexWindowListener(WindowListener wl) {
        if (JRexL.on) {
            JRexL.log(className, "**** addJRexWindowListener()-->wl <" + wl + ">");
        }
        if (this.browser != null) {
            this.browser.addJRexWindowListener(wl);
        }
    }

    public void removeJRexWindowListener() {
        if (JRexL.on) {
            JRexL.log(className, "**** removeJRexWindowListener()");
        }
        if (this.browser != null) {
            this.browser.removeJRexWindowListener();
        }
    }

    public void dispose() {
        if (JRexL.on) {
            JRexL.log(className, "**** dispose()-->");
        }
        if (this.browser != null) {
            this.browser.dispose();
        }
    }

    static {
        $assertionsDisabled = !JRexWindowManagerImpl.class.desiredAssertionStatus();
        className = JRexWindowManagerImpl.class.getName();
    }
}

