/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   Rich Giuli <richard.giuli@sri.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
#ifndef JRexLiveConnectSession_h_
#define JRexLiveConnectSession_h_
#include "JRexWindow.h"
#include "jni.h"
#include "jsapi.h"

#define LC_SESSION_CLASS_NAME   "org/mozilla/jrex/liveconnect/JRexLiveConnectSessionImpl"
#define JREX_JS_OBJECT_CLASS_NAME    "org/mozilla/jrex/liveconnect/JRexJSObject"

namespace JREX_LIVECONNECT{

    class JRexLiveConnectFields {
        public :
            static jfieldID peerID;
            static jfieldID sessionID;
            static jmethodID getSessionID;
            static jclass lcimpl_clazz; // global ref
            static jclass jrexjsobject_clazz; // global ref
    };

    class JRexLiveConnectSession {
        public:
            JRexLiveConnectSession(JRexWindow *window) : mJRexWindow(window), mJSContext(NULL) {}
            NS_IMETHOD Init(jobject lcSession);
            NS_IMETHOD StartupLiveConnect();
            NS_IMETHOD InvokeStringJavascriptMethod(const char* functionName, const char* arg, char** retStr);
            NS_IMETHOD EvalScript(const jschar* script_chars, size_t script_chars_length, jschar** retStr, size_t* retLength);
            JSObject* GetGlobalJSObject() { return mJSGlobal; }
            JSContext* GetJSContext() { return mJSContext; }
            virtual ~JRexLiveConnectSession();

            // JSObject JRex-specific methods. These must be called directly from JSObject,
            // because they access private members of JSObject.
            static nsresult GetWindowForSession(jclass clazz, jobject lcSession, jobject* retWin);
            static nsresult GetMember(jobject jrex_jsobj, jstring name, jobject* retObj);
            static nsresult GetSlot(jobject jrex_jsobj, jint indx, jobject* retObj);
            static nsresult SetMember(jobject jrex_jsobj, jstring name, jobject value);
            static nsresult Eval(jobject jrex_jsobj, jstring evalstr, jobject* retObj);
            static nsresult SetSlot(jobject jrex_jsobj, jint indx, jobject value);
            static nsresult RemoveMember(jobject jrex_jsobj, jstring name);
            static nsresult Call(jobject jrex_jsobj, jstring func, jobjectArray args, jobject* retObj);
            static nsresult ToString(jobject jrex_jsobj, jstring* retStr);
            static nsresult Equals(jobject jrex_jsobj, jobject cmp_obj, jboolean* retIsEq);

        private:
            //event types for liveconnect
            enum LiveConnectEventTypes{	INIT,
                                        STARTUP_LIVECONNECT,
                                        INVOKE_STRING_METHOD,
                                        EVAL_SCRIPT,
                                        GET_WINDOW,
                                        GET_MEMBER,
                                        GET_SLOT,
                                        SET_MEMBER,
                                        EVAL,
                                        SET_SLOT,
                                        REMOVE_MEMBER,
                                        CALL,
                                        TO_STRING,
                                        EQUALS};

            struct InitEventData{
                jobject lcSession;
            };

            struct InvokeStringEventData{
                char* functionName;
                char* arg;
            };

            struct EvalScriptEventData{
                EvalScriptEventData(const jschar* theChars) : script_chars(theChars) {}
                const jschar* script_chars;
                size_t script_chars_length;
            };

            struct GetWindowEventData{
                jobject lcSession;
                jclass clazz;
            };

            struct GetMemberEventData{
                jobject jrex_jsobj;
                jstring name;
            };

            struct GetSlotEventData{
                jobject jrex_jsobj;
                jint indx;
            };

            struct SetMemberEventData{
                jobject jrex_jsobj;
                jstring name;
                jobject value;
            };

            struct EvalEventData{
                jobject jrex_jsobj;
                jstring evalstr;
            };

            struct SetSlotEventData{
                jobject jrex_jsobj;
                jint indx;
                jobject value;
            };

            struct RemoveMemberEventData{
                jobject jrex_jsobj;
                jstring name;
            };

            struct CallEventData{
                jobject jrex_jsobj;
                jstring func;
                jobjectArray args;
            };

            struct ToStringEventData{
                jobject jrex_jsobj;
            };

            struct EqualsEventData{
                jobject jrex_jsobj;
                jobject cmp_obj;
            };

            struct JRexLiveConnectEvent : PLEvent{
                JRexLiveConnectSession *session;
                void* lcEventData;
            };

            static void* PR_CALLBACK HandleLiveConnectEvent(PLEvent* aEvent);
            static void PR_CALLBACK  DestroyLiveConnectEvent(PLEvent* aEvent);

            nsresult InitInternal(jobject lcSession);
            nsresult StartupLiveConnectInternal();
            nsresult InvokeStringJavascriptMethodInternal(const char* functionName, const char* arg, char** retStr);
            nsresult EvalScriptInternal(const jschar* script_chars, size_t script_chars_length, JSString** retStr);

            // JSObject JRex-specific method implementations
            static nsresult GetWindowForSessionInternal(jclass clazz, jobject lcSession, jobject* retWin);
            static nsresult GetMemberInternal(jobject jrex_jsobj, jstring name, jobject* retObj);
            static nsresult GetSlotInternal(jobject jrex_jsobj, jint indx, jobject* retObj);
            static nsresult SetMemberInternal(jobject jrex_jsobj, jstring name, jobject value);
            static nsresult EvalInternal(jobject jrex_jsobj, jstring evalstr, jobject* retObj);
            static nsresult SetSlotInternal(jobject jrex_jsobj, jint indx, jobject value);
            static nsresult RemoveMemberInternal(jobject jrex_jsobj, jstring name);
            static nsresult CallInternal(jobject jrex_jsobj, jstring func, jobjectArray args, jobject* retObj);
            static nsresult ToStringInternal(jobject jrex_jsobj, jstring* retStr);
            static nsresult EqualsInternal(jobject jrex_jsobj, jobject cmp_obj, jboolean* retIsEq);

            jobject mLCSession;
            JRexWindow *mJRexWindow;
            JSObject *mJSGlobal;
            JSContext *mJSContext;
            static PRBool sLCInited;
    };
}

#endif // LiveConnectSession_h_

