/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Driver;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public abstract class Connection {
    MysqlIO _io = null;
    private boolean _isClosed = true;
    private long _lastQueryFinishedTime = 0L;
    private String _host = null;
    private int _port = 3306;
    private String _user = null;
    private String _password = null;
    protected String _database = null;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _doUnicode = false;
    private String _encoding = null;
    private String _myURL = null;
    private int _maxRows = -1;
    private boolean _maxRowsChanged = false;
    private Driver _myDriver;
    private Hashtable _serverVariables = null;
    private int _maxAllowedPacket = 65536;
    private int _netBufferLength = 16384;
    private boolean _useFastPing = false;
    private boolean _highAvailability = false;
    private int _maxReconnects = 3;
    private double _initialTimeout = 2.0;
    private static final String _PING_COMMAND = "SELECT 1";
    private boolean _transactionsSupported = false;
    private boolean _relaxAutoCommit = false;
    protected boolean _useUltraDevWorkAround = false;
    private boolean _hasIsolationLevels = false;
    private boolean _capitalizeDBMDTypes = false;
    private boolean _hasQuotedIdentifiers = false;
    private boolean _useAnsiQuotes = false;
    private int isolationLevel = 2;
    private static Hashtable _mapTransIsolationName2Value = null;

    /*
     * Loose catch block
     */
    public void connectionInit(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        Object object;
        int n2;
        this._host = string == null ? "localhost" : string;
        this._port = n;
        if (string2 == null) {
            throw new SQLException("Malformed URL '" + string3 + "'.", "S1000");
        }
        this._database = string2;
        this._myURL = string3;
        this._myDriver = driver;
        this._user = properties.getProperty("user");
        this._password = properties.getProperty("password");
        if (this._user == null || this._user.equals("")) {
            this._user = "nobody";
        }
        if (this._password == null) {
            this._password = "";
        }
        if (properties.getProperty("relaxAutoCommit") != null) {
            this._relaxAutoCommit = properties.getProperty("relaxAutoCommit").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("autoReconnect") != null) {
            this._highAvailability = properties.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("capitalizeTypeNames") != null) {
            this._capitalizeDBMDTypes = properties.getProperty("capitalizeTypeNames").toUpperCase().equals("TRUE");
        }
        if (properties.getProperty("ultraDevHack") != null) {
            this._useUltraDevWorkAround = properties.getProperty("ultraDevHack").toUpperCase().equals("TRUE");
        }
        if (this._highAvailability) {
            if (properties.getProperty("maxReconnects") != null) {
                try {
                    this._maxReconnects = n2 = Integer.parseInt(properties.getProperty("maxReconnects"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (properties.getProperty("initialTimeout") != null) {
                try {
                    double d;
                    this._initialTimeout = d = (double)Integer.parseInt(properties.getProperty("initialTimeout"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (properties.getProperty("maxRows") != null) {
            try {
                n2 = Integer.parseInt(properties.getProperty("maxRows"));
                if (n2 == 0) {
                    n2 = -1;
                }
                this._maxRows = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Illegal parameter '" + properties.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (properties.getProperty("useUnicode") != null) {
            String string4 = properties.getProperty("useUnicode").toUpperCase();
            if (string4.startsWith("TRUE")) {
                this._doUnicode = true;
            }
            if (properties.getProperty("characterEncoding") != null) {
                this._encoding = properties.getProperty("characterEncoding");
                try {
                    object = "abc";
                    ((String)object).getBytes(this._encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Unsupported character encoding '" + this._encoding + "'.", "0S100");
                }
            }
        }
        try {
            block48: {
                block49: {
                    SQLException sQLException2222;
                    Statement statement;
                    block47: {
                        this._io = this.createNewIO(string, n);
                        this._io.init(this._user, this._password);
                        if (this._database.length() != 0) {
                            this._io.sendCommand(2, this._database, null);
                        }
                        this._isClosed = false;
                        this._serverVariables = new Hashtable();
                        if (this._io.versionMeetsMinimum(3, 22, 1)) {
                            this._useFastPing = true;
                        }
                        if (!this._io.versionMeetsMinimum(3, 21, 22)) break block48;
                        statement = null;
                        object = null;
                        statement = (Statement)((Object)this.createStatement());
                        object = (ResultSet)((Object)statement.executeQuery("SHOW VARIABLES"));
                        while (((ResultSet)object).next()) {
                            this._serverVariables.put(((ResultSet)object).getString(1), ((ResultSet)object).getString(2));
                        }
                        Object var11_20 = null;
                        if (object == null) break block47;
                        try {
                            ((ResultSet)object).close();
                        }
                        catch (SQLException sQLException2222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2222) {}
                    }
                    break block49;
                    {
                        catch (SQLException sQLException3) {
                            throw sQLException3;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException sQLException42222;
                        Object var11_21 = null;
                        if (object != null) {
                            try {
                                ((ResultSet)object).close();
                            }
                            catch (SQLException sQLException42222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException42222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (this._serverVariables.containsKey("max_allowed_packet")) {
                    this._maxAllowedPacket = Integer.parseInt((String)this._serverVariables.get("max_allowed_packet"));
                }
                if (this._serverVariables.containsKey("net_buffer_length")) {
                    this._netBufferLength = Integer.parseInt((String)this._serverVariables.get("net_buffer_length"));
                }
                this.checkTransactionIsolationLevel();
                this.checkServerEncoding();
            }
            this._transactionsSupported = this._io.versionMeetsMinimum(3, 23, 15);
            this._hasIsolationLevels = this._io.versionMeetsMinimum(3, 23, 36);
            String string5 = properties.getProperty("profileSql");
            if (string5 != null && string5.trim().equalsIgnoreCase("true")) {
                this._io.setProfileSql(true);
            } else {
                this._io.setProfileSql(false);
            }
            this._hasQuotedIdentifiers = this._io.versionMeetsMinimum(3, 23, 6);
            if (this._serverVariables.containsKey("sql_mode")) {
                int n3 = Integer.parseInt((String)this._serverVariables.get("sql_mode"));
                this._useAnsiQuotes = (n3 & 4) > 0;
            }
            this._io.resetMaxBuf();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot connect to MySQL server on " + this._host + ":" + this._port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + exception.getClass().getName() + ")", "08S01");
        }
    }

    public boolean capitalizeDBMDTypes() {
        return this._capitalizeDBMDTypes;
    }

    public boolean supportsTransactions() {
        return this._transactionsSupported;
    }

    public boolean supportsIsolationLevel() {
        return this._hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this._hasQuotedIdentifiers;
    }

    public abstract java.sql.Statement createStatement() throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("Callable statments not supported.", "S1C00");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this._transactionsSupported) {
            String string = "SET autocommit=" + (bl ? "1" : "0");
            this.execSQL(string, -1);
            this._autoCommit = bl;
        } else {
            if (!bl && !this._relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
            }
            this._autoCommit = bl;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    public void commit() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Commit attempt on closed connection.", "08003");
        }
        if (this._autoCommit && !this._relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this._transactionsSupported) {
            this.execSQL("commit", -1);
        }
    }

    public void rollback() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
        if (this._autoCommit && !this._relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true", "08003");
        }
        if (this._transactionsSupported) {
            this.execSQL("rollback", -1);
        }
    }

    public void close() throws SQLException {
        if (this._io != null) {
            try {
                this._io.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._io = null;
        }
        this._isClosed = true;
    }

    public boolean isClosed() throws SQLException {
        if (!this._isClosed) {
            try {
                MysqlIO mysqlIO = this._io;
                synchronized (mysqlIO) {
                    this.ping();
                }
            }
            catch (Exception exception) {
                this._isClosed = true;
            }
        }
        return this._isClosed;
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void setReadOnly(boolean bl) throws SQLException {
        this._readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this._readOnly;
    }

    public void setCatalog(String string) throws SQLException {
        this.execSQL("USE " + string, -1);
        this._database = string;
    }

    public String getCatalog() throws SQLException {
        return this._database;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        StringBuffer stringBuffer;
        if (this._hasIsolationLevels) {
            stringBuffer = new StringBuffer("SET SESSION TRANSACTION ISOLATION LEVEL ");
            switch (n) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    stringBuffer.append("READ COMMITTED");
                    break;
                }
                case 1: {
                    stringBuffer.append("READ UNCOMMITTED");
                    break;
                }
                case 4: {
                    stringBuffer.append("REPEATABLE READ");
                    break;
                }
                case 8: {
                    stringBuffer.append("SERIALIZABLE");
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + n + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(stringBuffer.toString(), -1);
        this.isolationLevel = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public long getIdleFor() {
        if (this._lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this._lastQueryFinishedTime;
        return l2;
    }

    public void finalize() throws Throwable {
        if (this._io != null && !this.isClosed()) {
            this.close();
        } else if (this._io != null) {
            this._io.forceClose();
        }
    }

    private void ping() throws Exception {
        if (this._useFastPing) {
            this._io.sendCommand(14, null, null);
        } else {
            this._io.sqlQuery(_PING_COMMAND, 50000000);
        }
    }

    ResultSet execSQL(String string, int n) throws SQLException {
        return this.execSQL(string, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResultSet execSQL(String string, int n, Buffer buffer) throws SQLException {
        MysqlIO mysqlIO = this._io;
        synchronized (mysqlIO) {
            ResultSet resultSet;
            block26: {
                ResultSet resultSet2;
                block25: {
                    block24: {
                        this._lastQueryFinishedTime = 0L;
                        if (this._highAvailability) {
                            int n2;
                            boolean bl;
                            double d;
                            try {
                                this.ping();
                                break block24;
                            }
                            catch (Exception exception) {
                                d = this._initialTimeout;
                                bl = false;
                                n2 = 0;
                            }
                            while (n2 < this._maxReconnects) {
                                try {
                                    try {
                                        this._io.forceClose();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this._io = this.createNewIO(this._host, this._port);
                                    this._io.init(this._user, this._password);
                                    if (this._database.length() != 0) {
                                        this._io.sendCommand(2, this._database, null);
                                    }
                                    if (this._useFastPing) {
                                        this._io.sendCommand(14, null, null);
                                    } else {
                                        this._io.sqlQuery(_PING_COMMAND, 50000000);
                                    }
                                    bl = true;
                                    break;
                                }
                                catch (Exception exception) {
                                    try {
                                        Thread.currentThread();
                                        Thread.sleep((long)d * 1000L);
                                        d *= d;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    ++n2;
                                }
                            }
                            if (!bl) {
                                throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this._maxReconnects + " times. Giving up.", "08001");
                            }
                        }
                    }
                    try {
                        try {
                            int n3;
                            int n4 = n3 = n == -1 ? 50000000 : n;
                            if (buffer == null) {
                                String string2 = null;
                                if (this.useUnicode()) {
                                    string2 = this.getEncoding();
                                }
                                resultSet2 = this._io.sqlQuery(string, n3, string2, this);
                                Object var12_22 = null;
                                break block25;
                            }
                            resultSet = this._io.sqlQueryDirect(buffer, n3, this);
                            break block26;
                        }
                        catch (EOFException eOFException) {
                            throw new SQLException("Lost connection to server during query", "08007");
                        }
                        catch (SQLException sQLException) {
                            throw sQLException;
                        }
                        catch (Exception exception) {
                            String string3 = exception.getClass().getName();
                            String string4 = exception.getMessage();
                            throw new SQLException("Error during query: Unexpected Exception: " + string3 + " message given: " + string4, "S1000");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_24 = null;
                        this._lastQueryFinishedTime = System.currentTimeMillis();
                        throw throwable;
                    }
                }
                this._lastQueryFinishedTime = System.currentTimeMillis();
                return resultSet2;
            }
            Object var12_23 = null;
            this._lastQueryFinishedTime = System.currentTimeMillis();
            return resultSet;
        }
    }

    protected abstract MysqlIO createNewIO(String var1, int var2) throws Exception;

    String getURL() {
        return this._myURL;
    }

    String getUser() {
        return this._user;
    }

    String getServerVersion() {
        return this._io.getServerVersion();
    }

    int getServerMajorVersion() {
        return this._io.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this._io.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this._io.getServerSubMinorVersion();
    }

    synchronized void maxRowsChanged() {
        this._maxRowsChanged = true;
    }

    synchronized boolean useMaxRows() {
        return this._maxRowsChanged;
    }

    public boolean useUnicode() {
        return this._doUnicode;
    }

    public String getEncoding() {
        return this._encoding;
    }

    Object getMutex() throws SQLException {
        if (this._io == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        return this._io;
    }

    int getMaxAllowedPacket() {
        return this._maxAllowedPacket;
    }

    int getNetBufferLength() {
        return this._netBufferLength;
    }

    boolean useAnsiQuotedIdentifiers() {
        return this._useAnsiQuotes;
    }

    protected MysqlIO getIO() {
        return this._io;
    }

    private void checkServerEncoding() throws SQLException {
        if (this.useUnicode() && this.getEncoding() == null) {
            this._encoding = (String)this._serverVariables.get("character_set");
            if (this._encoding != null) {
                Object object;
                if (Character.isLowerCase(this._encoding.charAt(0))) {
                    object = this._encoding.toCharArray();
                    object[0] = Character.toUpperCase(this._encoding.charAt(0));
                    this._encoding = new String((char[])object);
                }
                try {
                    object = "abc";
                    ((String)object).getBytes(this._encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this._encoding = null;
                }
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer n;
        String string = (String)this._serverVariables.get("transaction_isolation");
        if (string != null && (n = (Integer)_mapTransIsolationName2Value.get(string)) != null) {
            this.isolationLevel = n;
        }
    }

    static {
        _mapTransIsolationName2Value = new Hashtable(8);
        _mapTransIsolationName2Value.put("READ-UNCOMMITED", new Integer(1));
        _mapTransIsolationName2Value.put("READ-COMMITTED", new Integer(2));
        _mapTransIsolationName2Value.put("REPEATABLE-READ", new Integer(4));
        _mapTransIsolationName2Value.put("SERIALIZABLE", new Integer(8));
    }
}

