/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.toolkit.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class MRegistry {
    private Map settings;
    private File fl;

    public MRegistry(String string) {
        this(new File(string));
    }

    public MRegistry(File file) {
        this.fl = file;
        try {
            this.loadFromFile(file);
        }
        catch (Exception exception) {
            try {
                this.settings = new TreeMap();
                this.saveToFile(file);
            }
            catch (Exception exception2) {
                JOptionPane.showMessageDialog(null, "An error occured when saving to the hard drive. Any settings changed in this program will not be saved.");
            }
        }
    }

    public void saveSetting(String string, Object object) {
        this.settings.put(string, object);
        this.saveRegistry();
    }

    public Object getSetting(String string) {
        return this.settings.get(string);
    }

    private void saveRegistry() {
        try {
            this.saveToFile(this.fl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveToFile(File file) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(this.settings);
    }

    private void loadFromFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        this.settings = (TreeMap)objectInputStream.readObject();
        if (this.settings == null) {
            throw new ClassNotFoundException();
        }
    }
}

