/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.ranges;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMDocumentFragment;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class RangeImpl
implements Range {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMRange getInstance() {
        return this.getInstanceAsnsIDOMRange();
    }

    protected RangeImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public RangeImpl(nsIDOMRange mozInst) {
        this((nsISupports)mozInst);
    }

    public static RangeImpl getDOMInstance(nsIDOMRange mozInst) {
        RangeImpl node = (RangeImpl)instances.get(mozInst);
        return node == null ? new RangeImpl(mozInst) : node;
    }

    public nsIDOMRange getInstanceAsnsIDOMRange() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMRange)this.moz.queryInterface("{a6cf90ce-15b3-11d2-932e-00805f8add32}");
    }

    public void setEnd(Node refNode, final int offset) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setEnd(mozRefnode, offset);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public DocumentFragment cloneContents() {
        Callable<DocumentFragment> c = new Callable<DocumentFragment>(){

            @Override
            public DocumentFragment call() {
                nsIDOMDocumentFragment result = RangeImpl.this.getInstanceAsnsIDOMRange().cloneContents();
                return (DocumentFragment)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setEndAfter(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setEndAfter(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public short compareBoundaryPoints(final short how, Range sourceRange) {
        final nsIDOMRange mozSourcerange = sourceRange != null ? ((RangeImpl)sourceRange).getInstance() : null;
        Callable<Short> c = new Callable<Short>(){

            @Override
            public Short call() {
                short result = RangeImpl.this.getInstanceAsnsIDOMRange().compareBoundaryPoints((int)how, mozSourcerange);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setStart(Node refNode, final int offset) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setStart(mozRefnode, offset);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public Node getCommonAncestorContainer() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = RangeImpl.this.getInstanceAsnsIDOMRange().getCommonAncestorContainer();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setEndBefore(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setEndBefore(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void surroundContents(Node newParent) {
        final nsIDOMNode mozNewparent = newParent != null ? ((NodeImpl)newParent).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().surroundContents(mozNewparent);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void setStartAfter(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setStartAfter(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public Range cloneRange() {
        Callable<Range> c = new Callable<Range>(){

            @Override
            public Range call() {
                nsIDOMRange result = RangeImpl.this.getInstanceAsnsIDOMRange().cloneRange();
                return new RangeImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String toString() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = RangeImpl.this.getInstanceAsnsIDOMRange().toString();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void selectNodeContents(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().selectNodeContents(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void collapse(final boolean toStart) {
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().collapse(toStart);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public boolean getCollapsed() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = RangeImpl.this.getInstanceAsnsIDOMRange().getCollapsed();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setStartBefore(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().setStartBefore(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void insertNode(Node newNode) {
        final nsIDOMNode mozNewnode = newNode != null ? ((NodeImpl)newNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().insertNode(mozNewnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void selectNode(Node refNode) {
        final nsIDOMNode mozRefnode = refNode != null ? ((NodeImpl)refNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().selectNode(mozRefnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public DocumentFragment extractContents() {
        Callable<DocumentFragment> c = new Callable<DocumentFragment>(){

            @Override
            public DocumentFragment call() {
                nsIDOMDocumentFragment result = RangeImpl.this.getInstanceAsnsIDOMRange().extractContents();
                return (DocumentFragment)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void detach() {
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().detach();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public Node getStartContainer() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = RangeImpl.this.getInstanceAsnsIDOMRange().getStartContainer();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void deleteContents() {
        Runnable r = new Runnable(){

            public void run() {
                RangeImpl.this.getInstanceAsnsIDOMRange().deleteContents();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public Node getEndContainer() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = RangeImpl.this.getInstanceAsnsIDOMRange().getEndContainer();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getEndOffset() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                int result = RangeImpl.this.getInstanceAsnsIDOMRange().getEndOffset();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getStartOffset() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                int result = RangeImpl.this.getInstanceAsnsIDOMRange().getStartOffset();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

