var gClassicStyle, gIsMac, gConsole, gConsoleBundle, gMultiZillaBundle;
var gPrefs, gConsoleStatus, gConsoleFilters, gTextBoxEval, gEvaluator, gCodeToEvaluate;

/* :::::::: Console Initialization ::::::::::::::: */

window.onload = function()
{
  gConsole = document.getElementById("ConsoleBox");
  gConsoleBundle = document.getElementById("ConsoleBundle");
  gMultiZillaBundle = document.getElementById("MultiZillaBundle");
  gConsoleStatus = document.getElementById("ConsoleStatus");
  gConsoleFilters = document.getElementById("StatusbarFilters");
  gTextBoxEval = document.getElementById("TextboxEval");
  gEvaluator = document.getElementById("Evaluator");

  if (!gPrefs)
    gPrefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);

  if (arguments in window) {
    gClassicStyle = window.arguments[0].isClassicStyle;
    gIsMac = window.arguments[0].isMac;
  }
  else { // Fallback method in case the console is opened from outside MultiZilla!
    gClassicStyle = gPrefs.getBoolPref("multizilla.windows.classic-style");
    gIsMac = /Mac/.test(navigator.platform) || gPrefs.getBoolPref("multizilla.windows.mac-style");
  }
  if (gIsMac)
    document.documentElement.setAttribute("macStyling", "true");

  top.controllers.insertControllerAt(0, ConsoleController);  
  updateSortCommand(gConsole.sortOrder);
  initConsole();
  gEvaluator.addEventListener("load", loadOrDisplayResult, true);
}

function updateSortCommand(aOrder)
{
  var orderString = aOrder == 'reverse' ? "Descend" : "Ascend";
  var broadcaster = document.getElementById("Console:sort" + orderString);
  broadcaster.setAttribute("checked", true);  

  orderString = aOrder == 'reverse' ? "Ascend" : "Descend";
  broadcaster = document.getElementById("Console:sort" + orderString);
  broadcaster.setAttribute("checked", false);
}

function initConsole()
{
  var broadcaster = document.getElementById("Console:mode" + gConsole.mode);

  if (broadcaster)
    broadcaster.setAttribute("checked", true);

  var mode = (gConsole.mode == "All") ? "Errors Warnings Messages" : gConsole.mode;
  gConsoleStatus.setAttribute("mode", mode);

  gConsoleFilters.value = gConsole.filters.replace(/ /g, ', ');
  var languages = gConsole.languages;

  if (languages) {
    languages = languages.split(" ");

    for (i in languages) {
      broadcaster = document.getElementById("Console:show" + languages[i]);

      if (broadcaster)
        broadcaster.setAttribute("checked", true);
    }
  }
}

function changeMode(aMode)
{
  if (aMode == "All")
    aMode = "Errors Warnings Messages";

  gConsole.mode = aMode;
  gConsoleStatus.setAttribute("mode", aMode);
  document.persist("ConsoleBox", "mode");
}

function changeDisplay(aType, aValue)
{
  setAndPersists("languages", aType);
}

function setAndPersists(aType, aValue)
{
  var values = new Array();
  var origin = null;

  switch(aType) {
    case "filters": origin = gConsole.filters;
      break;
    case "languages": origin = gConsole.languages;
      break;
  }
  if (origin == null) {
    values.push(aValue);
  }
  else {
    values = origin.split(' ');

    if (values.indexOf(aValue) == -1) {
      values.push(aValue);
    }
    else {
      for (i in values) {
        if (values[i] == aValue)
          values.splice(i, 1);
      }
    }
    if (aValue != "None") {
      var indexNone = values.indexOf("None");

      if (indexNone >= 0)
        values.splice(indexNone, 1);
    }
  }
  var newValues = String(values).replace(/,/g, ' ');

  switch(aType) {
    case "filters":
        gConsole.mThrobber.setAttribute("busy", "true");
        gConsole.filters = newValues;
        gConsoleFilters.value = (values.length) ? String(values).replace(/,/g, ', ') : "None";
        dump("\nsetting filters: " + gConsole.filters);      
        gConsole.clear(true);
        gConsole.appendInitialItems();
      break;
    case "languages": gConsole.languages = newValues;
        dump("\nsetting languages: " + gConsole.languages);
      break;
  }
  document.persist("ConsoleBox", aType);
}

function checkChromePref()
{
  var showChromeErrors = true;
  var broadcastCHROME = document.getElementById("Console:allowCHROME");

  try {
    showChromeErrors = gPrefs.getBoolPref("javascript.options.showInConsole");
  } 
  catch(ex) {}

  if (!showChromeErrors) {
    broadcastCHROME.setAttribute("disabled", "true");
    if (gConsole.filters.indexOf("chrome") >= 0)
      updateFilterCommand("Off");
  }
  else broadcastCHROME.removeAttribute("disabled");
  gConsole._showChromeErrors = (showChromeErrors == true);
}

function clearConsole()
{
  gConsole.clear();
}
 
function changeSortOrder(aOrder)
{
  updateSortCommand(gConsole.sortOrder = aOrder);
}

function copyItemToClipboard()
{
  gConsole.copySelectedItem();
}

function viewSourceIn(aTarget)
{
  if (gConsole.selectedItem) { // we need a selected item or it fails!
    var url = gConsole.selectedItem.getAttribute("url");
    var line = gConsole.selectedItem.getAttribute("line");
    var noNavigatorWindow = (getTabbrowser(false) == null) ? true : false;
    var tabbrowser = getTabbrowser(true);

    if (url) { // skip for messages, no url there
      switch (aTarget) {
        case "new_tab":
             var browser = null;

             if (tabbrowser) {
               // Prevent url/tab duplication
               var tab = preventDupeTab('view-source:'+url, false, tabbrowser);
               // Is this url already loaded?
               if (tab) { // Yes, activate that tab and bail out!
                 tabbrowser.selectedTab = tab;
                 var win = getNavigatorWindow(false);
                 win.focus();
                 return;
               }
               // Prevent skipping of blank tabs
               browser = checkForBlankTab(tabbrowser);
               if (browser)
                 tab = tabbrowser.getTabForBrowser(browser);
               else
                 tab = tabbrowser.addTab(null, null, null, false, null, "restoreTab");
               browser = tabbrowser.getBrowserForTab(tab);
               tabbrowser.viewSourceInTab(browser, url, line)
             }
           break;
        case "new_window":
             if (noNavigatorWindow) // JS Console only open
               tabbrowser = getTabbrowserFromWindow(true); // open a new (first) navigator window
             else { // Did we have an open navigator window?
               window.open(); // Yes, open a new (second/third/...) navigator window
               tabbrowser = getTabbrowser(false);
             }
             tabbrowser.viewSourceInTab(tabbrowser.browsers[0], url, line);
             break;
        default: // View Source file in default 'view source' window
             window.openDialog("chrome://navigator/content/viewSource.xul", "_blank",
                               "all,dialog=no", url, null, null, line, false);
      }
    }
  }
}

function isItemSelected()
{
  return gConsole.selectedItem != null;
}

function isSourceLink()
{
  return gConsole.sourceLink != null;
}

function UpdateMenuItems()
{
  goUpdateCommand("cmd_copy");
  goUpdateCommand("cmd_viewSource");
  goUpdateCommand("cmd_viewSourceInTab");
  goUpdateCommand("cmd_viewSourceInWindow");
}

function onEvalKeyPress(aEvent)
{
  if (aEvent.keyCode == 13)
    evaluateTypein();
}

function evaluateTypein()
{
  gCodeToEvaluate = gTextBoxEval.value;
  // reset the iframe first; the code will be evaluated in loadOrDisplayResult
  // below, once about:blank has completed loading (see bug 385092)
  gEvaluator.contentWindow.location = "about:blank";
}

function loadOrDisplayResult()
{
  if (gCodeToEvaluate) {
    gEvaluator.contentWindow.location = "javascript: " +
                                        gCodeToEvaluate.replace(/%/g, "%25");
    gCodeToEvaluate = "";
    return;
  }
  var resultRange = gEvaluator.contentDocument.createRange();
  resultRange.selectNode(gEvaluator.contentDocument.documentElement);
  var result = resultRange.toString();

  if (result)
    gConsole.mCService.logStringMessage(result);
    // or could use appendMessage which doesn't persist
}

function openOptionsWindow()
{
  window.openDialog("chrome://multiviews/content/js-console/miscellaneous/optionsWindow.xul",  
                    "", "chrome, dialog, modal, centerscreen", gConsole, gClassicStyle, gIsMac);
}

function filterConsole(aTextbox)
{
  var searchTerm = aTextbox.value.toLowerCase();
  var consoleRows = document.getAnonymousElementByAttribute(gConsole, "class", "console-rows");

  for (var i = 0; i < consoleRows.childNodes.length; i++)
  {
    var row = consoleRows.childNodes[i];
    var hidden = ((searchTerm != "") && (row.getAttribute("msg").toLowerCase().indexOf(searchTerm) == -1));

    if (row.hidden != hidden)
      row.hidden = hidden;
  }
}

/* :::::::: Command Controller for the Window ::::::::::::::: */

var ConsoleController = 
{
  isCommandEnabled: function (aCommand)
  {
    switch (aCommand) {
      case "cmd_copy":
        return isItemSelected();
      case "cmd_viewSource":
      case "cmd_viewSourceInTab":
      case "cmd_viewSourceInWindow":
        return isSourceLink();
      default:
        return false;
    }
  },
  
  supportsCommand: function (aCommand) 
  {
    switch (aCommand) {
      case "cmd_copy":
      case "cmd_viewSource":
      case "cmd_viewSourceInTab":
      case "cmd_viewSourceInWindow":
        return true;
      default:
        return false;
    }
  },
  
  doCommand: function (aCommand)
  {
    switch (aCommand) {
      case "cmd_copy":
        copyItemToClipboard();
        break;
      case "cmd_viewSource":
        viewSourceIn("default");
        break;
      case "cmd_viewSourceInTab":
        viewSourceIn("new_tab");
        break;
      case "cmd_viewSourceInWindow":
        viewSourceIn("new_window");
        break;
      default:
        break;
    }
  },
  
  onEvent: function (aEvent) 
  {
  }
};

// XXX DEBUG

function debug(aText)
{
  var csClass = Components.classes['@mozilla.org/consoleservice;1'];
  var cs = csClass.getService(Components.interfaces.nsIConsoleService);
  cs.logStringMessage(aText);
}

function getStackTrace()
{
  var frame = Components.stack.caller;
  var str = "";
  while (frame) {
    if (frame.filename)
      str += frame.filename + ", Line " + frame.lineNumber;
    else
      str += "[" + gConsoleBundle.getString("noFile") + "]";
    
    str += " --> ";
    
    if (frame.functionName)
      str += frame.functionName;
    else
      str += "[" + gConsoleBundle.getString("noFunction") + "]";
      
    str += "\n";
    
    frame = frame.caller;
  }
  
  return str;
}

////////////////////////////////////////////////////////////////////////////////
// Start of 'helper functions' copied over from the MultiZilla source code!
////////////////////////////////////////////////////////////////////////////////
function preventDupeTab(href, useFirstPage, aBrowser)
{
  if (gPrefs.getBoolPref("multizilla.prevent.double") && href.substring(0,10) != "javascript") {
    if (!aBrowser)
      aBrowser = getBrowser();

    var tabHref = null;
    var baseHref = href.replace(/#.*/, "");

    if (baseHref[baseHref.length-1] == '/')
      baseHref = baseHref.substring(0, baseHref.length-1);
    for (var i = 0; i < aBrowser.mTabContainer.childNodes.length; i++) {
      if (aBrowser.mTabContainer.childNodes[i].hasAttribute("busy") || useFirstPage)
        tabHref = aBrowser.mTabContainer.childNodes[i].getAttribute("firstPage");
      else { 
        tabHref = aBrowser.browsers[i].webNavigation.currentURI.spec;
      }
      tabHref = tabHref.replace(/#.*/, "");

      if (tabHref[tabHref.length-1] == '/')
        tabHref = tabHref.substring(0, tabHref.length-1);
      var tab = aBrowser.mTabContainer.childNodes[i];

      if (baseHref == tabHref) {
        if (aBrowser.selectedTab == tab)
          aBrowser.loadURI(href); // New 'aBrowser' added!
        else {
          aBrowser.selectedTab = tab;
          if (href.indexOf("#") != -1)
            aBrowser.loadURI(href); // anchor link like webpage.html#anchor
        }
        return tab;
      }
    }
  }
  return null;
}

function checkForBlankTab(aBrowser)
{
  if (gPrefs.getBoolPref("multizilla.tabs.blank-tab-first")) {
    var page = "about:blank";
    var browser = aBrowser || getBrowser();
    var numberOfTabs = browser.mTabContainer.childNodes.length;

    for (var i = 0; i < numberOfTabs; i++) {
      if (browser.mTabContainer.childNodes[i].hasAttribute("busy"))
        page = browser.mTabContainer.childNodes[i].getAttribute("firstpage");
      else 
        page = browser.browsers[i].currentURI.spec

      if (page == "about:blank")
        return browser.browsers[i];
    }
  }
  return null;
}

function getNavigatorWindow(aOpenFlag)
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var navigatorWindow = windowManagerInterface.getMostRecentWindow("navigator:browser");

  if (!navigatorWindow) {
    if (!aOpenFlag)
      return null;
    else {
      window.open();
      navigatorWindow = windowManagerInterface.getMostRecentWindow("navigator:browser");
    }
  }
  return navigatorWindow;
}

function getTabbrowser(aOpenFlag)
{
  var navigatorWindow = getNavigatorWindow(aOpenFlag);

  if (navigatorWindow)
    return navigatorWindow.getBrowser();
  return null;
}

function onHelp(aPageAnchor)
{
  if (aPageAnchor == undefined)
    aPageAnchor = "";

  var helpPages = gMultiZillaBundle.getString("helpPages-JSConsole");
  var delimiter = gMultiZillaBundle.getString("helpDelimiter");
  var tabbrowser = getTabbrowser(true);
  var helpURL = (delimiter + aPageAnchor == delimiter) ? helpPages : helpPages + delimiter + aPageAnchor;
  tabbrowser.addOrGetTab(helpURL);
}

function shutdown()
{
  gEvaluator.removeEventListener("load", loadOrDisplayResult, true);
}
