/* 
  - The contents of this file are subject to the Mozilla Public
  - License Version 1.1 (the "License"); you may not use this file
  - except in compliance with the License. You may obtain a copy of
  - the License at http://www.mozilla.org/MPL/
  -
  - Software distributed under the License is distributed on an "AS
  - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
  - implied. See the License for the specific language governing
  - rights and limitations under the License.
  -
  - The Original Code is mozilla.org Code.
  -
  - The Initial Developer of the Original Code is
  - Netscape Communications Corporation.
  - Portions created by the Initial Developer are Copyright (C) 1998
  - the Initial Developer. All Rights Reserved.
  -
  - Contributor(s):
  -   HJ van Rantwijk <bugs4hj@aim.com>
  -   Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  -
  - Note: The JavaScript in this file was previously known as nsPrefWindow.js and
  -       nsWidgetStateManager.js in the mozilla source code (hence the name mozillaCode.js) 
  -       but will both be removed (I think) so we might want to use the (modified?) 
  -       toolkit's pref window binding for MultiZilla version 1.9 and later.
  -
  -       chrome://communicator/content/pref/nsPrefWindow.js is still available!
  -
*/

const Ci = Components.interfaces;
const Cc = Components.classes;

var wsm;
var hPrefWindow = null;

function nsWidgetStateManager(aContentID)
{
  this.dataManager = {
    pageData: [],

    setPageData: function(aPageTag, aDataObject) {
      dump("\ndataManager.setPageData()");
      this.pageData[aPageTag] = aDataObject;
    },

    getPageData: function(aPageTag) {
      if (!(aPageTag in this.pageData))
        this.pageData[aPageTag] = [];
      return this.pageData[aPageTag];
    },

    setItemData: function (aPageTag, aItemID, aDataObject) {
      if (!(aPageTag in this.pageData))
        this.pageData[aPageTag] = [];
      this.pageData[aPageTag][aItemID] = aDataObject;
    },

    getItemData: function(aPageTag, aItemID) {
      if (!(aItemID in this.pageData[aPageTag]))
        this.pageData[aPageTag][aItemID] = [];
      return this.pageData[aPageTag][aItemID];
    }
  }
  this.contentID = aContentID;

  wsm = this;

  this.handlers = {
    colorpicker: { get: wsm.get_Colorpicker, set: wsm.set_Colorpicker },
    menulist: { get: wsm.get_Menulist, set: wsm.set_Menulist },
    radiogroup: { get: wsm.get_Radiogroup, set: wsm.set_Radiogroup },
    checkbox: { get: wsm.get_Checkbox, set: wsm.set_Checkbox },
    textbox: { get: wsm.get_Textbox, set: wsm.set_Textbox },
    listitem: {  get: wsm.get_Listitem, set: wsm.set_Listitem },
    data: {  get: wsm.get_Data, set: wsm.set_Data },
    default_handler: { get: wsm.get_Default, set: wsm.set_Default }
  }
  this.attributes = [];
}

nsWidgetStateManager.prototype =
{
  get contentArea()
  {
    if (document.getElementById(this.contentID).localName == "tabpanels")
      return window.top;
    else
      return window.frames[this.contentID];
  },

  savePageData: function(aPageTag)
  {
    if (!(aPageTag in this.dataManager.pageData))
      return;

    var elements;

    if ('_elementIDs' in this.contentArea && this.contentArea._elementIDs) {
      elements = new Array();

      for (var i = 0; i < this.contentArea._elementIDs.length; i++) {
        var elt = this.contentArea.document.getElementById(this.contentArea._elementIDs[i]);

        if (elt)
          elements[elements.length] = elt;
        else {
          dump("*** FIX ME: '_elementIDs' in '" + this.contentArea.location.href.split('/').pop() +
               "' contains a reference to a non-existent element ID '" + this.contentArea._elementIDs[i] + "'.\n");
        }
      }
    }
    else {
      elements = this.contentArea.document.getElementsByAttribute("wsm_persist", "true");
    }

    for (var ii = 0; ii < elements.length; ii++) {
      var elementID   = elements[ii].id;
      var elementType = elements[ii].localName;

      if (!(aPageTag in this.dataManager.pageData))
        this.dataManager.pageData[aPageTag] = [];
      this.dataManager.pageData[aPageTag][elementID] = [];
      var get_Func = (elementType in this.handlers) ? this.handlers[elementType].get : this.handlers.default_handler.get;
      this.dataManager.setItemData(aPageTag, elementID, get_Func(elementID));
    }
    if ('GetFields' in this.contentArea) {
      var dataObject = this.dataManager.getPageData(aPageTag);
      dataObject = this.contentArea.GetFields(dataObject);

      if (dataObject)
        this.dataManager.setPageData(aPageTag, dataObject);
    }
  },

  setPageData: function(aPageTag)
  {
    var pageData = this.dataManager.getPageData(aPageTag);

    if ('SetFields' in this.contentArea) {
      if (!this.contentArea.SetFields(pageData))
        return;
    }
    for (var elementID in pageData) {
      var element = this.contentArea.document.getElementById(elementID);

      if (element) {
        var elementType = element.localName;
        var set_Func = (elementType in this.handlers) ? this.handlers[elementType].set
                                                      : this.handlers.default_handler.set;
        set_Func(elementID, pageData[elementID]);
      }
    }
  },

  generic_Set: function(aElement, aDataObject)
  {
    if (aElement) {
      for (var property in aDataObject) {
        if (property == "localname")
          continue;
        if (!aDataObject[property] && typeof aDataObject[property] == "boolean")
          aElement.removeAttribute(property);
        else if (property)
          aElement.setAttribute(property, aDataObject[property]);
      }
      if (!aElement.getAttribute("disabled", "true"))
        aElement.removeAttribute("disabled");
    }
  },

  generic_Get: function(aElement)
  {
    if (aElement) {
      var dataObject = [];
      var wsmAttributes = aElement.getAttribute("wsm_attributes");
      var attributes = wsm.attributes; // make a copy

      if (wsmAttributes != "")
        attributes.push(wsmAttributes.split(" ")); // modify the copy

      for(var i = 0; i < attributes.length; i++) {
        dataObject[attributes[i]] = aElement.getAttribute(attributes[i]);
      }
      dataObject.localname = aElement.localName;
      return dataObject;
    }
    return null;
  },

  set_Colorpicker: function (aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);

    if ('color' in aDataObject) {
      try {
        element.color = aDataObject.color;
      }
      catch (ex) {
        dump(aElementID + ", ex: " + ex + "\n");
      }
    }
  },

  get_Colorpicker: function(aElementID) 
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject  = wsm.generic_Get(element);

    if (dataObject) {
      dataObject.color = element.color;
      return dataObject;
    }
    return null;
  },

  set_Menulist: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    // set all generic properties
    wsm.generic_Set(element, aDataObject);
    // set menulist specific properties
    if ('value' in aDataObject) {
      try {
        element.value = aDataObject.value;
      }
      catch (ex) {
        dump(aElementID + ", ex: " + ex + "\n");
      }
    }
  },

  get_Menulist: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    // retrieve all generic attributes
    var dataObject  = wsm.generic_Get(element);
    // retrieve all menulist specific attributes
    if (dataObject) {
      dataObject.value = element.getAttribute("value");
      return dataObject;
    }
    return null;
  },

  set_Radiogroup: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);

    if ('value' in aDataObject) {
      element.value = aDataObject.value;
    }
    if ('disabled' in aDataObject) {
      element.disabled = aDataObject.disabled;
    }
  },

  get_Radiogroup: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);

    if (dataObject) {
      dataObject.value = element.getAttribute("value");
      return dataObject;
    }
    return null;
  },

  set_Textbox: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);
  },

  get_Textbox: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);

    if (dataObject) {
      dataObject.value = element.value;
      return dataObject;
    }
    return null;
  },

  set_Checkbox: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    // Set generic properites. 
    wsm.generic_Set(element, aDataObject);
   // Handle reversed boolean values.
    if ("checked" in aDataObject && element.hasAttribute("reversed"))
      element.checked = !aDataObject.checked; 
  },

  get_Checkbox: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);

    if (dataObject) {
      var checked = element.checked;
      dataObject.checked = element.getAttribute("reversed") == "true" ? !checked : checked;
      return dataObject;
    }
    return null;
  },

  set_Listitem: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);
    // Handle reversed boolean values.
    if ("checked" in aDataObject && element.hasAttribute("reversed"))
      element.checked = !aDataObject.checked; 
  },

  get_Listitem: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);

    if (dataObject) {
      if (element.getAttribute("type") == "checkbox") {
        var checked = element.checked;
        dataObject.checked = element.getAttribute("reversed") == "true" ? !checked : checked;
      }
      return dataObject;
    }
    return null;
  },

  set_Data: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);

    if ('value' in aDataObject)
      element.setAttribute("value", aDataObject.value);
  },

  get_Data: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);

    if (dataObject) {
      dataObject.value = element.getAttribute("value");
      return dataObject;
     }
     return null;
  },

  set_Default: function(aElementID, aDataObject)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    wsm.generic_Set(element, aDataObject);
  },

  get_Default: function(aElementID)
  {
    var element = wsm.contentArea.document.getElementById(aElementID);
    var dataObject = wsm.generic_Get(element);
    return dataObject ? dataObject : null;
  }
}
  
/***
  * Start of: nsPrefWindow.js
  */
const _DEBUG = false; 

var queuedTag; 

function initPanel(aPrefTag)
{
  if (hPrefWindow)
    hPrefWindow.onpageload(aPrefTag)
  else
    queuedTag = aPrefTag;
} 

function onLoad()
{
  hPrefWindow = new nsPrefWindow('panelFrame');

  if (!hPrefWindow)
    throw "failed to create prefwindow";
  else
    hPrefWindow.init();
}

function nsPrefWindow(aContentID)
{
  if (!aContentID)
    throw "Error: aContentID not supplied!";

  this.contentID = aContentID;
  this.contentFrame = aContentID; // For backward compatibility with old style pref panels
  this.wsm = new nsWidgetStateManager(aContentID);
  this.wsm.attributes = ["preftype", "prefstring", "prefattribute", "disabled"];
  this.pref = null;
  this.chromeRegistry = null;
  this.observerService = null;
  this.cancelHandlers = [];
  this.okHandlers = [];
  this.pagePrefChanged = false;
  this.pagePrefUpdated = [];
  this.contentWindow = null;
  this.contentElement = null;
  this.prefTree = null;
  this.panelBuffer = [];
  this.loadingOverlay = false;
  this.onload();
}

nsPrefWindow.prototype =
{
  onload: function()
  {
    try  {
      var regType = ('nsIChromeRegistrySea' in Ci) ? Ci.nsIChromeRegistrySea : Ci.nsIXULChromeRegistry;
      this.chromeRegistry = Cc["@mozilla.org/chrome/chrome-registry;1"].getService(regType);
      this.pref = Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefService).getBranch(null);
      this.observerService = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);

      this.contentElement = document.getElementById(this.contentID);

      if (this.contentElement.localName == "tabpanels")
        this.contentWindow = window.top;
      else
        this.contentWindow = window.frames[this.contentID];

      this.prefTree = document.getElementById("prefsTree");
    }
    catch(ex) {
      dump("*** Failed to create prefs object\n");
      return;
    }
  },

  init: function()
  {        
    if (window.queuedTag)
      this.onpageload(window.queuedTag);
  
    if (window.arguments[1])
      this.openBranch(window.arguments[1], window.arguments[2]);
  },
                  
  onAccept: function()
  {
    var tag = this.contentElement.getAttribute("tag");

    if (tag == "")
      tag = this.contentElement.getAttribute("src");

    hPrefWindow.wsm.savePageData(tag);

    for(var i = 0; i < hPrefWindow.okHandlers.length; i++) {
      try {
        hPrefWindow.okHandlers[i]();
      } catch (ex) {
        dump("some silly ok handler /*"+hPrefWindow.okHandlers[i]+"*/ failed: "+ e);
      }
    }
    hPrefWindow.savePrefs();
    return true;
  },
        
  onCancel: function()
  {
    for(var i = 0; i < hPrefWindow.cancelHandlers.length; i++) {
      try {
        hPrefWindow.cancelHandlers[i]();
      } catch (ex) {
        dump("some silly cancel handler /*"+hPrefWindow.cancelHandlers[i]+"*/ failed: "+ e);
      }
    }
    return true;
  },

  registerOKCallbackFunc: function(aFunctionReference)
  { 
    this.okHandlers[this.okHandlers.length] = aFunctionReference;
  },

  registerCancelCallbackFunc: function(aFunctionReference)
  {
    this.cancelHandlers[this.cancelHandlers.length] = aFunctionReference;
  },

  getPrefIsLocked: function(aPrefString)
  {
    return this.pref.prefIsLocked(aPrefString);
  },

  getPref: function(aPrefType, aPrefString)
  {
    try {
      switch (aPrefType) {
        case "bool":
          return this.pref.getBoolPref(aPrefString);
        case "int":
          return this.pref.getIntPref(aPrefString);
        case "localfile":
          return this.pref.getComplexValue(aPrefString, Ci.nsILocalFile);
        case "localizedstring":
          return this.pref.getComplexValue(aPrefString, Ci.nsIPrefLocalizedString).data;
        case "color":
        case "string":
        default:
          return this.pref.getComplexValue(aPrefString, Ci.nsISupportsString).data;
      }
    }
    catch (ex) {
      if (_DEBUG) {
        dump("*** no default pref for " + aPrefType + " pref: " + aPrefString + "\n");
        dump(e + "\n");
      }
    }
    return "!/!ERROR_UNDEFINED_PREF!/!";
  },

  setPref: function(aPrefType, aPrefString, aValue)
  {
    try {
      switch (aPrefType) {
        case "bool":
          this.pref.setBoolPref(aPrefString, aValue);
          break;
        case "int":
          this.pref.setIntPref(aPrefString, aValue);
          break;
        case "localfile":
          this.pref.setComplexValue(aPrefString, Ci.nsILocalFile, aValue);
         break;
        case "color":
        case "string":
        case "localizedstring":
        default:
          var supportsString = Cc["@mozilla.org/supports-string;1"].createInstance(Ci.nsISupportsString);
          supportsString.data = aValue;
          this.pref.setComplexValue(aPrefString, Ci.nsISupportsString, supportsString);
          break;
      }
    }
    catch (ex) {
      dump(e + "\n");
    }
  },
          
  savePrefs: function()
  {
    for (var pageTag in this.wsm.dataManager.pageData) {
      var pageData = this.wsm.dataManager.getPageData(pageTag);

      if ("initialized" in pageData && pageData.initialized) {
        if ("elementIDs" in pageData)
          pageData = pageData.elementIDs;

        for (var elementID in pageData) {
          if (elementID == "initialized")
            continue;
          var itemObject = pageData[elementID];

          if (typeof(itemObject) != "object")
            break;
          if ("prefstring" in itemObject && itemObject.prefstring) {
            var elt = itemObject.localname;
            var prefattribute = itemObject.prefattribute;

            if (!prefattribute) {
              if (elt == "radiogroup" || elt == "textbox" || elt == "menulist")
                prefattribute = "value";
              else if (elt == "checkbox" || elt == "listitem")
                prefattribute = "checked";
              else if (elt == "colorpicker")
                prefattribute = "color";
              else if (elt == "button")
                prefattribute = "disabled";
            }
            var value = itemObject[prefattribute];
            var preftype = itemObject.preftype;

            if (!preftype) {
              if (elt == "textbox" || elt == "colorpicker")
                 preftype = "string";
              else if (elt == "checkbox" || elt == "listitem" || elt == "button")
                preftype = "bool";
              else if (elt == "radiogroup" || elt == "menulist")
                preftype = "int";
            }
            switch (preftype) {
              case "bool":
                if (value == "true" && typeof(value) == "string")
                  value = true;
                 else if (value == "false" && typeof(value) == "string")
                  value = false;
                break;
              case "int":
                value = parseInt(value, 10);                              
                break;
              case "color":
                if (toString(value) == "") {
                  dump("*** ERROR CASE: illegal attempt to set an empty color pref. ignoring.\n");
                  break;
                }
              case "string":
              case "localizedstring":
              default:
                if (typeof(value) != "string")
                  value = toString(value);
                break;
            }
            // the pref is not saved, if the pref value is not
            // changed or the pref is locked.
            if (!this.getPrefIsLocked(itemObject.prefstring) && (value != this.getPref(preftype, itemObject.prefstring)))
              this.setPref(preftype, itemObject.prefstring, value);
          }
        }
      }
    }
    try {
      Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefService).savePrefFile(null);
    }
    catch (ex) {
      try {
        var prefUtilBundle = document.getElementById("bundle_prefutilities");
        var alertText = prefUtilBundle.getString("prefSaveFailedAlert");
        var titleText = prefUtilBundle.getString("prefSaveFailedTitle");
        var promptService = Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService);
        promptService.alert(window, titleText, alertText);
      }
      catch (ex) {
        dump(ex + "\n");
      }
    }
  },                        

  loadOverlay: function(aTab)
  {
    this.loadingOverlay = true;
    var targetIndex = this.panelBuffer.splice(0, 1);
    var targetTab = (aTab) ? aTab : this.prefTree.childNodes[targetIndex];
    var overlayURL = targetTab.getAttribute("overlayURL");

    if (overlayURL) {
      function OverlayLoadObserver() {
        this.targetPanel = this._outer.contentElement.childNodes[targetIndex];
      }
      OverlayLoadObserver.prototype = {
        _outer: this,

        observe: function (aSubject, aTopic, aData) {
          // dump("\nloadOverlay - targetTab: " + targetTab.id);
          targetTab.removeAttribute("overlayURL");
          targetTab.setAttribute("tag", overlayURL);
          // dump("\nOverlayLoadObserver - overlayURL: " + overlayURL);
          if (aTab == undefined)
            this._outer.contentElement.setAttribute("tag", overlayURL);
          // dump("\nOverlayLoadObserver - observe");
          var event = document.createEvent("Events");
          event.initEvent("load", true, true);
          event.preload = (aTab) ? this.targetPanel.id : null;
          this.targetPanel.dispatchEvent(event);

          if (this._outer.panelBuffer.length)
            this._outer.loadOverlay();
          else
            this._outer.loadingOverlay = false;
        }
      };
      var observer = new OverlayLoadObserver();
      window.__mozilla__loadOverlay(overlayURL, observer);
    }
  },

  selectPanel: function()
  {
    var targetIndex = this.prefTree.selectedIndex;
    var panelTag = this.contentElement.getAttribute("tag");
    // dump("\nthis.contentElement: " + this.contentElement.id);
    if (panelTag) {
      // dump("\nselectPanel - panelTag: " + panelTag);
      this.wsm.savePageData(panelTag);
    }
    var newTag = this.prefTree.selectedItem.getAttribute("tag");

    if (newTag) {
     // dump("\nselectPanel - newTag: " + newTag);
      this.contentElement.setAttribute("tag", newTag);
    }

    if (this.panelBuffer.indexOf(targetIndex) == -1 &&
        this.prefTree.selectedItem.hasAttribute("overlayURL")) {
      this.panelBuffer.unshift(targetIndex);
    }
    if (!this.loadingOverlay && this.panelBuffer.length) {
      this.loadOverlay();
    }
    else {
      var pageData = this.wsm.dataManager.getPageData(newTag);
      _elementIDs = pageData._elementIDs; // recollect stored array with IDs
    }
    this.contentElement.selectedIndex = targetIndex;

    var selectedPanel = hPrefWindow.contentElement.selectedPanel;
    var tabs = selectedPanel.getElementsByTagName("tabs")[0];

    if (tabs) {
      var persistedTabID = tabs.getAttribute("LastActiveTab");

      if (persistedTabID) {
        var persistedTab = document.getElementById(persistedTabID);
        tabs.selectedItem = persistedTab;
      }
    }
  },

  switchPage: function()
  {
    var prefTree = this.prefTree;
    var selectedItem, targetItem;

    if (prefTree.localName == "tabs") {
      selectedItem = prefTree.selectedIndex;
      targetItem = prefTree.selectedItem;
    }
    else {
      selectedItem = prefTree.contentView.getItemAtIndex(prefPanelTree.currentIndex);
      targetItem = selectedItem.firstChild.firstChild;
    }
    var contentElement = this.contentElement;
    var oldURL = contentElement.getAttribute("tag");

    if (!oldURL)
      oldURL = contentElement.getAttribute("src");

    this.wsm.savePageData(oldURL); // save data from the current page. 

    var newURL = targetItem.getAttribute("url");
    var newTag = targetItem.getAttribute("tag");

    if (newURL != oldURL) {
      contentElement.setAttribute("src", newURL);

      if (!newTag)
        contentElement.removeAttribute("tag");
      else
        contentElement.setAttribute("tag", newTag);
    }
  },
              
  onpageload: function(aPageTag)
  {
    if (this.contentElement.localName == "iframe") {
      var header = document.getElementById("header");

      if (header)
        header.setAttribute("title", this.contentWindow.document.documentElement.getAttribute("headertitle"));
    }
    // update widgets states when it is first loaded, or there are
    // system pref switch. (i.e., to refect the changed lock status).
    if (!(aPageTag in this.wsm.dataManager.pageData) ||
        (this.pagePrefChanged && (!(aPageTag in this.pagePrefUpdated))))
    {
      var prefElements = this.contentWindow.document.getElementsByAttribute("prefstring", "*");
      this.initPreferences(aPageTag, prefElements);
    }
    if ('Startup' in this.contentWindow)
      this.contentWindow.Startup();
  },

  initPreferences: function(aPageTag, aPrefElements)
  {
    if (this.pagePrefChanged)
      this.pagePrefUpdated[aPageTag] = [];

    this.wsm.dataManager.getPageData(aPageTag);
    var prefElement, isNodeList = (aPrefElements[0] instanceof XULElement);

    for (var i = 0; i < aPrefElements.length; i++) {
      if (isNodeList)
        prefElement = aPrefElements[i];
      else {
        var prefID = aPrefElements[i];
        prefElement = this.contentWindow.document.getElementById(prefID);
      }
      if (prefElement == null) {
        dump("\nfailed pref: " + prefElement);
        continue;
      }
      var prefstring = prefElement.getAttribute("prefstring");
      var prefid = prefElement.getAttribute("id");
      var preftype = prefElement.getAttribute("preftype");
      var elt = prefElement.localName;

      if (!preftype) {
        switch(elt) {
          case "textbox":
          case "colorpicker":
            preftype = "string";
            break;
          case "checkbox":
          case "listitem":
          case "button":
            preftype = "bool";
            break;
          case "radiogroup":
          case "menulist":
            preftype = "int";
            break;
        }
      }
      var prefdefval = prefElement.getAttribute("prefdefval");
      var prefattribute = prefElement.getAttribute("prefattribute");

      if (!prefattribute) {
        switch(elt) {
          case "radiogroup":
          case "textbox":
          case "menulist":
            prefattribute = "value";
            break;
          case "checkbox":
          case "listitem":
            prefattribute = "checked";
            break;
          case "colorpicker":
            prefattribute = "color";
            break;
          case "button":
            prefattribute = "disabled";
            break;
        }
      }
      var prefvalue = this.getPref(preftype, prefstring);

      if (prefvalue == "!/!ERROR_UNDEFINED_PREF!/!")
        prefvalue = prefdefval;

      var root = this.wsm.dataManager.getItemData(aPageTag, prefid);
      root[prefattribute] = prefvalue;
      var isPrefLocked = this.getPrefIsLocked(prefstring);

      if (isPrefLocked)
        root.disabled = "true";

      root.localname = prefElement.localName;
    }
    this.wsm.setPageData(aPageTag);
    // Keep the array with IDs for when the user re-selects a panel!
    this.wsm.dataManager.pageData[aPageTag]._elementIDs = aPrefElements;
    this.wsm.dataManager.pageData[aPageTag].initialized = true;
    // All preferences on this panel should now be initialized,
    // dispatch event to let our listeners do their housekeeping!
    var event = document.createEvent("Events");
    event.initEvent("postinit", true, true);
    document.dispatchEvent(event);
    // Old style post 'event' (kept for compatibility only)
    if ('mzAfterPanelInit' in this.wsm.contentArea)
      this.wsm.contentArea.mzAfterPanelInit();
  },

  openBranch: function(aComponentName, aSelectItem)
  {
    var panelTree = document.getElementById("prefsTree");
    var selectItem = document.getElementById(aSelectItem);
    var selectItemroot = document.getElementById(aComponentName);
    var parentIndex = panelTree.contentView.getIndexOfItem(selectItemroot);

    if (parentIndex != -1 && !panelTree.view.isContainerOpen(parentIndex))
      panelTree.view.toggleOpenState(parentIndex);

    var index = panelTree.view.getIndexOfItem(selectItem);

    if (index == -1)
      return;

    panelTree.view.selection.select(index);
  }
};


