/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2008 by HJ van Rantwijk.  All Rights Reserved.
  */

const ADDBUTTON    = 0;
const MERGEBUTTON  = 1;
const RELOADBUTTON = 3;

const NO_ROWS_AVAILABLE      = -1;
const NO_ROWS_SELECTED       = 0;
const MIXED_ROWS_SELECTED    = 1;
const MULTIPLE_ROWS_SELECTED = 2;
const TAB_ROW_SELECTED       = 3;
const WINDOW_ROW_SELECTED    = 4;

const TITLE_PROPERTY    = 0;
const LOCATION_PROPERTY = 4;
const SELECTED_PROPERTY = 6;
const ORDINAL_PROPERTY  = 7;
const TABSTYLE_PROPERTY = 13;

const nsIWindowDataSource = Components.interfaces.nsIWindowDataSource; // We need this for multiviewsRDF.js!
const nsIRDFResource = Components.interfaces.nsIRDFResource;
const nsIRDFLiteral = Components.interfaces.nsIRDFLiteral;

var gPreferences;
var gBrowser = null; // declared in navigator.js but out of reach for us!

var gResource = "";
var gSelectedWindowID = null;
var contextMenuitems = null;
var gManager;
var gMultiZilla = null;

/***
  * Toolbar button ID arrays that will be replaced with elements in updateToolbarButtons()
  * note: keep the order in-line with the corresponding XUL code!
  */
var toolbarButtons = ["addSessionButton", "mergeTabsButton", "openSessionButton",
                      "reloadButton", "propertiesButton", "renameButton",
                      "deleteButton", "prefsButton" ];
/***
  * Toolbar button arrays, to ease the pain of enabling/disabling the buttons
  */
var defaultEnabledButtons      = [  true, false, false, false, false, false, false, true ];
var tabEnabledButtons          = [  true, false,  true,  true,  true, false,  true, true ];
var windowEnabledButtons       = [  true, false,  true, false,  true,  true,  true, true ];
var selectionEnabledButtons    = [  true, false,  true, false, false, false,  true, true ];
var multipleRowsEnabledButtons = [  true, false,  true, false, false, false,  true, true ];


function initFrame()
{
  gManager = window.top;
  gManager.selectWindowStyling(document.documentElement);
  var navigatorWindow = gManager.getNavigatorWindow(true);
  gPreferences = navigatorWindow.gMultiZilla.prefs;
  gMultiZilla = navigatorWindow.gMultiZilla;
}

// Copied over from multiviewsInit.js because multiviewsRDF.js needs it.
function mzGetNumberOfWindowsByType(aType)
{
  var defaultType = "navigator:browser";

  if (!aType) // default check for browser window
    aType = defaultType;

  var windowCounter = 0;
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var enumerator = windowManager.getEnumerator(aType);

  while (enumerator.hasMoreElements()) {
    var aWindow = enumerator.getNext();
    windowCounter++;
  }
  return windowCounter;
}

function updateToolbarButtons()
{
  // Check if the toolbar buttons are initialized
  if (typeof toolbarButtons[0] == 'string') {
    // Not initialized yet, initialize button array
    for (var i = 0; i < toolbarButtons.length; i++)
      toolbarButtons[i] = document.getElementById(toolbarButtons[i]);
  }
  var buttons = defaultEnabledButtons;
  var treeState = sessionManager.getCurrentTreeState();
  var propertyTooltipType = "item";

  if (treeState > NO_ROWS_SELECTED) {
    // No, check tree selection state and choose the appropriate toolbar button array
    if (treeState == TAB_ROW_SELECTED) {
      buttons = tabEnabledButtons;
      propertyTooltipType = "tab";
    }
    else if (treeState == WINDOW_ROW_SELECTED) {
      buttons = windowEnabledButtons;
      propertyTooltipType = "window";
    }
    else if (treeState == MIXED_ROWS_SELECTED)
      buttons = selectionEnabledButtons;
    else if (treeState == MULTIPLE_ROWS_SELECTED)
      buttons = multipleRowsEnabledButtons;
  }
  var propertyButtonTooltipID = propertyTooltipType + "PropertiesButton.tooltiptext";
  var propertyButtonTooltip = gSessionManagerStringBundle.getString(propertyButtonTooltipID);
  toolbarButtons[4].setAttribute("tooltiptext", propertyButtonTooltip);
  // Enable/disable the toolbar buttons based on the toolbar array
  for (var buttonIndex = 0; buttonIndex < toolbarButtons.length; buttonIndex++)
    toolbarButtons[buttonIndex].disabled = !buttons[buttonIndex];

  toolbarButtons[ADDBUTTON].disabled = areAllTabsBlank(tabbrowser);
  toolbarButtons[MERGEBUTTON].disabled = areAllTabsBlank(tabbrowser) || treeState == NO_ROWS_SELECTED || treeState != WINDOW_ROW_SELECTED;

  var acceptButton = gManager.document.documentElement.getButton("accept");

  if (acceptButton.disabled)
    acceptButton.disabled = (treeState == NO_ROWS_SELECTED);
}

function initContextMenu(aEvent)
{
  tabbrowser = gManager.getTabbrowser(true);

  var i = 0;
  var clickedRow = sessionManager.getRowNumber(aEvent);
  // Disable all menu items, but the first one, for clicking on an empty spot in the tree
  if (clickedRow == -1) {
    var menuItems = aEvent.originalTarget.childNodes;
    // Iterate over all menu items and disable them
    for (i = 1; i < menuItems.length; i++) {
      menuItems[i].setAttribute("disabled", true);
      menuItems[i].hidden = false;
    }
  }
  var rows = tree.treeBoxObject.view.rowCount;

  if (rows == 0) {
    menuItems[0].setAttribute("disabled", true);
    return;
  }
  var selectedResources = sessionManager.getSelectedResources();
  // Disable "Select All" when there's a selection
  var selectAll = document.getElementById("SelectAll");
  // Disable "Deselect All" when there's no selection
  var deselectAll = document.getElementById("UndoSelection");

  if (selectedResources == null)
    selectedResources = new Array();
  if (selectedResources.length > 1) {
    selectAll.setAttribute("disabled", "true");
    deselectAll.removeAttribute("disabled");
  }
  else { // No selection, enable "Select All" and disable "Deselect All"
    if (rows > 1)
      selectAll.removeAttribute("disabled");
    deselectAll.setAttribute("disabled", "true");
  }
  var tabElements = document.getElementsByAttribute("display_for", "tabs");
  var windowElements = document.getElementsByAttribute("display_for", "windows");
  var tabAndWindowElements = document.getElementsByAttribute("display_for", "tabs-and-windows");
  var isMixed = sessionManager.checkForMixedSelection();
  var isContainer = isMixed ? false : (clickedRow == -1) ? (selectedResources && selectedResources.length == 1 && selectedResources[0].match(/root/) == "root") : tree.treeBoxObject.view.isContainer(clickedRow);
  var isWindow = isMixed ? false : isContainer;
  var isTab = isMixed ? false : !isWindow;

  for (i = 0; i < tabElements.length; i++) {
    tabElements[i].setAttribute("disabled", !isTab);
    tabElements[i].hidden = !isTab;
  }
  for (i = 0; i < windowElements.length; i++) {
    windowElements[i].setAttribute("disabled", !isWindow);
    windowElements[i].hidden = !isWindow;
  }
  for (i = 0; i < tabAndWindowElements.length; i++) {
    tabAndWindowElements[i].setAttribute("disabled", !isMixed);
    tabAndWindowElements[i].hidden = !isMixed;
  }
  document.getElementById('FileAsBookmark').setAttribute("disabled", (isContainer || selectedResources.length > 1));
  document.getElementById('FileAsGroupmark').setAttribute("disabled", isMixed || (!isContainer && selectedResources.length == 1));
  document.getElementById('SetInterval').setAttribute("disabled", (!isTab || selectedResources.length > 1));
  document.getElementById('AddNewSession').setAttribute("disabled", areAllTabsBlank(tabbrowser));
  document.getElementById('MergeTabs').setAttribute("disabled", areAllTabsBlank(tabbrowser) || (selectedResources.length == 0) || (!isContainer));
  document.getElementById('OpenSMPropertyWindow').setAttribute("disabled", (selectedResources.length > 1));
  document.getElementById('RenameSession').setAttribute("disabled", (!isContainer || selectedResources.length > 1));
}

function initReloadPopup(aPopup, aEvent)
{
  if (toolbarButtons[RELOADBUTTON].disabled) {
    aEvent.preventDefault();
    return;
  }
  tabbrowser.initReloadPopup(document, aPopup, null, sessionManager.getReloadInterval());
}

function activatePropertiesFrame()
{
  var treeState = sessionManager.getCurrentTreeState();

  if (treeState == NO_ROWS_SELECTED || treeState == MULTIPLE_ROWS_SELECTED)
    return;

  if (currentRow == -1)
    gResource = sessionManager.getSelectedResources()[0];
  else
    gResource = sessionManager.getResourceForRow(tree, currentRow); // tab    -> urn:session-x:window-x:tabs:tab-x
                                                                    // window -> urn:session-x:window-x:tabs:root
  var propertyType = gResource.match(/:tabs:root/) ? "windowPropertiesFrame"
                                                   : "propertiesFrame";
  gManager.switchPage(propertyType);
}

function activateSettingsFrame()
{
  gManager.switchPage("settingsFrame");
}

function getTargetWindow(aTitle, aButtonText, aTargetWindowID)
{
  gSelectedWindowID = null;
  var isClassicStyle = gPreferences.readBoolean("multizilla.windows.classic-style", false);
  window.openDialog("chrome://multiviews/content/session-manager/miscellaneous/sessionManagerSelectWindow.xul", "",
                    "chrome, dependent, modal, dialog, centerscreen", aTitle, aButtonText, aTargetWindowID, window, isClassicStyle);

  if (gSelectedWindowID) {
    var windowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService(nsIWindowDataSource);
    return windowManagerDS.getWindowForResource(gSelectedWindowID);
  }
  return null;
}
// multiviewsRDF.js needs this function!
function checkForBlankTab(aTabBrowser)
{
  if (gPreferences.readBoolean("multizilla.tabs.blank-tab-first", true)) {
    var page = "about:blank";
    aTabBrowser = aTabBrowser ? aTabBrowser : getBrowser();
    var tabContainer = aTabBrowser.mTabs;

    for (var i = 0; i < tabContainer.length; i++) {
      var tab = tabContainer[i];

      if (tab.hasAttribute("busy"))
        page = tab.getAttribute("firstpage");
      else 
        page = tab.linkedBrowser.currentURI.spec;

      if (page == "about:blank") {
        return tab.linkedBrowser;
      }
    }
  }
  return null;
}
// multiviewsRDF.js needs this function!
function areAllTabsBlank(aTabbrowser)
{
  if (!aTabbrowser)
    aTabbrowser = gManager.getTabbrowser(true);

  var numberOfTabs = aTabbrowser.mTabContainer.childNodes.length;
  var numberOfBlankTabs = mzGetNumberOfBlankTabs(aTabbrowser);

  return (numberOfTabs == numberOfBlankTabs);
}
// multiviewsRDF.js needs this function!
function mzGetNumberOfBlankTabs(aTabBrowser)
{
  var blankTabs = 0;
  var tabs = aTabBrowser.mTabs;

  for (var i = 0; i < tabs.length; i++) {
    var tab = tabs[i];
    var browser = tab.linkedBrowser;

    if (tab.hasAttribute("busy")) {
      if (tab.getAttribute("firstPage") == "about:blank")
        blankTabs++;
    }
    else if (browser.currentURI.spec == "about:blank")
      blankTabs++;
  }
  return blankTabs;
}

function bookmarkSelection()
{
  var selectedResources = sessionManager.getSelectedResources();
  // Do we have any resources?
  if (selectedResources) {
    var groupmarkInfo = new Array();
    var mainResources = new Array();
    var selectedResourceInfo = { name: "", url: "", charset: null };
    var propertyValues, i = -1;
    // Iterate over all resources
    for (rIndex in selectedResources) {
      var resource = selectedResources[rIndex];       
      // Is this a session container?
      if (resource.match(/root/) == "root") {
        // Yes, get all resources
        var resourceList = mzGetResourcesFromContainer(mzRDFStore, resource);
        // Iterate over all container items
        for (cIndex in resourceList) {
          resource = resourceList[cIndex];
          i++;
          propertyValues = mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(resource));
          groupmarkInfo[i] = new Object();
          groupmarkInfo[i].name = propertyValues[TITLE_PROPERTY];
          groupmarkInfo[i].url = propertyValues[LOCATION_PROPERTY];
          /* We need to store the character set when we save sessions!
             groupmarkInfo[i].charset = propertyValues[CHARSET_PROPERTY]; */
          groupmarkInfo[i].charset = window.opener.document.characterSet;

          if (propertyValues[SELECTED_PROPERTY] == "true")
            selectedResourceInfo = groupmarkInfo[i];
        }
      }
      else { // Not a session container
        i++;
        propertyValues = mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(resource));
        groupmarkInfo[i] = new Object();
        groupmarkInfo[i].name = propertyValues[TITLE_PROPERTY];
        groupmarkInfo[i].url = propertyValues[LOCATION_PROPERTY];
        /* We need to store the character set when we save sessions!
           groupmarkInfo[i].charset = propertyValues[CHARSET_PROPERTY]; */
        groupmarkInfo[i].charset = window.opener.document.characterSet;

        if (propertyValues[SELECTED_PROPERTY] == "true")
          selectedResourceInfo = groupmarkInfo[i];
      }
    }
  }
  var type = (selectedResources.length > 1) ? "addGroup,group" : "";
  openDialog("chrome://communicator/content/bookmarks/addBookmark.xul", "",
             "chrome, dependent, modal, dialog, resizable=yes, centerscreen",
             selectedResourceInfo.name, selectedResourceInfo.url, null, 
             selectedResourceInfo.charset, type, groupmarkInfo);
}

function initTreeTooltip(aEvent)
{
  var node = document.tooltipNode;
  var nodeName = node.localName;
  var tooltipNode = aEvent.target;

  if (nodeName == 'tree' || nodeName.match('menu') || nodeName == 'treecol') {
    aEvent.preventDefault();
    return;
  }
  tooltipNode.firstChild.hidden = (nodeName != 'treecols');
  tooltipNode.childNodes[1].hidden = (nodeName != 'splitter');
  tooltipNode.lastChild.hidden = (nodeName != 'treechildren');
}

function mzSpinButton(aDocument, aElementId, aStepValue, aMinValue, aMaxValue)
{
  /***
    * The 'onup' and 'ondown' buttons/images are always functional, even 
    * when disabled, so we need to check this to prevent failures!
    */
  if (!aDocument || !aElementId)
    return;
  var spinbutton = aDocument.getElementById(aElementId);

  if (!spinbutton || spinbutton.disabled)
    return;

  var newValue = Number(spinbutton.value) + Number(aStepValue);
  spinbutton.value = (newValue > (aMinValue-1) && newValue < (aMaxValue+1)) ? newValue : (newValue < aMinValue) ? aMaxValue : aMinValue;
}

function mzKeySpinButton(aEvent)
{
  /***
    * The 'onup' and 'ondown' buttons/images are always functional, even 
    * disable doesn't disable them, so we need to check this ourselfs!
    */
    if (!aEvent || (aEvent.keyCode != 38 && aEvent.keyCode != 40))
      return;

    aEvent.preventDefault();

    var newValue;
    var textBox = aEvent.target;
    var spinbuttonID = textBox.getAttribute('control');

    if (!spinbuttonID)
      return;

    var spinbutton = aEvent.target.ownerDocument.getElementById(spinbuttonID);

    if (!spinbutton || spinbutton.disabled)
      return;

    var minValue = Number(spinbutton.getAttribute('min'));
    var maxValue = Number(spinbutton.getAttribute('max'));
    var stepValue = Number(spinbutton.getAttribute('step'));
    stepValue = stepValue ? stepValue : 5;

    if (aEvent.keyCode == 40)
      newValue = Number(aEvent.target.value) - stepValue;
    else if (aEvent.keyCode == 38)
      newValue = Number(aEvent.target.value) + stepValue;
    // dump("\nminValue: " + minValue + "maxValue: " + maxValue + "stepValue: " + stepValue);
    aEvent.target.value = (newValue > (minValue-1) && newValue < (maxValue+1)) ? newValue : (newValue < minValue) ? maxValue : minValue;
}

function mzValidateSpinValue(aEvent)
{
  if (!aEvent)
    return;

  var textBox = aEvent.target;
  var spinbuttonID = textBox.getAttribute('control');

  if (!spinbuttonID)
    return;

  var spinbutton = aEvent.target.ownerDocument.getElementById(spinbuttonID);

  if (!spinbutton || spinbutton.disabled)
    return;

  if (aEvent.type == "input" || (aEvent.keyCode != 38 && aEvent.keyCode != 40)) {
    var currentValue = Number(aEvent.target.value);
    var minValue = Number(spinbutton.getAttribute('min'));
    var maxValue = Number(spinbutton.getAttribute('max'));
    var stepValue = Number(spinbutton.getAttribute('step'));
    stepValue = stepValue ? stepValue : 5;

    if (isNaN(currentValue) || (currentValue < minValue || currentValue > maxValue))
      aEvent.target.value = minValue;
  }
}

var sessionManager = {
  tree : null,
  tabbrowser : null,
  lastResource : null,
  reloadInterval : 0,
  currentRow : null,
  gStringBundle : null,
  gSessionManagerStringBundle: null,
  // tooltipBox : null,
  // tabNumberTooltip : null,
  // sessionNumberTooltip : null,
  // windowNumberTooltip : null,
  dragResourceList : null,

  initSessionManager: function()
  {
    tree = document.getElementById("sessionManagerTree");
    tree.ref = "urn:sessions:root";
    mzInitializeRDFStorageFile();
    tree.database.AddDataSource(mzRDFStore);
    tree.builder.rebuild();
    tree.builder.addObserver(sessionTreeBuilderObserver);
    sessionTreeBuilderObserver._init();
    tabbrowser = gManager.getTabbrowser(true);
    gBrowser = gManager.getBrowser();
    // tooltipBox = document.getElementById("tooltipBox");
    // tabNumberTooltip = tooltipBox.childNodes[0];
    // sessionNumberTooltip = tooltipBox.childNodes[1];
    // windowNumberTooltip = tooltipBox.childNodes[2];
    lastResource = null;
    reloadInterval = 0;
    currentRow = -1;
    // sessionManager.extraCSS();
    gStringBundle = parent.document.getElementById("properties");
    gSessionManagerStringBundle = parent.document.getElementById("sessionManagerProperties");
    updateToolbarButtons();
    sizeToContent();
    sessionManager.selectMatchingSession();
  },

  selectMatchingSession: function()
  {
    var rowCount = tree.treeBoxObject.view.rowCount;

    if (rowCount) {
      var targetResource = "urn:session-0:" + mzGetRelativeWindowResourceID(gManager.opener) + ":tabs:root";

      if (mzCheckResource(mzRDFStore, targetResource)) {
        var containerResources = mzGetResourcesFromContainer(mzRDFStore, targetResource);

        if (containerResources != -1 && containerResources.length > 0) {
          for (var row = 0; row < rowCount; row++) {
            if (tree.treeBoxObject.view.isContainer(row)) {
              if (tree.builderView.getResourceAtIndex(row).Value == targetResource)
                break;
            }
          }
          tree.currentIndex = row;
          tree.view.selection.select(row);

          if (!tree.treeBoxObject.view.isContainerOpen(row))
            tree.treeBoxObject.view.toggleOpenState(row);
          // XXX: what if there more items than rows?  Won't that fail somehow?
          var lastContainerRow = Number(row + containerResources.length + 1);
          tree.treeBoxObject.ensureRowIsVisible(lastContainerRow);    
        }
      }
    }
  },

  reInitSessionManager: function()
  {
    tree = document.getElementById("sessionManagerTree");
    tree.builder.rebuild();
    lastResource = null;
  },

  getRowNumber: function(aEvent, aTree)
  {
    if (aTree == undefined)
      aTree = tree;

    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    return aTree.treeBoxObject.getRowAt(X, Y);
  },

  getResourceForRow: function(aTree, aRowNumber)
  {
    if (aTree == undefined)
      aTree = tree;

    return (aRowNumber > -1) ? aTree.builderView.getResourceAtIndex(aRowNumber).Value : null;
  },

  getResourceSpecs: function(aResource)
  {
    var resourceValues = aResource.replace(/^urn:session-/, '').replace(/[a-z:.#\/]/g, '').split('-');
    return resourceValues;
  },

  getSelectedResources: function(aTree)
  {
    if (aTree == undefined)
      aTree = tree;

    var resources = new Array();
    var rows = this.getSelectedRows(aTree);

    for (i in rows) {
      var resource = this.getResourceForRow(aTree, rows[i]);

      if (resource)
        resources.push(resource);
    }
    if (resources.length)
      return resources;
    return null;
  },

  getSelectedRows: function(aTree)
  {
    if (aTree == undefined)
      aTree = tree;

    var rows = -1;
    // Get and return all selection ranges
    var rangeCount = aTree.view.selection.getRangeCount();
    var selectedRows = new Array();
    // Iterate over all ranges to collect the selected rows
    for (var range = 0; range < rangeCount; range++) {
      var startSelection = new Object();
      var endSelection = new Object();
      aTree.view.selection.getRangeAt(range, startSelection, endSelection);
      // Collect all rows and store them in our array
      for (var row = startSelection.value; row <= endSelection.value; row++) {
        // Check for invalid row numbers
        if (startSelection.value != -1 || endSelection.value != -1)
          selectedRows[++rows] = row;
      }
    }
    return selectedRows;
  },

  getCurrentTreeState: function()
  {
    if (tree.treeBoxObject.view.rowCount < 1)
      return NO_ROWS_AVAILABLE;

    var selectedRows = sessionManager.getSelectedRows();

    if (selectedRows.length == 0)
      return NO_ROWS_SELECTED;

    var isMixed = sessionManager.checkForMixedSelection();

    if (isMixed)
      return MIXED_ROWS_SELECTED;

    var isMultiple = (selectedRows.length > 1);

    if (isMultiple)
      return MULTIPLE_ROWS_SELECTED;

    var isContainer = (currentRow > -1) ? tree.treeBoxObject.view.isContainer(tree.currentIndex) : false;
    var isWindow = isMultiple ? false : isContainer;
    var isTab = isMultiple ? false : !isWindow;

    if (isTab)
      return TAB_ROW_SELECTED;
    else if (isWindow)
      return WINDOW_ROW_SELECTED;
    return NO_ROWS_SELECTED;
  },

  getReloadInterval: function(aEvent)
  {
    var interval = 0;
    var columnID = "sm-interval";
    columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;

    if (aEvent) {
      var row = this.getRowNumber(aEvent);
      interval = (row > -1) ? tree.view.getCellText(row, columnID) : 0;
    }
    else if (!aEvent && tree.currentIndex != -1)
      interval = tree.view.getCellText(tree.currentIndex, columnID);

    if (interval)
      return interval;
    return 1;
  },

  setReloadInterval: function(aEvent, aValue)
  {
    // var resource = this.getResourceForRow(tree, currentRow);
    var selectedResources = sessionManager.getSelectedResources();
    var resource = (currentRow != -1) ? this.getResourceForRow(tree, currentRow) : selectedResources[0];
    var intervalProp = RDF.GetResource("http://multizilla.mozdev.org/rdf#interval");
    var currentValue = mzRDFStore.GetTarget(RDF.GetResource(resource), intervalProp, true);

    if (aValue == 0) // Remove interval property from tree
      mzRDFStore.Unassert(RDF.GetResource(resource), intervalProp, currentValue);
    else
      mzAddOrChangeValue(mzRDFStore, RDF.GetResource(resource), intervalProp, currentValue, RDF.GetLiteral(aValue));
    mzSetModifiedDate(mzRDFStore, resource);
  },

  /* disableIntervals: function(aTabResource)
  {
    var containerResource = aTabResource.replace(/tab-\w* /, 'root'); !!!note the extra space!!!
    var mzRDF = "http://multizilla.mozdev.org/rdf#";
    var property = mzRDF + "interval";

    mzRemoveProperties(containerResource, [property]);
  }, */

  setRowTooltip: function(aEvent)
  {
    var row = this.getRowNumber(aEvent);
    if (row == -1)
      return;

    var resource = this.getResourceForRow(tree, row);
    var resourceValues = this.getResourceSpecs(resource);

    if (resourceValues.length == 3) {
      tabNumberTooltip.setAttribute("value", "Tab: " + Number(resourceValues[2]));
      tabNumberTooltip.removeAttribute("hidden");
    }
    else
      tabNumberTooltip.setAttribute("hidden", "true");

    windowNumberTooltip.setAttribute("value", "Window: " + Number(resourceValues[1]));
    sessionNumberTooltip.setAttribute("value", "Session: " + Number(resourceValues[0]));
  },

  convertResourceDataToNumbers: function(aDataArray)
  {
     for (i in aDataArray)
       aDataArray[i] = Number(aDataArray[i])+1;
     return aDataArray;
  },

  checkForMixedSelection: function()
  {
    var tabs = 0;
    var windows = 0;
    var mixed = false;

    // Collect selected tree rows
    var selectedItems = this.getSelectedRows();
    // Do we have any selected items?
    if (selectedItems && selectedItems.length > 0) {
      // Iterate over the seleted items
      for (var row = 0; row < selectedItems.length; row++) {
        if (tree.treeBoxObject.view.isContainer(selectedItems[row]))
          windows++;
        else
          tabs++;
        // Do we have a mixed selection?
        if (tabs > 0 && windows > 0) {
          mixed = true;
          break;
        }
      }
    }
    return mixed;
  },

  removeWindowItemsFromSelection: function()
  {
    // Collect selected tree rows
    var selectedItems = this.getSelectedRows();
    // Do we have any selected items?
    if (selectedItems) {
      // Iterate over the seleted items to clear the window items
      for (row in selectedItems) {
        if (tree.treeBoxObject.view.isContainer(row))
          tree.view.selection.clearRange(row, row);
      }
    }
  },

  selectRows: function(aTree, aCommand)
  {
    if (aTree == undefined)
      aTree = tree;

    switch (aCommand) {
      case "all": // Called from the context menu, or Ctrl+A ?
           aTree.view.selection.selectAll();
           // Only remove window items when we're calle for the main tree
           if (aTree.id == "sessionManagerTree")
             this.removeWindowItemsFromSelection();
           break;
      case "none": // Called from the context menu, or Ctrl+Z ?
           aTree.view.selection.clearSelection();

           if (aTree.currentIndex >= 0)
             aTree.view.selection.select(aTree.currentIndex);
           break;
    }
    aTree.focus();
  },

  renameTabSession: function()
  {
    var selectedResources = this.getSelectedResources(tree);

    if (selectedResources && selectedResources.length == 1 && selectedResources[0].match(/:tabs:root/)) {
      var aWindow = gManager.getNavigatorWindow();

      if (!aWindow) {
        aWindow = gManager.getNavigatorWindow(true);
        setTimeout(sessionManager.renameTabSession, 0, aWindow);
        return;
      }
      else 
        aWindow = window;
      renameTabSession(mzRDFStore, selectedResources[0], aWindow);
    }
  },

  addNewSession: function()
  {
    var browserWindow, windowID, sessionID = 0;

    if (mzGetNumberOfWindowsByType() > 1) {
      // open selection window with window index number as third argument (window.arguments[2])
      var parentBrowserWindow = gManager.getNavigatorWindow(false);
      var targetWindowNumber = mzGetIndexNumberForWindow(parentBrowserWindow);
      var title = gStringBundle.getString("addSessionTitle");
      var buttonText = gStringBundle.getString("addSessionButton");
      browserWindow = getTargetWindow(title, buttonText, targetWindowNumber);
    }
    else {
      browserWindow = gManager.getNavigatorWindow(true);
    }
    if (!browserWindow)
      return;

    windowID = mzGetRelativeWindowResourceID(browserWindow);
    sessionID = mzGetNextSessionID(sessionID, windowID);

    var selectedTabStyle = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");
    var resource = "urn:" + sessionID + ":" + windowID + ":tabs:root";

    mzStoreGroupData(mzRDFStore, resource, browserWindow.gBrowser, false, false, selectedTabStyle, true, browserWindow);
    tree.builder.rebuild();
    this.selectMatchingSession();
  },

  mergeTabs: function()
  {
    var browserWindow, resource = this.getResourceForRow(tree, currentRow);
    resource = mzGetLastResourceFromContainer(mzRDFStore, resource);
    var resourceValues = this.getResourceSpecs(resource);
    var tabIndex = Number(resourceValues[2]) + 1;

    if (mzGetNumberOfWindowsByType() > 1) {
      // open selection window with window index number as third argument (window.arguments[2])
      var parentBrowserWindow = gManager.getNavigatorWindow(false);
      var targetWindowNumber = mzGetIndexNumberForWindow(parentBrowserWindow);
      var title = gStringBundle.getString("mergeTabsTitle");
      var buttonText = gStringBundle.getString("mergeTabsButton");
      browserWindow = getTargetWindow(title, buttonText, targetWindowNumber);
    }
    else
      browserWindow = gManager.getNavigatorWindow(true);

    if (!browserWindow)
      return;

    var historyItemsToKeep = gPreferences.readInteger("multizilla.browsersession.history-items", 0);
    addTabDataSeqToDS(mzRDFStore, resource, tabIndex, browserWindow.gBrowser, true, "", (historyItemsToKeep > 0), true);
    mzSetModifiedDate(mzRDFStore, resource);
    this.selectMatchingSession();
  },

  doConfirm: function(additionalText)
  {
    var dialogTitle = gStringBundle.getString("tsmConfirmActionTitle");
    var dialogText = gStringBundle.getString("tsmConfirmActionText");
    additionalText = gStringBundle.getString(additionalText);
    dialogText = dialogText.replace(/%S/, additionalText);
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);
    var result = promptService.confirmEx(gManager, dialogTitle, dialogText,
                                         (promptService.BUTTON_POS_0 * promptService.BUTTON_TITLE_YES) + 
                                         (promptService.BUTTON_POS_1 * promptService.BUTTON_TITLE_NO),
                                         null, null, null, null, {value:0});
    tree.focus();
    return (result == 0); // Yes returns 0 / No, Esc and X returns 1
  },

  onClick: function(aEvent)
  {
    var dialogButton = gManager.gAcceptButton;

    if (tree.treeBoxObject.view.rowCount > 0 && dialogButton.hasAttribute("disabled"))
      dialogButton.removeAttribute("disabled");

    if (aEvent.detail == 2)
      return;

    this.doClick(aEvent);
  },

  onDblClick: function(aEvent)
  {
    if (aEvent.button == 1)
      return;

    this.doClick(aEvent);
  },

  doClick: function (aEvent)
  {
    currentRow = this.getRowNumber(aEvent);

    if (currentRow == -1 || !tree.view.selection.isSelected(currentRow))
      return;

    var isContainer = tree.treeBoxObject.view.isContainer(currentRow);
    reloadInterval = sessionManager.getReloadInterval(aEvent);

    if (aEvent.button == 0 && aEvent.detail == 2 && !isContainer || aEvent.button == 1) {
      if (isContainer && aEvent.ctrlKey) {
        if (this.getSelectedResources() == null) {
          tree.currentIndex = currentRow;
          tree.view.selection.clearSelection();
          tree.view.selection.select(currentRow);
          tree.treeBoxObject.ensureRowIsVisible(currentRow);
        }
        sessionManager.loadTabsOrSession(true, false, -1);
        return;
      }
      sessionManager.loadTabsOrSession(true, false, false);
    }
  },

  getPreLoadType: function()
  {
    if (tree.currentIndex == -1)
      return(0);
    return tree.treeBoxObject.view.isContainer(tree.currentIndex) ? 4 : 2;
  },

  onSelect: function()
  {
    if (gManager.gPreloadStatus > 1) {
      var preLoadType = this.getPreLoadType();

      if ((preLoadType == 4) && (gManager.gPreloadStatus & preLoadType))
        setTimeout(gManager.preLoad, 0, preLoadType);
      else
        gManager.preLoad(preLoadType);
    }
    currentRow = tree.currentIndex;
    updateToolbarButtons();
  },

  onRemove: function(skipLastResourceCheck)
  {
    var rows = this.getSelectedRows();
    var confirmActionText = (rows.length > 1) ? "tsmRemoveMultipleItems" : "tsmRemoveSingleItem";

    if (!this.doConfirm(confirmActionText))
      return;

    if (rows && rows.length) {
      var containersToBeValidated = new Array();
      // Delete the selected row(s) from the bottom to the top
      for (var i = rows.length-1; i > -1; i--) {
        /***
          * 'urn:session-x:window-x:tabs:root' for windows (containers)
          * 'urn:session-x:window-x:tabs:tab-x' for tabs (normal rows)
          */
        var resource = this.getResourceForRow(tree, rows[i]);
        var containerResource = resource.replace(/tab-\w*/, 'root');

        if (containersToBeValidated.length) {
          for (cIndex in containersToBeValidated) {
            // Is this a new container?
            if (containerResource != containersToBeValidated[cIndex])
              containersToBeValidated.push(containerResource);
          }
        }
        else
          containersToBeValidated.push(containerResource);
        // Prevent duplicated actions!
        if (!skipLastResourceCheck && (lastResource == null || lastResource == resource))
          break;
        if (tree.treeBoxObject.view.isContainer(rows[i])) // Window
          mzRemoveAllResourcesFor(mzRDFStore, resource);
        else { // Single Tab
          mzRemoveTabResourcesFor(mzRDFStore, resource);
        }
      }
      for (cIndex in containersToBeValidated) {
        containerResource = containersToBeValidated[cIndex];
        sessionTreeBuilderObserver._checkContainerIndex(containerResource);
        sessionTreeBuilderObserver._validateContainer(containerResource);
        mzSetModifiedDate(mzRDFStore, containerResource);
      }
    }
    this.reInitSessionManager();
  },

  loadTabsOrSession: function(skipLastResourceCheck, closeSessionManager, openInNewWindow)
  {
    var rows = this.getSelectedRows();
    var result;

    if (rows && rows.length) {
      mzTabIndex = 0;
      var startupFlag = false;
      // [Open] openInNewWindow = true [click] openInNewWindow = false!
      closeSessionManager = (openInNewWindow == true); // 'openInNewWindow' can be 0, 1 or -1
      // check for open browser window
      if (gManager.getNavigatorWindow(false) == null) { // no open browser window
        tabbrowser = gManager.getTabbrowser(true); // open a new browser window and re-initialize 'tabbrowser'
        openInNewWindow = false;
        startupFlag = true;
      }
      for (i in rows) {
        var resource = this.getResourceForRow(tree, rows[i]);
        // Prevent duplicated actions!
        if (!skipLastResourceCheck && (/* lastResource == null || */ lastResource == resource)) {
          continue;
        }
        if (tree.treeBoxObject.view.isContainer(rows[i])) { // Restore Window(s)
          // Do we really need to open a new window?
          openInNewWindow = (openInNewWindow >= 0) ? !areAllTabsBlank(tabbrowser) : false;
          // Open new browser window if the user clicked on the Ok button, or 
          // when he tries to fool us, by closing all available browser windows!
          var browser = openInNewWindow ? openWindowAndReturnBrowser() : tabbrowser;
          result = mzRestoreTabsFromResource(mzRDFStore, browser, resource, openInNewWindow);
        }
        else { // Restore Tab(s)
          var newTab = (mzTabIndex > 0 || rows.length == 1);
          startupFlag = newTab;
          mzTabIndex++;
          result = mzRestoreTabFromResource(mzRDFStore, tabbrowser, RDF.GetResource(resource), newTab, startupFlag);
        }
        if (result == -1)
          break;
      }
    }
    if (closeSessionManager)
      window.top.close();
  },

  refreshTabStyling: function(aNewStyle)
  {
    var rows = tree.treeBoxObject.view.rowCount;

    for (var row = 0; row < rows; row++)
    {
      if (tree.treeBoxObject.view.isContainer(row)) {
        var windowResource = sessionManager.getResourceForRow(tree, row);
        var windowContainer = mzRDFCUtils.MakeSeq(mzRDFStore, RDF.GetResource(windowResource)).GetElements();

        while (windowContainer.hasMoreElements())
        {
          var tabResource = windowContainer.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
          var tabContainer = mzRDFCUtils.MakeSeq(mzRDFStore, RDF.GetResource(tabResource)).GetElements();
          var labels = mzRDFStore.ArcLabelsOut(tabResource);

          while (labels.hasMoreElements())
          {
            try {
              var label = labels.getNext().QueryInterface(Components.interfaces.nsIRDFResource);

              if (label.Value == "http://multizilla.mozdev.org/rdf#selected") {
                var data = mzRDFStore.GetTarget(tabResource, label, true);
                var value = data.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

                if (value == "true")
                  mzAddOrChangeStyleProperty(mzRDFStore, tabResource.Value, aNewStyle);
                else
                  mzRDFStore.Unassert(tabResource, label, data);
              }
            } 
            catch(ex) { 
              // die silently
            }
          }
	    }
      }
    }
  },

  /* extraCSS: function()
  {
    if ("@mozilla.org/content/style-sheet-service;1" in Components.classes) {
      dump("\nTSM nsIStyleSheetService available!");
      var _nsIStyleSheetService = Components.classes["@mozilla.org/content/style-sheet-service;1"].getService(Components.interfaces.nsIStyleSheetService);
      var _nsIIOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
      var buttonIconsCSS = _nsIIOService.newURI("chrome://multiviews/content/buttonIcons.css", null, null);

    if (_nsIStyleSheetService.sheetRegistered(buttonIconsCSS, _nsIStyleSheetService.USER_SHEET))
      _nsIStyleSheetService.unregisterSheet(buttonIconsCSS, _nsIStyleSheetService.USER_SHEET);
    else 
      _nsIStyleSheetService.loadAndRegisterSheet(buttonIconsCSS, _nsIStyleSheetService.USER_SHEET);
    }
  }, */

  sortSessionContainers: function(aDataSource)
  {
    var sessionContainer = mzRDFCUtils.MakeSeq(aDataSource, RDF.GetResource("urn:sessions:root")).GetElements();
    var resourceList = new Array();

    while (sessionContainer.hasMoreElements()) {
      var containerResource = sessionContainer.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
      resourceList.push(containerResource.Value);
    }
    if (resourceList.length) {
      function compare(a, b)
      {
        if (a < b) return -1;
        if (a > b) return 1;
        return 0;
      }
      resourceList = resourceList.sort(compare);

      for (rIndex in resourceList) {
        var resource = resourceList[rIndex];
        dump("\n\nvalidating: " + resource);
        // sessionTreeBuilderObserver._validateContainer(RDF.GetResource(resource));
      }
    }
  },

  validateSessionContainers: function(aDataSource)
  {
    var sessionContainer = mzRDFCUtils.MakeSeq(aDataSource, RDF.GetResource("urn:sessions:root")).GetElements();
    var resourceList = new Array();

    while (sessionContainer.hasMoreElements()) {
      var containerResource = sessionContainer.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
      resourceList.push(containerResource);
    }
    if (resourceList.length) {
      for (rIndex in resourceList) {
        var resource = resourceList[rIndex];
        dump("\n\nvalidating: " + resource.Value);
        sessionTreeBuilderObserver._validateContainer(resource.Value); // resource);
      }
    }
  },

  onDragStart: function(aEvent, aXferData, aDragSession)
  {
    if (tree.treeBoxObject.view.rowCount > 0) {
      if (aEvent.ctrlKey)
        aDragSession.action = Components.interfaces.nsIDragService.DRAGDROP_ACTION_COPY;

      sessionTreeBuilderObserver.dragSession = aDragSession;
      var X = aEvent.pageX;
      var Y = aEvent.pageY;
      var dragStartRow = tree.treeBoxObject.getRowAt(X, Y);

      if (dragStartRow == -1 || tree.treeBoxObject.view.isContainer(dragStartRow))
        return;

      var startResource = this.getResourceForRow(tree, dragStartRow);
      var resource, resources = this.getSelectedResources();
      // Do we have any selected rows?
      if (resources == null) {
        // No, and this happens when you start a d&d copy action without first selecting (a) row(s)
        resources = [startResource];
        this.dragResourceList = [startResource];
      }
      else {
        var alreadyAdded = false;
        this.dragResourceList = resources;

        for (rIndex in resources) {
          resource = resources[rIndex];
          if (resource.match(/tabs:root$/))
            return;
          if (startResource == resource) {
            alreadyAdded = true;
            break;
          }
        }
        if (!alreadyAdded)
          return;
          // this.dragResourceList.push(resources[i]);
      }
      var resourceList = "";

      for (i in resources) {
        resource = resources[i];
        resourceList = resourceList.concat((i == 0 || i == resources.length) ? resource : "," + resource);
      }
      aXferData.data = new TransferData();
      aXferData.data.addDataForFlavour("text/x-moz-url", "sm:resources:" + resourceList);
    }
  },

  onDragExit: function(aEvent, aXferData, aDragSession)
  {
    this.dragResourceList = null;
  },

  canDrop: function (aEvent, aDragSession)              {},
  onDragOver: function(aEvent, aXferData, aDragSession) {},
  onDrop: function(aEvent, aXferData, aDragSession)     {},
  getSupportedFlavours: function ()                     {}

};

/***
  * Drag & Drop support for the Session Manager (v1.6.5.0)
  * written by HJ on a rainy, but hot, Saterday afternoon.
  *
  * Notes: I've only tested it with my Mozilla 1.7 build.
  *        Should now also work with Mozilla 1.8 builds!
  */
var sessionTreeBuilderObserver =
{
  DROP_BEFORE : -1, // Components.interfaces.nsITreeView.DROP_BEFORE,
  DROP_ON     : 0,  // Components.interfaces.nsITreeView.DROP_ON,
  DROP_AFTER  : 1,  // Components.interfaces.nsITreeView.DROP_AFTER,

  dragSession     : null,
  dragTarget      : "",
  dragAction      : null,
  dragTargetIndex : -1,

  _init: function()
  {
     /***
       * Preserve backward compatibility with older Mozilla versions/builds
       * FYI: the values in older builds are: 1, 2, and 3
       */
     if ('inDropBefore' in Components.interfaces.nsITreeView) { // Old Mozilla version?
       this.DROP_BEFORE = 0;
       this.DROP_ON     = 1;
       this.DROP_AFTER  = 2;
     }
  },

  _prepareDragAction: function(aResource, aDragAction, aContainerFlag)
  {
     if (aDragAction == "append" && aContainerFlag)
       aResource = aResource.replace(/tab-\w*/, 'root');

     this.dragTarget = aResource;
     this.dragAction = aDragAction;
     return true;
  },

  _isDropOnParentContainer: function(aTargetResource, aOrientation)
  {
    var targetSessionResource = (aTargetResource.match(/root/) == "root") ? aTargetResource : aTargetResource.replace(/tab-\w*/, 'root');
    var sessionContainer = mzRDFCUtils.MakeSeq(mzRDFStore, RDF.GetResource(targetSessionResource));
    var containerItems = sessionContainer.GetCount();

    for (i in sessionManager.dragResourceList) {
      // convert 'urn:session-N:window-N:tabs:tab-N' to 'urn:session-N:window-N:tabs:root'
      var resource = sessionManager.dragResourceList[i].replace(/tab-\w*/, 'root');
      // prevent invalid/unsupported drops
      if (aTargetResource == resource || 
          containerItems == 1 && targetSessionResource == resource && aOrientation != this.DROP_ON)
        return this._prepareDragAction("", null, -1);
    }
    return false;
  },

  _checkContainerIndex: function(aTargetContainerResource)
  {
    var resourceList = mzGetResourcesFromContainer(mzRDFStore, RDF.GetResource(aTargetContainerResource));
    var newTargetResource = aTargetContainerResource.replace(/tabs:root/, 'tabs:tab-');
    // Iterate over the container items
    for (i in resourceList) {
      var resource = resourceList[i];
      var targetResource = newTargetResource + Number(i);
      /***
        * The 'resource' and 'targetResource' should normally be equal, but they will 
        * be different in older versions of MultiZilla when you delete one or more tabs 
        * from session containers, so that is the reason why we need this extra check!
        */
      if (resource != targetResource) {
        sessionManager.dragResourceList = [resource];
        /***
          * We might be called after a tab has been removed!
          * Note that we have to simulate a Drag and Drop (move) action 
          * or onDrop(insert) will fail with a JavaScript error!
          */
        if (this.dragSession == null)
          this.dragSession = {action: Components.interfaces.nsIDragService.DRAGDROP_ACTION_MOVE};

        this.dragAction = "insert";
        this.dragTarget = resource;
        this.onDrop(-1, null); // Emulate drag and drop action
        return -1;
      }
    }
    return true;
  },

  _validateContainer: function(aTargetContainerResource)
  {
    var resourceList = mzGetResourcesFromContainer(mzRDFStore, RDF.GetResource(aTargetContainerResource));
    var resource, currentValue, selectedTab = -1;
    var selectedTabStyle = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");
    var mzRDF = "http://multizilla.mozdev.org/rdf#";
    var name_property = RDF.GetResource(mzRDF + "name");
    var ordinal_property = RDF.GetResource(mzRDF + "ordinal");
    var selected_property = RDF.GetResource(mzRDF + "selected");
    var selectedTabStyle_property = RDF.GetResource(mzRDF + "selectedTabStyle");
    // Get the index of the selected tab
    for (i in resourceList) {
      resource = resourceList[i];
      var data = mzRDFStore.GetTarget(RDF.GetResource(resource), selected_property, true);
      // Is this the selected tab?
      if (data && data.QueryInterface(Components.interfaces.nsIRDFLiteral).Value == "true") {
        selectedTab = i;
        break;
      }
    }
    for (i in resourceList) {
      dump("\nresourceList[i]: " + resourceList[i]);
      resource = RDF.GetResource(resourceList[i]);
      var containerResource = resource.Value.replace(/tab-\w*/, 'root');
      // Check name
      data = mzRDFStore.GetTarget(RDF.GetResource(containerResource), name_property, true);

      if (data == null) {
         mzWriteSessionName(mzRDFStore, containerResource, resource.Value);
         dump("\nAdding missing: name property!");
      }
      // Check ordinal
      data = mzRDFStore.GetTarget(resource, ordinal_property, true);

      if (data) {
        currentValue = data.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        // Is the current 'ordinal' property set right?
        if (currentValue != i) {
          dump("\nReplacing: incorrect ordinal property!");
          mzAddOrChangeValue(mzRDFStore, resource, ordinal_property, RDF.GetLiteral(currentValue), RDF.GetLiteral(i));
        }
      }
      else {
        mzAddOrChangeValue(mzRDFStore, resource, ordinal_property, null, RDF.GetLiteral(i));
        dump("\nAdding missing: ordinal property!");
      }
      // Select the first tab when we don't have one.
      if (i == 0 && selectedTab == -1) {
        selectedTab = 0;
        currentValue = mzRDFStore.GetTarget(resource, selected_property, true);
        mzAddOrChangeValue(mzRDFStore, resource, selected_property, currentValue, RDF.GetLiteral("true"));
        dump("\nAdding missing: selected tab property!");
        currentValue = mzRDFStore.GetTarget(resource, selectedTabStyle_property, true);
        mzAddOrChangeValue(mzRDFStore, resource, selectedTabStyle_property, currentValue, RDF.GetLiteral(selectedTabStyle));
        dump("\nAdding missing: selected tab style property!");
      }
      else {
        data = mzRDFStore.GetTarget(resource, selected_property, true);
        // Is this the selected tab?
        if (i == selectedTab && data) {
          data = mzRDFStore.GetTarget(resource, selectedTabStyle_property, true);

          if (data) {
            currentValue = data.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
            // Does the current value match the users preference?
            if (currentValue != selectedTabStyle) {
              mzAddOrChangeValue(mzRDFStore, resource, selectedTabStyle_property, data, RDF.GetLiteral(selectedTabStyle));
              dump("\nReplacing: incorrect selected tab style property!");
            }
          }
          else {
            mzAddOrChangeValue(mzRDFStore, resource, selectedTabStyle_property, data, RDF.GetLiteral(selectedTabStyle));
            dump("\nReplacing: incorrect selected tab style property!");
          }
        }
        else { // No, not the selected tab
          var data = mzRDFStore.GetTarget(resource, selected_property, true);
          // Remove 'selected' property for all but the selected tab (when available)
          if (data) {
            mzRDFStore.Unassert(resource, selected_property, data);
            dump("\nRemoving: invalid selected tab property!");
          }
          data = mzRDFStore.GetTarget(resource, selectedTabStyle_property, true);
          // Remove 'selectedTabStyle' property for all but the selected tab (when available)
          if (data) {
            mzRDFStore.Unassert(resource, selectedTabStyle_property, data);
            dump("\nRemoving: invalid selected tab style property!");
          }
        }
      }
    }
    mzFlushDataSource(mzRDFStore);
  },

  canDrop: function(aItemIndex, orientation)
  {
    // Prevent drops from other windows
    if (!sessionManager.dragResourceList)
      return false;
    // get target resource i.e. 'urn:session-N:window-N:tabs:root' or 'urn:session-N:window-N:tabs:tab-N'
    var resource = sessionManager.getResourceForRow(tree, aItemIndex); // urn:session-N:window-N:tabs:root

    if (this._isDropOnParentContainer(resource, orientation))
      return false;

    var isSessionContainer = (resource.match(/root/) == "root");

    switch(orientation)
    {
      case this.DROP_BEFORE:
           if (isSessionContainer) {
             if (aItemIndex == 0) // prevent drops before/above the first session container
               break;
           }
           else
             return this._prepareDragAction(resource, "insert", isSessionContainer);
           break;
      case this.DROP_ON:
           if (isSessionContainer)
             return this._prepareDragAction(resource, "append", isSessionContainer);
           break;
      case this.DROP_AFTER:
           var hasNextSibling = tree.treeBoxObject.view.hasNextSibling(aItemIndex, aItemIndex);
           var dragAction = (hasNextSibling) ? "insert" : "append";

           if (hasNextSibling)
             resource = sessionManager.getResourceForRow(tree, aItemIndex + 1);

           if (isSessionContainer)
             return this._prepareDragAction(resource, "insert", isSessionContainer);
           else
             return this._prepareDragAction(resource, dragAction, isSessionContainer);
    }
    this._prepareDragAction("", null, false);
    return false;
  },

  onDrop: function(aRow, orientation)
  {
    var resource = this.dragTarget;
    var targetSessionResource = (resource.indexOf('tab-') > 0) ? resource.replace(/tab-\w*/, 'root') : resource;
    this.dragTarget = (this.dragAction == "append") ? targetSessionResource : resource;
    var resourceList = mzGetResourcesFromContainer(mzRDFStore, targetSessionResource);
    var newTargetResource = targetSessionResource.replace(/tabs:root/, 'tabs:tab-');
    var i, tabDataObject, targetResource, propertyValues, hasSelectedTab, selectedTabStyle = "";
    var targetIndex = mzRDFCUtils.indexOf(mzRDFStore, RDF.GetResource(targetSessionResource), RDF.GetResource(this.dragTarget));
    var sessionsToBeValidated = new Array();
    var draggedItems = 0;

    if (this.dragAction == "append") {
      for (i in sessionManager.dragResourceList) {
        targetTabResource = newTargetResource + (resourceList.length + Number(i));
        resource = sessionManager.dragResourceList[i];
        propertyValues = mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(resource));
        var moveInParentContainer = (targetSessionResource == resource.replace(/tab-\w*/, 'root'));
        selectedTabStyle = (moveInParentContainer && propertyValues[SELECTED_PROPERTY] == "true") ? propertyValues[TABSTYLE_PROPERTY] : "";
        propertyValues[TABSTYLE_PROPERTY] = selectedTabStyle;
        mzAddOrInsertTabToSession(mzRDFStore, targetSessionResource, targetTabResource, 0, propertyValues, selectedTabStyle);

        if (moveInParentContainer)
          mzRemoveTabResourcesFor(mzRDFStore, resource);
        else if (this.dragSession.action & Components.interfaces.nsIDragService.DRAGDROP_ACTION_MOVE)
          mzRemoveTabResourcesFor(mzRDFStore, resource);

        mzFlushDataSource(mzRDFStore);
        draggedItems++;
      }
      // Do we have to remove items from RDF?
      if (draggedItems && (this.dragSession.action & Components.interfaces.nsIDragService.DRAGDROP_ACTION_MOVE)) {
        // Iterate over the dragged items
        for (i in sessionManager.dragResourceList) {
          // Is this item dragged to a different session container?
          if (sessionManager.dragResourceList[i].replace(/tab-\w*/, 'root') != targetSessionResource) {
            mzRemoveTabResourcesFor(mzRDFStore, sessionManager.dragResourceList[i]);
            mzFlushDataSource(mzRDFStore);
          }
        }
      }
      this._checkContainerIndex(targetSessionResource);
    }
    else if (this.dragAction == "insert") { // Also used for moving tabs in a session container!
      // Replace the resource strings with data objects from the corresponding items
      for (rIndex in resourceList) {
        tabDataObject = new Object();
        tabDataObject.resource = resourceList[rIndex];
        tabDataObject.propertyValues = mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(tabDataObject.resource));
        tabDataObject.isnew = false;
        resourceList[rIndex] = tabDataObject;
      }
      // Insert the dragged items into our data object array
      for (i = (sessionManager.dragResourceList.length - 1); i >= 0; i--) {
        tabDataObject = new Object();
        tabDataObject.resource = sessionManager.dragResourceList[i];
        tabDataObject.propertyValues = mzGetTabDataFromResource(mzRDFStore, RDF.GetResource(tabDataObject.resource));
        tabDataObject.isnew = true;
        resourceList.splice((targetIndex-1), 0, tabDataObject); // Arrays start with 0 but index with 1
      }
      sessionManager.dragResourceList = null;
      // Remove all items from target session container
      var sessionsContainerItems = mzGetResourcesFromContainer(mzRDFStore, targetSessionResource);

      for (i in sessionsContainerItems) {
        mzRemoveTabResourcesFor(mzRDFStore, sessionsContainerItems[i], false);
      }
      // Remove dragged items from RDF and resourceList, when needed
      if (this.dragSession.action & Components.interfaces.nsIDragService.DRAGDROP_ACTION_MOVE) {
        for (rIndex in resourceList) {
          // Is this a newly inserted item?
          if (resourceList[rIndex].isnew) {
            resource = resourceList[rIndex].resource;
            // Lookup resource and remove it from RDF and data object array
            for (i in resourceList) {
              if (resourceList[i].isnew)
                continue;
              else if (resource == resourceList[i].resource) {
                resourceList.splice(i, 1);
                break;
              }
            }
            // Remove dragged items from the source session container
            if (resource.indexOf(newTargetResource) < 0) {
              mzRemoveTabResourcesFor(mzRDFStore, resource, false);
              // Did we remove the selected tab?
              if (resourceList[rIndex].propertyValues[SELECTED_PROPERTY] == "true")
                sessionsToBeValidated.push(resource.replace(/tab-\w*/, 'root'));
            }
          }
        }
      }
      // We might have dragged the selected tab out of a session 
      for (i in sessionsToBeValidated) {
        this._validateContainer(sessionsToBeValidated[i]);
      }
      /***
        * Do we (still) have a selected tab in the target session container? 
        * Note that there won't be one when your drag it to another session!
        */
      for (i in resourceList) {
        if (resourceList[i].propertyValues[SELECTED_PROPERTY] == "true") {
          hasSelectedTab = true;
          break;
        }
      }
      // Select the first tab when we didn't have one
      if (!hasSelectedTab) {
        selectedTabStyle = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");
        resourceList[0].propertyValues[TABSTYLE_PROPERTY] = selectedTabStyle;
        resourceList[0].propertyValues[SELECTED_PROPERTY] = "true";
        selectedTabStyle = "";
      }
      // Append all items from data object array
      for (i = 0; i < resourceList.length; i++) {
        targetResource = newTargetResource + i;
        propertyValues = resourceList[i].propertyValues;
        // Make sure we only have one selected tab, with optional tab styling
        if (selectedTabStyle == "" && propertyValues[SELECTED_PROPERTY] == "true")
          selectedTabStyle = propertyValues[TABSTYLE_PROPERTY];
        else {
          propertyValues[TABSTYLE_PROPERTY] = "";
          propertyValues[SELECTED_PROPERTY] = "false";
        }
        mzAddOrInsertTabToSession(mzRDFStore, targetSessionResource, targetResource, 0, propertyValues, selectedTabStyle);
        mzFlushDataSource(mzRDFStore);
      }
    }
    tree.builder.rebuild();
    sessionManager.dragResourceList = null;
    this.dragSession = null;
  },
  // Backward compatibility with older Mozilla versions/builds
  canDropOn: function(aRow)
  {
    var orientation = this.DROP_ON;
    return this.canDrop(aRow, orientation);
  },
  // Backward compatibility with older Mozilla versions/builds
  canDropBeforeAfter: function(aRow, before)
  {
    var orientation = (before) ? this.DROP_BEFORE : this.DROP_AFTER;
    return this.canDrop(aRow, orientation);
  },

  onToggleOpenState    : function (aRow)                           {},
  onCycleHeader        : function (aColumnID, aHeaderElement)      {},
  onSelectionChanged   : function ()                               {},
  onCycleCell          : function (aItemIndex, aColumnID)          {},
  isEditable           : function (aItemIndex, aColumnID)          {},
  onSetCellText        : function (aItemIndex, aColumnID, aValue)  {},
  onPerformAction      : function (aAction)                        {},
  onPerformActionOnRow : function (aAction, aItemIndex)            {},
  onPerformActionOnCell: function (aAction, aItemIndex, aColumnID) {}
}

function reFocus(aPreviousFrame)
{
  updateToolbarButtons();
  // tree.focus();
}

function shutdown()
{
  tree.builder.removeObserver(sessionTreeBuilderObserver);
}

function onCancel(aEvent)
{
  return true;
}
  
function onAccept(aEvent)
{
  sessionManager.loadTabsOrSession(false, false, false);
  return true;
}

function onPageShow()
{
  sessionManager.initSessionManager();
}

addEventListener("pageshow", onPageShow, true);
// addEventListener("load", sessionManager.initSessionManager, false);
