/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2008 by HJ van Rantwijk.  All Rights Reserved.
  */

const TAB_BUTTON        = 0;
const WINDOW_BUTTON     = 1;
const SESSION_BUTTON    = 2;
const INTERVAL_BUTTON   = 3;
const PROPERTIES_BUTTON = 4;
const CLOSE_BUTTON      = 5;
const QPREFS_BUTTON     = 6;

const CM_SELECT_ALL  = 0;
const CM_SELECT_NONE = 1;
const CM_INTERVAL    = 2;

const NO_ROWS_AVAILABLE      = -1;
const NO_ROWS_SELECTED       = 0;
const SINGLE_ROW_SELECTED    = 1;
const MULTIPLE_ROWS_SELECTED = 2;
const ROW_IS_CONTAINER       = 4;
const MIXED_ROWS_SELECTED    = 8;

const gWindowManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
                                 .getService(Components.interfaces.nsIWindowMediator);
const nsIWindowDataSource = Components.interfaces.nsIWindowDataSource;
const gWindowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator']
                                   .getService(nsIWindowDataSource);
const gObserverService = Components.classes['@mozilla.org/observer-service;1']
                                   .getService(Components.interfaces.nsIObserverService);
const gPromptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                 .getService(Components.interfaces.nsIPromptService);

// Triggered by 'DOMAttrModified' in the tab binding in multiviews.xml
const gTabSelectedStateObserver = 
{
  observe: function(aTab, aSubject, aResourceString) {
    if (aTab.selected) {
      mzAddOrChangeStyleProperty(dataSource, aResourceString, gSelectedTabStyle);
      updateSelectedTab(aResourceString);
    }
    else {
      var property = RDF.GetResource("http://multizilla.mozdev.org/rdf#selectedTabStyle");

      try {
        var data = dataSource.GetTarget(RDF.GetResource(aResourceString), property, true);

        if (data)
          dataSource.Unassert(RDF.GetResource(aResourceString), property, data);
      } catch(ex) {
        // dump("\ngTabSelectedStateObserver - ex: " + ex);
      }
    }
  }
}  

// tab.handler.DOMAttrModified (multiviews.xml) -> gTabUpdateObserver
const gTabUpdateObserver = 
{
  observe: function(aNode, aTopic, aDataArray)
  {
    // dump("\n\ngTabUpdateObserver - aDataArray: " + aDataArray);
    aDataArray = aDataArray.split(',');
    var setAttribute;
    var attrName = aDataArray[0];
    // dump("\nattrName: " + attrName);
    var resourceString = aDataArray[1];
    // dump("\nresourceString: " + resourceString);
    var tabBrowser, tab, targetWindowResource;

    switch(attrName)
    {
      case "movingTab": // triggere by method 'moveTabTo' in tabbrowser.xml
      case "linkedpanel": // 'linkedpanel,urn:window-n:tabs:tab-n'
           targetWindowResource = resourceString.replace(/:tabs:tab-\w*/, ":tabs:root");
           tabBrowser = (aNode.localName == "tabbrowser") ? aNode : aNode.parentNode.parentNode.parentNode.parentNode;

           if (gWindowResources.indexOf(targetWindowResource) == -1)
             gWindowResources.push(targetWindowResource);

           mzStoreGroupData(dataSource, targetWindowResource, tabBrowser, true, false, gSelectedTabStyle, false);
           setAttribute = false;
           updateSelectedTab(resourceString);
           break;
      case "removeTab": // triggered by method 'removeTab' in tabbrowser.xml
           mzRemoveTabResourcesFor(dataSource, resourceString, false);

           targetWindowResource = resourceString.replace(/:tabs:tab-\w*/, ":tabs:root");
           // dump("\nremoveTab - targetWindowResource: " + targetWindowResource);
           tabBrowser = aNode;
           mzStoreGroupData(dataSource, targetWindowResource, tabBrowser, true, false, gSelectedTabStyle, false);
           setAttribute = false;
           updateSelectedTab();
           break;
      case "autoreload":
           tab = aNode;
           attrValue = tab.mReloadInterval;
           attrName = "interval";
           setAttribute = (attrValue > 0);
           break;
      case "busy":
      case "image":
      case "label":
           tab = aNode;
           attrValue = tab.getAttribute(attrName);
           setAttribute = tab.hasAttribute(attrName);
    }
    if (setAttribute != undefined) {
      var property = RDF.GetResource("http://multizilla.mozdev.org/rdf#" + attrName);

      try {
        var data = dataSource.GetTarget(RDF.GetResource(resourceString), property, true);

        if (setAttribute) {
          // dump("\nsetAttribute: " + attrName + " - value: " + attrValue);
          mzAddOrChangeProperty(dataSource, resourceString, attrName, attrValue);
        }
        else if (!setAttribute) {
          // dump("\nremoveAttribute: " + aDataArray[0]);
          if (data)
            dataSource.Unassert(RDF.GetResource(resourceString), property, data);
        }
      } catch(ex) {
        // dump("\ngTabUpdateObserver - ex: " + ex);
      }          
    }
  }
};

/***
  * This listener is where all the magic happens ;)
  * See also: nsIWindowMediatorListener.idl
  */
var gStageChecking = null; // for test purpose only!

const gWindowManagerListener = 
{
  onOpenWindow: function(aXULWindow)
  {
    dump("\n\ngWindowManagerListener - onOpenWindow " + aXULWindow);
    setTimeout(delayedOpenWindow, 0, aXULWindow);
  },

  onCloseWindow: function(aXULWindow)
  {
    dump("\n\ngWindowManagerListener - onCloseWindow: " + aXULWindow);
    /* var rows = tree.treeBoxObject.view.rowCount;
    tree.view.selection.clearSelection();
    tree.currentIndex = -1;

    for (var row = 0; row < rows; row++) {
      if (tree.treeBoxObject.view.isContainer(row)) {
        var resource = tabManager.getResourceForRow(row);
        var windowID = resource.replace(/urn:/, '').replace(/:tabs:root/, '');
        var targetWindow = gWindowManagerDS.getWindowForResource(windowID);

        if (targetWindow == null || isBrowserWindow(targetWindow) == false) {
          var targetIndex = gWindowResources.indexOf(resource);
          gWindowResources.splice(targetIndex, 1);
          // dump("\nmzRemoveAllResourcesFor: " + resource);
          mzRemoveAllResourcesFor(dataSource, resource); // remove window from tree
          rows = tree.treeBoxObject.view.rowCount;
        }
      }
    }
    setWindowTitles(targetIndex); */
  },

  onWindowTitleChange: function(aXULWindow, aWindowTitle)
  {
    dump("\n\ngWindowManagerListener - onWindowTitleChange: " + aWindowTitle);
    setTimeout(delayedTitleChange, 0, aXULWindow, aWindowTitle);
  }
}

function delayedOpenWindow(aXULWindow)
{
    var openDataArray = getOpenWindowDataArray();

    for (i in openDataArray) {
      dump("\nopenDataArray[" + i + "].windowID    : " + openDataArray[i].windowID);
      dump("\nopenDataArray[" + i + "].windowNumber: " + openDataArray[i].windowNumber);
      // dump("\nopenDataArray[" + i + "].windowType  : " + openDataArray[i].windowType);
      dump("\nopenDataArray[" + i + "].windowTitle : " + openDataArray[i].windowTitle);
    }
  
}

function delayedTitleChange(aXULWindow, aWindowTitle)
{
    var chromeWindow = getChromeWindowFromXULWindow(aXULWindow);
 
    if (isBrowserWindow(chromeWindow)) {
      dump("\nonWindowTitleChange - isBrowserWindow: " + chromeWindow);
      var windowID = mzGetWindowResourceID(chromeWindow);
      dump("\nwindowID: " + windowID);
      var targetResource = "urn:" + windowID + ":tabs:root";
      dump("\ntargetResource: " + targetResource);
      dump("\ngWindowResources: " + gWindowResources);
      // urn:window-0:tabs:root,urn:window-window-3:tabs:root,urn:window-3:tabs:root

      if (gWindowResources.indexOf(targetResource) == -1) {
        dump("\nIF");
        dump("\nAdding new targetResource: " + targetResource);
        var browser = chromeWindow.getBrowser();
        gWindowResources.push(targetResource);
        gObserverService.notifyObservers(window.document.documentElement, "MZManagers", "start");
        mzStoreGroupData(dataSource, targetResource, browser, true, false, gSelectedTabStyle, false);
      }
      else {
        dump("\nELSE");
        // function delayedInner() {
          dump("\nonWindowTitleChange - else: " + chromeWindow);
          // var windowNumber = mzGetIndexNumberForWindow(chromeWindow);
          var windowNumber = mzGetWindowXULWindowIndex(aXULWindow);
          var windowTitle = "[ " + windowNumber + " ] " + aWindowTitle;
          mzWriteSessionName(dataSource, targetResource, windowTitle);
        // }
        // setTimeout(delayedInner, 0);
      }
      mzFlushDataSource(dataSource);
    }
  // }
}

var gManager;
var gPreferences;

var pref = null; // declared in navigator.js but out of reach for us!
var tree = null;
var dataSource = null;
// var resourcePrefix = "http://multizilla.mozdev.org/rdf#"; // this one doesn't seem to be used anymore!

/***
  * Toolbar button ID arrays that will be replaced with elements in updateToolbarButtons()
  * note: keep the order in-line with the corresponding XUL code!
  */
var toolbarButtons = [ "tabButton", "windowButton", "sessionButton", "reloadButton", "propertiesButton", "deleteButton", "prefsButton" ];
/***
  * Context Menu ID array that will be replaced with elements in initContextMenu(aEvent)
  * note: we have to keep the order in-line with the corresponding XUL code!
  */
var contextMenuItems = [ "doCmd_SelectAll", "doCmd_UndoSelection", "SetInterval" ];
/***
  * Toolbar button arrays, to ease the pain of enabling/disabling the buttons
  */
var defaultEnabledButtons      = [  true,  true, false, false, false, false, true ];
var selectionEnabledButtons    = [  true,  true, false,  true,  true,  true, true ];
var multipleRowsEnabledButtons = [ false,  true, false, false, false,  true, true ];

var busyTabs = -1;
var gResource = "";
var gTabbrowser = null;
var gWindowResources = new Array();
var gUseStackedWindows = false;
var gLastTabOrdinal = -1;
var gToolbarButtonState = null;
/***
  * Keep this in sync with gSelectedTabStyle in settingsFrame.js
  */
var gSelectedTabStyle = "bold"; // "none", "italic", "bold", "italic-and-bold", "red", "italic-and-red"

var gLastActiveWindowID = null;
var gLastSelectedResource = null;
var gSessionSaving = -1;
var gRunAsSidebar = false;

function showInfo()
{
  var windowObj = getOpenWindowDataArray()
  var data = "";

  for (i in windowObj) {
    data += "window[" + i + "].windowID [" + windowObj[i].windowID + "].windowNumber[" + + windowObj[i].windowNumber + "]\n";
  }
  alert(data);
}

function initFrame()
{
  gManager = window.top;
  gManager.selectWindowStyling(document.documentElement);
  var navigatorWindow = gManager.getNavigatorWindow(true);
  gPreferences = navigatorWindow.gMultiZilla.prefs;
  // dump("\ntime-end  : " + new Date().valueOf());
}

function updateSelectedTab(aResourceString)
{
  if (aResourceString == undefined) {
    var navigatorWindow = Components.classes['@mozilla.org/appshell/window-mediator;1']
                                    .getService(Components.interfaces.nsIWindowMediator)
                                    .getMostRecentWindow("navigator:browser");
    var windowID = mzGetWindowResourceID(navigatorWindow);
    var tabBrowser = navigatorWindow.getBrowser();
    aResourceString = "urn:" + windowID + ":tabs:tab-" + tabBrowser.getTabIndex(tabBrowser.selectedTab);
  }
  // dump("\nupdateSelectedTab - aResourceString: " + aResourceString);
  var newActiveTabRow = tabManager.getRowForResource(aResourceString);
  // dump("\nupdateSelectedTab - newActiveTabRow: " + newActiveTabRow);
  tree.view.selection.select(newActiveTabRow);
  tree.treeBoxObject.ensureRowIsVisible(newActiveTabRow);
}

function updateToolbarButtons()
{
  if (gRunAsSidebar)
    return;
  // Is the toolbar button array initialized?
  if (typeof toolbarButtons[0] == 'string') {
    // Nope, not yet, initialize array now
    for (i in toolbarButtons) {
      toolbarButtons[i] = document.getElementById(toolbarButtons[i]);
    }
  }
  var buttons = defaultEnabledButtons;
  var treeState = tabManager.getCurrentTreeState();
  var propertyTooltipType = "item";

  if (treeState > NO_ROWS_SELECTED) {
    if (treeState & SINGLE_ROW_SELECTED) {
      buttons = selectionEnabledButtons;
    }
    else if (treeState == MULTIPLE_ROWS_SELECTED)
      buttons = multipleRowsEnabledButtons;
  }
  // Enable/disable the toolbar buttons based on the toolbar array
  for (i in toolbarButtons) {
    toolbarButtons[i].disabled = !buttons[i];
  }
  if (treeState & SINGLE_ROW_SELECTED)
    propertyTooltipType = (treeState & ROW_IS_CONTAINER) ? "window" : "tab";

  var propertyButtonTooltipID = propertyTooltipType + "PropertiesButton.tooltiptext";
  var propertyButtonTooltip = gTabManagerStringBundle.getString(propertyButtonTooltipID);
  toolbarButtons[4].setAttribute("tooltiptext", propertyButtonTooltip);
  // Additional checks to disable one or more toolbar buttons
  var isLastBrowserWindow = (mzGetNumberOfWindowsByType("navigator:browser") == 1);
  var disabled = ((treeState == NO_ROWS_SELECTED && !isLastBrowserWindow) ||
                  treeState & MULTIPLE_ROWS_SELECTED);
  toolbarButtons[TAB_BUTTON].disabled = disabled;
  toolbarButtons[SESSION_BUTTON].disabled = (treeState == NO_ROWS_SELECTED ||
                                            (treeState == SINGLE_ROW_SELECTED && !(treeState & ROW_IS_CONTAINER)) ||
                                            (treeState == MULTIPLE_ROWS_SELECTED && !(treeState & ROW_IS_CONTAINER)));
  var columnID = "tm-location";
  columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
  var location = (tree.currentIndex != -1) ? tree.view.getCellText(tree.currentIndex, columnID) : "";
  disabled = (treeState != SINGLE_ROW_SELECTED || (treeState & ROW_IS_CONTAINER));
  toolbarButtons[INTERVAL_BUTTON].disabled = (disabled || location == "");
  toolbarButtons[PROPERTIES_BUTTON].disabled = disabled;
  toolbarButtons[CLOSE_BUTTON].disabled = (treeState == NO_ROWS_SELECTED || (treeState & ROW_IS_CONTAINER && isLastBrowserWindow));
}

function initContextMenu(aEvent)
{
  // Is the context menu item array initialized?
  if (typeof contextMenuItems[0] == 'string') {
    // Nope, not yet, initialize array now
    for (i in contextMenuItems) {
      contextMenuItems[i] = document.getElementById(contextMenuItems[i]);
    }
  }
  for (i in contextMenuItems) {
    contextMenuItems[i].setAttribute('disabled', 'true');
  }
  var treeState = tabManager.getCurrentTreeState();

  if (treeState == NO_ROWS_AVAILABLE)
    return;

  var treeRows = tree.treeBoxObject.view.rowCount;

  if (treeState == MULTIPLE_ROWS_SELECTED) {
    contextMenuItems[CM_SELECT_ALL].setAttribute('disabled', 'true');
    contextMenuItems[CM_SELECT_NONE].removeAttribute('disabled');
  }
  else { // NO_ROWS_SELECTED || SINGLE_ROW_SELECTED
    if (treeRows > 1)
      contextMenuItems[CM_SELECT_ALL].removeAttribute('disabled');
    contextMenuItems[CM_SELECT_NONE].setAttribute('disabled', 'true');
  }
  var columnID = "tm-location";
  columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
  var location = (tree.currentIndex != -1) ? tree.view.getCellText(tree.currentIndex, columnID) : "";
  var disabled = (treeState != SINGLE_ROW_SELECTED || (treeState & ROW_IS_CONTAINER) || location == "");

  if (!disabled)
    contextMenuItems[CM_INTERVAL].removeAttribute('disabled');
}

function activatePropertiesFrame()
{
  if (tree.currentIndex > -1)
    gManager.switchPage("propertiesFrame");
}

function activateSettingsFrame()
{
  gManager.switchPage("settingsFrame");
}

function initTreeTooltip(aEvent)
{
  var node = document.tooltipNode;
  var nodeName = node.localName;
  var tooltipNode = aEvent.target;

  if (nodeName == 'tree' || nodeName.match('menu') || nodeName == 'treecol') {
    aEvent.preventDefault();
    return;
  }
  tooltipNode.firstChild.hidden = (nodeName != 'treecols');
  tooltipNode.childNodes[1].hidden = (nodeName != 'splitter');
  tooltipNode.lastChild.hidden = (nodeName != 'treechildren');
}

function getOpenWindowDataArray()
{
  // dump("\ngetOpenWindowDataArray");
  var openWindowDataArray = new Array();
  var tree = document.getElementById("OpenWindowTree");

  for (var row = 0; row < tree.treeBoxObject.view.rowCount; row++) {
    try {
      var treeItem = tree.builderView.getItemAtIndex(row);

      if (treeItem) {
        var win = windowManagerDS.getWindowForResource(treeItem.id);

        if (win && win.document.documentElement.getAttribute("windowtype") == "navigator:browser") {
          dump("\nrow: " + row);
          var obj = new Object();
          obj.windowID = treeItem.id;
          var columnID = "KeyIndex";
          columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
          obj.windowNumber = tree.view.getCellText(row, columnID);
          columnID = "WindowTitle";
          columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
          obj.windowTitle = tree.view.getCellText(row, columnID);
          openWindowDataArray.push(obj);
        }
      }
    } catch (ex) {
      // dump("\ngetOpenWindowDataArray: " + ex);
    }
  }
  return(openWindowDataArray);
}

/* function sanatizeTree(aXULWindow)
{
  if (isBrowserWindow(aXULWindow)) {
    var rows = tree.treeBoxObject.view.rowCount;
    tree.view.selection.clearSelection();
    tree.currentIndex = -1;

    for (var row = 0; row < rows; row++) {
      if (tree.treeBoxObject.view.isContainer(row)) {
        var resource = tabManager.getResourceForRow(row);
        var windowID = resource.replace(/urn:/, '').replace(/:tabs:root/, '');
        var targetWindow = gWindowManagerDS.getWindowForResource(windowID);

        if (targetWindow == null || isBrowserWindow(targetWindow) == false) {
          var targetIndex = gWindowResources.indexOf(resource);
          gWindowResources.splice(targetIndex, 1);
          mzRemoveAllResourcesFor(dataSource, resource); // remove window from tree
          rows = tree.treeBoxObject.view.rowCount;
        }
      }
    }
  }
} */

function setWindowTitles(aStartIndex)
{
  // dump("\n\nsetWindowTitles: " + aStartIndex);
  if (aStartIndex == undefined) {
    // dump("\nsetWindowTitles - invalid value: " + aStartIndex);
    return;
  }
  var openDataArray = getOpenWindowDataArray();
  var i = (aStartIndex == undefined) ? 0 : aStartIndex;

  for (i; i < gWindowResources.length; i++) {
    var windowTitle = "[ " + openDataArray[i].windowNumber + " ] " + openDataArray[i].windowTitle;
    mzWriteSessionName(dataSource, gWindowResources[i], windowTitle);
  }
}

function getChromeWindowFromXULWindow(aXULWindow)
{
  // dump("\naXULWindow: " + aXULWindow)
  dump("\naXULWindow.XULBrowserWindow: " + aXULWindow.XULBrowserWindow);
  var chromeWindow = null;

  if (aXULWindow instanceof Components.interfaces.nsIXULWindow) {
    try {
      var docShell = aXULWindow.docShell;

      if (docShell) {
        var requestor = docShell.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
        chromeWindow = requestor.getInterface(Components.interfaces.nsIDOMWindow);
      }
    } catch(ex) {
      throw("ex(TM:getChromeWindowFromXULWindow): " + ex);
    }
  }
  return chromeWindow;
}

function isBrowserWindow(aWindow)
{
  dump("\nisBrowserWindow: " + aWindow);
  try {
    var chromeWindow = (aWindow instanceof ChromeWindow) ? aWindow : getChromeWindowFromXULWindow(aWindow);

    if (chromeWindow && (chromeWindow.document.documentElement.getAttribute('windowtype') == 'navigator:browser'))
      return true;
  } catch(ex) {
    throw("ex(TM:isBrowserWindow): " + ex);
  }
  return false;
}

function getXULWindowResourceID(aXULWindow)
{
  var retValue = -1;
  var chromeWindow = getChromeWindowFromXULWindow(aXULWindow);

  if (chromeWindow && isBrowserWindow(chromeWindow))
    retValue = mzGetWindowResourceID(chromeWindow);

  return retValue;
}

function areAllTabsBlank(aTabbrowser)
{
  var numberOfTabs = aTabbrowser.mTabContainer.childNodes.length;
  var numberOfBlankTabs = mzGetNumberOfBlankTabs(aTabbrowser);

  return (numberOfTabs == numberOfBlankTabs);
}

// multiviewsRDF.js needs this function!
function mzGetNumberOfBlankTabs(aTabBrowser)
{
  var blankTabs = 0;
  var tabs = aTabBrowser.mTabs;

  for (var i = 0; i < tabs.length; i++) {
    var tab = tabs[i];
    var browser = tab.linkedBrowser;

    if (tab.hasAttribute("busy")) {
      if (tab.getAttribute("firstPage") == "about:blank")
        blankTabs++;
    }
    else if (browser.currentURI.spec == "about:blank")
      blankTabs++;
  }
  return blankTabs;
}

///////////////////////////////////////////////////////////////////////////////
// This function is copied over from multiviewsInit.js because it is not 
// available from multiviewsRDF.js (read 'it is not included').
////////////////////////////////////////////////////////////////////////////////
function mzGetNumberOfWindowsByType(aType)
{
  var defaultType = "navigator:browser";

  if (!aType) // default check for browser window
    aType = defaultType;

  var windowCounter = 0;
  var enumerator = gWindowManager.getEnumerator(aType);

  while (enumerator.hasMoreElements()) {
    var aWindow = enumerator.getNext();
    windowCounter++;
  }
  return windowCounter;
}

function initReloadPopup(document, aPopup, aEvent)
{
  if (toolbarButtons[3].disabled) {
    aEvent.preventDefault();
    return;
  }
  var tabBrowser = gManager.getTabbrowser(true);
  tabBrowser.initReloadPopup(document, aPopup, null, tabManager.getReloadInterval());
}


var tabManager = 
{
  tree: null,
  currentRow: null,
  windowManagerDS: null,
  reloadInterval: 0,
  gStringBundle: null,
  gTabManagerStringBundle: null,

  initTabManager: function()
  {
    if (gManager.document.documentElement.getAttribute("id") == "tabManager-sidebar")
      gRunAsSidebar = true;

    windowManagerDS = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService(nsIWindowDataSource);
    dataSource = Components.classes['@mozilla.org/rdf/datasource;1?name=in-memory-datasource'].createInstance(Components.interfaces.nsIRDFDataSource);
    tree = document.getElementById('TabManagerTree');
    tree.database.AddDataSource(dataSource);

    gTabbrowser = gManager.getTabbrowser(true);
    currentRow = -1;
    reloadInterval = 0;
    gStringBundle = gManager.document.getElementById("properties");
    gTabManagerStringBundle = gManager.document.getElementById("tabManagerProperties");
    gSelectedTabStyle = gPreferences.readString("multizilla.tab-manager.selectedtab-styling", "bold");

    tabManager.buildTree();
    updateSelectedTab();
    sizeToContent();
    updateToolbarButtons();

    gObserverService.notifyObservers(window.document.documentElement, "MZManagers", "start");
    gObserverService.addObserver(gTabSelectedStateObserver, "selectedTabState", false);
    gObserverService.addObserver(gTabUpdateObserver, "tabUpdate", false);
    gWindowManager.addListener(gWindowManagerListener);
  },

  buildTree: function()
  {
    var windowResources = mzGetWindowResourceIDList(true);

    if (windowResources) {
      var sessionID = 0;

      for (i in windowResources) {
        var windowID = windowResources[i];
        var browserWindow = windowManagerDS.getWindowForResource(windowID);
        var tabbrowser = browserWindow.getBrowser();
        var resource = "urn:" + windowID + ":tabs:root";
        gWindowResources.push(resource);
        // dump("\nAdding initial resources: " + resource);
        mzStoreGroupData(dataSource, resource, tabbrowser, true, false, gSelectedTabStyle, false);
      }
      setWindowTitles(0); // 0 is index aka first window
    }
  },

  refreshTree: function()
  {
    // dump("\nrefreshTree: " + gWindowResources);
    for (i in gWindowResources) {
      var resource = gWindowResources[i];
      var windowID = resource.replace(/urn:/, '').replace(/:tabs:root/, '');
      // dump("\nwindowID: " + windowID);
      var browserWindow = windowManagerDS.getWindowForResource(windowID);

      if (browserWindow) {
        var tabbrowser = browserWindow.getBrowser();
        mzStoreGroupData(dataSource, resource, tabbrowser, true, false, gSelectedTabStyle, false);
      }
    }
    // Re-enable the toolbar buttons
    if (gToolbarButtonState) {
      for (i in toolbarButtons) {
        toolbarButtons[i].disabled = gToolbarButtonState[i];
      }
    }
    gToolbarButtonState = null;
  },

  disableToolbarButtons: function()
  {
    gToolbarButtonState = new Array();

    for (i in toolbarButtons) {
      gToolbarButtonState[i] = toolbarButtons[i].disabled;
	  toolbarButtons[i].disabled = true;
    }
  },

  click: function(aEvent)
  {
    currentRow = this.getRowNumber(aEvent);

    if (currentRow == -1)
      return;
    reloadInterval = this.getReloadInterval(aEvent);
  },

  getRowNumber: function(aEvent)
  {
    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    return tree.treeBoxObject.getRowAt(X, Y);
  },

  getResourceForRow: function(aRowNumber)
  {
    return (aRowNumber > -1) ? tree.builderView.getResourceAtIndex(aRowNumber).Value : null;
  },

  getRowForResource: function(aResourceString)
  {
    var rowCount = tree.treeBoxObject.view.rowCount;

    for (var row = 0; row < rowCount; row++) {
      if (tree.builderView.getResourceAtIndex(row).Value == aResourceString)
        return row;
    }
    return -1;
  },

  getSelectedResources: function()
  {
    var resources = new Array();
    var rows = this.getSelectedRows();

    for (i in rows) {
      resources[i] = { row: rows[i], 
                       resource: this.getResourceForRow(rows[i])
                     };
    }
    if (resources)
      return resources;
    return null;
  },

  getSelectedRows: function()
  {
    var rows = -1;
    var selectedRows = new Array();
    // Get and return all selection ranges
    var rangeCount = tree.builderView.selection.getRangeCount();
    // Iterate over all ranges to collect the selected rows
    for (var range = 0; range < rangeCount; range++) {
      var startSelection = {};
      var endSelection = {};
      tree.builderView.selection.getRangeAt(range, startSelection, endSelection);
      // Collect all rows and store them in our array
      for (var row = startSelection.value; row <= endSelection.value; row++) {
        // Check for invalid row numbers
        if (startSelection.value != -1 || endSelection.value != -1)
          selectedRows[++rows] = row;
      }
    }
    if (selectedRows)
      return selectedRows;
    return null;
  },

  getCurrentTreeState: function()
  {
    if (tree.treeBoxObject.view.rowCount < 1)
      return NO_ROWS_AVAILABLE;

    var selectedRows = this.getSelectedRows();

    if (selectedRows.length > 1) {
      if (this.isMixedSelection())
        return (MULTIPLE_ROWS_SELECTED + MIXED_ROWS_SELECTED);
	  else if (tree.treeBoxObject.view.isContainer(Number(selectedRows[0])))
        return (MULTIPLE_ROWS_SELECTED + ROW_IS_CONTAINER);
      return MULTIPLE_ROWS_SELECTED;
    }
    else if (selectedRows.length == 1) {
      if (tree.treeBoxObject.view.isContainer(Number(selectedRows[0])))
        return (SINGLE_ROW_SELECTED + ROW_IS_CONTAINER);
      return SINGLE_ROW_SELECTED;
    }
    return NO_ROWS_SELECTED;
  },

  getRowSource: function(row, inout)
  {
    var isContainerRow = false;
    var resource = this.getResourceForRow(row);
    var windowID = resource.replace(/urn:/, '');
    var tabIndex = windowID.replace(/window-\w*:tabs:tab-/, '');

	if (tree.treeBoxObject.view.isContainer(row)) {
      windowID = windowID.replace(/:tabs:\w*/, '');
      isContainerRow = true;
    }
    else
      windowID = windowID.replace(/:tabs:tab-\w*/, '');

    var browserWindow = windowManagerDS.getWindowForResource(windowID);
    var tabBrowser = browserWindow.getBrowser();
    var tab = (isContainerRow) ? null : tabBrowser.mTabs[tabIndex];

    inout.window = browserWindow;
    inout.windowID = windowID;
    inout.resource = resource;
    inout.tabbrowser = tabBrowser;
    inout.tab = (isContainerRow) ? null : tab;
    inout.browser = (isContainerRow) ? null : tab.linkedBrowser;
  },

  getReloadInterval: function(aEvent)
  {
    var interval = 0;
    var columnID = "tm-interval";
    columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;

    if (aEvent) {
      var row = this.getRowNumber(aEvent);
      interval = (row > -1) ? tree.view.getCellText(row, columnID) : 0;
    }
    else if (!aEvent && tree.currentIndex != -1)
      interval = tree.view.getCellText(tree.currentIndex, columnID);

    if (interval)
      return interval;
    return 1;
  },

  setReloadInterval: function(aEvent, aValue)
  {
    var resource = this.getResourceForRow(currentRow);
    var intervalProp = RDF.GetResource("http://multizilla.mozdev.org/rdf#interval");
    var currentValue = dataSource.GetTarget(RDF.GetResource(resource), intervalProp, true);

    if (aValue == 0) // Remove interval property from tree
      dataSource.Unassert(RDF.GetResource(resource), intervalProp, currentValue);
    else
      mzAddOrChangeValue(dataSource, RDF.GetResource(resource), intervalProp, currentValue, RDF.GetLiteral(aValue));

    mzFlushDataSource(dataSource);
    this.updateTab("interval", aValue);
  },

  isMixedSelection: function()
  {
    var tabs = 0;
    var windows = 0;
    var mixed = false;

    // Collect selected tree rows
    var selectedItems = this.getSelectedRows();
    // Do we have any selected items?
    if (selectedItems && selectedItems.length > 0) {
      // Iterate over the seleted items
      for (var row = 0; row < selectedItems.length; row++) {
        if (tree.treeBoxObject.view.isContainer(selectedItems[row]))
          windows++;
        else
          tabs++;
        // Do we have a mixed selection?
        if (tabs > 0 && windows > 0) {
          mixed = true;
          break;
        }
      }
    }
    return mixed;
  },

  removeWindowItemsFromSelection: function()
  {
    // Collect selected tree rows
    var selectedRows = this.getSelectedRows();
    // Do we have any selected items?
    if (selectedRows) {
      // Iterate over the selected items to clear the 'window' (container) items
      for (row in selectedRows) {
        if (tree.treeBoxObject.view.isContainer(row))
          tree.view.selection.clearRange(row, row);
      }
    }
  },

  selectRows: function(aCommand)
  {
    switch (aCommand) {
      case "all": // Called from the context menu, or Ctrl+A ?
           tree.view.selection.selectAll();
           this.removeWindowItemsFromSelection();
           break;
      case "none": // Called from the context menu, or Ctrl+Z ?
           tree.view.selection.clearSelection();
           // dump("\ntree.currentIndex: " + tree.currentIndex);
           tree.view.selection.select(tree.currentIndex);
           tree.treeBoxObject.ensureRowIsVisible(tree.currentIndex);
           break;
    }
    tree.focus();
  },

  activateSelectedTab: function(row)
  {
    var obj = new Object();
    this.getRowSource(row, obj);

    /* if (obj.resource != gLastSelectedResource)
    { */
      // dump("\nactivateSelectedTab for: " + obj.resource);
      if (obj.resource.indexOf("root") != -1) {
        if (obj.windowID != gLastActiveWindowID) {
          // dump("\nselecting window-1");
          obj.window.focus();
          window.focus();
        }
      }
      else {
        if (obj.windowID != gLastActiveWindowID) {
          // dump("\nselecting window-2");
          obj.window.focus();
          window.focus();
        }
        if (obj.tabbrowser.selectedTab != obj.tab) {
          dump("\nselecting tab!");
          obj.tabbrowser.selectedTab = obj.tab;
        }
      }
    // }
    gLastActiveWindowID = obj.windowID;
    gLastSelectedResource = obj.resource;
    // this.refreshAfterCommand();
  },

  add: function(openType)
  {
    this.disableToolbarButtons(); // Prevent race actions.

    if (openType == 'window') {
      window.open();
    }
    else {
      var newTab = null; 
      var loadInBackground = gPreferences.readBoolean("browser.tabs.loadInBackground", true);
      // dump("\ntabManager.add - loadInBackground: " + loadInBackground);
      var treeState = this.getCurrentTreeState();

      if (treeState == NO_ROWS_SELECTED) {
        if (openType == 'tab') {
          var tabbrowser = gManager.getTabbrowser(true);
          newTab = tabbrowser.addTab();

          if (!loadInBackground)
            tabbrowser.selectedTab = newTab;
        }
      }
      else {
        var obj;

        if (openType == 'tab') {
          obj = new Object();
          this.getRowSource(currentRow, obj);
          obj.tabbrowser.addTab(null, null, null, !loadInBackground);
        }
        else if (openType == 'session') {
          if (mzRDFStore == null)
            mzInitializeRDFStorageFile();

          if (!this.isMixedSelection()) {
            var selectedRows = this.getSelectedRows();

            if (selectedRows) {
              var windowID = 'window-0';
              var sessionID = 0;
              var currentWindow = 0;
              var skippedWindows = 0;
              var totalSelectedWindows = 0;

              for (var i = 0; i < selectedRows.length; i++)
              {
                if (tree.treeBoxObject.view.isContainer(Number(selectedRows[i])))
                {
                  totalSelectedWindows++;
                  obj = new Object();
                  this.getRowSource(selectedRows[i], obj);

                  if (areAllTabsBlank(obj.tabbrowser)) {
                    skippedWindows++;
                    continue; // Yes, skip this window
                  }
                  else {
                    /***
                      * obj.windowID might be set to 'window-10' but that still doesn't mean it is the 
                      * tenth open browser window and that is why we need an indexed value of windowID
                      */
                    if (currentWindow == 0) {
                      sessionID = mzGetNextSessionID(sessionID, windowID);
                    }
                    else {
                      windowID = 'window-' + currentWindow;
                    }
                    var resource = "urn:" + sessionID + ":" + windowID + ":tabs:root";
                    var selectedTabStyle = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");
                    mzStoreGroupData(mzRDFStore, resource, obj.tabbrowser, true, false, selectedTabStyle, true, null);
                    currentWindow++;
                  }
                }
              }
              /***
                * Get rid of the tree selection(s). This should prevent people from 
                * adding the same session over and over again.
                */
              tree.view.selection.clearSelection();
              tree.currentIndex = -1;

              var promptTitle, promptText;
              var notificationArray = new Array();

              if (skippedWindows) {
                // promptTitle = gStringBundle.GetStringFromName('tmAddTabSessionNotificationTitle');
                promptTitle = gStringBundle.getString('tmAddTabSessionNotificationTitle');
                notificationArray = [ skippedWindows, totalSelectedWindows ];
                // promptText = gStringBundle.formatStringFromName('tmSkippedWindowsText', notificationArray, 2);
                promptText = gStringBundle.getFormattedString('tmSkippedWindowsText', notificationArray, 2);
              }
              else if (totalSelectedWindows) {
                // promptTitle = gStringBundle.GetStringFromName('tmAddTabSessionNotificationTitle');
                promptTitle = gStringBundle.getString('tmAddTabSessionNotificationTitle');
                sessionID = sessionID.replace(/session-/, '');
                notificationArray = [ totalSelectedWindows, sessionID ];
                // promptText = gStringBundle.formatStringFromName('tmSavedWindowsText', notificationArray, 2);
                promptText = gStringBundle.getFormattedString('tmSavedWindowsText', notificationArray, 2);
              }
              if (skippedWindows || totalSelectedWindows) {
                try {
                  // catch a dreadful JS exception (nsIDOMWindowInternal.focus)
                  gPromptService.alert(window, promptTitle, promptText);
                } catch(ex) {}
              }
            }
          }
        }
        obj = null;
      }
    }
    this.refreshAfterCommand();
  },

  closeTabs: function(allTabs)
  {
    if (allTabs) // needed for context menu items, might be moved out
      tabManager.selectRows('all');
    this.closeSelectedItems();
  },

  closeWindows: function()
  {
    this.closeSelectedItems();
  },

  closeSelectedItems: function()
  {
    var selectedResources = this.getSelectedResources();

    if (selectedResources == null) {
      return;
    }
    else { // Two step data collection process
      this.disableToolbarButtons();

      var obj = new Object;
      var windows = new Array();
      var resourceObj, resource;
      var saveSessionPref = gPreferences.readInteger("multizilla.browsersession.save.behavior", 3);
      var skipSingleTab = gPreferences.readBoolean("multizilla.browsersession.skip.save-single-tab", false);
      var shouldSave = (saveSessionPref > 0);
      var windowsToConfirm = 0;
      // collect all selected windows
      for (rIndex in selectedResources) {
        resourceObj = selectedResources[rIndex];
        resource = resourceObj.resource;

        if (resource.match(/tabs:root/)) {
          obj = new Object();
          this.getRowSource(resourceObj.row, obj);
          var numberOfTabs = obj.tabbrowser.mTabContainer.childNodes.length;

          if (!shouldSave || areAllTabsBlank(obj.tabbrowser) || numberOfTabs == 1 && skipSingleTab)
            resourceObj.obj = { window: obj.window };
          else {
            resourceObj.obj = obj;
            windowsToConfirm++;
          }
          windows.push(resourceObj);
        }
      }
      var tabs = new Array();
      // collect all selected tabs that are not part of a selected window
      for (rIndex in selectedResources) {
        var tabIsChild = false;
        resourceObj = selectedResources[rIndex];
        // convert 'urn:window-N:tabs:tab-N' into 'urn:window-N:tabs:root'
        resource = resourceObj.resource.replace(/tab-\w*/, 'root');

        for (wIndex in windows) {
          if (resource == windows[wIndex].resource) {
            tabIsChild = true;
            break;
          }
        }
        if (tabIsChild)
          selectedResources.pop(resourceObj);
        else {
          this.getRowSource(resourceObj.row, obj);
          resourceObj.obj = { tabbrowser: obj.tabbrowser,
                              tab: obj.tab };
          tabs.push(resourceObj);
        }
      }
      obj = null;
      resourceObj = null;
    }
    selectedResources = null;
    // Do we need to close windows and/or tabs?
    if (windows.length || tabs.length) {
      const confirmPrefID = "multizilla.tab-manager.confirm.close-";
      var closeWindowsConfirmation = (windows.length && gPreferences.readBoolean(confirmPrefID + "windows", true));
      // dump("\ncloseWindowsConfirmation: " + closeWindowsConfirmation);
      var closeTabsConfirmation = (tabs.length && gPreferences.readBoolean(confirmPrefID + "tabs", true));
      // dump("\ncloseTabsConfirmation: " + closeTabsConfirmation);
      var skipCloseWindowConfirmation = (gPreferences.readInteger("multizilla.browsersession.save.behavior", 3) == 3 &&
                                         gPreferences.readBoolean("multizilla.tab-manager.confirm.skip-close-windows", true));
      // dump("\nskipCloseWindowConfirmation: " + skipCloseWindowConfirmation);
      var confirmRequired = ((closeWindowsConfirmation && windowsToConfirm == 0) || 
                             (closeWindowsConfirmation && skipCloseWindowConfirmation == false) ||
                             closeTabsConfirmation);
      // dump("\nconfirmRequired: " + confirmRequired);
      var selectedTabStyling = gPreferences.readString("multizilla.session-manager.selectedtab-styling", "bold");

      // Do we need to ask for the users confirmation?
      if (confirmRequired) {
        var header;

        if (closeWindowsConfirmation && closeTabsConfirmation)
          header = 'tabs-windows';
        else if (closeWindowsConfirmation)
          header = (windows.length == 1) ? 'window' : 'windows';
        else if (closeTabsConfirmation)
          header = (tabs.length == 1) ? 'tab' : 'tabs';

        var confirmationTitle = header + '.confirmDialogTitle';
        var confirmationText = header + '.confirmDialogText';
        // Ask for the users confirmation before removing the tab(s) and/or window(s)
        if ((closeTabsConfirmation && header.match(/tab/)) ||
            (closeWindowsConfirmation && header.match(/window/))) {

          if (!gManager.getConfirmation(confirmationTitle, confirmationText, null)) {
            // Re-enable the toolbar buttons, counter part of this.disableToolbarButtons();
            if (gToolbarButtonState) {
              for (i in toolbarButtons) {
                toolbarButtons[i].disabled = gToolbarButtonState[i];
              }
            }
            gToolbarButtonState = null;
            tree.focus();
            return;
          }
        }
      }
      // Remove the selected Tabs
      for (tIndex in tabs) {
        obj = tabs[tIndex].obj;
        obj.tabbrowser.removeTab(obj.tab);
      }
      tabs = null;
      // Remove the selected Windows
      for (wIndex in windows) {
        obj = windows[wIndex].obj;

        if (obj.windowID == undefined) // No session to be saved!
          obj.window.close();
        else { // Save session for this window!
          if (mzRDFStore == null) // do we really need this here?
            mzInitializeRDFStorageFile();

          gSessionObject = obj;
          /*** 
            * obj.window might be the 10th window opened during this session, but it
            * should still point to a relative window index number like Menu/Windows does, 
            * or we might end up adding a new session as 'urn:session-0:window-10:tabs:root' 
            * instead of 'urn:session-0:window-2:tabs:root' and that's not what we want!
            */
          gSessionObject.windowID = mzGetRelativeWindowResourceID(obj.window);
          /***
            * Session stored in multizilla.rdf use a different urn so we have to transform 
            * 'urn:window-x:tabs:root' into 'urn:session-0:window-N:tabs:root' or else ...
            */
          gSessionObject.resource = "urn:session-0:" + gSessionObject.windowID + ":tabs:root";
          gSessionObject.previouslyStored = mzCheckResource(mzRDFStore, gSessionObject.resource);
          gSessionObject.saveAsNewSession = (!gSessionObject.previouslyStored);
          gSessionObject.mergeSessions = false;
          gSessionObject.askConfirmation = true;
          gSessionObject.datasource = mzRDFStore;
          gSessionObject.sessionID = 0;
          gSessionObject.closeWSFlag = true;
          gSessionObject.selectedTabStyle = selectedTabStyling;
          gSessionObject.parentWindow = window; // Open session saver window as a dependent window of this!
          gSessionObject.saveHistory = true;
          gSessionObject.isCancelled = false;

          mzSaveTabSession(false, true, gSessionObject, false);
        }
      }
      obj = null;
      windows = null;

      try {
        mzFlushDataSource(dataSource);
        tree.builder.rebuild();
        this.refreshAfterCommand();
      } catch(ex) {
        // die silently
      }
    }
  },

  refreshAfterCommand: function()
  {
    /* This might fail when you open a new window and quickly close the tab manager!
    var focusedWindow = document.commandDispatcher.focusedWindow;

    if (focusedWindow != window)
      dump("\nWrong Window Focused"); */

    updateToolbarButtons();
    setTimeout(window.focus,0); // focus TM Window, to make the ESC key work
    // document.commandDispatcher.focusedWindow = window;
    // document.commandDispatcher.focusedElement = tree;
    tree.focus(); // focus TM Tree, to make key up/down work
  },

  updateTab: function(updateType, data)
  {
    // dump("\nupdateTab");
    var treeState = this.getCurrentTreeState();

    if (treeState != SINGLE_ROW_SELECTED || tree.currentIndex == -1)
      return;

    var obj = new Object();
    this.getRowSource(tree.currentIndex, obj);
    var tab = obj.tab;
    var browser = obj.browser;
    var tabbrowser = obj.tabbrowser;
    var columnID;

    switch(updateType) {
      case "label":
        tab.setAttribute("label", data);
        columnID = "Name";
        columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
        tree.builderView.setCellText(currentRow, columnID, data);
        break;
      case "customlabel":
        if (data)
          tab.setAttribute("customLabel", "true");
        else
          tabbrowser.removeCustomLabel();
        // tree.builderView.setCellValue(currentRow, '', data);
        // tree.builderView.setCellText(currentRow, '', data);
        break;
      case "location":
        browser.loadURI(data);
        columnID = "tm-location";
        columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
        tree.builderView.setCellText(currentRow, columnID, data);
        break;
      case "interval":
        tabbrowser.setReloadInterval(tab, data);
        break;
      case "allowPlugins":
      case "allowJavascript":
      case "allowMetaRedirects":
      case "allowSubframes":
      case "allowImages":
        browser.docShell[updateType] = data;
        tabbrowser.refreshDocShellPropertyButtons();
        break;
    }
  },

  onSelect: function(aEvent)
  {
    // dump("\n\nonSelect: " + aEvent.type); // keyCode);

    if (gManager.gPreloadStatus > 1) {
      var preLoadType = 2;

      if (gManager.gPreloadStatus & preLoadType)
        setTimeout(gManager.preLoad, 0, preLoadType);
    }
    if (tree.currentIndex == -1) {
      /* dump("\ncurrentRow: " + currentRow);
      if ((currentRow != -1) && (currentRow <= tree.treeBoxObject.view.rowCount)) {
        tree.currentIndex = currentRow;
        dump("\nUPDATING ROW");
      } */
      updateToolbarButtons();
      // tree.view.selection.select(tree.currentIndex);
    }
    else {
      var resource = this.getResourceForRow(tree.currentIndex);

      if (resource != gLastSelectedResource) {
         currentRow = tree.currentIndex;
         var treeState = this.getCurrentTreeState();

         if ((treeState & SINGLE_ROW_SELECTED) && !(treeState & ROW_IS_CONTAINER))
           this.activateSelectedTab(currentRow);
      }
      // tree.view.selection.select(tree.currentIndex);
    }
    this.refreshAfterCommand();
  }
};

function shutdown()
{
  gObserverService.notifyObservers(window.document.documentElement, "MZManagers", "stop");
  gObserverService.removeObserver(gTabSelectedStateObserver, "selectedTabState");
  gObserverService.removeObserver(gTabUpdateObserver, "tabUpdate");
  gWindowManager.removeListener(gWindowManagerListener);
}

function onCancel(aEvent)
{
  return true;
}

function onAccept(aEvent)
{
  return false;
}

function onPageShow()
{
  tabManager.initTabManager();
}

addEventListener("pageshow", onPageShow, true);
// addEventListener("load", tabManager.initTabManager, false);

/*
////////////////////////////////////////////////////////////////////////////////
function updateCurrentIndex()
{
  tree.currentIndex = gTabbrowser.selectedTab.ordinal;
  tree.view.selection.toggleSelect(tree.currentIndex);
}

var tabManagerDNDObserver =
{
  tree : null,

  initTabManagerDNDObserver: function()
  {
    tree = document.getElementById("tabManagerTree");
    mzInitializeRDFStorageFile();
    tree.database.AddDataSource(mzRDFStore);
    tree.builder.rebuild();
    updateCurrentIndex();
    tabbrowser = getLastActiveBrowserWindow().getBrowser();
    stringBundle = document.getElementById("tm-properties");
    tabListInit();
  },

  onDragStart: function(aEvent, aXferData, aDragSession)
  {
    // start the row drag operation only when there are at least 2 visible rows
    if (tree.treeBoxObject.view.rowCount > 1) {
      aEvent.target.setAttribute("dragover", "true");
      var columnID = "sm-interval";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      var ordinal = tree.view.getCellText(tree.currentIndex, columnID);
      // dump("onDragStart ordinal: "+ordinal+"\n");
      aXferData.data = new TransferData();
      aXferData.data.addDataForFlavour("text/unicode", ordinal);
    }
  },

  onDragOver: function(aEvent, aXferData, aDragSession)
  {
    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    var row = tree.treeBoxObject.getRowAt(X, Y);

    aDragSession.canDrop = true;
    if (row > -1) {
      dump("onDragOver - row: "+row+"\n");
      var columnID = "sm-interval";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      var ordinal = tree.view.getCellText(row, columnID);
      dump("ordinal: "+ordinal+"\n");
      ordinal++;
      var element = document.getElementById("tm-tab-"+ordinal);
      dump(element.nodeName+"\n");
      // nsDragAndDrop.mDragSession.sourceNode = element;
    }
  },

  onDrop: function(aEvent, aXferData, aDragSession)
  {
    dump("onDrop\n"+aEvent.originalTarget.nodeName);
  },

  onDragExit: function(aEvent, aXferData, aDragSession)
  {
    tree.childNodes[1].removeAttribute("dragover");
  },

  getSupportedFlavours: function ()
  {
    // we might want to expand this
    var flavourSet = new FlavourSet();
    flavourSet.appendFlavour("text/unicode");
    return flavourSet;
  },

  canDrop: function (aEvent, aDragSession)
  {
    aDragSession.canDrop = true;
    // allow drops from the Tab Manager only
    var doc = aDragSession.sourceNode.ownerDocument;
    var elem = doc.getElementById("tabManagerWindow");
    return (elem && (elem.getAttribute("windowtype") == "multizilla:tabmanager"));
  }
};
addEventListener("load", tabManagerDNDObserver.initTabManagerDNDObserver, false); */

