# Node Foundation Core Technical Committee (CTC) Meeting 2015-10-21

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-10-21
* **GitHub Issue**: https://github.com/nodejs/node/issues/3464
* **Minutes Google Doc**: <https://docs.google.com/document/d/1ad8Xlza_B-iWexdlAd1Z5muzBy_HH88t_iSD31OUepA>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1tVPxA4Y3n3dmICJFZN2vK93PXjCaUQ-eiN2mvt7zqbE>_

## Present

* Rod Vagg (CTC)
* Brian White (CTC)
* Steven R. Loomis (observer)
* James Snell (CTC)
* Michael Dawson (observer)
* Chris Dickinson (CTC)
* Ben Noordhuis (CTC)
* Jeremiah Senkpiel (CTC)
* Trevor Norris (CTC)
* Alexis Campailla (CTC)
* Mikeal Rogers (observer)
* Shigeki Ohtsu (CTC)
* Seth Thompson (observer)
* Bert Belder (CTC)
* Fedor Indutny (CTC)
## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node

* governance: add new collaborators #VIII [#3472](https://github.com/nodejs/node/issues/3472)
* detect "full-icu" module [#3460](https://github.com/nodejs/node/issues/3460)
* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* node: deprecate public access to `process.binding` [#2768](https://github.com/nodejs/node/pull/2768)

## Minutes

### Review of previous meeting

* V8 security reporting [#3348](https://github.com/nodejs/node/issues/3348)
* doc: add information about Assert behavior and maintenance [#3330](https://github.com/nodejs/node/pull/3330)
* WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)
* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Compiling node v4.0.0 with OpenSSL 1.0.1 fails [#2783](https://github.com/nodejs/node/issues/2783)
* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

### Standup

* Rod Vagg: index.tab and index.json updates (nodejs.org/dist/index.*) including an “lts” field, also made consistent directories for ancient Node tarballs with shasums files so nvm and other tools can simplify their access. v5 and other build yak shaving.
* Brian White: usual triaging and PR and Issues commenting, not much else
* Steven R. Loomis: Intl meeting, "full-icu" npm module [will be away until Nov 11 meeting, Unicode conf/Unicode-TC]
* James Snell: Working on localization for the node runtime [#3413](https://github.com/nodejs/node/pull/3413)
* Michael Dawson: Working through PPC and AIX PRs and issues, LTS WG discussions, Benchmarking WG, working with Stefan on agenda items for API WG meeting.
* Chris Dickinson: was busy with vacation and conferences, but looking into the WhatWG Streams spec, next up is static analysis server
* Ben Noordhuis: The usual. Looking into make the debugger better. The test suite is in bad shape
* Jeremiah Senkpiel: issue and PR work — going back through the backlog now, helping with v5 release + npm@3
* Trevor Norris: flurry of AsyncWrap PRs, trying to get it to a point where people could more reliably use it, it can’t be hidden forever.
* Alexis Campailla: Sick, traveling; CI progress on flakiness, some progress on native module build service
* Mikeal Rogers: Foundation resources for v5 release: PR folks wrote a blog post, expectation setting, make sure enterprises are still using LTS, if you’re a dev here’s what to be excited about, etc.
* Shigeki Ohtsu: Worked semver-major fix to limit DH key size [#1831] (https://github.com/nodejs/node/pull/1831) and some works for root certs.
* Seth Thompson: Security mailing list stuff went through this week, working on v8 side of things to create a new version of the octane benchmark, excited about the benchmarking WG
* Bert Belder: nothing
* Fedor Indutny: reviewing PRs, helped fix a beforeExit bug, fixing yet another V8’s ArrayBuffer issue
  - Discussed the ArrayBuffer issue in detail

* (Aside: Shigeki and Fedor were asked to look at [#3406](https://github.com/nodejs/node/issues/3406) - “p1/p2” issue )

### governance: add new collaborators #VIII [#3472](https://github.com/nodejs/node/issues/3472)

- Discussed onboarding.

- Action: Jeremiah to schedule and run another onaboarding, Chris to tune in.

### detect "full-icu" module [#3460](https://github.com/nodejs/node/issues/3460)

Stems from conversation from the 0.X days about whether Node should ship other languages separately.

This is a module published on npm as an alternative to shipping with Node proper.

Whether node can detect a full-icu install in a special place (node_modules/full-icu, global/node_modules/full-icu)

Nathan7 commented with a concern about coupling npm to node

Currently have to start node with ICU_DATA_PATH=some/path/to/file

Rod: Couple it to `execPath`

James: globally installed could install into a well known global location

Rod: Does this have to be done at startup?

Stephen: Yes. V8 has to have the data available before starting.

James: Happens right after parsing args

Rod: Could use HOME?

Stephen: Could use NODE_PATH?

Rod: Trying to move away from NODE_PATH

Ben: Might just bite the bullet and include ICU?

Stephen: I would like that, but I am sympathetic to folks running on OpenWRT

Ben: I can see that, but all this installing in special paths leaves a lot of margin for error.

James: Full ICU will double the size of the Node binary. Hard pill to swallow.

Rod: We could offer alternative downloads?

Stephen: Two downloads would work as well. We could do this all from build infra.

Bert: I would not be in favor of that. We end up with “oh my module doesn’t work” “oh you didn’t download the right flavor of Node”

Jeremiah: It’s going to make it confusing no matter what

... [I missed this]

Chris: could we offer better error messages?

Rod: it peeks through in a lot of places — the ICU object, strings, etc. Maybe best to leave to module authors? Include a process.versions.icu object?

James: small-icu is the default build running locally — CI doesn’t run with ICU enabled?

Trevor: even if small-icu is there, it means less data, but not less build time. I would like to see how that affects the raspberry pi’s build time.

Ben: we could avoid rebuilding ICU on rasppis

Stephen: or use a precompiled ICU

Jeremiah: Assumes an internet connected machine

Rod: If we go with small-icu we should make it available

Ben: should we add it to the repo?

Alexis: I think so, it’s causing problems

[???]: It’s about 80mb

Rod: How big is it?

Stephen: The source size & binary size was comparable to Node.
We could have a non-standard source checked in.

Mikeal: we could use the large file storage stuff GH just added.
Stephen: 25mb uncompressed, 130mb for source tree

Mikeal: if we say “you need ICU to build”  we need to make it available

Trevor: How’s this going to work with bouncing between branches?

Alexis: What about keeping it as text?

Ben:

Steven: We have a 25mb compressed zip of source, that itself contains a 25mb compressed zip. We could strip that down — what would it take to delete the tests, etc — a subset

Mikeal: so could we just install this 25mb file?

Rod: This adds a dep on Git LFS

Mikeal: Let’s try to solve one problem at a time — fix downloading, not making the default

Rod: I’m happy with how the CI does it

…

Stephen: The first time you hit something ICU-based it loads it.

Rod: I’m just wondering if this could be turned into a proper npm module.

Stephen: I’m not sure — it looks pretty deeply enmeshed into V8

Seth: I don’t have answers off the top of my head on that one, I responded on the thread; we don’t currently have a priority to mess
around with localization. If there’s a design doc that proposes cleaning things up we’d be interested

James: Resource bundle mechanism — [Note: didn’t get all of this] “using the same startup sequence as Intl.. so needs to be configured at start time” (https://github.com/nodejs/node/pull/3413 uses ICU’s resource bundle mechanism, which uses the same init path as the core data. ICU does not allow multiple initializations.

Alexis: If the only reason we’re trying to package it is to use npm to install it, maybe we’re complicating this unnecessarily

Rod: On the iojs side we decided not to go with ICU. It’s in core because it has to be initialized before v8 is started, my question is this something that could be changed upstream in v8? Ideally this should not be in core.

Steven: It didn’t look like it could be split off easily.

Chris: JS proxies

Steven: Possible, but _very_ tricky

[Moving conversation to GH]


### WG: Considering a new HTTP WG [#3214](https://github.com/nodejs/node/issues/3214)

HTTP WG first meeting is tomorrow at 1pm Pacific, nothing to discuss yet

### node: deprecate public access to `process.binding` [#2768](https://github.com/nodejs/node/pull/2768)

Lots of discussion, focused on `process.binding('natives')`. Summary: We should at least try to make it read-only first. Ben said he would follow up with a PR.

### node: make listen address configurable [#3316](https://github.com/nodejs/node/pull/3316)

Fedor: Ben suggested commandline argument to submit hostname and port. Fedor concerned about the amout of code required to parse and separate the two parts of the option. Would be better to have a separate argument for hostname.

Discussion about usability vs simplicity of code.

Quick vote on whether to move forward with the PR in its current form, no objections.

## Next Meeting

October 28th, 2015
