# Copyright 2013 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# This file is automatically generated from the V8 source and should not
# be modified manually, run 'make grokdump' instead to update this file.

# List of known V8 instance types.
INSTANCE_TYPES = {
  64: "STRING_TYPE",
  68: "ONE_BYTE_STRING_TYPE",
  65: "CONS_STRING_TYPE",
  69: "CONS_ONE_BYTE_STRING_TYPE",
  67: "SLICED_STRING_TYPE",
  71: "SLICED_ONE_BYTE_STRING_TYPE",
  66: "EXTERNAL_STRING_TYPE",
  70: "EXTERNAL_ONE_BYTE_STRING_TYPE",
  74: "EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  82: "SHORT_EXTERNAL_STRING_TYPE",
  86: "SHORT_EXTERNAL_ONE_BYTE_STRING_TYPE",
  90: "SHORT_EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  0: "INTERNALIZED_STRING_TYPE",
  4: "ONE_BYTE_INTERNALIZED_STRING_TYPE",
  2: "EXTERNAL_INTERNALIZED_STRING_TYPE",
  6: "EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  10: "EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  18: "SHORT_EXTERNAL_INTERNALIZED_STRING_TYPE",
  22: "SHORT_EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  26: "SHORT_EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  128: "SYMBOL_TYPE",
  134: "FLOAT32X4_TYPE",
  129: "MAP_TYPE",
  130: "CODE_TYPE",
  131: "ODDBALL_TYPE",
  182: "CELL_TYPE",
  184: "PROPERTY_CELL_TYPE",
  132: "HEAP_NUMBER_TYPE",
  133: "MUTABLE_HEAP_NUMBER_TYPE",
  135: "FOREIGN_TYPE",
  136: "BYTE_ARRAY_TYPE",
  137: "BYTECODE_ARRAY_TYPE",
  138: "FREE_SPACE_TYPE",
  139: "EXTERNAL_INT8_ARRAY_TYPE",
  140: "EXTERNAL_UINT8_ARRAY_TYPE",
  141: "EXTERNAL_INT16_ARRAY_TYPE",
  142: "EXTERNAL_UINT16_ARRAY_TYPE",
  143: "EXTERNAL_INT32_ARRAY_TYPE",
  144: "EXTERNAL_UINT32_ARRAY_TYPE",
  145: "EXTERNAL_FLOAT32_ARRAY_TYPE",
  146: "EXTERNAL_FLOAT64_ARRAY_TYPE",
  147: "EXTERNAL_UINT8_CLAMPED_ARRAY_TYPE",
  148: "FIXED_INT8_ARRAY_TYPE",
  149: "FIXED_UINT8_ARRAY_TYPE",
  150: "FIXED_INT16_ARRAY_TYPE",
  151: "FIXED_UINT16_ARRAY_TYPE",
  152: "FIXED_INT32_ARRAY_TYPE",
  153: "FIXED_UINT32_ARRAY_TYPE",
  154: "FIXED_FLOAT32_ARRAY_TYPE",
  155: "FIXED_FLOAT64_ARRAY_TYPE",
  156: "FIXED_UINT8_CLAMPED_ARRAY_TYPE",
  158: "FILLER_TYPE",
  159: "DECLARED_ACCESSOR_DESCRIPTOR_TYPE",
  160: "DECLARED_ACCESSOR_INFO_TYPE",
  161: "EXECUTABLE_ACCESSOR_INFO_TYPE",
  162: "ACCESSOR_PAIR_TYPE",
  163: "ACCESS_CHECK_INFO_TYPE",
  164: "INTERCEPTOR_INFO_TYPE",
  165: "CALL_HANDLER_INFO_TYPE",
  166: "FUNCTION_TEMPLATE_INFO_TYPE",
  167: "OBJECT_TEMPLATE_INFO_TYPE",
  168: "SIGNATURE_INFO_TYPE",
  169: "TYPE_SWITCH_INFO_TYPE",
  171: "ALLOCATION_MEMENTO_TYPE",
  170: "ALLOCATION_SITE_TYPE",
  172: "SCRIPT_TYPE",
  173: "CODE_CACHE_TYPE",
  174: "POLYMORPHIC_CODE_CACHE_TYPE",
  175: "TYPE_FEEDBACK_INFO_TYPE",
  176: "ALIASED_ARGUMENTS_ENTRY_TYPE",
  177: "BOX_TYPE",
  185: "PROTOTYPE_INFO_TYPE",
  180: "FIXED_ARRAY_TYPE",
  157: "FIXED_DOUBLE_ARRAY_TYPE",
  181: "SHARED_FUNCTION_INFO_TYPE",
  183: "WEAK_CELL_TYPE",
  189: "JS_MESSAGE_OBJECT_TYPE",
  188: "JS_VALUE_TYPE",
  190: "JS_DATE_TYPE",
  191: "JS_OBJECT_TYPE",
  192: "JS_CONTEXT_EXTENSION_OBJECT_TYPE",
  193: "JS_GENERATOR_OBJECT_TYPE",
  194: "JS_MODULE_TYPE",
  195: "JS_GLOBAL_OBJECT_TYPE",
  196: "JS_BUILTINS_OBJECT_TYPE",
  197: "JS_GLOBAL_PROXY_TYPE",
  198: "JS_ARRAY_TYPE",
  199: "JS_ARRAY_BUFFER_TYPE",
  200: "JS_TYPED_ARRAY_TYPE",
  201: "JS_DATA_VIEW_TYPE",
  187: "JS_PROXY_TYPE",
  202: "JS_SET_TYPE",
  203: "JS_MAP_TYPE",
  204: "JS_SET_ITERATOR_TYPE",
  205: "JS_MAP_ITERATOR_TYPE",
  206: "JS_WEAK_MAP_TYPE",
  207: "JS_WEAK_SET_TYPE",
  208: "JS_REGEXP_TYPE",
  209: "JS_FUNCTION_TYPE",
  186: "JS_FUNCTION_PROXY_TYPE",
  178: "DEBUG_INFO_TYPE",
  179: "BREAK_POINT_INFO_TYPE",
}

# List of known V8 maps.
KNOWN_MAPS = {
  0x08081: (136, "ByteArrayMap"),
  0x080ad: (129, "MetaMap"),
  0x080d9: (131, "NullMap"),
  0x08105: (180, "FixedArrayMap"),
  0x08131: (4, "OneByteInternalizedStringMap"),
  0x0815d: (183, "WeakCellMap"),
  0x08189: (131, "TheHoleMap"),
  0x081b5: (138, "FreeSpaceMap"),
  0x081e1: (158, "OnePointerFillerMap"),
  0x0820d: (158, "TwoPointerFillerMap"),
  0x08239: (131, "UndefinedMap"),
  0x08265: (132, "HeapNumberMap"),
  0x08291: (131, "BooleanMap"),
  0x082bd: (131, "UninitializedMap"),
  0x082e9: (182, "CellMap"),
  0x08315: (184, "GlobalPropertyCellMap"),
  0x08341: (181, "SharedFunctionInfoMap"),
  0x0836d: (133, "MutableHeapNumberMap"),
  0x08399: (134, "Float32x4Map"),
  0x083c5: (180, "NativeContextMap"),
  0x083f1: (130, "CodeMap"),
  0x0841d: (180, "ScopeInfoMap"),
  0x08449: (180, "FixedCOWArrayMap"),
  0x08475: (157, "FixedDoubleArrayMap"),
  0x084a1: (68, "OneByteStringMap"),
  0x084cd: (180, "FunctionContextMap"),
  0x084f9: (131, "NoInterceptorResultSentinelMap"),
  0x08525: (131, "ArgumentsMarkerMap"),
  0x08551: (131, "ExceptionMap"),
  0x0857d: (131, "TerminationExceptionMap"),
  0x085a9: (180, "HashTableMap"),
  0x085d5: (180, "OrderedHashTableMap"),
  0x08601: (128, "SymbolMap"),
  0x0862d: (64, "StringMap"),
  0x08659: (69, "ConsOneByteStringMap"),
  0x08685: (65, "ConsStringMap"),
  0x086b1: (67, "SlicedStringMap"),
  0x086dd: (71, "SlicedOneByteStringMap"),
  0x08709: (66, "ExternalStringMap"),
  0x08735: (74, "ExternalStringWithOneByteDataMap"),
  0x08761: (70, "ExternalOneByteStringMap"),
  0x0878d: (70, "NativeSourceStringMap"),
  0x087b9: (82, "ShortExternalStringMap"),
  0x087e5: (90, "ShortExternalStringWithOneByteDataMap"),
  0x08811: (0, "InternalizedStringMap"),
  0x0883d: (2, "ExternalInternalizedStringMap"),
  0x08869: (10, "ExternalInternalizedStringWithOneByteDataMap"),
  0x08895: (6, "ExternalOneByteInternalizedStringMap"),
  0x088c1: (18, "ShortExternalInternalizedStringMap"),
  0x088ed: (26, "ShortExternalInternalizedStringWithOneByteDataMap"),
  0x08919: (22, "ShortExternalOneByteInternalizedStringMap"),
  0x08945: (86, "ShortExternalOneByteStringMap"),
  0x08971: (139, "ExternalInt8ArrayMap"),
  0x0899d: (140, "ExternalUint8ArrayMap"),
  0x089c9: (141, "ExternalInt16ArrayMap"),
  0x089f5: (142, "ExternalUint16ArrayMap"),
  0x08a21: (143, "ExternalInt32ArrayMap"),
  0x08a4d: (144, "ExternalUint32ArrayMap"),
  0x08a79: (145, "ExternalFloat32ArrayMap"),
  0x08aa5: (146, "ExternalFloat64ArrayMap"),
  0x08ad1: (147, "ExternalUint8ClampedArrayMap"),
  0x08afd: (149, "FixedUint8ArrayMap"),
  0x08b29: (148, "FixedInt8ArrayMap"),
  0x08b55: (151, "FixedUint16ArrayMap"),
  0x08b81: (150, "FixedInt16ArrayMap"),
  0x08bad: (153, "FixedUint32ArrayMap"),
  0x08bd9: (152, "FixedInt32ArrayMap"),
  0x08c05: (154, "FixedFloat32ArrayMap"),
  0x08c31: (155, "FixedFloat64ArrayMap"),
  0x08c5d: (156, "FixedUint8ClampedArrayMap"),
  0x08c89: (180, "SloppyArgumentsElementsMap"),
  0x08cb5: (180, "CatchContextMap"),
  0x08ce1: (180, "WithContextMap"),
  0x08d0d: (180, "BlockContextMap"),
  0x08d39: (180, "ModuleContextMap"),
  0x08d65: (180, "ScriptContextMap"),
  0x08d91: (180, "ScriptContextTableMap"),
  0x08dbd: (189, "JSMessageObjectMap"),
  0x08de9: (135, "ForeignMap"),
  0x08e15: (191, "NeanderMap"),
  0x08e41: (191, "ExternalMap"),
  0x08e6d: (171, "AllocationMementoMap"),
  0x08e99: (170, "AllocationSiteMap"),
  0x08ec5: (174, "PolymorphicCodeCacheMap"),
  0x08ef1: (172, "ScriptMap"),
  0x09101: (161, "ExecutableAccessorInfoMap"),
  0x09159: (162, "AccessorPairMap"),
  0x09209: (185, "PrototypeInfoMap"),
  0x09839: (137, "BytecodeArrayMap"),
  0x09865: (177, "BoxMap"),
  0x09891: (163, "AccessCheckInfoMap"),
  0x098bd: (164, "InterceptorInfoMap"),
  0x098e9: (165, "CallHandlerInfoMap"),
  0x09915: (166, "FunctionTemplateInfoMap"),
  0x09941: (167, "ObjectTemplateInfoMap"),
  0x0996d: (169, "TypeSwitchInfoMap"),
  0x09999: (173, "CodeCacheMap"),
  0x099c5: (175, "TypeFeedbackInfoMap"),
  0x099f1: (176, "AliasedArgumentsEntryMap"),
  0x09a1d: (178, "DebugInfoMap"),
  0x09a49: (179, "BreakPointInfoMap"),
}

# List of known V8 objects.
KNOWN_OBJECTS = {
  ("OLD_SPACE", 0x08081): "NullValue",
  ("OLD_SPACE", 0x08091): "EmptyDescriptorArray",
  ("OLD_SPACE", 0x08099): "EmptyFixedArray",
  ("OLD_SPACE", 0x080bd): "TheHoleValue",
  ("OLD_SPACE", 0x080dd): "UndefinedValue",
  ("OLD_SPACE", 0x08105): "NanValue",
  ("OLD_SPACE", 0x08115): "TrueValue",
  ("OLD_SPACE", 0x08135): "FalseValue",
  ("OLD_SPACE", 0x08159): "empty_string",
  ("OLD_SPACE", 0x08165): "UninitializedValue",
  ("OLD_SPACE", 0x08191): "EmptyByteArray",
  ("OLD_SPACE", 0x08199): "NoInterceptorResultSentinel",
  ("OLD_SPACE", 0x081d5): "ArgumentsMarker",
  ("OLD_SPACE", 0x08201): "Exception",
  ("OLD_SPACE", 0x08229): "TerminationException",
  ("OLD_SPACE", 0x0825d): "NumberStringCache",
  ("OLD_SPACE", 0x08a65): "SingleCharacterStringCache",
  ("OLD_SPACE", 0x08efd): "StringSplitCache",
  ("OLD_SPACE", 0x09305): "RegExpMultipleCache",
  ("OLD_SPACE", 0x0970d): "EmptyExternalInt8Array",
  ("OLD_SPACE", 0x09719): "EmptyExternalUint8Array",
  ("OLD_SPACE", 0x09725): "EmptyExternalInt16Array",
  ("OLD_SPACE", 0x09731): "EmptyExternalUint16Array",
  ("OLD_SPACE", 0x0973d): "EmptyExternalInt32Array",
  ("OLD_SPACE", 0x09749): "EmptyExternalUint32Array",
  ("OLD_SPACE", 0x09755): "EmptyExternalFloat32Array",
  ("OLD_SPACE", 0x09761): "EmptyExternalFloat64Array",
  ("OLD_SPACE", 0x0976d): "EmptyExternalUint8ClampedArray",
  ("OLD_SPACE", 0x09779): "EmptyFixedUint8Array",
  ("OLD_SPACE", 0x09789): "EmptyFixedInt8Array",
  ("OLD_SPACE", 0x09799): "EmptyFixedUint16Array",
  ("OLD_SPACE", 0x097a9): "EmptyFixedInt16Array",
  ("OLD_SPACE", 0x097b9): "EmptyFixedUint32Array",
  ("OLD_SPACE", 0x097c9): "EmptyFixedInt32Array",
  ("OLD_SPACE", 0x097d9): "EmptyFixedFloat32Array",
  ("OLD_SPACE", 0x097e9): "EmptyFixedFloat64Array",
  ("OLD_SPACE", 0x097f9): "EmptyFixedUint8ClampedArray",
  ("OLD_SPACE", 0x0980d): "InfinityValue",
  ("OLD_SPACE", 0x0981d): "MinusZeroValue",
  ("OLD_SPACE", 0x0982d): "MinusInfinityValue",
  ("OLD_SPACE", 0x09839): "MessageListeners",
  ("OLD_SPACE", 0x09855): "CodeStubs",
  ("OLD_SPACE", 0x0e52d): "ArrayProtector",
  ("OLD_SPACE", 0x0e9a1): "KeyedLoadDummyVector",
  ("OLD_SPACE", 0x13ded): "NonMonomorphicCache",
  ("OLD_SPACE", 0x14131): "PolymorphicCodeCache",
  ("OLD_SPACE", 0x14139): "NativesSourceCache",
  ("OLD_SPACE", 0x14429): "ExperimentalNativesSourceCache",
  ("OLD_SPACE", 0x14461): "ExtraNativesSourceCache",
  ("OLD_SPACE", 0x1446d): "CodeStubNativesSourceCache",
  ("OLD_SPACE", 0x1448d): "EmptyScript",
  ("OLD_SPACE", 0x144cd): "IntrinsicFunctionNames",
  ("OLD_SPACE", 0x240e1): "UndefinedCell",
  ("OLD_SPACE", 0x240e9): "ObservationState",
  ("OLD_SPACE", 0x240f5): "SymbolRegistry",
  ("OLD_SPACE", 0x24f9d): "EmptySlowElementDictionary",
  ("OLD_SPACE", 0x24fc5): "AllocationSitesScratchpad",
  ("OLD_SPACE", 0x253cd): "WeakObjectToCodeTable",
  ("OLD_SPACE", 0x25461): "EmptyPropertyCell",
  ("OLD_SPACE", 0x25471): "CodeStubContext",
  ("OLD_SPACE", 0x2ba11): "CodeStubExportsObject",
  ("OLD_SPACE", 0x2be89): "EmptyBytecodeArray",
  ("OLD_SPACE", 0x594dd): "StringTable",
  ("CODE_SPACE", 0x16341): "JsEntryCode",
  ("CODE_SPACE", 0x26a61): "JsConstructEntryCode",
}
