/*
   mul10.S - optimized 16-bit multiply by 10

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "macros.inc"

#define r_hi r25
#define r_lo r24
#define r_tmp1 __tmp_reg__
#define r_tmp2 r23

/* 
   r_hi:r_lo *= 10

   Optimized version, without calling __mulhi3 (which is slow for
   non-enhanced core, and not present in libgcc.a for enhanced core).
 */

	.section .text
	.global _U(__mulhi_const_10)

_U(__mulhi_const_10):
#if __AVR_ENHANCED__
	ldi r_tmp2,10
	mul r_hi,r_tmp2
	mov r_hi,r0
	mul r_lo,r_tmp2
	mov r_lo,r0
	add r_hi,r1
	clr r1	; __zero_reg__
#else
	mov r_tmp2,r_lo
	mov r_tmp1,r_hi
	add r_lo,r_lo
	adc r_hi,r_hi
	add r_lo,r_lo
	adc r_hi,r_hi
	add r_lo,r_tmp2
	adc r_hi,r_tmp1
	add r_lo,r_lo
	adc r_hi,r_hi
#endif
	ret

