/*
   strcasecmp_P.S
   Case insensitive compare

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22

#define ret_hi r25
#define ret_lo r24

#define tmp r22
#define cht r21

; int strcasecmp_P(const char *s1, const char *s2)

    .text
    .global _U(strcasecmp_P)
    .type   _U(strcasecmp_P), @function
_U(strcasecmp_P):
    LOAD_Z(s2_lo, s2_hi)
    LOAD_X(s1_lo, s1_hi)
.strcasecmp_P_loop:
    LD    ret_lo, X+          ; load *s1
    LPM_R0_ZP                 ; load *s2
    MOV   tmp,r0              ; copy of *s2 to tmp
    MOV   cht, r0             ; copy of *s2 to cht
    ORI   cht, 0x20           ; make tmp lower case
    CPI   cht, 'a'            ; test on [a .. z]
    BRLT  .strcasecmp_P_tst
    CPI   cht, 'z'+1
    BRGE  .strcasecmp_P_tst
    ORI   tmp, 0x20           ; we got an aplpha in s2
    ORI   ret_lo, 0x20
.strcasecmp_P_tst:               ; compare
    SUB   ret_lo, tmp
    BRNE  .strcasecmp_P_done
    TST   r0                  ; end of s2?
    BRNE  .strcasecmp_P_loop
.strcasecmp_P_done:
; ret_hi = SREG.C ? 0xFF : 0
    SBC   ret_hi, ret_hi
    RET
.strcasecmp_P_end:
    .size   _U(strcasecmp_P), .strcasecmp_P_end - _U(strcasecmp_P)

