
#include "macros.inc"

#define dest_hi r25
#define dest_lo r24
#define src_hi r23
#define src_lo r22
#define len_hi r21
#define len_lo r20

; char *strncpy(char *dest, const char *src, size_t len)

	.text
	.global	_U(strncpy)
	.type	_U(strncpy), @function
_U(strncpy):
	LOAD_Z(src_lo, src_hi)
	LOAD_X(dest_lo, dest_hi)
.strncpy_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcs	.strncpy_done
	ld	__tmp_reg__, Z+
	st	X+, __tmp_reg__
	tst	__tmp_reg__
	brne	.strncpy_loop
; store null characters up to the end of dest
; as the glibc manual says:
; This behavior is rarely useful, but it is specified by the ISO C standard.
	rjmp	.strncpy_clr_start
.strncpy_clr_loop:
	st	X+, __zero_reg__
.strncpy_clr_start:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcc	.strncpy_clr_loop
.strncpy_done:
; return dest (unchanged)
	ret
.strncpy_end:
	.size	_U(strncpy), .strncpy_end - _U(strncpy)

