
#include "macros.inc"

#define src_hi r25
#define src_lo r24
#define len_hi r23
#define len_lo r22

; size_t strnlen(const char *src, size_t len)

	.text
	.global	_U(strnlen)
	.type	_U(strnlen), @function
_U(strnlen):
	LOAD_Z(src_lo, src_hi)
.strnlen_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	ld	__tmp_reg__, Z+
	cpse	__tmp_reg__, __zero_reg__
	brcc	.strnlen_loop
; Z points one character past the terminating NUL
; return Z - 1 - src = (-1 - src) + Z = ~src + Z
	com	src_lo
	com	src_hi
	add	src_lo, ZL
	adc	src_hi, ZH
	ret
.strnlen_end:
	.size	_U(strnlen), .strnlen_end - _U(strnlen)

