/* vim: set sw=8 ts=8 si : */
/****************************************************************************
* Title   :   compatibility module for forward compatibility with
              newer ARV C compiler which does not have older
	      macros
* Authors:    Guido Socher
* Copyright: GPL
*
*        
*****************************************************************************/
#ifndef AVR_COMPAT_H
#define AVR_COMPAT_H


#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif

#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#ifndef outp
#define outp(val, sfr) outb(sfr, val) 
#endif

#ifndef inp
#define inp(sfr) inb(sfr) 
#endif

#ifndef BV
#define BV(bit) _BV(bit)
#endif


#endif //AVR_COMPAT_H

