/* vim: set sw=4 ts=4 si : */
/*************************************************************************
Title:    linuxfocus autonomous robot, testprgram
Authors:   guido socher <guido[at]linuxfocus.org>, 
           katja socher <katja[at]linuxfocus.org>
Copyright: GPL
**************************************************************************/
#include <io.h>
#include <progmem.h>
#include <stdlib.h>


#define LED1 PB0
#define LED2 PD2

void delay_ms(unsigned int ms)
/* delay for a minimum of <ms> */
/* with a 4Mhz crystal, the resolution is 1 ms */
{
        unsigned int outer1, outer2;
        outer1 = 200; /* 4 MHZ */
        /* outer1 = 300;  6 MHZ */

        while (outer1) {
                outer2 = 1000;
                while (outer2) {
                        while ( ms ) ms--;
                        outer2--;
                }
                outer1--;
        }
}


void main(void)
{ 
	/*enable motor pins as output */
	sbi(DDRB,LED1);	
	sbi(DDRD,LED2);	

	
	while (1) {
		/* blink led  */
		cbi(PORTB,LED1);	
		cbi(PORTD,LED2);	
		delay_ms(200);
		sbi(PORTB,LED1);
		sbi(PORTD,LED2);	
		delay_ms(200);					
	}
}
