// einfaches Beispiel einer Bevoelkerungsentwicklung
// Ausgangspunkt ist eine vorgebare Verteilung von Maennern
// und Frauen der untersuchten Region, Weiterhin wirken ein:
// Die Geburtenzahl, die Sterbewahrscheinlichkeiten, die 
// Migration. die Migration und die Sterbewahrscheinlichkeiten
// sind auf die Kompartimente 0..4, 5..9, 10..14,...
// bezogen und in einer Datei aenderbar abgelegt. Die Simulation
// errechnet eine Tabelle der Individuen pro Kompartiment. 
// Die Simulation erfolgt jahresweise, wobei immer 1/5 der 
// unteren Gruppe in ueberliegende Gruppe aufsteigen. Als 
// public ist dieses Feld nach jedem Simulationsschritt abgreifbar.
//
// Version 0.1 9.3.2002
// Dr. Ralf Wieland

#ifndef __DEMOGRAPHIE
#define __DEMOGRAPHIE

#include <iostream>
#include <fstream>

class demographie{
 public: 
    demographie(char*);  // filename des inputfiles
    ~demographie();
    void gebset(float);
    void step();         // Jahresschritt
    float get_m();        // return the sum of male
    float get_f();         // return the sum of female
    void save(char*);    // schreibe die Tabelle aus
    void reset();        // setzt ursprungsdaten zurueck
    void mig_plus(float);
    void mig_minus(float);
    float *m, *f;        // m=maenner, f=frauen
 protected:
    float *sf, *sm,  *migf,*migm, gm, gf; 
    // sterbewahrscheinlichkeit, Migration, Geburtenrate
    float *m0, *f0;      // Speicher fuer originale Verteilung
    float *migf0, *migm0; // die Migration ist aenderbar
    float flag;
};

#endif
