
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <ctype.h>
#include <string.h>
#include <stdio.h>

#include "node.h"
check_nodes()
{
	NODE *nd_ptr;
	int i, j, node_num;
	static char *type_names[3] = { "***", "MENU", "COMMAND" };
	int temp[MAX_NODES];

	/* go through the nodes:
		in each node, go through the list of names of nodes it
			consists of and lookup and save the numbers of the
			nodes consists of.
		print warning if node name doesn't exist.
		E.g. if MENU MAIN is read as consisting of nodes
			"PostOf" and "Persnl", this will look up and
			save the corresponding node numbers for "PostOf"
			and "Persnl".
		Reasons: faster access later & immediate consistency check
			at the beginning.
	 */

	/* convert node labels in menus to node numbers */
	/* check all nodes actually exist */
	for( node_num = 0; node_num < n_nodes; node_num++ ) {
		nd_ptr = node[node_num];
		for( i = 0; i < nd_ptr->nd_n; i++ ) {
			nd_ptr->nd_nums[i] =
				find_node( nd_ptr->nd_labs[i] );
			if( nd_ptr->nd_nums[i] == -1 ) {
				printf("*** %s %s, node \"%s\" not found ***\n\n",
					type_names[nd_ptr->nd_type],
					nd_ptr->nd_label,
					nd_ptr->nd_labs[i] );
				desc_err( "*** non-existent node referenced");
			}
		}
	}
	/* count references to nodes */
	for( i = 0; i < n_nodes; i++ ) temp[i] = 0;
	for( i = 0; i < n_nodes; i++ ) {
		nd_ptr = node[i];
		if( nd_ptr->nd_type == TYPE_MENU ) {
			for( j = 0; j < nd_ptr->nd_n; j++ ) {
				temp[nd_ptr->nd_nums[j]]++;
			}
		}
	}
	/* check all nodes are referenced */
	for( i = 0; i < n_nodes; i++ ) {
		if( temp[i] == 0 ) {
			nd_ptr = node[i];
			if( !strcmp(nd_ptr->nd_label,"main")
				&& !strcmp(nd_ptr->nd_label,"Short_Cuts") ) {
				printf("*** Node \"%s\" Unreferenced\n",
					nd_ptr->nd_label );
				sleep(2);
			}
		}
	}
}
