
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <stdio.h>

#include "getch7.h"
#include "menu.h"
#include "misc.h"
#include "node.h"

MENU *current_menu;

display_menu( menu )
MENU *menu;
{
	int i;
	char *ptr;
	char temp[MAX_TITLE_LEN+1];
	static char *line_nums[] = {
		" 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8",
		" 9", "10", "11", "12", "13", "14", "15", "16" };
	char **nptr;
	int is_short_cuts;

	current_menu = menu;
	clear();
	strcpy( temp, menu->mn_title );
	/* chop off trailing '/' */
	temp[ strlen(temp) - 1 ] = '\0';
	mvaddstr( 0, 15, HEADER );
	mvaddstr( 2, 15, temp );

	is_short_cuts = ( short_cut_menu == menu );

	/* write out the menu lines */
	for( i = 0, nptr = line_nums;
				i < MAX_MENU_ENTRIES && i < menu->mn_nrows;
				i++, nptr++ ) {
		ptr = menu->mn_line[i];
		if( is_short_cuts && i > 0 ) {
			mvaddch( i + 4, 5, '\'' );
			addch( menu_letter[i] );
			addstr( "': " );
		} else {
			mvaddstr( i + 4, 5, *nptr );
			addstr( ".  " );
		}
		addstr( ptr );
		clrtoeol();
	}
	bottom_line();

	arrow_draw( cur_line_no );
	refresh();
}

#define Add_Bold( string ) standout(); addstr( string ); standend();

bottom_line()
{
	mvaddstr( LINES-1, 0, "Press " );
	Add_Bold( "?" );
	addstr( " and ");
	Add_Bold( "*" );
	addstr( " for Help, " );
	Add_Bold( "q" );
	addstr(" to Quit, " );
	if( cur_level > 0 ) {
		Add_Bold( "u" );
		addstr(" to go up a menu, ");
	}
	Add_Bold( "v" );
	addstr(" to view shortcuts");

	clrtoeol();
	refresh();
}

int
check_quit()
{
	int c = 0;

	mvaddstr( LINES-1, 0,
		"Really quit the UCLink Menu System (y/n) ? y" );
	clrtoeol();
	refresh();
	move( LINES-1, 43 );
	refresh();

	while( 1 ) {
		raw();
		GETCH7( c );
		noraw();
		if( c == 'y' || c == '\r' || c == '\n' ) {
			return(1);
		} else if ( c == 'n' ) {
			return(0);
		}
		ring_bell();
	}
}

arrow_move( old_row, new_row )
int old_row, new_row;
{
	arrow_erase( old_row );
	arrow_draw( new_row );
}

arrow_draw( line )
int line;
{
	mvaddstr( line + 4, 1, "-->" );
	refresh();
}

arrow_erase( line )
int line;
{
	mvaddstr( line + 4, 1, "   " );
	refresh();
}
