
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <stdio.h>

#include "node.h"

print_tree( top_num, depth )
int top_num, depth;
{
	NODE *nd_ptr;
	int i, j;

	nd_ptr = node[top_num];
	for( i = 0; i < depth; i++ ) printf("     ");
	printf("%s\n", nd_ptr->nd_title);
	if( nd_ptr->nd_type == TYPE_MENU ) {
		depth++;
		for( j = 0; j < nd_ptr->nd_n; j++ ) {
			print_tree( nd_ptr->nd_nums[j], depth );
		}
	}

}

dump_nodes()
{
	NODE *nd_ptr;
	int i, node_num;
	static char *type_names[3] = { "***", "MENU", "COMMAND" };

	for( node_num = 0; node_num < n_nodes; node_num++ ) {
		nd_ptr = node[node_num];
		printf("\nnode %2d: type=%s,name=%s,title=%s\n",
			node_num,
			type_names[nd_ptr->nd_type],
			nd_ptr->nd_label,
			nd_ptr->nd_title );
		for( i = 0; i < nd_ptr->nd_n; i++ )  {
			printf("\t%3d: %3d %s\n",
				i, nd_ptr->nd_nums[i], nd_ptr->nd_labs[i] );
		}
	}
}
