#ifdef TEST_LIBIO
#include <iostdio.h>
#else
#ifdef __cplusplus
#include <strstream.h>
#else
#include <stdio.h>
#endif
#endif /* !TEST_LIBIO */

/* Tests taken from Cygnus C library. */

typedef struct
{
  int line;
  double value;
  char *result;
  char *format_string;
} sprint_double_type;

sprint_double_type sprint_doubles[] = 
{
__LINE__,  30.3,			"<          +30.3>", "<%+15.10g>",
__LINE__,  10.0,			"<10.00>", "<%5.2f>",

__LINE__,  1.002121970718271e+05,	"100212.19707   ", "%0-15.5f",
__LINE__, -1.002121970718271e+05,	"-100212.19707  ", "%0-15.5f",
__LINE__,  1.002121970718271e+05,	"000100212.19707", "%015.5f",
__LINE__, -1.002121970718271e+05,	"-00100212.19707", "%015.5f",
__LINE__,  1.002121970718271e+05,	"+00100212.19707", "%+015.5f",
__LINE__, -1.002121970718271e+05,	"-00100212.19707", "%+015.5f",
__LINE__,  1.002121970718271e+05,	" 00100212.19707", "% 015.5f",
__LINE__, -1.002121970718271e+05,	"-00100212.19707", "% 015.5f",
__LINE__,  1.002121970718271e+05,	"+100212.19707  ", "%+-15.5f",
__LINE__, -1.002121970718271e+05,	"-100212.19707  ", "%+-15.5f",

__LINE__, -1.002121970718271e+29,	"-1.0E+29", "%.1E",
__LINE__, -1.002126048612756e-02,	"-1.002126E-02", "%+#E",
__LINE__, -1.002653755271637e+00,	"-1.00265", "%G",
__LINE__, -1.003238744365917e-23,	"-0.00", "%4.2f",
__LINE__, -1.005084840877781e-29,	"  -0", "%4.f",
__LINE__, -1.005362549674427e+01,	"-10.0536", "%#g",
__LINE__, -1.005915042991691e-17,	"-1.00592E-17", "%G",
__LINE__, -1.007829874228503e-18,	"-1.00783e-18", "%.7g",
__LINE__, -1.007829874228503e-18,	"-1.007830e-18", "%#.7g",
__LINE__, -1.009390937771849e+15,	"-1009390937771848.628657", "%+f",
__LINE__, -1.010679382726182e-29,	"-0.0000000", "%.7f",
__LINE__, -1.010691853346650e+13,	"-10106918533466.497934", "%+f",
__LINE__, -1.013412912122286e-22,	"-1.01E-22", "%.2E",
__LINE__, -1.019269582113858e-25,	"  -0", "%4.0f",
__LINE__, -1.019886033368556e+24,	"-1.019886E+24", "%+.7G",
__LINE__, -1.021037413548719e+02,	"-102.103741", "%f",
__LINE__, -1.023833576089065e+26,	"-1.023834E+26", "%+E",
__LINE__, -1.024736652408627e+10,	"-10247366524.086265", "%+f",
__LINE__, -1.025439198495476e+09,	"-1.02544e+09", "%+g",
__LINE__, -1.027080247585776e-04,	"-0.0001027", "%6.7f",
__LINE__, -1.028096307262016e+18,	"-1.0281E+18", "%3G",
__LINE__, -1.029604290697901e-02,	"-0.010296", "%g",
__LINE__, -1.034347730570491e+16,	"-10343477305704908.975059", "%+f",
__LINE__, -1.034663325049286e+22,	"-1.0E+22", "%#.1E",
__LINE__, -1.034843152721857e-14,	"    -0", "%6.f",
__LINE__, -1.036082122299529e-29,	"-1.04e-29", "%4.3g",
__LINE__, -1.037213662365954e-09,	"-1e-09", "%3.e",
__LINE__, -1.038563976775690e-12,	"-0.000000", "%f",
__LINE__, -1.040910158681323e-02,	"-0.0104091", "%+G",
__LINE__, -1.044680094714482e-20,	"-1.04468E-20", "%G",
__LINE__, -1.044990054091126e+24,	"-1.044990E+24", "%+E",
__LINE__, -1.045693871096982e+11,	"-1.045694e+11", "%+e",
__LINE__, -1.045714133591312e-04,	"-0.000104571", "%+#3g",
__LINE__, -1.046215079103016e-15,	"-1.04622e-15", "%g",
__LINE__, -1.046285293993789e-18,	"-1.04629E-18", "%+4G",
__LINE__, -1.046306092899333e-06,	"-0.00", "%0.2f",
__LINE__, -1.047308973649206e-22,	"-1.05E-22", "%+1.3G",
__LINE__, -1.047369032507755e+01,	"-1.047369E+01", "%E",
__LINE__, -1.048986365562919e-21,	"-1.05E-21", "%+.2E",
__LINE__, -1.049530193156793e-17,	"-1.04953E-17", "%+G",
__LINE__, -1.050073419263768e+25,	"-1.05007e+25", "%g",
__LINE__, -1.051739652002504e-28,	"-0.000000", "%+f",
__LINE__, -1.054493420082636e+21,	"-1.0545e+21", "%#5.4e",
__LINE__, -1.055867291029098e+18,	"-1.05587e+18", "%g",
__LINE__, -1.056514389757866e-16,	"-1.05651E-16", "%5.6G",
__LINE__, -1.057180924868704e+15,	"-1057180924868704", "%4.f",
__LINE__, -1.058455468395683e-23,	"-1.05846e-23", "%g",
__LINE__, -1.062560982393212e+08,	"-1.06256e+08", "%g",
__LINE__, -1.063365829241138e-10,	"-1.063366e-10", "%+e",
__LINE__, -1.063568908667280e-19,	"-1.06357E-19", "%+G",
__LINE__, -1.063734263253492e-13,	"-0.000000", "%0f",
__LINE__, -1.064472689765495e-13,	"-1E-13", "%4.0G",
__LINE__, -1.067192610000129e-25,	"-1.06719E-25", "%G",
__LINE__, -1.068401334996592e-12,	"-0.0000000", "%+.7f",
__LINE__, -1.069012628653724e-13,	"-1.069013E-13", "%+.7G",
__LINE__, -1.069451976810790e+16,	"-10694519768107904.056365", "%f",
__LINE__, -1.069568935323556e+17,	"-1.06957e+17", "%g",
__LINE__, -1.071351044854107e-29,	"-1.07135e-29", "%g",
__LINE__, -1.072274197526185e-21,	"-1E-21", "%1.G",
__LINE__, -1.073875921752995e+23,	"-1E+23", "%5.E",
__LINE__, -1.074835151152265e-12,	"-1.0748e-12", "%1.5g",
__LINE__, -1.075171047088241e-19,	"-1.07517E-19", "%#G",
__LINE__, -1.076258826412760e+22,	"-1.076259e+22", "%+e",
__LINE__, -1.076365103160401e+06,	"-1.07637E+06", "%+4.6G",
__LINE__, -1.076817750454633e+08,	"-1e+08", "%4.g",
__LINE__, -1.078615405755685e-30,	"-1e-30", "%4.g",
__LINE__, -1.078629622917468e-25,	"-1.078630e-25", "%e",
__LINE__, -1.079352432833170e+11,	"-107935243283", "%+2.f",
__LINE__, -1.081431147440215e+16,	"-10814311474402147.439378", "%+f",
__LINE__, -1.083042116905339e-16,	"-1.083e-16", "%.5g",
__LINE__, -1.085351710708553e-10,	"-1.085e-10", "%1.4g",
__LINE__, -1.085796045618276e+07,	"-1.085796e+07", "%e",
__LINE__, -1.087398259981007e+22,	"-1.0874e+22", "%g",
__LINE__, -1.087986044402224e-11,	"-1.087986e-11", "%e",
__LINE__, -1.090451848762709e-02,	"-1.090452e-02", "%e",
__LINE__, -1.091463236899737e+11,	"-1.091463E+11", "%#E",
__LINE__, -1.091617921737384e-29,	"-1.09162e-29", "%3g",
__LINE__, -1.092049328579047e-17,	"-1.092049E-17", "%E",
__LINE__, -1.093647615472090e+06,	"-1093647.61547", "%6.5f",
__LINE__, -1.094133175602384e-08,	"-1.1E-08", "%0.1E",
__LINE__, -1.095397916728214e-23,	"-1e-23", "%6.e",
__LINE__, -1.098958790437321e+02,	"-109.895879", "%+#f",
__LINE__, -1.100194638181594e-20,	"-1.100195e-20", "%e",
__LINE__, -1.102174253534260e+05,	"-1.1e+05", "%2.3g",
__LINE__, -1.102890180316350e-12,	"-1.10289e-12", "%+g",
__LINE__, -1.105582337418378e+00,	"-1.11", "%3.3g",
__LINE__, -1.110515122647056e+04,	"-1.E+04", "%#0.G",
__LINE__, -1.111365895262625e-18,	"-1e-18", "%0.g",
__LINE__, -1.112010622677495e+04,	"-11120.1", "%g",
__LINE__, -1.112580043156699e-23,	"-1.11258e-23", "%1g",
__LINE__, -1.112829057091303e+08,	"-1.11283e+08", "%+2g",
__LINE__, -1.115019046200472e+18,	"-1.1150190e+18", "%+#.7e",
__LINE__, -1.118078332268016e-13,	"-1.12E-13", "%1.3G",
__LINE__, -1.119113571963886e+08,	"-1.119114e+08", "%e",
__LINE__, -1.120102397563448e-15,	"-1.12e-15", "%.4g",
__LINE__, -1.120707480791434e-19,	"-1.12071e-19", "%g",
__LINE__, -1.124243676139007e-07,	"-0.000000", "%f",
__LINE__, -1.125025214608798e+15,	"-1.12503E+15", "%0G",
__LINE__, -1.126074395136447e+06,	"-1E+06", "%+.0G",
__LINE__, -1.127203019940870e-06,	"-0.000001", "%+#7f",
__LINE__, -1.130577648480677e+01,	"-1.130578e+01", "%e",
__LINE__, -1.131469694425240e-11,	"-1.13147e-11", "%#0.6g",
__LINE__, -1.132225023239752e+02,	"-113.223", "%G",
__LINE__, -1.133702113050128e+20,	"-1E+20", "%+3.E",
__LINE__, -1.135529466224404e-13,	"-1.13553e-13", "%#g",
__LINE__, -1.137587210063004e+21,	"-1e+21", "%.1g",
__LINE__, -1.140765637106361e-21,	"-1.1e-21", "%+.1e",
__LINE__, -1.141182595083699e-18,	"-0.000000", "%f",
__LINE__, -1.141695709120972e+00,	"-1.1417", "%3G",
__LINE__, -1.143199141708028e+18,	"-1143199141708027833", "%2.f",
__LINE__, -1.146712902056139e+21,	"-1146712902056139071760.298975", "%f",
__LINE__, -1.146837903839073e-02,	" -0.0", "%+5.1f",
__LINE__, -1.147363016107446e+10,	"-1.14736e+10", "%+7g",
__LINE__, -1.149575523465052e+20,	"-114957552346505220697.28140", "%+.5f",
__LINE__, -1.152748955392589e+13,	"-1.15275E+13", "%G",
__LINE__, -1.152751106015483e-17,	"-1E-17", "%+3.E",
__LINE__, -1.155539139258226e-18,	"-1.2e-18", "%+.2g",
__LINE__, -1.157089280563492e+20,	"-1.15709e+20", "%g",
__LINE__, -1.161217745859779e+19,	"-1.161218E+19", "%E",
__LINE__, -1.162293536734798e+10,	"-11622935367.347980", "%f",
__LINE__, -1.162629909468603e+20,	"-1.16E+20", "%.3G",
__LINE__, -1.164979155838631e+24,	"-1.16498E+24", "%G",
__LINE__, -1.165103052644816e-20,	" -1e-20", "%+7.g",
__LINE__, -1.166448459023264e-08,	"-0.000000", "%f",
__LINE__, -1.167694506705309e+28,	"-1e+28", "%.1g",
__LINE__, -1.169901754818745e-28,	"-0.000000", "%+f",
__LINE__, -1.170330336216446e+08,	" -1e+08", "%7.g",
__LINE__, -1.170946623214213e-17,	"-1.17095E-17", "%G",
__LINE__, -1.174581596799302e+27,	"-1.174582e+27", "%+e",
__LINE__, -1.174763473995155e-28,	"-1E-28", "%.1G",
__LINE__, -1.175885640508038e-23,	"-1E-23", "%+.0E",
__LINE__, -1.177268411775439e-05,	"-0.000012", "%#2.6f",
__LINE__, -1.177739669428001e-30,	"-1.17774E-30", "%G",
__LINE__, -1.178059639880544e-02,	"-0.0117806", "%+.7G",
__LINE__, -1.178793300854446e-13,	"-1.2E-13", "%+#0.2G",
__LINE__, -1.179629345138058e-04,	"-0.000118", "%0.3g",
__LINE__, -1.180730292213358e-25,	"-1.18073e-25", "%g",
__LINE__, -1.180766261654697e+02,	"-118.077", "%3g",
__LINE__, -1.181880261069391e-29,	"-1.181880e-29", "%+#e",
__LINE__, -1.183752810063514e-09,	"-1.18375e-09", "%#g",
__LINE__, -1.184191742443406e-21,	"-1.184192e-21", "%e",
__LINE__, -1.184859760488406e-26,	"-1.18486E-26", "%G",
__LINE__, -1.187276828720072e-29,	"-1.18728E-29", "%G",
__LINE__, -1.187992907205195e-04,	"-1.187993E-04", "%E",
__LINE__, -1.190586192763405e-28,	"-1.E-28", "%#1.E",
__LINE__, -1.192104053032086e+02,	"-119.21", "%G",
__LINE__, -1.192917884333569e+26,	"-1.192918E+26", "%E",
__LINE__, -1.195900753509801e+22,	"-1.1959e+22", "%g",
__LINE__, -1.196559413116537e-28,	"-0.000000", "%6.6f",
__LINE__, -1.197534588732952e+12,	"-1.19753e+12", "%#g",
__LINE__, -1.200279514790649e-25,	"-0.0000", "%0.4f",
__LINE__, -1.203806667944635e+10,	"-1.2038067E+10", "%5.7E",
__LINE__, -1.204344885974736e+07,	"-1.204E+07", "%#2.4G",
__LINE__, -1.205668007693083e+00,	"-1.20567", "%g",
__LINE__, -1.205898515218947e-11,	"-1.2059e-11", "%+g",
__LINE__, -1.206787414909373e-05,	"-1.2e-05", "%2.2g",
__LINE__, -1.207905830366447e+15,	"-1.207906e+15", "%6.7g",
__LINE__, -1.208067010597729e-17,	"-1.208067e-17", "%5e",
__LINE__, -1.210189135822574e+01,	"-12", "%+2.0f",
__LINE__, -1.211560695948122e+10,	"-1.21156e+10", "%+g",
__LINE__, -1.214003025273234e-18,	"-1.214e-18", "%+g",
__LINE__, -1.214096815259005e+17,	"-121409681525900459.142520", "%f",
__LINE__, -1.214699041716797e-14,	"-1.2147E-14", "%G",
__LINE__, -1.215061611919443e+14,	"-121506161191944.306310", "%+#f",
__LINE__, -1.217491221065185e+27,	"-1.21749e+27", "%g",
__LINE__, -1.218538401534388e-11,	"-1.218538e-11", "%#e",
__LINE__, -1.218810085883466e+16,	"-1e+16", "%+.1g",
__LINE__, -1.219422688169801e+08,	"-1.219423e+08", "%e",
__LINE__, -1.220473194407651e-14,	"-1.2205E-14", "%1.5G",
__LINE__, -1.220824440193375e-02,	"-0.012208", "%4f",
__LINE__, -1.221520240637007e+13,	"-1.221520E+13", "%1E",
__LINE__, -1.221894719843486e+29,	"-1.22189E+29", "%G",
__LINE__, -1.223020108610281e+25,	"-1.22302E+25", "%G",
__LINE__, -1.223203206227728e-02,	"-0.012232", "%G",
__LINE__, -1.225661737076919e-15,	"-1.22566E-15", "%G",
__LINE__, -1.228147221003795e-08,	"-1.22815E-08", "%G",
__LINE__, -1.228298534591771e+20,	"-1.22830E+20", "%#G",
__LINE__, -1.228469080229780e-02,	"-0.012285", "%0f",
__LINE__, -1.229161950699222e-09,	"-1e-09", "%0.e",
__LINE__, -1.231294820136559e-17,	"-1.231295E-17", "%1.7G",
__LINE__, -1.232588663406698e-21,	"-1E-21", "%+0.G",
__LINE__, -1.233381256982191e-26,	"-0.000000", "%f",
__LINE__, -1.233435864835578e+14,	"-1.23344e+14", "%#g",
__LINE__, -1.237409567806099e-25,	"-1.23741E-25", "%#G",
__LINE__, -1.238244697758558e-02,	"-1.238245e-02", "%7e",
__LINE__, -1.239393163123284e+26,	"-1.23939e+26", "%+g",
__LINE__, -1.240484781756132e-18,	"-1E-18", "%4.E",
__LINE__, -1.241420286838750e+23,	"-1E+23", "%2.E",
__LINE__, -1.243781122052343e-18,	"-1.243781e-18", "%+e",
__LINE__, -1.244421506844779e+07,	"-1.244422E+07", "%+6E",
__LINE__, -1.245754054764741e-21,	"-1e-21", "%5.0g",
__LINE__, -1.245992228426733e-24,	"-0.000000", "%f",
__LINE__, -1.246498277739883e-12,	"-0.0000000", "%5.7f",
__LINE__, -1.247130891343776e-18,	"-1.24713E-18", "%G",
__LINE__, -1.247309461703025e-03,	"-0.0012473", "%#5.5G",
__LINE__, -1.248139162966407e-29,	"-1.e-29", "%+#6.g",
__LINE__, -1.249756153623776e+08,	"-1.249756e+08", "%e",
__LINE__, -1.250899983565585e-10,	"-1.2509e-10", "%5g",
__LINE__, -1.250957368798327e+19,	"-1.25096E+19", "%0G",
__LINE__, -1.252630814464822e-02,	"-0.012526", "%+f",
__LINE__, -1.253076368257011e-28,	"-0.000000", "%f",
__LINE__, -1.254243507039370e+01,	"-1.254244e+01", "%e",
__LINE__, -1.257605614492298e-12,	"-1.257606E-12", "%6.7G",
__LINE__, -1.258041911573120e+06,	"-1258041.911573", "%+f",
__LINE__, -1.261670983426507e-25,	"-0.00", "%.2f",
__LINE__, -1.263216883336562e-14,	"-1.26322e-14", "%g",
__LINE__, -1.266846944498751e-15,	"-1e-15", "%0.g",
__LINE__, -1.266977908502326e+06,	"-1266978", "%+1.f",
__LINE__, -1.267006162870084e-23,	"-1.267006e-23", "%e",
__LINE__, -1.269144609375931e+01,	"-1.269145e+01", "%+e",
__LINE__, -1.269458714257904e+25,	"-1.26946E+25", "%G",
__LINE__, -1.276697325772662e-02,	"-0.0128", "%7.3G",
__LINE__, -1.278855081807602e+15,	"-1278855081807601.87891", "%#0.5f",
__LINE__, -1.278966821639612e+20,	"-1.278967E+20", "%3E",
__LINE__, -1.281942705258106e+03,	"-1281.94", "%+G",
__LINE__, -1.282331291499203e+14,	"-128233129149920.266343", "%+f",
__LINE__, -1.285125739341808e-28,	"-1.28513e-28", "%g",
__LINE__, -1.285700693704978e+11,	"-1.285701E+11", "%E",
__LINE__, -1.286574096459251e+28,	"-1.287E+28", "%6.4G",
__LINE__, -1.287967889247240e+03,	"-1287.97", "%G",
__LINE__, -1.288913808801319e-27,	"-1.3e-27", "%7.1e",
__LINE__, -1.289147517760377e-18,	"-1.289148E-18", "%E",
__LINE__, -1.289355006600107e+23,	"-1.28936E+23", "%+G",
__LINE__, -1.291232014623979e+01,	"-1.29123E+01", "%+.5E",
__LINE__, -1.293658562875966e-18,	"-1.29366e-18", "%+g",
__LINE__, -1.294982911983638e-19,	"-1.29498E-19", "%#G",
__LINE__, -1.296123363481695e-13,	"-1.296123E-13", "%E",
__LINE__, -1.296632862070602e-20,	"-1.29663e-20", "%+g",
__LINE__, -1.297801639022777e+23,	"-129780163902277735132884.11777", "%#0.5f",
__LINE__, -1.297886574534611e+16,	"-1.297887e+16", "%+e",
__LINE__, -1.300588216308401e+11,	"-1.30e+11", "%.2e",
__LINE__, -1.301296100909062e-10,	"-1.3013e-10", "%+g",
__LINE__, -1.303144244306468e-07,	"-1.303144E-07", "%E",
__LINE__, -1.304096315024042e-20,	"-1.3041E-20", "%+G",
__LINE__, -1.304817970675085e+16,	"-1.304818E+16", "%+E",
__LINE__, -1.304870304632683e-15,	" -1e-15", "%7.g",
__LINE__, -1.305213586757638e-18,	"-1.30521e-18", "%g",
__LINE__, -1.306880734910465e-22,	"-1.306881E-22", "%E",
__LINE__, -1.308964092631446e-23,	"-1.30896e-23", "%g",
__LINE__, -1.312070555198201e+26,	"-131207055519820126043839537", "%+7.f",
__LINE__, -1.312511609151056e-30,	"-1.312512E-30", "%#E",
__LINE__, -1.313087359008389e-23,	"-0.000000", "%+f",
__LINE__, -1.316948423042059e-02,	"-1.316948E-02", "%+E",
__LINE__, -1.317080882577385e+29,	"-1.317E+29", "%+.4G",
__LINE__, -1.317514598984346e+24,	"-1.317515e+24", "%e",
__LINE__, -1.317817551125923e-21,	"-1.31782E-21", "%+G",
__LINE__, -1.319603985988120e+29,	"-131960398598811989856471882376.354188", "%f",
__LINE__, -1.328850458671907e+06,	"-1e+06", "%.0e",
__LINE__, -1.328945346449817e-23,	"-1.328945e-23", "%+e",
__LINE__, -1.330146584094221e-08,	"-1e-08", "%+5.g",
__LINE__, -1.332609617892115e+00,	"-1.33261", "%2.7G",
#ifndef __PCCNECV70__
__LINE__, -1.332751724965715e+22,	"-13327517249657150344432.920974", "%f",
__LINE__, -1.333194379353273e-19,	"-0.000000", "%f",
__LINE__, -1.334304387932777e-06,	"-1.334304e-06", "%e",
__LINE__, -1.334306581172082e-05,	"-1.3e-05", "%+1.2g",
__LINE__, -1.335283510893438e-05,	" -1E-05", "%7.G",
__LINE__, -1.337939692108373e+11,	"-1.33794e+11", "%+4g",
__LINE__, -1.339117288874809e-03,	"-0.001", "%1.3f",
__LINE__, -1.340100588141492e+27,	"-1.340101E+27", "%E",
__LINE__, -1.341953272572953e-19,	"-0.000000", "%+f",
__LINE__, -1.343058354301620e-02,	"-1.343058e-02", "%e",
__LINE__, -1.346662720871543e+22,	"-1.34666E+22", "%#G",
__LINE__, -1.354010578652210e-02,	"-0.0135401", "%#g",
__LINE__, -1.354066549307666e-12,	"    -0", "%+6.f",
__LINE__, -1.355284719365947e+21,	"-1.35528e+21", "%g",
__LINE__, -1.356326532145087e+29,	"-1E+29", "%4.G",
__LINE__, -1.357278618897291e+19,	"-13572786188972911780.581398", "%f",
__LINE__, -1.357537331348202e-10,	"-0.000", "%+.3f",
__LINE__, -1.360011287595868e-10,	"-0.000000", "%f",
__LINE__, -1.360506902899232e+16,	"-13605069028992320.", "%#5.f",
__LINE__, -1.361102570277000e+10,	"-1.3611E+10", "%G",
__LINE__, -1.362601255900219e+07,	"-1.363E+07", "%.4G",
__LINE__, -1.366078182354771e+10,	"-1.36608E+10", "%0G",
__LINE__, -1.366667926615127e+08,	"-136666792.661513", "%f",
__LINE__, -1.367162823743231e-12,	"-0.000000", "%#f",
__LINE__, -1.371523037550709e+09,	"-1.37152e+09", "%+g",
__LINE__, -1.374328925986197e-17,	"-1.37e-17", "%.2e",
__LINE__, -1.374995603898421e-26,	"-1.375e-26", "%+g",
__LINE__, -1.376726539375688e+09,	"-1.376727E+09", "%+E",
__LINE__, -1.378351117694958e-13,	"-0.000000", "%f",
__LINE__, -1.378514699313619e-14,	"-1.378515e-14", "%e",
__LINE__, -1.379347588942324e-23,	"-1.4e-23", "%+.1e",
__LINE__, -1.380380583822272e-17,	"-0.000000", "%+f",
__LINE__, -1.381658659947406e+19,	"-1.38166e+19", "%g",
__LINE__, -1.382775316390237e+29,	"-138277531639023653298181670834.3104", "%+#7.4f",
__LINE__, -1.383541138922400e+00,	"-1.383541E+00", "%E",
__LINE__, -1.384625301445090e+01,	"-13.8", "%+.3g",
__LINE__, -1.386844086284027e-13,	"-1.38684E-13", "%+G",
__LINE__, -1.386930516448650e-28,	"-1.386931E-28", "%E",
__LINE__, -1.387444896054260e-07,	"-1.38744E-07", "%G",
__LINE__, -1.389685107980798e+22,	"-1.38969E+22", "%G",
__LINE__, -1.390880300369347e+03,	"-1390.880300", "%f",
__LINE__, -1.391423370198150e-17,	"-1E-17", "%+2.G",
__LINE__, -1.394441767471218e-09,	"-1.394442e-09", "%e",
__LINE__, -1.396275525062527e-20,	"-1.39628E-20", "%G",
__LINE__, -1.397045957455157e+24,	"-1E+24", "%.0E",
__LINE__, -1.397458546930799e+21,	"-1397458546930798526375.383517", "%f",
__LINE__, -1.397584578988941e-14,	"-1.39758e-14", "%5g",
__LINE__, -1.397789397300823e+09,	"-1.398e+09", "%.4g",
__LINE__, -1.398167472294874e+21,	"-1.398167E+21", "%+7E",
__LINE__, -1.398809636136688e-16,	"-0.000000", "%+f",
__LINE__, -1.399545335304119e+26,	"-139954533530411872277454676.805064", "%#5f",
__LINE__, -1.400102603335755e+20,	"-140010260333575509150.705329", "%2f",
__LINE__, -1.401212746235235e+04,	"-1.401213e+04", "%e",
__LINE__, -1.404409427681801e+07,	"-1E+07", "%4.E",
__LINE__, -1.406018114263948e-25,	"-1e-25", "%3.e",
__LINE__, -1.406245608096877e-06,	"-1.4e-06", "%+.1e",
__LINE__, -1.410697254683835e-10,	"-1.410697e-10", "%e",
__LINE__, -1.410739097553846e+25,	"-1.410739E+25", "%+E",
__LINE__, -1.410850631189577e+04,	"-14108.5", "%.6g",
__LINE__, -1.411680434455781e+28,	"-14116804344557807304738616949.180141", "%f",
__LINE__, -1.413309465660099e-27,	"-1.413309E-27", "%+#E",
__LINE__, -1.418468741386300e+09,	"-1418468741.386300", "%f",
__LINE__, -1.420277110892909e+06,	"-1.42028e+06", "%1g",
__LINE__, -1.420417889565590e-17,	"-1.42E-17", "%.2E",
__LINE__, -1.421098212056305e+08,	"-1.421098e+08", "%4e",
__LINE__, -1.421792812798986e-20,	" -1E-20", "%7.G",
__LINE__, -1.423675488122461e+18,	"-1423675488122461363.360571", "%f",
__LINE__, -1.423810545840653e+15,	"-1E+15", "%3.E",
__LINE__, -1.424242673476368e-15,	"-1.424243e-15", "%e",
__LINE__, -1.427847435688733e-01,	"-1.427847E-01", "%E",
__LINE__, -1.433897734612555e-04,	"-0.0001", "%3.g",
__LINE__, -1.434537754075696e-24,	"-1.435E-24", "%+0.3E",
__LINE__, -1.434774864809324e-24,	"-1E-24", "%2.E",
__LINE__, -1.435583851565142e-11,	"-1E-11", "%.0E",
__LINE__, -1.438791024010112e+11,	"-1.43879e+11", "%#.6g",
__LINE__, -1.439267565343777e+27,	"-1.4e+27", "%2.1e",
__LINE__, -1.439440602670449e+02,	"-143.944", "%G",
__LINE__, -1.439494412124925e+13,	"-14394944121249.251268", "%f",
__LINE__, -1.440032823245152e+10,	"-14400328232.451516", "%f",
__LINE__, -1.440174494009562e-08,	"-0.000000", "%7f",
__LINE__, -1.440827804010568e+07,	"-1.E+07", "%#6.1G",
__LINE__, -1.442760907195336e+09,	"-1.44276E+09", "%+5G",
__LINE__, -1.444655304181403e+10,	"-14446553041.814035", "%7f",
__LINE__, -1.444995766787036e+04,	"-14450", "%5G",
__LINE__, -1.445078682874535e-13,	"-1E-13", "%3.E",
__LINE__, -1.446781469662328e+01,	"-14.4678", "%G",
__LINE__, -1.447795251395321e-04,	"-0.000145", "%+f",
__LINE__, -1.448193079247108e-02,	"-0.014", "%4.2G",
__LINE__, -1.449552967961345e+14,	"-1E+14", "%1.E",
__LINE__, -1.451269763513571e+10,	"-14512697635.135705", "%6f",
__LINE__, -1.451843176990292e+12,	"-1e+12", "%1.g",
__LINE__, -1.452631405935931e+06,	"-1.452631e+06", "%e",
__LINE__, -1.452753650285897e+21,	"-1452753650285897091265.496783", "%5f",
__LINE__, -1.453811512433860e-05,	"-1e-05", "%+6.g",
__LINE__, -1.454071430557372e+13,	"-1.4541E+13", "%.4E",
__LINE__, -1.455956079562999e+03,	"-1455.96", "%G",
__LINE__, -1.459712196146602e-17,	"-1.45971e-17", "%g",
__LINE__, -1.461857733495947e-02,	"-1.4619E-02", "%.4E",
__LINE__, -1.465257069090911e-11,	"-1.465257E-11", "%+E",
__LINE__, -1.465306607257042e+05,	"-146531", "%g",
__LINE__, -1.465857076315921e+20,	"-1.46586E+20", "%+G",
__LINE__, -1.467919792051489e+16,	"-1.46792e+16", "%2g",
__LINE__, -1.469271519834567e+20,	"-146927151983456720785", "%+.0f",
__LINE__, -1.472961447442697e-28,	"-1.47296e-28", "%#g",
__LINE__, -1.473385695190456e-12,	"-1.473386E-12", "%E",
__LINE__, -1.485003089033267e-10,	"-1.485E-10", "%2G",
__LINE__, -1.490541379072390e-18,	"-1.490541E-18", "%4E",
__LINE__, -1.490683434793125e+22,	"-14906834347931249951102.472551", "%#f",
__LINE__, -1.498356837215425e+20,	"-1.49836E+20", "%#G",
__LINE__, -1.498677007818122e+14,	"-1.49868E+14", "%+4G",
__LINE__, -1.502143197677119e+23,	"-150214319767711934616727.", "%#7.f",
__LINE__, -1.503563770470753e-24,	"-1.50356e-24", "%.6g",
__LINE__, -1.504643092793197e-18,	"-1.504643e-18", "%+4e",
__LINE__, -1.507017706254022e-13,	"-1.50702e-13", "%+g",
__LINE__, -1.507054033750081e-22,	"-0.000000", "%f",
__LINE__, -1.508662346022339e+16,	"-1.508662E+16", "%#E",
__LINE__, -1.509366882438902e+08,	"-2e+08", "%4.g",
__LINE__, -1.511086567087967e+20,	"-1.51109e+20", "%g",
__LINE__, -1.514959134622707e-18,	"-0.000000", "%+f",
__LINE__, -1.515730120364204e+06,	"-2E+06", "%0.G",
__LINE__, -1.516372763118606e-09,	"-1.51637e-09", "%g",
__LINE__, -1.520610443546204e+27,	"-1.52061e+27", "%g",
__LINE__, -1.522040655642012e+11,	"-1.52204E+11", "%+2G",
__LINE__, -1.523772495014966e-24,	"-2E-24", "%2.G",
__LINE__, -1.523980825983892e-05,	"-0.000", "%2.3f",
__LINE__, -1.526696214603152e-03,	"-0.0015267", "%+6.5G",
__LINE__, -1.528680540769583e+00,	"-1.5287", "%0.5G",
__LINE__, -1.529951830525433e+08,	"-1.529952e+08", "%+e",
__LINE__, -1.533052896559935e+05,	"-153305", "%4.0f",
__LINE__, -1.533829640475152e-03,	"-0.00153383", "%+#g",
__LINE__, -1.535617804643105e-30,	"-1.535618e-30", "%e",
__LINE__, -1.537623698361821e+16,	"-15376236983618207.7875719", "%4.7f",
__LINE__, -1.544994895330616e+24,	"-1.54499e+24", "%g",
__LINE__, -1.545083356728403e+17,	"-1.545083e+17", "%e",
__LINE__, -1.545684535393879e+12,	"-1.55E+12", "%3.3G",
__LINE__, -1.545878334099427e+13,	"-15458783340994.268762", "%1f",
__LINE__, -1.547697185980564e-18,	"-1.5477e-18", "%.6g",
__LINE__, -1.548576527172579e-29,	"-1.5E-29", "%2.2G",
__LINE__, -1.549712227835891e+08,	"-1.549712e+08", "%#6.7g",
__LINE__, -1.550010819435335e-21,	"-1.55001E-21", "%G",
__LINE__, -1.551412476164257e+14,	"-1.551412E+14", "%E",
__LINE__, -1.553156638090030e+01,	" -2E+01", "%7.G",
__LINE__, -1.553733233064355e-01,	"-0.2", "%3.g",
__LINE__, -1.558391111609365e+00,	"-1.558391", "%+f",
__LINE__, -1.562004019284766e+15,	"-1.562E+15", "%6.5G",
__LINE__, -1.562195733239758e-16,	"-0.000000", "%f",
__LINE__, -1.563953339012525e-14,	"-1.56395E-14", "%1G",
__LINE__, -1.568317638534983e+18,	"-1.56832E+18", "%1G",
__LINE__, -1.568546851135348e+04,	"-15685.5", "%+#G",
__LINE__, -1.574297872228857e+18,	"-1.574298e+18", "%e",
__LINE__, -1.575696460196291e-21,	"-1.5757E-21", "%G",
__LINE__, -1.576324848379791e+25,	"-1.57632E+25", "%+G",
__LINE__, -1.577524395140843e+06,	"-1.5775E+06", "%.5G",
__LINE__, -1.585122856675091e+12,	"-1585122856675.091452", "%f",
__LINE__, -1.586734674395556e-02,	"-1.586735E-02", "%E",
__LINE__, -1.592602264315192e+22,	"-1.5926E+22", "%G",
__LINE__, -1.594121556700562e+05,	"-2E+05", "%+.0G",
__LINE__, -1.598538116193430e+22,	"-1.59854e+22", "%+g",
__LINE__, -1.605647463222382e+18,	"-1.6056E+18", "%.5G",
__LINE__, -1.610891449201191e+06,	"-1.6109E+06", "%#6.4E",
__LINE__, -1.614593168166818e-05,	"-1.61459E-05", "%G",
__LINE__, -1.615597722557325e-03,	"-0.001616", "%f",
__LINE__, -1.616038022182124e-29,	"-1.61604E-29", "%1G",
__LINE__, -1.618380771451625e-28,	"-2e-28", "%+1.g",
__LINE__, -1.620287456872150e+10,	"-1.620e+10", "%#7.3e",
__LINE__, -1.620469955611903e-29,	"-0.000000", "%f",
__LINE__, -1.622580720690927e+20,	"-1.622581E+20", "%+#E",
__LINE__, -1.622752500991079e-12,	"-1.622753E-12", "%E",
__LINE__, -1.622771933776459e+08,	"-1.6228E+08", "%+4.4E",
__LINE__, -1.623894567037391e+09,	"-1.623895e+09", "%#e",
__LINE__, -1.624021408185354e-25,	"-1.624E-25", "%.5G",
__LINE__, -1.624405320939366e-06,	"-1.62441e-06", "%+#g",
__LINE__, -1.631236208958857e-25,	"-1.631236e-25", "%#e",
__LINE__, -1.632165969536046e+20,	"-1.63217E+20", "%G",
__LINE__, -1.632859596256475e+06,	"-1.63286E+06", "%G",
__LINE__, -1.634371961703112e+06,	"-1.634372E+06", "%+E",
__LINE__, -1.637230383641845e+24,	"-1.63723e+24", "%#g",
__LINE__, -1.638081480475853e+17,	"-1.63808e+17", "%+g",
__LINE__, -1.638279690467673e+14,	"-163827969046767.325523", "%#f",
__LINE__, -1.640360249548215e-29,	"-1.64036e-29", "%+6.6g",
__LINE__, -1.645691728060833e-30,	"-1.64569e-30", "%g",
__LINE__, -1.648548965852592e-03,	"   -0", "%5.f",
__LINE__, -1.650100957771182e+21,	"-1650100957771182308420.065965", "%+f",
__LINE__, -1.650957176011913e-02,	"-0.016510", "%#4.5G",
__LINE__, -1.651165108095301e+29,	"-165116510809530137038336761179.380119", "%f",
__LINE__, -1.657132845094847e-06,	"-0.000002", "%f",
__LINE__, -1.657152146172541e+12,	"-1.657152E+12", "%.7G",
__LINE__, -1.658377345516132e-06,	"-0.00", "%.2f",
__LINE__, -1.658850468902324e+20,	"-1.659e+20", "%.4g",
__LINE__, -1.661723557149830e+18,	"-1.66172E+18", "%G",
__LINE__, -1.663570885140273e+14,	"-166357088514027", "%2.f",
__LINE__, -1.665186944896906e+25,	"-1.66519E+25", "%G",
__LINE__, -1.675910137717036e+22,	"-2e+22", "%5.g",
__LINE__, -1.677447987675587e-15,	"-1.67745E-15", "%G",
__LINE__, -1.677510590697220e+06,	"-1677510.590697", "%5f",
__LINE__, -1.677658141289510e-18,	"-2E-18", "%+5.G",
__LINE__, -1.678316848066192e-03,	"-1.678317E-03", "%E",
__LINE__, -1.681506404024821e+24,	"-1.68151E+24", "%G",
__LINE__, -1.688584243722160e+12,	"-1.68858E+12", "%+#G",
__LINE__, -1.689468295411408e+28,	"-1.68947E+28", "%+G",
__LINE__, -1.690746767470207e-11,	"-1.69075E-11", "%G",
__LINE__, -1.692773960755248e-14,	"-2E-14", "%4.E",
__LINE__, -1.693349092740995e-18,	"-1.69335e-18", "%g",
__LINE__, -1.693642321808920e-26,	"-1.69364E-26", "%G",
__LINE__, -1.694579128700042e-12,	"-0.000000", "%f",
__LINE__, -1.695454897264717e-08,	"-1.7E-08", "%+4.3G",
__LINE__, -1.695733278397589e+19,	"-1.695733e+19", "%4e",
__LINE__, -1.699522534409388e-05,	"-1.69952E-05", "%G",
__LINE__, -1.701752039544919e+00,	"-2", "%.0f",
__LINE__, -1.702304998615036e+16,	"-1.7023E+16", "%1G",
__LINE__, -1.703113580904556e-25,	"-1.703114e-25", "%+e",
__LINE__, -1.705165515454546e+29,	"-1.705166e+29", "%+e",
__LINE__, -1.707392568277288e-05,	"-1.70739E-05", "%G",
__LINE__, -1.707477319256742e+09,	"-1707477319.26", "%7.2f",
__LINE__, -1.709669107513969e-03,	" -0.002", "%7.g",
__LINE__, -1.713284011412432e-24,	"-1.713e-24", "%3.3e",
__LINE__, -1.715512203951086e-28,	"-1.715512E-28", "%E",
__LINE__, -1.716880832248879e+13,	"-1.71688e+13", "%+g",
__LINE__, -1.720722835740680e-15,	"-1.7E-15", "%.1E",
__LINE__, -1.721855769574895e+07,	"-17218557.695749", "%3f",
__LINE__, -1.722449437415368e+01,	"-1.722449e+01", "%e",
__LINE__, -1.723218805116591e-29,	"-2e-29", "%.0g",
__LINE__, -1.726129004920195e-05,	"-1.72613E-05", "%0G",
__LINE__, -1.727400228037571e-28,	"-0.0000000", "%2.7f",
__LINE__, -1.730008745782339e-23,	"-1.73e-23", "%.4g",
__LINE__, -1.731875670201859e+09,	"-1.73188E+09", "%G",
__LINE__, -1.732142976428085e+10,	"-2E+10", "%+6.0E",
__LINE__, -1.732699651229194e-02,	"-0.017327", "%5g",
__LINE__, -1.734772870736446e-12,	"-0.000000", "%+f",
__LINE__, -1.738576887938331e+09,	"-1.73858e+09", "%g",
__LINE__, -1.738759937912438e-08,	"-1.73876e-08", "%+2g",
__LINE__, -1.739320154069143e-18,	"-0.0000", "%1.4f",
__LINE__, -1.739870415800800e+16,	"-1.73987e+16", "%g",
__LINE__, -1.741290506928618e+04,	"-17412.9", "%G",
__LINE__, -1.742520800031913e+29,	"-1.742521e+29", "%7e",
__LINE__, -1.747620095195231e+01,	"-2e+01", "%+2.g",
__LINE__, -1.749860675924882e-21,	"-1.74986E-21", "%G",
__LINE__, -1.752675363661431e-06,	"-1.7527E-06", "%.5G",
__LINE__, -1.752871508059699e-06,	"     -0", "%7.f",
__LINE__, -1.755178530989839e+25,	"-1.7551785e+25", "%1.7e",
__LINE__, -1.755566213249512e-07,	"-1.755566e-07", "%.6e",
__LINE__, -1.756193485005071e-24,	"-1.75619E-24", "%+2.6G",
__LINE__, -1.758501410496218e+03,	"-1758.501", "%.7G",
__LINE__, -1.758795617219102e+20,	"-1.75880E+20", "%#6G",
__LINE__, -1.760538679276709e+03,	"-2e+03", "%+1.e",
__LINE__, -1.762660914833003e+27,	"-1.76266E+27", "%G",
__LINE__, -1.765122691141907e+19,	"-17651226911419071186.1", "%5.1f",
__LINE__, -1.765313277389086e-18,	"-2E-18", "%+1.E",
__LINE__, -1.765821717148734e+19,	"-1.76582E+19", "%G",
__LINE__, -1.767048687863149e-17,	"-1.77E-17", "%+.3G",
__LINE__, -1.768661645451962e+18,	"-1.77E+18", "%+.3G",
__LINE__, -1.769753257452233e+01,	"-17.6975", "%G",
__LINE__, -1.770945665065531e+28,	"-1.770946E+28", "%0.7G",
__LINE__, -1.776713865753894e-09,	"-2e-09", "%1.g",
__LINE__, -1.778424845787448e+03,	"-1.7784E+03", "%.4E",
__LINE__, -1.779060610701250e+06,	"-1.779061E+06", "%E",
__LINE__, -1.781447182110762e-27,	"-1.781447E-27", "%E",
__LINE__, -1.782655842123784e-13,	"-2.E-13", "%#2.1G",
__LINE__, -1.783071018169166e+16,	"-17830710181691664.217851", "%+f",
__LINE__, -1.784665985294415e+25,	"-2E+25", "%3.G",
__LINE__, -1.787297600658096e+25,	"-2E+25", "%+5.E",
__LINE__, -1.788200250255718e+12,	"-1.7882E+12", "%2.4E",
__LINE__, -1.792860730579114e-09,	"-1.79286E-09", "%G",
__LINE__, -1.793122797100936e+24,	"-1.793123e+24", "%e",
__LINE__, -1.793761706915029e-25,	"-0.000000", "%f",
__LINE__, -1.793947567431932e+22,	"-1.79395e+22", "%g",
__LINE__, -1.796428035404303e-18,	"-1.79643e-18", "%g",
__LINE__, -1.797113144273918e-16,	"-1.79711E-16", "%.6G",
__LINE__, -1.798796767828424e-29,	"-1.7988E-29", "%G",
__LINE__, -1.805004010633763e-11,	"-1.805e-11", "%2.5g",
__LINE__, -1.806936269752338e-26,	"-1.80694e-26", "%g",
__LINE__, -1.807122541760172e-10,	"-1.80712e-10", "%g",
__LINE__, -1.808295407815630e-06,	"-1.8083E-06", "%+G",
__LINE__, -1.813893236685959e+15,	"-1813893236685959", "%0.f",
__LINE__, -1.816201530145367e+06,	"-1816202", "%+2.f",
__LINE__, -1.822811219123512e+13,	"-1.82281e+13", "%g",
__LINE__, -1.826276499170243e-25,	"-2E-25", "%+3.G",
__LINE__, -1.832399287433839e-26,	"-1.832399E-26", "%#4E",
__LINE__, -1.833597815584463e-18,	"-0.000000", "%+3f",
__LINE__, -1.834165532712233e+28,	"-1.834166E+28", "%.7G",
__LINE__, -1.837633147831083e+28,	"-1.8376331e+28", "%.7e",
__LINE__, -1.839756716742518e-01,	"-0.2", "%+0.G",
__LINE__, -1.840101206950368e-14,	"-1.840101E-14", "%+E",
__LINE__, -1.842043645474877e+17,	"-1.84204e+17", "%+g",
__LINE__, -1.842155892969934e+17,	"-1.84216e+17", "%+g",
__LINE__, -1.843566073012842e-25,	"-1.84357E-25", "%G",
__LINE__, -1.843976321320497e-02,	"-0.02", "%+4.2f",
__LINE__, -1.845299931651554e+11,	"-1.8453E+11", "%0.4E",
__LINE__, -1.846199038659889e-06,	"-1.8462e-06", "%0.5g",
__LINE__, -1.847062180184169e-30,	"-1.847062E-30", "%5E",
__LINE__, -1.847962158722201e-16,	"-0.000000", "%f",
__LINE__, -1.849446376756582e+15,	"-1.8E+15", "%2.2G",
__LINE__, -1.853168465523878e-24,	"-2E-24", "%1.E",
__LINE__, -1.853601367230139e+10,	"-1.853601e+10", "%e",
__LINE__, -1.857367903775364e+18,	"-1.86E+18", "%1.3G",
__LINE__, -1.858332820633906e-05,	"-0.000019", "%7f",
__LINE__, -1.860243811657223e-23,	"-1.860244e-23", "%e",
__LINE__, -1.860660612539794e+08,	"-1.86066e+08", "%+6.5e",
__LINE__, -1.861160816251124e-09,	"-2E-09", "%1.G",
__LINE__, -1.862380636974688e-25,	"-1.9E-25", "%.2G",
__LINE__, -1.864168808453004e+15,	"-1.86417E+15", "%G",
__LINE__, -1.864273144411246e+07,	"-1.86427e+07", "%g",
__LINE__, -1.864929236615802e-02,	"-2e-02", "%+3.e",
__LINE__, -1.865010503480847e+19,	"-2E+19", "%4.G",
__LINE__, -1.866276374553144e+22,	"-1.866276e+22", "%e",
__LINE__, -1.870809567910649e+09,	"-1.870810e+09", "%e",
__LINE__, -1.872555495839008e-13,	"-1.872555E-13", "%3E",
__LINE__, -1.874465717110388e-22,	"-1.874466E-22", "%E",
__LINE__, -1.874916306627632e+21,	"-1874916306627632422987.517202", "%f",
__LINE__, -1.875804322194491e-23,	"-0.000000", "%+f",
__LINE__, -1.876662099198587e-04,	"-0.000187666", "%G",
__LINE__, -1.876775504795760e-25,	"-1.87678e-25", "%0g",
__LINE__, -1.879343051002554e-20,	"   -0.", "%#6.f",
__LINE__, -1.881535445774717e-15,	"-1.881535e-15", "%e",
__LINE__, -1.887515901404300e+00,	"-1.888", "%2.4G",
__LINE__, -1.887730637149009e+17,	"-1.887731E+17", "%E",
__LINE__, -1.889920303480086e+17,	"-1.889920e+17", "%+e",
__LINE__, -1.891903478784091e+04,	"-1.891903e+04", "%e",
__LINE__, -1.893550084305833e+16,	"-1.89355e+16", "%g",
__LINE__, -1.894675230197676e+05,	"-1.894675e+05", "%#e",
__LINE__, -1.898389624953187e-27,	"-1.898390e-27", "%+e",
__LINE__, -1.899250044644046e+21,	"-1899250044644046120367.875119", "%+4.6f",
__LINE__, -1.904187609804679e-02,	"-1.90419E-02", "%0.5E",
__LINE__, -1.904452538421193e-04,	"-2e-04", "%4.0e",
__LINE__, -1.904615326969061e-16,	"-1.904615e-16", "%1.7g",
__LINE__, -1.907761255064750e+02,	"-190.776126", "%f",
__LINE__, -1.910727641826707e-10,	" -2e-10", "%7.g",
__LINE__, -1.913149279262051e+15,	"-1.913149e+15", "%.7g",
__LINE__, -1.913235739298009e+28,	"-1.913236e+28", "%e",
__LINE__, -1.913526822735271e+18,	"-1.914e+18", "%.4g",
__LINE__, -1.913780977515583e+17,	"-191378097751558335.9150", "%5.4f",
__LINE__, -1.917095456962182e-10,	"-2E-10", "%4.G",
__LINE__, -1.918803033972851e+23,	"-191880303397285132405158.947222", "%f",
__LINE__, -1.926420984801848e+16,	"-19264209848018483.128840", "%+f",
__LINE__, -1.931905465942639e-10,	"-1.93191e-10", "%g",
__LINE__, -1.932907105840252e+06,	"-1.932907e+06", "%+#e",
__LINE__, -1.933091601918916e+15,	"-1.933092E+15", "%#E",
__LINE__, -1.934296184983361e+09,	"-1.9343e+09", "%1.6g",
__LINE__, -1.934637311832448e+11,	"-1.93464e+11", "%+g",
__LINE__, -1.936201483262186e+12,	"-2e+12", "%+6.g",
__LINE__, -1.939114661603911e+19,	"-1.93911E+19", "%G",
__LINE__, -1.940478182124347e-13,	"-0.000000", "%f",
__LINE__, -1.943218220654923e+08,	"-2E+08", "%+5.0G",
__LINE__, -1.943526872455779e-30,	"-1.9E-30", "%.1E",
__LINE__, -1.949869164681357e+19,	"-1.949869e+19", "%#3e",
__LINE__, -1.954181060535402e+23,	"-1.954181e+23", "%e",
__LINE__, -1.961581555579142e+14,	"-1.962E+14", "%.3E",
__LINE__, -1.964535562036915e+07,	"-1.96454E+07", "%G",
__LINE__, -1.969749653575926e+04,	"-19697.5", "%.6g",
__LINE__, -1.973475369169053e+15,	"-1.97348e+15", "%g",
__LINE__, -1.975658532866600e-21,	"-2e-21", "%+1.2g",
__LINE__, -1.984050343831260e+09,	"-1.984050E+09", "%E",
__LINE__, -1.984422410018571e+12,	"-1.984422e+12", "%+4.7g",
__LINE__, -1.984878687667223e-22,	"-0.000000", "%f",
__LINE__, -1.986116930967811e-28,	"-1.98612e-28", "%g",
__LINE__, -1.986774457812683e+02,	"-1.986774e+02", "%e",
__LINE__, -1.987274814938726e-04,	"-0.000198727", "%g",
__LINE__, -1.987319200580415e+10,	"-1.987319E+10", "%E",
__LINE__, -1.987980768698114e-19,	"-0.000000", "%3f",
__LINE__, -1.994698965044602e-29,	"-2E-29", "%+4.0G",
__LINE__, -1.997833122667050e+26,	"-1.99783E+26", "%G",
__LINE__, -1.999453681184129e-10,	"-0.00000", "%.5f",
__LINE__, -1.999897345839745e-16,	"-1.9999e-16", "%g",
__LINE__, -2.003703825123989e-22,	"-0.000000", "%f",
__LINE__, -2.004569188274957e-23,	"-2.00457E-23", "%G",
__LINE__, -2.005911883189058e+07,	"-2.00591E+07", "%G",
__LINE__, -2.006438312005722e-25,	"-2.006e-25", "%0.4g",
__LINE__, -2.017322171210280e+18,	"-2.01732E+18", "%+0G",
__LINE__, -2.017718635819594e-06,	"-2.01772e-06", "%5g",
__LINE__, -2.019187445568160e-12,	"-0.00", "%.2f",
__LINE__, -2.021022665608503e+25,	"-20210226656085028551501636.684", "%2.3f",
__LINE__, -2.022720393474145e+07,	"-2.02272E+07", "%#G",
__LINE__, -2.024506694471065e+23,	"-2.02451E+23", "%G",
__LINE__, -2.024884686553821e-15,	" -2e-15", "%7.g",
__LINE__, -2.027484636128966e-23,	"-2.0275E-23", "%.5G",
__LINE__, -2.028185530467237e+21,	"-2028185530467237374097.067", "%+4.3f",
__LINE__, -2.028388905566873e-09,	"-0.000000", "%f",
__LINE__, -2.029856507431584e-17,	"-2.02986E-17", "%G",
__LINE__, -2.029891733449167e+27,	"-2029891733449166846270372843.7190875", "%3.7f",
__LINE__, -2.031933616694469e+14,	"-2.031934E+14", "%#E",
__LINE__, -2.034011738471413e-10,	"-2.03401E-10", "%#G",
__LINE__, -2.036087355975756e+29,	"-203608735597575574161055556032.806635", "%+f",
__LINE__, -2.036355025137273e+09,	"-2.036355E+09", "%#.7G",
__LINE__, -2.038423730536878e+12,	"-2E+12", "%4.G",
__LINE__, -2.045209202278810e+23,	"-2.045209e+23", "%+#e",
__LINE__, -2.046794083517423e-06,	"-2.04679e-06", "%g",
__LINE__, -2.048042459678599e-19,	"-0.000000", "%f",
__LINE__, -2.050526462096153e+18,	"-2.05053e+18", "%+g",
__LINE__, -2.053583900249402e+13,	"-2.053584e+13", "%0.7g",
__LINE__, -2.054342100957522e-23,	"-2.05434E-23", "%#G",
__LINE__, -2.054793400141025e+11,	"-205479340014.1", "%+2.1f",
__LINE__, -2.059200689196498e-11,	"-0.000000", "%#f",
__LINE__, -2.060960692728114e-16,	"-0.000000", "%+f",
__LINE__, -2.061417528654300e-30,	"-2.06E-30", "%.3G",
__LINE__, -2.061513401198340e-29,	"-2.06151e-29", "%7g",
__LINE__, -2.061846698845984e+27,	"-2.061847E+27", "%E",
__LINE__, -2.063922242876789e-19,	"-2.06392e-19", "%#g",
__LINE__, -2.065359431805529e+03,	"-2065.359432", "%f",
__LINE__, -2.065529069992156e-04,	"-0.000206553", "%+G",
__LINE__, -2.066082546490980e-25,	"-2.06608e-25", "%5g",
__LINE__, -2.068394312095200e+17,	"-2.068394e+17", "%e",
__LINE__, -2.071024178556425e-10,	"-2.07102E-10", "%G",
__LINE__, -2.074401605950382e-22,	"-2.07e-22", "%1.3g",
__LINE__, -2.074731895144874e-26,	"-2.07473E-26", "%G",
__LINE__, -2.074895800882730e+18,	"-2074895800882730068.082083", "%+f",
__LINE__, -2.077336220500764e-30,	"-0", "%2.f",
__LINE__, -2.078067878561077e+09,	"-2.0781e+09", "%0.5g",
__LINE__, -2.080497889634533e+15,	"-2.080498E+15", "%4E",
__LINE__, -2.084717279367594e-21,	"-2.08472e-21", "%+g",
__LINE__, -2.087827915301948e+29,	"-2E+29", "%6.1G",
__LINE__, -2.090268686389680e+05,	"-2.090269e+05", "%1e",
__LINE__, -2.092036176589720e+24,	"-2.09204e+24", "%+g",
__LINE__, -2.093546373938615e-21,	"-2.093546e-21", "%#e",
__LINE__, -2.101302069316682e+18,	"-2.1013e+18", "%+7g",
__LINE__, -2.103463622286002e-13,	"-2.103464E-13", "%E",
__LINE__, -2.105622845016732e+06,	"-2105622.845017", "%1f",
__LINE__, -2.109999123037767e+28,	"-2.11E+28", "%.2E",
__LINE__, -2.110317013992166e+04,	"-21103.2", "%+g",
__LINE__, -2.112226142154618e+21,	"-2112226142154617569702.", "%#6.f",
__LINE__, -2.112519484486528e+06,	"-2.11252E+06", "%G",
__LINE__, -2.113439260812000e+23,	"-2E+23", "%1.G",
__LINE__, -2.113465893194608e-15,	"-2.1135E-15", "%.5G",
__LINE__, -2.113547784669409e+20,	"-2.1135e+20", "%2.5g",
__LINE__, -2.114146001321822e+28,	"-2.114146e+28", "%e",
__LINE__, -2.114509425574444e-30,	"  -0", "%4.f",
__LINE__, -2.114887421659561e-21,	"-0.000000", "%+f",
__LINE__, -2.121120215127601e+21,	"-2121120215127601404958.5683097", "%.7f",
__LINE__, -2.122555390665796e+06,	"-2E+06", "%0.G",
__LINE__, -2.123468430242052e-27,	"-0.000000", "%+f",
__LINE__, -2.123473598890635e+28,	"-2.12347e+28", "%+g",
__LINE__, -2.124328049748190e-04,	"-2.124328E-04", "%E",
__LINE__, -2.125633890999010e+28,	"-2E+28", "%+5.G",
__LINE__, -2.125697963566045e+21,	"-2.1257E+21", "%0G",
__LINE__, -2.127638109230109e+06,	"-2.12764e+06", "%+6g",
__LINE__, -2.128456114617786e+07,	"-2.128456E+07", "%E",
__LINE__, -2.128732742932824e-04,	"-2.128733E-04", "%#E",
__LINE__, -2.129654381588404e+27,	"-2129654381588404365999167566.7697564", "%+.7f",
__LINE__, -2.129792795009985e+20,	"-2.12979e+20", "%g",
__LINE__, -2.131026925664619e-20,	"-2e-20", "%.0e",
__LINE__, -2.132860730144188e-04,	"-0.0002", "%5.g",
__LINE__, -2.133620979309562e+06,	"-2e+06", "%3.e",
__LINE__, -2.133821423139120e-27,	"-2.13382E-27", "%.6G",
__LINE__, -2.134253401425940e-07,	"-0.000000", "%f",
__LINE__, -2.135469568156964e-29,	"-2.135470E-29", "%+7E",
__LINE__, -2.135723595288365e-25,	"-0.0", "%.1f",
__LINE__, -2.137642458920094e-09,	"-2.13764e-09", "%g",
__LINE__, -2.143412361116583e+12,	"-2.14341e+12", "%+g",
__LINE__, -2.144467087741129e-17,	"-2.14447e-17", "%+g",
__LINE__, -2.145726966596964e-11,	"-0.000000", "%2f",
__LINE__, -2.148318753042597e+08,	"-2.14832E+08", "%5G",
__LINE__, -2.149932310549644e-19,	"-2.14993e-19", "%g",
__LINE__, -2.150050917377646e-21,	" -0", "%3.f",
__LINE__, -2.150854313643430e-16,	"-0.000000", "%.6f",
__LINE__, -2.151071797121845e+00,	"-2.15107", "%+g",
__LINE__, -2.158728406865981e+14,	"-215872840686598.088666", "%7f",
__LINE__, -2.166062878011641e-23,	"-2.166063e-23", "%e",
__LINE__, -2.167045002060684e+12,	"-2.167045E+12", "%E",
__LINE__, -2.173752581051530e+20,	"-217375258105153035259.604621", "%f",
__LINE__, -2.175599129057555e+24,	"-2.175599E+24", "%E",
__LINE__, -2.176564454093042e-02,	"-0.0217656", "%+G",
__LINE__, -2.181270774327071e-12,	"-0.000000", "%#1f",
__LINE__, -2.184404769844158e-09,	"-2.2E-09", "%+.2G",
__LINE__, -2.184881476334310e-07,	"-2.18488e-07", "%g",
__LINE__, -2.189197211449684e-11,	"-2E-11", "%.0G",
__LINE__, -2.189451286805190e+20,	"-218945128680519029984", "%3.f",
__LINE__, -2.190642494146884e-27,	" -0.", "%#4.f",
__LINE__, -2.194727956725854e+06,	"-2.19E+06", "%.3G",
__LINE__, -2.196145868303877e+11,	"-219614586830.387726", "%+5f",
__LINE__, -2.196397972262690e-16,	"-0.000000", "%3f",
__LINE__, -2.202692843474668e-01,	"-2.203e-01", "%.3e",
__LINE__, -2.204528684782451e-21,	"-2.20453E-21", "%G",
__LINE__, -2.214926838821340e-16,	"-2e-16", "%+2.g",
__LINE__, -2.215558986352773e+18,	"-2215558986352773374", "%0.f",
__LINE__, -2.216976693056186e+27,	"-2216976693056186498154147557.215765", "%f",
__LINE__, -2.217348422793322e+13,	"-2.21735E+13", "%6G",
__LINE__, -2.217732695583920e-07,	"-0", "%.0f",
__LINE__, -2.221185494767834e-14,	"-2.22119e-14", "%g",
__LINE__, -2.224557193699609e-16,	"-2.224557E-16", "%E",
__LINE__, -2.227417758704028e-18,	"-0.000000", "%0f",
__LINE__, -2.231261655673006e-30,	"-2.231262E-30", "%E",
__LINE__, -2.233081938836160e+21,	"-2233081938836160240668.960", "%+6.3f",
__LINE__, -2.233158918439853e+05,	"-223316", "%2G",
__LINE__, -2.233802298007898e-30,	"-2.2338E-30", "%2G",
__LINE__, -2.233864858404732e+17,	"-223386485840473181.241350", "%f",
__LINE__, -2.241242805107749e+14,	"-2.24124E+14", "%G",
__LINE__, -2.244555498855249e+25,	"-2.24456E+25", "%#G",
__LINE__, -2.248170665127481e-07,	"-2.248171E-07", "%E",
__LINE__, -2.252558275567388e-13,	"-2.25256e-13", "%g",
__LINE__, -2.256190083496001e+13,	"-22561900834960.0136398", "%7.7f",
__LINE__, -2.259851596715945e+27,	"-2.259852e+27", "%e",
__LINE__, -2.260461480001174e-21,	"-0.000000", "%f",
__LINE__, -2.264128628428577e+22,	"-2.26413e+22", "%1g",
__LINE__, -2.265914518399595e-04,	"-0.000226591", "%G",
__LINE__, -2.266251557092826e+23,	"-2.26625e+23", "%g",
__LINE__, -2.268592252572450e+19,	"-2.268592e+19", "%2.6e",
__LINE__, -2.268597523847349e+11,	"-2.2686e+11", "%g",
__LINE__, -2.268963106935546e+05,	"-226896", "%+g",
__LINE__, -2.272527876808919e-24,	"-0.000000", "%#f",
__LINE__, -2.273366440479073e+02,	"-227.337", "%g",
__LINE__, -2.277858038556191e+25,	"-2.28E+25", "%0.3G",
__LINE__, -2.282019915623415e+25,	"-2E+25", "%5.E",
__LINE__, -2.283333247435650e-27,	"  -0", "%4.f",
__LINE__, -2.285230610829355e+23,	"-2E+23", "%2.G",
__LINE__, -2.290900253402985e+23,	"-2.2909E+23", "%G",
__LINE__, -2.293266953268186e+08,	"-2.29327e+08", "%g",
__LINE__, -2.293489603164786e+23,	"-229348960316478578391752.3076525", "%4.7f",
__LINE__, -2.294434667605481e+15,	"-2.2944E+15", "%.5G",
__LINE__, -2.296607768466765e+21,	"-2.29661E+21", "%G",
__LINE__, -2.297449967994012e+14,	"-229744996799401.23542", "%+.5f",
__LINE__, -2.301162556466583e-01,	"-0.230116", "%+#2g",
__LINE__, -2.301676246374004e+05,	"-230168.", "%#g",
__LINE__, -2.301976724487835e-01,	"-0.230198", "%5G",
__LINE__, -2.303269770571222e-15,	"-2.303270e-15", "%.6e",
__LINE__, -2.306451480495636e+23,	"-2.30645E+23", "%G",
__LINE__, -2.307659351219690e-17,	"-0.000000", "%+3f",
__LINE__, -2.309009762339430e+16,	"-2.30901E+16", "%G",
__LINE__, -2.309261751862100e+06,	"-2309261.751862", "%+f",
__LINE__, -2.309504876918634e-26,	" -2E-26", "%7.E",
__LINE__, -2.310910348147804e-26,	"-2e-26", "%5.g",
__LINE__, -2.317173552252235e+05,	"-231717.4", "%.7g",
__LINE__, -2.319517289618469e-23,	"-2.31952E-23", "%+G",
__LINE__, -2.320103195142527e+08,	"-2.320103E+08", "%+E",
__LINE__, -2.323523032125633e+24,	"-2323523032125633491773442.07419", "%.5f",
__LINE__, -2.326279126614399e-16,	"-0.000000", "%f",
__LINE__, -2.331393688620925e-09,	"-2.33139e-09", "%#g",
__LINE__, -2.334233527512469e+01,	"   -23", "%6.0f",
__LINE__, -2.337418834112767e+24,	" -2E+24", "%7.E",
__LINE__, -2.339455293612118e+12,	"-2339455293612.1", "%+.1f",
__LINE__, -2.341930318143367e-18,	"-2.E-18", "%#4.E",
__LINE__, -2.346107614950921e-17,	"-0.00000", "%+2.5f",
__LINE__, -2.348356578807972e+23,	"-2.34836e+23", "%g",
__LINE__, -2.351485855138244e+19,	"-2.351486e+19", "%+e",
__LINE__, -2.362101647639198e-15,	"-2.36210e-15", "%#g",
__LINE__, -2.369743873030115e+08,	"-2e+08", "%.1g",
__LINE__, -2.371658164739356e+25,	"-23716581647393559784120498.079574", "%f",
__LINE__, -2.372427847607163e+28,	"-2.37243E+28", "%G",
__LINE__, -2.375465465294647e+11,	"-2.375465e+11", "%e",
__LINE__, -2.377128971572195e-18,	"-0.0", "%1.1f",
__LINE__, -2.380322448568089e-13,	"-2.38032E-13", "%+#0G",
__LINE__, -2.385960728264882e+26,	"-2E+26", "%.0E",
__LINE__, -2.387345744004747e+00,	"-2.38735", "%G",
__LINE__, -2.390480023300201e+25,	"-2.39048e+25", "%g",
__LINE__, -2.395420431930886e+23,	"-2E+23", "%2.E",
__LINE__, -2.401144663870969e-10,	"-2.e-10", "%#6.g",
__LINE__, -2.402787441215039e-08,	"-2.40279e-08", "%g",
__LINE__, -2.402990830425278e+08,	"-2.40299E+08", "%G",
__LINE__, -2.404213682932215e+08,	"-2.40421e+08", "%2g",
__LINE__, -2.409385592298822e+21,	"-2409385592298821876511.283335", "%7f",
__LINE__, -2.410798267658614e+13,	"-2.4108e+13", "%+g",
__LINE__, -2.413180068271811e-24,	"-0.000000", "%+f",
__LINE__, -2.413268457113495e+26,	"-2.41327E+26", "%3.6G",
__LINE__, -2.415341832206007e-13,	"-0.000000", "%+f",
__LINE__, -2.422519577068670e-08,	"-0.0000000", "%.7f",
__LINE__, -2.422533651282808e+20,	"-2.42253E+20", "%#G",
__LINE__, -2.422795006880671e+17,	"-2.4228e+17", "%g",
__LINE__, -2.423483330202008e+20,	"-2.42348e+20", "%g",
__LINE__, -2.431756009640369e-04,	"-0.000243176", "%+#3g",
__LINE__, -2.431878622534173e-05,	"-0.000024", "%f",
__LINE__, -2.432012113077180e+24,	"-2.43201e+24", "%g",
__LINE__, -2.433843704470487e+07,	"-24338437", "%4.f",
__LINE__, -2.435475755031956e+11,	"-2.435476E+11", "%1E",
__LINE__, -2.438081888695437e-13,	"-0.000000", "%f",
__LINE__, -2.438334590462860e+10,	"-2.4E+10", "%5.2G",
__LINE__, -2.440223135334059e+17,	"-2.44022e+17", "%g",
__LINE__, -2.444107281115317e-21,	"-2.44411e-21", "%+g",
__LINE__, -2.444582273206171e-02,	"  -0.02", "%7.G",
__LINE__, -2.445234676352794e+23,	"-2.44523e+23", "%#g",
__LINE__, -2.449185020984714e+08,	"-2.E+08", "%#2.G",
__LINE__, -2.450646640466020e+22,	"-2.45065E+22", "%5G",
__LINE__, -2.456840850262473e+13,	"-24568408502625", "%0.f",
__LINE__, -2.464466865714499e-10,	"-2e-10", "%6.g",
__LINE__, -2.466022088999151e+27,	"-2.46602E+27", "%G",
__LINE__, -2.484398113119779e-04,	"-2.484398E-04", "%E",
__LINE__, -2.484591850456328e+23,	"-248459185045632846566832.085955", "%+f",
__LINE__, -2.488166252162446e-11,	"-2.5E-11", "%4.2G",
__LINE__, -2.493507313049390e+24,	"-2.49E+24", "%4.3G",
__LINE__, -2.500280281988428e+28,	"-2.5E+28", "%.4G",
__LINE__, -2.500373956445372e-07,	"-2.50037e-07", "%g",
__LINE__, -2.505566434769299e-12,	"-2.5E-12", "%+#0.2G",
__LINE__, -2.508215917020758e+05,	"-2.508216e+05", "%5e",
__LINE__, -2.519368094680315e-29,	"-2.51937e-29", "%#0g",
__LINE__, -2.522266530587753e-11,	"-2.52227e-11", "%+g",
__LINE__, -2.534492886372514e-06,	"-2.53449E-06", "%0G",
__LINE__, -2.534617610955074e-02,	"-0.03", "%0.2f",
__LINE__, -2.540551642835634e+26,	"-3E+26", "%4.G",
__LINE__, -2.548210731830516e-26,	"-0.000", "%2.3f",
__LINE__, -2.558868082397931e-11,	"-3E-11", "%2.E",
__LINE__, -2.560062512991052e+11,	"-2.56006E+11", "%+G",
__LINE__, -2.561274682814428e-05,	"-0.000026", "%f",
__LINE__, -2.563424949397357e-02,	"    -0", "%6.f",
__LINE__, -2.577010939931465e+17,	"-2.57701E+17", "%G",
__LINE__, -2.578224879294822e+10,	"-3E+10", "%+4.1G",
__LINE__, -2.585655636750244e+13,	"-2.585656e+13", "%+0.7g",
__LINE__, -2.585657986834408e+14,	"-2.5857e+14", "%3.5g",
__LINE__, -2.586728929368101e+02,	"-258.673", "%+g",
__LINE__, -2.591293023229468e+06,	"-2591293.0232295", "%2.7f",
__LINE__, -2.592454222603538e-06,	"-2.59245E-06", "%G",
__LINE__, -2.599399905869649e+02,	"-259.939991", "%f",
__LINE__, -2.605382860307596e+12,	"-2.60538E+12", "%2G",
__LINE__, -2.607507689402762e-01,	"-0.260751", "%#.6g",
__LINE__, -2.612933252582967e+15,	"-2.61293e+15", "%g",
__LINE__, -2.614337505491483e-14,	"-2.61434E-14", "%.6G",
__LINE__, -2.618302263333671e+14,	"-2.62e+14", "%3.3g",
__LINE__, -2.622998533972296e+00,	"-3.", "%#0.g",
__LINE__, -2.623348319869643e-15,	"-2.62335E-15", "%#G",
__LINE__, -2.626703132693163e+23,	"-3E+23", "%+6.E",
__LINE__, -2.629610853765779e+25,	"-2.62961E+25", "%+#G",
__LINE__, -2.632993880472784e+26,	"-2.63299E+26", "%G",
__LINE__, -2.635651112327873e-20,	"-2.63565E-20", "%1G",
__LINE__, -2.636003980473492e-23,	"-2.636E-23", "%G",
__LINE__, -2.639316453244009e+10,	"-26393164532.440094", "%#f",
__LINE__, -2.640517223417942e-28,	"-2.641e-28", "%.3e",
__LINE__, -2.640625797147664e-22,	"-2.640626E-22", "%E",
__LINE__, -2.644401262524378e-12,	" -0.000", "%7.3f",
__LINE__, -2.651033203243637e-14,	"-2.651033e-14", "%+e",
__LINE__, -2.652386470126594e-24,	"-2.652386E-24", "%E",
__LINE__, -2.654281018623631e-12,	"-0.00000", "%6.5f",
__LINE__, -2.655529742118827e+02,	"-265.552974", "%f",
__LINE__, -2.658550833241620e+22,	"-26585508332416196708436.473273", "%+f",
__LINE__, -2.660515890519100e+08,	"-2.660516E+08", "%E",
__LINE__, -2.665025749266086e-24,	"-2.66503E-24", "%G",
__LINE__, -2.666117105643095e-20,	"-2.66612e-20", "%g",
__LINE__, -2.667051347741259e+11,	"-3e+11", "%6.g",
__LINE__, -2.667207607243375e+04,	"-26672.076072", "%+#f",
__LINE__, -2.667631877167590e+26,	"-2.667632E+26", "%E",
__LINE__, -2.673817942962878e+13,	"-2.673818e+13", "%+2.6e",
__LINE__, -2.674972907853507e+20,	"-2.674973E+20", "%E",
__LINE__, -2.675830887404867e+14,	"-2.675831E+14", "%E",
__LINE__, -2.682749918168908e+26,	"-2.682750E+26", "%E",
__LINE__, -2.689222801942679e-03,	"-0.0027", "%7.2G",
__LINE__, -2.692245629411156e+25,	"-2.69225e+25", "%g",
__LINE__, -2.692606702464273e+11,	"-2.69261e+11", "%g",
__LINE__, -2.693070822061136e-27,	"-2.69307e-27", "%+g",
__LINE__, -2.694415515655336e-30,	"-3E-30", "%+3.0E",
__LINE__, -2.694770057384739e+15,	"-2.69477e+15", "%g",
__LINE__, -2.699998392329361e+01,	"-27", "%+.2g",
__LINE__, -2.700151952281511e+23,	"-270015195228151050343968.", "%+#5.f",
__LINE__, -2.707398527302841e-08,	"-2.70740e-08", "%+#3g",
__LINE__, -2.711404950850030e-21,	"-2.71E-21", "%.2E",
__LINE__, -2.714057739024281e-10,	"-2.714e-10", "%.4g",
__LINE__, -2.717657632815414e-10,	"-2.71766e-10", "%g",
__LINE__, -2.720875786430592e-09,	"-2.7E-09", "%6.2G",
__LINE__, -2.725886730997891e+19,	"-2.72589e+19", "%g",
__LINE__, -2.726089169748676e-09,	"-2.72609E-09", "%+G",
__LINE__, -2.732907572038661e-30,	"-2.73291E-30", "%G",
__LINE__, -2.737918050958789e+11,	"-3e+11", "%1.g",
__LINE__, -2.739024251198484e-18,	"-2.73902e-18", "%+g",
__LINE__, -2.742646144452305e+13,	"-2.74265e+13", "%g",
__LINE__, -2.742911865386719e+06,	"-3E+06", "%+5.G",
__LINE__, -2.759159275123811e-30,	"-0.000000", "%+f",
__LINE__, -2.759794813930001e-21,	"-2.75979e-21", "%+g",
__LINE__, -2.763243077558348e+20,	"-2.7632E+20", "%+0.4E",
__LINE__, -2.770348477810209e-14,	"-0.000000", "%2f",
__LINE__, -2.776074766292453e+05,	"-277607", "%g",
__LINE__, -2.776610811432007e-07,	"-2.77661E-07", "%6G",
__LINE__, -2.778673793270678e+23,	"-3E+23", "%+4.E",
__LINE__, -2.782405168708350e+08,	"-278240516.87084", "%.5f",
__LINE__, -2.783316149365198e-09,	"-3E-09", "%5.0G",
__LINE__, -2.785436703085409e-27,	"-2.78544E-27", "%#G",
__LINE__, -2.787479051660640e+21,	"-2.78748e+21", "%g",
__LINE__, -2.789445406042450e-03,	"-0.002789", "%+f",
__LINE__, -2.791104581836077e+05,	"-279110.4581836", "%+7.7f",
__LINE__, -2.802078617775784e+04,	"-28020.786", "%0.3f",
__LINE__, -2.804954315579055e+20,	"-2.80495E+20", "%G",
__LINE__, -2.806575341862696e-05,	"-2.80658E-05", "%G",
__LINE__, -2.807769556900402e-06,	"-0.000003", "%+#f",
__LINE__, -2.808882056357941e-12,	"-0.0", "%.1f",
__LINE__, -2.809386677339924e+10,	"-2.8094E+10", "%6.5G",
__LINE__, -2.818404311437694e+19,	"-3E+19", "%6.G",
__LINE__, -2.819463285551660e+01,	"-28.1946", "%+G",
__LINE__, -2.821428853207724e-16,	"-3e-16", "%6.g",
__LINE__, -2.824452750788444e+07,	"-3e+07", "%+2.g",
__LINE__, -2.825430381094971e+28,	"-3e+28", "%+.0e",
__LINE__, -2.830010928384944e-17,	"-0", "%.0f",
__LINE__, -2.832505114479680e-09,	"-0.000000", "%f",
__LINE__, -2.833246604950796e+13,	"-2.83325E+13", "%G",
__LINE__, -2.833274073265017e+13,	"-28332740732650.174564", "%f",
__LINE__, -2.835842581787797e+07,	"-2.83584E+07", "%2G",
__LINE__, -2.839758384681983e-07,	"-2.83976E-07", "%.6G",
__LINE__, -2.841077022753766e-09,	"-3E-09", "%0.1G",
__LINE__, -2.845307294930682e+00,	"-2.845307e+00", "%+1e",
__LINE__, -2.847420163874243e+19,	"-2.8e+19", "%1.2g",
__LINE__, -2.848133715109881e-25,	"-2.848134E-25", "%E",
__LINE__, -2.850208101288058e-06,	"-2.8502E-06", "%+5.4E",
__LINE__, -2.853666525870413e+04,	"-28536.665259", "%f",
__LINE__, -2.855661543202034e+21,	"-2.85566e+21", "%g",
__LINE__, -2.859528889324159e-08,	"-2.859529e-08", "%3e",
__LINE__, -2.860545310690251e+29,	"-3e+29", "%.1g",
__LINE__, -2.863576633666884e-14,	"-2.863577e-14", "%+5e",
__LINE__, -2.864115740396321e-14,	"-2.86412e-14", "%g",
__LINE__, -2.864481979037153e+20,	"-2.86E+20", "%3.3G",
__LINE__, -2.867582970177984e-18,	"-0.000000", "%f",
__LINE__, -2.868237707901564e+25,	"-3E+25", "%6.E",
__LINE__, -2.871741071402520e+13,	"-3e+13", "%.1g",
__LINE__, -2.873724610073364e+18,	"-2873724610073364438.278531", "%+#f",
__LINE__, -2.876433859770866e-25,	"-2.87643e-25", "%g",
__LINE__, -2.877458587075737e-08,	"-2.877E-08", "%+.4G",
__LINE__, -2.883349842927101e+24,	"-2.883350E+24", "%2E",
__LINE__, -2.883749925642885e+09,	"-2.883750e+09", "%e",
__LINE__, -2.883773835633003e-17,	"-0.000000", "%+f",
__LINE__, -2.890389090491409e+24,	"-2890389090491409262995148.310438", "%#1f",
__LINE__, -2.900848552225810e-11,	"-0.000000", "%+f",
__LINE__, -2.911942123176400e+25,	"-29119421231764004431852300", "%0.f",
__LINE__, -2.912904462180751e-18,	"-2.9129E-18", "%6G",
__LINE__, -2.917717875075651e+26,	"-3e+26", "%0.e",
__LINE__, -2.922293201084093e-26,	"-2.922293E-26", "%E",
__LINE__, -2.925070319932451e-30,	"-0.000000", "%f",
__LINE__, -2.926558572870874e+15,	"-2.926559E+15", "%E",
__LINE__, -2.928781435877896e+26,	"-2.928781e+26", "%+e",
__LINE__, -2.930178318110376e+28,	"-2.930178E+28", "%E",
__LINE__, -2.930984661925819e+05,	"-293098.5", "%.7G",
__LINE__, -2.932762424932762e-08,	"-0.000000", "%#f",
__LINE__, -2.933415597492494e+10,	"-29334155974.924943", "%+#2f",
__LINE__, -2.933564314850986e+29,	"-2.93356E+29", "%7G",
__LINE__, -2.943224907893795e+10,	"-2.943225E+10", "%+7E",
__LINE__, -2.945311540471221e+19,	"-2.94531E+19", "%#G",
__LINE__, -2.945812356522847e+15,	"-2.94581e+15", "%+g",
__LINE__, -2.945836999630957e+00,	"-2.945837E+00", "%E",
__LINE__, -2.947798782726622e-01,	"-0.29478", "%+g",
__LINE__, -2.948958405827917e+18,	"-2.94896e+18", "%g",
__LINE__, -2.949790871798059e-11,	"-2.94979E-11", "%G",
__LINE__, -2.950347806125225e-12,	"-2.95035e-12", "%g",
__LINE__, -2.952781884599368e-29,	"-2.952782E-29", "%+E",
__LINE__, -2.956801341442716e+06,	"-2.9568E+06", "%G",
__LINE__, -2.957469310356540e-07,	"-0.000", "%1.3f",
__LINE__, -2.960464869534870e-23,	"-2.96046E-23", "%G",
__LINE__, -2.962339381825446e-07,	"-0", "%1.f",
__LINE__, -2.971013180028710e+22,	"-2.971e+22", "%3.5g",
__LINE__, -2.975167862441254e+07,	"-2.97517e+07", "%g",
__LINE__, -2.976018424339993e+16,	"-2.976018e+16", "%3e",
__LINE__, -2.979173094835454e+29,	"-2.97917E+29", "%G",
__LINE__, -2.983135249987541e-03,	"-0.00298314", "%+G",
__LINE__, -2.985142444917919e-24,	"-2.985142E-24", "%+#7E",
__LINE__, -2.988680953635159e-14,	"-0.0000000", "%2.7f",
__LINE__, -2.989629778079379e+04,	"-29896.297781", "%f",
__LINE__, -2.991274275137276e+19,	"-29912742751372762839.423558", "%+4f",
__LINE__, -2.991286396006024e-06,	"-2.99129e-06", "%4g",
__LINE__, -2.993310397844811e+04,	"-2.993310E+04", "%3.6E",
__LINE__, -2.994669852410861e-29,	"-2.99467E-29", "%G",
__LINE__, -2.996082093034831e+27,	"-2.996082e+27", "%1e",
__LINE__, -2.999783904575110e+16,	"-2.999784E+16", "%#E",
__LINE__, -3.012019221956988e+25,	"-3.012019E+25", "%E",
__LINE__, -3.014211917706622e-25,	"-0.000000", "%+f",
__LINE__, -3.015149723683428e-19,	"-3.01515E-19", "%G",
__LINE__, -3.022158478004638e-19,	"-3.02216e-19", "%6g",
__LINE__, -3.022825518373900e-12,	"-3.0228E-12", "%+.4E",
__LINE__, -3.025108924057340e-19,	"-0.000000", "%f",
__LINE__, -3.026316824631967e+24,	"-3026316824631966717618070.106255", "%1f",
__LINE__, -3.033074643529623e-13,	"-3.03307e-13", "%g",
__LINE__, -3.035292960731141e+24,	"-3035292960731141409524980.190326", "%f",
__LINE__, -3.043291272956732e-13,	"-3.04329e-13", "%#g",
__LINE__, -3.045216723973715e-23,	"-3.045e-23", "%.4g",
__LINE__, -3.047140976048835e+09,	"-3.04714E+09", "%3.5E",
__LINE__, -3.047680278470886e+09,	"-3.047680E+09", "%#E",
__LINE__, -3.048465807963461e+05,	"-304847", "%g",
__LINE__, -3.050904753556756e+22,	"-3.0509E+22", "%G",
__LINE__, -3.052845748999047e-13,	"-3.05285e-13", "%g",
__LINE__, -3.053395231883620e-06,	"-3E-06", "%2.G",
__LINE__, -3.054894203375445e-28,	"-3e-28", "%2.g",
__LINE__, -3.055080347760755e-13,	"-0", "%2.f",
__LINE__, -3.055513037393624e-29,	"-3e-29", "%3.g",
__LINE__, -3.056198778208295e-06,	"-3.0562e-06", "%g",
__LINE__, -3.057813660266980e-21,	"-3E-21", "%1.G",
__LINE__, -3.059687036330998e-11,	"-3.1E-11", "%#2.2G",
__LINE__, -3.061450385559094e-10,	"-3.06145E-10", "%G",
__LINE__, -3.066605713361383e-27,	"-0.000000", "%f",
__LINE__, -3.071590110813156e+22,	"-3.07159E+22", "%G",
__LINE__, -3.073253864426931e+26,	"-3.0733E+26", "%.5G",
__LINE__, -3.078998328596940e+07,	"-3.079e+07", "%5.4g",
__LINE__, -3.082733887951920e+06,	"-3.082734e+06", "%+6e",
__LINE__, -3.084365358064710e+24,	"-3.084365E+24", "%#E",
__LINE__, -3.086948022123716e+25,	"-30869480221237162176350921.072299", "%+f",
__LINE__, -3.088200214218024e-10,	"-0", "%0.f",
__LINE__, -3.093442983942874e+08,	"-309344298.394287", "%f",
__LINE__, -3.103573455403534e-09,	"-3.103573E-09", "%#E",
__LINE__, -3.109178443120997e+07,	"-31091784.431210", "%f",
__LINE__, -3.111494549914917e+28,	"-3e+28", "%0.g",
__LINE__, -3.113384020517480e-17,	"    -0", "%+6.f",
__LINE__, -3.121622779718055e+14,	"-312162277971805.491", "%+.3f",
__LINE__, -3.122780443843900e-01,	"-0.312278", "%#g",
__LINE__, -3.122952438335638e-25,	"-3.122952E-25", "%E",
__LINE__, -3.128970339463168e-18,	"-3e-18", "%3.g",
__LINE__, -3.130862507719335e+10,	"-3.130863e+10", "%3e",
__LINE__, -3.145960838955379e+03,	"-3145.96", "%g",
__LINE__, -3.149362645138929e+21,	"-3.14936e+21", "%g",
__LINE__, -3.150697168664913e+26,	"-315069716866491322804222363.629378", "%+f",
__LINE__, -3.157946785041287e+05,	"-3.1579e+05", "%.4e",
__LINE__, -3.158347006986809e-02,	"-3.E-02", "%#.0E",
__LINE__, -3.159542871923388e+07,	"-31595429", "%2.f",
__LINE__, -3.169997512351985e+15,	"-3.169998E+15", "%6.7G",
__LINE__, -3.170971776544746e+07,	"-31709717.765447", "%f",
__LINE__, -3.173246079104466e+19,	"-3.173246E+19", "%1E",
__LINE__, -3.173581228658553e-02,	"-0.03", "%+0.G",
__LINE__, -3.187598864929850e-07,	"-3.18760E-07", "%#G",
__LINE__, -3.190525302270244e+08,	"-3.190525e+08", "%+0.7g",
__LINE__, -3.191879884186422e+19,	"-3.19E+19", "%.2E",
__LINE__, -3.197292604744926e+02,	"-3.197293e+02", "%+e",
__LINE__, -3.203713337688838e-12,	"-3.20371E-12", "%6G",
__LINE__, -3.204416889544914e-18,	"-0.000000", "%+f",
__LINE__, -3.204494471917096e+09,	"-3.20449e+09", "%g",
__LINE__, -3.211933195516720e+11,	"-3.21193E+11", "%G",
__LINE__, -3.214544021431917e-24,	"-0.000000", "%1f",
__LINE__, -3.215501229487004e-07,	"-3e-07", "%3.e",
__LINE__, -3.232157492322707e-13,	"-3.E-13", "%+#5.G",
__LINE__, -3.239074974455177e-05,	"-3.239e-05", "%2.4g",
__LINE__, -3.243083730801156e-24,	"-3.243084e-24", "%#e",
__LINE__, -3.243128583394124e+07,	"-32431285.8339", "%6.4f",
__LINE__, -3.247997999770571e-08,	"-3e-08", "%5.e",
__LINE__, -3.258251054563991e-15,	"-3.2583E-15", "%.5G",
__LINE__, -3.259499053187446e+07,	"-3.2595E+07", "%5.6G",
__LINE__, -3.261907782031174e+20,	"-3.3e+20", "%.2g",
__LINE__, -3.263979380855122e+29,	"-3.26398E+29", "%G",
__LINE__, -3.264166546402073e+06,	"-3.26417E+06", "%5G",
__LINE__, -3.269357648926951e+01,	"-3.E+01", "%#5.G",
__LINE__, -3.273523287028019e-30,	"-3.27352e-30", "%g",
__LINE__, -3.274464331526264e-14,	"-3e-14", "%.0g",
__LINE__, -3.276647049958546e+05,	"-327664.7", "%+.1f",
__LINE__, -3.276853612008326e-04,	"-3.276854e-04", "%e",
__LINE__, -3.288077788905925e+17,	"-3.28808e+17", "%g",
__LINE__, -3.292054327509010e+21,	"-3.29205e+21", "%+g",
__LINE__, -3.292086868337041e-16,	"     -0", "%7.f",
__LINE__, -3.299368070005327e-17,	"-3E-17", "%5.G",
__LINE__, -3.307165537474566e-30,	"-3e-30", "%+2.g",
__LINE__, -3.310556325973673e-17,	"-3.31056E-17", "%G",
__LINE__, -3.315407318453138e-09,	"-3.315407e-09", "%+#.6e",
__LINE__, -3.318402800998018e-09,	"-3.3184E-09", "%+G",
__LINE__, -3.324277622889107e-04,	"-0.000332428", "%G",
__LINE__, -3.326372457131185e+14,	"-3.326372e+14", "%0e",
__LINE__, -3.333300611287597e+18,	"-3.3E+18", "%4.2G",
__LINE__, -3.333608976277018e-25,	"-3.33361e-25", "%g",
__LINE__, -3.333613056182724e-24,	"-3.33361e-24", "%.5e",
__LINE__, -3.338505874378410e-26,	"-0.00000", "%.5f",
__LINE__, -3.339838772519661e+24,	"-3.3398E+24", "%0.5G",
__LINE__, -3.354802735583258e-27,	"-3.3548E-27", "%G",
__LINE__, -3.356542080644329e+15,	"-3356542080644329.129058", "%#f",
__LINE__, -3.360027692463026e-29,	"-3.36003e-29", "%+g",
__LINE__, -3.361845657814323e+06,	"-3361845.657814", "%f",
__LINE__, -3.363135493765816e-12,	"   -0", "%5.f",
__LINE__, -3.367383112102258e+19,	"-33673831121022579360.158034", "%f",
__LINE__, -3.376798505037497e+03,	"-3376.8", "%+3G",
__LINE__, -3.388170639372559e+09,	"-3.388171e+09", "%+e",
__LINE__, -3.397304185715499e-12,	"-3.397304e-12", "%+e",
__LINE__, -3.401559374016378e-13,	"-3.40156e-13", "%g",
__LINE__, -3.402651870178825e+21,	"-3.40265e+21", "%+g",
__LINE__, -3.410491213537530e+12,	"-3.41049E+12", "%G",
__LINE__, -3.411695570460075e-01,	"-3.411696e-01", "%e",
__LINE__, -3.417311435719220e+29,	"-3.4E+29", "%3.1E",
__LINE__, -3.417581063208165e-23,	"  -0", "%+4.f",
__LINE__, -3.424005615113663e-28,	"-0.000000", "%f",
__LINE__, -3.424793585094130e-12,	"-0.000000", "%f",
__LINE__, -3.434733077762304e-05,	"-3.43473e-05", "%g",
__LINE__, -3.436384988494743e+08,	"-3.43638E+08", "%G",
__LINE__, -3.441082995163884e-21,	"-0.000000", "%f",
__LINE__, -3.442868661576827e-23,	"-3.442869e-23", "%#.7g",
__LINE__, -3.444337521046186e+13,	"-3.44434E+13", "%#G",
__LINE__, -3.448230173418967e-28,	"-3.44823E-28", "%#G",
__LINE__, -3.448523828225326e-21,	"-3.4485e-21", "%.4e",
__LINE__, -3.449876796754720e-07,	"-3.44988e-07", "%g",
__LINE__, -3.450163790411588e+25,	"-34501637904115876054333966.749255", "%2f",
__LINE__, -3.450224454406567e-26,	"-3.450224E-26", "%#1E",
__LINE__, -3.459930768422874e-28,	"-3.46E-28", "%2.3G",
__LINE__, -3.460730505022601e-28,	"-3.46073e-28", "%#g",
__LINE__, -3.462894265593946e-10,	"-3.46289e-10", "%+#g",
__LINE__, -3.464808359229496e+05,	"-346481", "%6.6G",
__LINE__, -3.467272303652620e-03,	"-0.00346727", "%g",
__LINE__, -3.468252706910251e+10,	"-3.5E+10", "%#7.2G",
__LINE__, -3.473623965680253e+27,	"-3.47362e+27", "%g",
__LINE__, -3.474527926009729e+11,	"-3.475E+11", "%.4G",
__LINE__, -3.476489048299929e+15,	"-3.47649e+15", "%g",
__LINE__, -3.477809698895344e-09,	"-0.000", "%+.3f",
__LINE__, -3.493008398637667e-28,	"  -0", "%+4.f",
__LINE__, -3.497441286691613e+07,	"-3.49744e+07", "%g",
__LINE__, -3.500904660533358e+00,	"-3.500905E+00", "%+1E",
__LINE__, -3.504996054364915e+25,	"-3.505e+25", "%+g",
__LINE__, -3.507738629125434e-24,	"-0.00", "%+4.2f",
__LINE__, -3.508557770253211e-04,	"-3.508558e-04", "%#6e",
__LINE__, -3.516056824437550e+20,	"-3.516057e+20", "%#e",
__LINE__, -3.521102917733367e+02,	"-352.11", "%g",
__LINE__, -3.523948985825251e+10,	"-3.52395e+10", "%+g",
__LINE__, -3.525281835697895e-15,	"-3.525282e-15", "%e",
__LINE__, -3.534088845494570e-26,	"-0.000000", "%2f",
__LINE__, -3.541002442741569e+01,	"-35.410", "%3.3f",
__LINE__, -3.541126630345017e-19,	"-3.541127e-19", "%e",
__LINE__, -3.545277845967514e-17,	"-0.000000", "%f",
__LINE__, -3.560935430637329e-12,	"-3.56094E-12", "%G",
__LINE__, -3.564234584447659e-23,	"-3.56423E-23", "%G",
__LINE__, -3.576040378379921e-11,	"-0.000000", "%+6f",
__LINE__, -3.578133580350674e-05,	"-3.578134e-05", "%#e",
__LINE__, -3.584484015191491e-28,	"-0.0", "%+2.1f",
__LINE__, -3.591961845146752e+27,	"-3.59196E+27", "%G",
__LINE__, -3.602508380305001e+26,	"-3.60251e+26", "%g",
__LINE__, -3.603113449808132e+04,	"-36031.134498", "%+3.6f",
__LINE__, -3.605569849504628e+25,	"-4E+25", "%6.G",
__LINE__, -3.611297754851416e+05,	"-361129.775485", "%+f",
__LINE__, -3.613177909959201e-28,	"-0.000000", "%f",
__LINE__, -3.616261225230595e-01,	"-0.361626", "%3g",
__LINE__, -3.619203521536307e+09,	"-3.6192E+09", "%G",
__LINE__, -3.619316709131723e-27,	"-0.0000000", "%.7f",
__LINE__, -3.623100583082346e+28,	"-3.6231E+28", "%+G",
__LINE__, -3.626582653589919e+21,	"-3626582653589918603387.332041", "%f",
__LINE__, -3.626667540343067e-30,	"-4.E-30", "%#.0G",
__LINE__, -3.633539220625861e-30,	"-3.634E-30", "%+.3E",
__LINE__, -3.641655782149502e-11,	"-3.64166E-11", "%G",
__LINE__, -3.644523594046571e+25,	"-3.64452e+25", "%5g",
__LINE__, -3.645977605394108e+25,	"-3.646e+25", "%+0.3e",
__LINE__, -3.647864582248812e+13,	"-4E+13", "%4.G",
__LINE__, -3.655241667633056e-25,	"-3.655242E-25", "%E",
__LINE__, -3.662603655433297e+23,	"-3.662604e+23", "%e",
__LINE__, -3.668995445134158e+22,	" -4E+22", "%7.G",
__LINE__, -3.670006666569412e-11,	"-3.670007e-11", "%e",
__LINE__, -3.670510381138509e-24,	"-3.670510e-24", "%e",
__LINE__, -3.671283003268254e-20,	"-3.67128E-20", "%G",
__LINE__, -3.687760201176777e-13,	"-3.68776E-13", "%G",
__LINE__, -3.687983982100676e-14,	"-0.00", "%.2f",
__LINE__, -3.694808382827435e-12,	"-3.694808E-12", "%#E",
__LINE__, -3.696158520838821e+28,	"-3.69616E+28", "%3G",
__LINE__, -3.700911860811323e+18,	"-3.70091e+18", "%+g",
__LINE__, -3.701328314738669e+24,	"-3.70133e+24", "%g",
__LINE__, -3.707068461822151e-19,	"-3.707068E-19", "%E",
__LINE__, -3.710679411506914e+25,	"-3.71068e+25", "%g",
__LINE__, -3.713003840923896e-23,	"-3.713e-23", "%7g",
__LINE__, -3.717028397747828e-28,	"-3.71703e-28", "%g",
__LINE__, -3.728159642236442e+14,	"-3.72816E+14", "%G",
__LINE__, -3.731956233637010e+21,	"-3.73196E+21", "%G",
__LINE__, -3.742336623322610e+07,	"-3.74234e+07", "%g",
__LINE__, -3.748328269630045e+04,	"-37483.3", "%G",
__LINE__, -3.750803081283569e-27,	"-3.7508E-27", "%+7G",
__LINE__, -3.752021500826652e-04,	"-0.0004", "%.1G",
__LINE__, -3.755942257004103e-12,	"-3.75594E-12", "%G",
__LINE__, -3.765921235889045e+03,	" -4e+03", "%+7.g",
__LINE__, -3.772453135667801e-28,	"-3.77245E-28", "%G",
__LINE__, -3.776384200230367e+27,	"-3.776e+27", "%1.4g",
__LINE__, -3.787035870684945e-25,	"-4E-25", "%+3.G",
__LINE__, -3.798616350818839e-29,	"-3.7986164e-29", "%.7e",
__LINE__, -3.807178315238428e-15,	"-0.000000", "%+#6f",
__LINE__, -3.822059837967635e+18,	"-3822059837967634621.236357", "%6.6f",
__LINE__, -3.823553096022006e+12,	"-3.82355e+12", "%g",
__LINE__, -3.839198115259428e-23,	"-0.000000", "%f",
__LINE__, -3.846953640321746e+02,	"-3.846954E+02", "%E",
__LINE__, -3.852230696542361e+08,	"-3.8522e+08", "%#.5g",
__LINE__, -3.861139362195314e-25,	"-3.86114E-25", "%2G",
__LINE__, -3.873388618099769e+09,	"-3873388618", "%0.0f",
__LINE__, -3.874161550543817e+15,	"-3.874162e+15", "%+e",
__LINE__, -3.874527935469425e+20,	"-3.87E+20", "%3.3G",
__LINE__, -3.878069577893697e-30,	"-3.878070E-30", "%#E",
__LINE__, -3.878852490397702e-20,	"-3.87885e-20", "%g",
__LINE__, -3.879688342272101e-10,	"-0.00", "%#4.2f",
__LINE__, -3.879797428399897e+03,	"-3880", "%1.4g",
__LINE__, -3.881588804766756e+00,	"-3.9", "%+4.2G",
__LINE__, -3.889377318111182e+01,	"-38.8938", "%+.4f",
__LINE__, -3.893444523430385e-03,	"-0.004", "%+2.g",
__LINE__, -3.894912141515856e+03,	"-3894.91", "%+g",
__LINE__, -3.905279115773667e+04,	"-39052.791158", "%f",
__LINE__, -3.905333955484919e-20,	"-3.90533E-20", "%G",
__LINE__, -3.906559442060730e+27,	"-3906559442060730447110472596.250474", "%f",
__LINE__, -3.909396469655334e-26,	"-3.91E-26", "%.3G",
__LINE__, -3.920132491092364e+11,	"-3.92013e+11", "%g",
__LINE__, -3.935651497471973e+27,	"-3935651497471972604103029880", "%5.f",
__LINE__, -3.939742577853889e-03,	"-0.004", "%5.G",
__LINE__, -3.943284017088198e+19,	"-39432840170881981123.3", "%.1f",
__LINE__, -3.947452186327660e+09,	"-3947452186.33", "%0.2f",
__LINE__, -3.951967237553488e+18,	"-3951967237553488132.562052", "%f",
__LINE__, -3.953673427359789e-28,	"-3.954E-28", "%3.4G",
__LINE__, -3.956044867371602e+23,	"-4e+23", "%+6.1g",
__LINE__, -3.965038994251913e-20,	"-3.96504e-20", "%g",
__LINE__, -3.970527677577937e+05,	"-4.e+05", "%#0.1g",
__LINE__, -3.970717822164395e-20,	"-3.970718e-20", "%6e",
__LINE__, -3.978063834438912e-19,	"-3.97806E-19", "%G",
__LINE__, -3.982705395472599e+27,	"-3.9827e+27", "%#.5g",
__LINE__, -3.983486821352571e-28,	"-3.98349e-28", "%g",
__LINE__, -3.985470630230926e-14,	"-4e-14", "%.2g",
__LINE__, -3.993095662863953e-16,	"-3.993096e-16", "%e",
__LINE__, -4.006984141314271e-22,	" -4e-22", "%7.2g",
__LINE__, -4.006984141314271e-22,	"-4.0e-22", "%#7.2g",
__LINE__, -4.013226099863981e+06,	"-4.013226E+06", "%+E",
__LINE__, -4.013702226581167e+00,	"-4.0137022", "%+#3.7f",
__LINE__, -4.017598274642537e+11,	"-4E+11", "%5.G",
__LINE__, -4.021385792825529e-09,	" -4e-09", "%7.2g",
__LINE__, -4.024099064819937e-20,	"-4.0241E-20", "%+G",
__LINE__, -4.026952473441366e+22,	"-4.026952e+22", "%6.7g",
__LINE__, -4.027636677087866e+12,	"-4.02764E+12", "%G",
__LINE__, -4.036506013049443e+17,	"-4.03651e+17", "%0.6g",
__LINE__, -4.063191953523012e-06,	"  -0.0", "%6.1f",
__LINE__, -4.070953223475192e-23,	"-4.07095E-23", "%G",
__LINE__, -4.072425833070524e+09,	"-4.072426E+09", "%E",
__LINE__, -4.086025576759603e+12,	"-4.086026e+12", "%e",
__LINE__, -4.086627783296081e-24,	"-4.087E-24", "%.3E",
__LINE__, -4.086683676772144e+10,	"-40866836767.721439", "%f",
__LINE__, -4.087336043219081e-10,	"-0.", "%+#0.f",
__LINE__, -4.125162973336809e-26,	"-4.125163E-26", "%.7G",
__LINE__, -4.150753797717075e-10,	"-4.2e-10", "%.2g",
__LINE__, -4.152126152181912e+23,	"-4.15213e+23", "%g",
__LINE__, -4.164458223079432e-07,	"-4.164458E-07", "%E",
__LINE__, -4.170624866130099e+03,	"-4170.624866", "%4.6f",
__LINE__, -4.171137277374942e-01,	" -4E-01", "%+7.E",
__LINE__, -4.176067421901769e-25,	"-4.17607E-25", "%G",
__LINE__, -4.179514418604771e+24,	"-4.1795e+24", "%3.5g",
__LINE__, -4.196285183415621e+23,	"-4.19629E+23", "%5G",
__LINE__, -4.198600486581023e+23,	"-4E+23", "%+4.G",
__LINE__, -4.199020494598538e-16,	"-0.000000", "%+f",
__LINE__, -4.207824153501688e-01,	"-0.420782", "%G",
__LINE__, -4.219086441294006e-13,	"  -0", "%+4.f",
__LINE__, -4.223689582765525e+12,	"-4.22369e+12", "%g",
__LINE__, -4.230213377391093e+04,	"-42302.1", "%+2.6G",
__LINE__, -4.232495358100605e-02,	"-0.042325", "%+f",
__LINE__, -4.235459662515940e-29,	"-0.000000", "%f",
__LINE__, -4.240807508057296e-07,	"-4e-07", "%0.g",
__LINE__, -4.248376819122346e-13,	"-4.248377e-13", "%7e",
__LINE__, -4.251361939638334e-23,	"-4.251362E-23", "%E",
__LINE__, -4.253044333568077e+24,	"-4.253044e+24", "%4e",
__LINE__, -4.255728039119772e-30,	"-4.25573E-30", "%2G",
__LINE__, -4.256502531648988e+02,	"-425.65", "%G",
__LINE__, -4.260731632612400e-04,	"-0", "%2.f",
__LINE__, -4.262037138254753e-25,	"-4e-25", "%5.g",
__LINE__, -4.270910126379393e+00,	"-4.2709", "%#7.4f",
__LINE__, -4.273844276097008e-09,	" -0.", "%#4.f",
__LINE__, -4.280424136111831e+21,	"-4.280E+21", "%.3E",
__LINE__, -4.284351940366486e-23,	"-0.000000", "%+f",
__LINE__, -4.291747881693517e-29,	"-4.3e-29", "%+#.2g",
__LINE__, -4.298346825232928e+04,	"-42983.5", "%G",
__LINE__, -4.298879924365432e+28,	"-42988799243654316484253286034.800112", "%f",
__LINE__, -4.302192665689887e-25,	"-0.000000", "%f",
__LINE__, -4.303899568112784e+06,	"-4E+06", "%1.G",
__LINE__, -4.307399960278190e-30,	"-4.31e-30", "%.3g",
__LINE__, -4.341161949359232e+01,	"-43.411619", "%+f",
__LINE__, -4.353334435604675e+17,	" -4e+17", "%+7.g",
__LINE__, -4.354760231068195e+08,	"-4e+08", "%2.e",
__LINE__, -4.363535913318519e+08,	"-4.363536E+08", "%+7E",
__LINE__, -4.365389605557404e-29,	"-4.365390e-29", "%e",
__LINE__, -4.369278570829168e-22,	"-4.369279E-22", "%5E",
__LINE__, -4.372187639240662e-11,	"-4.37219e-11", "%+g",
__LINE__, -4.374221079233858e-15,	"-4.37422E-15", "%4.6G",
__LINE__, -4.374840292001664e-13,	"-0.000000", "%+f",
__LINE__, -4.376554800103945e+16,	"-43765548001039453.751559", "%f",
__LINE__, -4.376659235899513e+07,	"-4.4E+07", "%0.2G",
__LINE__, -4.377316129868239e-06,	"-4.37732E-06", "%+5G",
__LINE__, -4.380028480226885e+21,	"-4e+21", "%1.0e",
__LINE__, -4.380434965450223e+16,	"-43804349654502230.393405", "%f",
__LINE__, -4.392477080355168e-15,	"-4E-15", "%+2.G",
__LINE__, -4.396120020536161e+17,	"-439612002053616102.159594", "%#f",
__LINE__, -4.400993154571784e+13,	"-44009931545717.844159", "%f",
__LINE__, -4.402873692051930e-26,	"-4.4e-26", "%5.3g",
__LINE__, -4.405330274903779e+24,	"-4405330274903779042006135.568954", "%+5f",
__LINE__, -4.406272291312090e+06,	"-4.40627e+06", "%+g",
__LINE__, -4.407065949816988e-13,	"-0.000000", "%f",
__LINE__, -4.408295597674563e-10,	"-4.4083e-10", "%g",
__LINE__, -4.417553815178214e-30,	"-4.41755E-30", "%G",
__LINE__, -4.428894120469459e+16,	"-4.42889e+16", "%g",
__LINE__, -4.433747825142046e+04,	"-4.433748e+04", "%#e",
__LINE__, -4.435051082856639e+11,	"-4.43505E+11", "%G",
__LINE__, -4.445045573007259e-27,	"-4.445e-27", "%.5g",
__LINE__, -4.447791368960968e-25,	" -4e-25", "%+7.g",
__LINE__, -4.449691386526521e-11,	"-4.44969e-11", "%g",
__LINE__, -4.451399093849402e+06,	"-4.e+06", "%#0.e",
__LINE__, -4.453753130320864e-22,	"-4E-22", "%6.E",
__LINE__, -4.455910780463539e+00,	"-4", "%2.g",
__LINE__, -4.464935674747308e+25,	"-4.46494e+25", "%g",
__LINE__, -4.469759565657550e-29,	"-4.46976e-29", "%g",
__LINE__, -4.473254139442931e+14,	"-4E+14", "%3.1G",
__LINE__, -4.480844704930373e-04,	"-0.000448", "%5.6f",
__LINE__, -4.484177356024563e+19,	"-4.484177E+19", "%E",
__LINE__, -4.488115678357666e-13,	"-4.48812e-13", "%g",
__LINE__, -4.491545112281561e+12,	"-4.491545E+12", "%E",
__LINE__, -4.492547433553077e-23,	"-4.49255e-23", "%g",
__LINE__, -4.492701755830813e-05,	"-0.000045", "%f",
__LINE__, -4.497405935096372e-02,	"-4.497406e-02", "%e",
__LINE__, -4.502764260212887e+21,	"-4.50276E+21", "%G",
__LINE__, -4.511984199938207e+29,	"-451198419993820731832556703011.505306", "%f",
__LINE__, -4.514517861504637e-13,	"-4.51452e-13", "%g",
__LINE__, -4.525577218881990e+24,	"-4.5e+24", "%2.2g",
__LINE__, -4.549244580903896e-26,	"-5E-26", "%2.G",
__LINE__, -4.569192488002113e-29,	"-5E-29", "%3.G",
__LINE__, -4.572011438847734e+17,	"-4.57e+17", "%#.3g",
__LINE__, -4.573010973514519e-08,	"-4.57301e-08", "%+7g",
__LINE__, -4.584534976177852e-04,	"-0.000458453", "%7g",
__LINE__, -4.584729895132228e-21,	"-0.000000", "%4f",
__LINE__, -4.585259328217483e-30,	"-4.58526E-30", "%+#4.6G",
__LINE__, -4.589603063610410e-04,	"-4.589603E-04", "%+E",
__LINE__, -4.592428795671033e+22,	" -5e+22", "%7.g",
__LINE__, -4.595683678223830e-20,	"   -0", "%5.f",
__LINE__, -4.602585606100101e+05,	"-4.602586E+05", "%E",
__LINE__, -4.603375306660027e-08,	"-5E-08", "%+6.G",
__LINE__, -4.611341343728034e-18,	"-4.611341e-18", "%5e",
__LINE__, -4.613608487855863e+05,	"-461361", "%6g",
__LINE__, -4.615997775774194e-24,	"-4.61600e-24", "%#g",
__LINE__, -4.620310950564759e+23,	"-462031095056475926696749", "%1.0f",
__LINE__, -4.620645693595563e-10,	"-4.6206457e-10", "%.7e",
__LINE__, -4.621527706233292e-09,	"-4.621528e-09", "%#e",
__LINE__, -4.625215210297273e-13,	"-4.62522E-13", "%G",
__LINE__, -4.636755152220100e-29,	"-0.000000", "%#f",
__LINE__, -4.641203877508087e+23,	"-4.6412e+23", "%0g",
__LINE__, -4.648627249239175e+23,	"-4.65E+23", "%+0.3G",
__LINE__, -4.662546890623409e-10,	"-4.663E-10", "%.3E",
__LINE__, -4.664488650292317e-27,	"-4.66449e-27", "%#g",
__LINE__, -4.668715685060282e+08,	"-466871568.50603", "%.5f",
__LINE__, -4.673332851657081e-18,	"-4.7e-18", "%#5.2g",
__LINE__, -4.683361436174074e+24,	"-4.68e+24", "%#.2e",
__LINE__, -4.693748680461066e-01,	"-0.469375", "%G",
__LINE__, -4.697110010549124e+23,	"-4.69711E+23", "%G",
__LINE__, -4.710442739966989e+06,	"-4.710443e+06", "%2e",
__LINE__, -4.713427678642280e-09,	"-4.71343e-09", "%g",
__LINE__, -4.721999055940316e-04,	"-4.721999e-04", "%#1e",
__LINE__, -4.724262200578540e+17,	"-472426220057853996.081576", "%+f",
__LINE__, -4.733267644288093e+01,	"-4.733268e+01", "%7e",
__LINE__, -4.742854711396110e-11,	"-0.000000", "%f",
__LINE__, -4.757456106385936e+23,	"-4.75746e+23", "%g",
__LINE__, -4.770895495642298e+27,	"-4770895495642298200777986494.358629", "%2f",
__LINE__, -4.775073456318149e+29,	"-4.775073E+29", "%#E",
__LINE__, -4.779997387204258e+17,	"-4.78e+17", "%g",
__LINE__, -4.799264315770707e-23,	"-4.799264E-23", "%+.7G",
__LINE__, -4.814277930599660e+10,	"-5e+10", "%2.1g",
__LINE__, -4.818413387018612e+05,	"-5e+05", "%.0g",
__LINE__, -4.818827195107612e-16,	"-4.818827e-16", "%e",
__LINE__, -4.841524514024803e+21,	"-4.84152E+21", "%G",
__LINE__, -4.860585077313477e+10,	"-4.86059E+10", "%+G",
__LINE__, -4.870037451948589e+28,	"-48700374519485887248038125107.996166", "%f",
__LINE__, -4.888835952705153e-28,	"-4.888836E-28", "%+E",
__LINE__, -4.893523355754114e-19,	"-4.893523e-19", "%.6e",
__LINE__, -4.906070260482585e+17,	"-490607026048258454", "%+.0f",
__LINE__, -4.907734144101900e+25,	"-5E+25", "%+.1G",
__LINE__, -4.917899547741841e-25,	"-4.917900e-25", "%e",
__LINE__, -4.923348512538722e+25,	"-49233485125387215219916470.232420", "%+.6f",
__LINE__, -4.926052630078460e-26,	"-4.926053e-26", "%e",
__LINE__, -4.926751662051156e+14,	"-4.927E+14", "%+5.3E",
__LINE__, -4.928017952199046e-12,	"-0.000000", "%f",
__LINE__, -4.944296782981195e-21,	"-4.9443E-21", "%1.5G",
__LINE__, -4.947320427183599e-19,	"-4.947320e-19", "%.6e",
__LINE__, -4.968188938972135e+17,	"-4.96819E+17", "%G",
__LINE__, -4.968756725758674e+05,	"-496876", "%G",
__LINE__, -4.968788759793340e-26,	"-4.97E-26", "%.3G",
__LINE__, -4.983904999913364e-24,	"-5E-24", "%0.G",
__LINE__, -4.985209496522767e+23,	"-4.985209e+23", "%e",
__LINE__, -4.987363880732866e+08,	"-4.98736E+08", "%G",
__LINE__, -4.989754940144973e+05,	"-498975.494014", "%f",
__LINE__, -4.998203870733718e-25,	"-4.9982e-25", "%g",
__LINE__, -4.999153445016792e-27,	"-5e-27", "%+1.e",
__LINE__, -5.002693488258108e+06,	" -5e+06", "%+7.g",
__LINE__, -5.017958458603783e+05,	"-5.0179585E+05", "%+.7E",
__LINE__, -5.028902178573363e-12,	"-5.0289e-12", "%0g",
__LINE__, -5.032337536971444e+07,	"-50323375.369714", "%f",
__LINE__, -5.036525516370473e-24,	"-5.0365e-24", "%4.5g",
__LINE__, -5.038642321515756e+18,	"-5038642321515755639.893541", "%f",
__LINE__, -5.051003516976770e-14,	"-5.051E-14", "%+G",
__LINE__, -5.051196143816789e+27,	"-5.0512e+27", "%g",
__LINE__, -5.057372886713786e+28,	"-5.057373e+28", "%#e",
__LINE__, -5.057475029459727e+12,	"-5.05748e+12", "%+g",
__LINE__, -5.068286816124670e-17,	"-5.068E-17", "%5.3E",
__LINE__, -5.070475165759468e-12,	"-0.000000", "%4.6f",
__LINE__, -5.081352543220476e+20,	"-5.081E+20", "%.3E",
__LINE__, -5.084398319179363e+11,	"-508439831917.936313", "%#f",
__LINE__, -5.085781220648484e+05,	"-5.E+05", "%+#7.G",
__LINE__, -5.094941054632498e-24,	"-5.09494E-24", "%+G",
__LINE__, -5.100059596310871e-10,	"-5.10006e-10", "%3.6g",
__LINE__, -5.103072553594136e-01,	"-0.5", "%+1.g",
__LINE__, -5.106319890388412e+08,	"-5.106320e+08", "%4e",
__LINE__, -5.107120687977690e+09,	"-5107120687.977690", "%f",
__LINE__, -5.119910716893161e-13,	"-5.11991E-13", "%6G",
__LINE__, -5.127594569425709e-29,	"-5.12759e-29", "%#g",
__LINE__, -5.130365585632797e+29,	"-5.13037e+29", "%#g",
__LINE__, -5.131415638022112e+08,	"-513141563.802211", "%0f",
__LINE__, -5.144703216335916e-23,	"-5.1447e-23", "%g",
__LINE__, -5.152511923201882e-05,	"-5.15251E-05", "%+G",
__LINE__, -5.165484448280190e-12,	" -0.0", "%5.1f",
__LINE__, -5.179220760465737e-20,	"-5e-20", "%+5.g",
__LINE__, -5.183005119662180e-10,	"-5.183005E-10", "%+E",
__LINE__, -5.199587953258117e+13,	"-5.19959e+13", "%6g",
__LINE__, -5.202041951844580e-25,	"-0.000000", "%f",
__LINE__, -5.202836038621740e+00,	"-5.20284", "%G",
__LINE__, -5.212204099528552e-11,	"-5.2122e-11", "%.6g",
__LINE__, -5.225617726710534e+17,	"-522561772671053414.995868", "%+f",
__LINE__, -5.230162003281426e+25,	"-52301620032814257754694153.84578", "%+6.5f",
__LINE__, -5.251849429321286e-11,	"-5.25185e-11", "%g",
__LINE__, -5.265174939930368e+23,	"-5.265175E+23", "%1.6E",
__LINE__, -5.271218134351422e+21,	"-5.27122e+21", "%+1g",
__LINE__, -5.273823357545750e+17,	"-527382335754575048.980541", "%f",
__LINE__, -5.279848797214957e+11,	"-527984879721.495659", "%0f",
__LINE__, -5.281551888625290e+11,	"-5e+11", "%4.g",
__LINE__, -5.281780377142961e-24,	"-5.28178e-24", "%g",
__LINE__, -5.292125782379512e+03,	"-5292.125782", "%f",
__LINE__, -5.292401691410388e+15,	"-5292401691410387.520875", "%f",
__LINE__, -5.305120752102265e-25,	"-5.30512e-25", "%+#.5e",
__LINE__, -5.317975791704413e+16,	"-5.31798e+16", "%+g",
__LINE__, -5.336522843607233e+27,	"-5.33652e+27", "%#6g",
__LINE__, -5.342016438000917e-05,	" -5e-05", "%+7.e",
__LINE__, -5.351122291549103e+06,	"-5351122.291549", "%+0f",
__LINE__, -5.352043956303597e+00,	"-5.35204", "%g",
__LINE__, -5.353582488767747e+09,	"-5.354E+09", "%7.3E",
__LINE__, -5.383420177718380e+04,	"-5e+04", "%1.e",
__LINE__, -5.384320189791882e-10,	"-5.384320e-10", "%e",
__LINE__, -5.409487543257379e-12,	"-5.40949E-12", "%G",
__LINE__, -5.418395794776773e+23,	"-5.4184e+23", "%g",
__LINE__, -5.419918795921525e-09,	"-0.000000", "%+f",
__LINE__, -5.422374157832442e+11,	"-5.42237e+11", "%3g",
__LINE__, -5.426916951577001e-27,	"-5.42692E-27", "%+G",
__LINE__, -5.430058833461779e+28,	"-5.43006E+28", "%G",
__LINE__, -5.444433348653147e+23,	"-5.444433E+23", "%E",
__LINE__, -5.446560186537024e+09,	"-5.446560E+09", "%E",
__LINE__, -5.464243500152188e+27,	"-5.46424E+27", "%G",
__LINE__, -5.464427517531742e+20,	"-546442751753174249529.365625", "%f",
__LINE__, -5.465783705970954e+05,	"-5E+05", "%1.E",
__LINE__, -5.475138077475789e-11,	"-5e-11", "%.0e",
__LINE__, -5.475302250616576e+10,	"-54753022506.1658", "%.4f",
__LINE__, -5.488964905442472e+09,	"-5.48896e+09", "%g",
__LINE__, -5.492508526846316e-08,	"-5.49251e-08", "%.6g",
__LINE__, -5.520533408804846e-15,	"-5.520533e-15", "%e",
__LINE__, -5.532744688447266e+28,	"-55327446884472664123677532188.594341", "%2.6f",
__LINE__, -5.535834653450131e-14,	"-5.5e-14", "%0.1e",
__LINE__, -5.554344735392882e-02,	"-5.554345E-02", "%+#E",
__LINE__, -5.555497334515501e-17,	"-5.5555e-17", "%g",
__LINE__, -5.558304303221977e+14,	"-555830430322197.699411", "%f",
__LINE__, -5.562210815777694e-05,	"-5.562211E-05", "%#1E",
__LINE__, -5.564800722538402e-09,	"-5.56480e-09", "%#.6g",
__LINE__, -5.567143271590439e-01,	"-5.567143e-01", "%#e",
__LINE__, -5.568606044396186e+01,	"-55.6861", "%4g",
__LINE__, -5.592027856401721e+12,	"-5.592028e+12", "%.7g",
__LINE__, -5.592295342565443e+22,	"-6.E+22", "%#3.G",
__LINE__, -5.600007421926053e+07,	"-56000074.219261", "%1f",
__LINE__, -5.601444553155006e-12,	"-5.60144E-12", "%G",
__LINE__, -5.605128912835080e-03,	"-0.005605", "%+f",
__LINE__, -5.610950285679577e+19,	"-5.61095E+19", "%G",
__LINE__, -5.622074657679467e+11,	"-562207465767.946690", "%f",
__LINE__, -5.627358352391656e-01,	"-0.6", "%1.g",
__LINE__, -5.627974317622488e-02,	"-5.627974e-02", "%+e",
__LINE__, -5.629497696447229e+27,	"-5.629E+27", "%+.4G",
__LINE__, -5.631383567258576e-29,	"-5.63138e-29", "%0g",
__LINE__, -5.635241327177333e-18,	"-5.63524E-18", "%G",
__LINE__, -5.644819783138381e+06,	"-5.644820E+06", "%#E",
__LINE__, -5.648538459114833e+26,	"-564853845911483265496144667.849876", "%+f",
__LINE__, -5.649004865848537e+00,	"-5.649", "%g",
__LINE__, -5.653403316885170e+23,	"-6E+23", "%2.0E",
__LINE__, -5.656109962244926e-18,	"-0.000000", "%f",
__LINE__, -5.674988031695793e+22,	"-5.674988E+22", "%+.7G",
__LINE__, -5.686380226400881e-22,	"-0.000000", "%f",
__LINE__, -5.698840855829442e-14,	"-5.69884E-14", "%G",
__LINE__, -5.707036642649580e+03,	"-5707.036643", "%f",
__LINE__, -5.710344882278847e+11,	"-5.71034E+11", "%+G",
__LINE__, -5.714852196401017e+19,	"-5.71485E+19", "%+G",
__LINE__, -5.720153622156089e-22,	"-5.72015E-22", "%G",
__LINE__, -5.722366011976922e+26,	"-5.72237e+26", "%+g",
__LINE__, -5.722909928097404e+12,	"-5.72291E+12", "%2G",
__LINE__, -5.725325961787777e-25,	"-5.72533e-25", "%g",
__LINE__, -5.727138241052646e+19,	"-5.72714e+19", "%+#g",
__LINE__, -5.734025840446336e+14,	"-5.73403e+14", "%+g",
__LINE__, -5.736469106710259e-05,	"-0.000057", "%.6f",
__LINE__, -5.755099153733116e-14,	"-5.7551e-14", "%+g",
__LINE__, -5.758411844890947e-20,	"-6E-20", "%+6.G",
__LINE__, -5.760350214122813e+03,	"-5760.35", "%+g",
__LINE__, -5.768009192512392e-30,	"-0", "%1.f",
__LINE__, -5.772343286693103e+07,	"-5.77234E+07", "%G",
__LINE__, -5.776693265471852e-27,	"-5.776693E-27", "%E",
__LINE__, -5.779682861172754e-28,	"-5.779683e-28", "%e",
__LINE__, -5.789953490749936e+26,	"-578995349074993637117358957.76656", "%5.5f",
__LINE__, -5.796771264754334e+04,	"-57967.7", "%g",
__LINE__, -5.804788370597286e-02,	"-5.80479E-02", "%+#1.5E",
__LINE__, -5.805343475329215e-13,	"-5.80534e-13", "%g",
__LINE__, -5.809853913830122e+09,	"-5809853914", "%+0.f",
__LINE__, -5.817313814570609e-30,	"     -0", "%7.0f",
__LINE__, -5.831708441750138e+00,	"-5.83171", "%#g",
__LINE__, -5.846914550593652e+29,	"-5.846915e+29", "%e",
__LINE__, -5.851455214762288e+04,	"-58514.6", "%+G",
__LINE__, -5.855803663871393e-23,	"-6E-23", "%5.E",
__LINE__, -5.858065129988470e+10,	"-5.85807e+10", "%+g",
__LINE__, -5.863147168075411e-14,	"-5.86315e-14", "%+g",
__LINE__, -5.878936740266680e-04,	"-0.000587894", "%g",
__LINE__, -5.887654893386630e+25,	"-58876548933866299506689756.526612", "%#f",
__LINE__, -5.889416409731902e-02,	"-0.06", "%5.g",
__LINE__, -5.897630195029892e-18,	"-5.897630E-18", "%#0.7G",
__LINE__, -5.898506808456422e-19,	"-5.89851E-19", "%G",
__LINE__, -5.901768645393515e+29,	"-5.90177E+29", "%+G",
__LINE__, -5.907529093570369e+10,	"-59075290935.703695", "%f",
__LINE__, -5.910069365260240e+13,	"-59100693652602.39849", "%+#5.5f",
__LINE__, -5.915678929676435e-07,	"-0.000001", "%+f",
__LINE__, -5.922232380131716e-01,	"-0.592223", "%+3f",
__LINE__, -5.923716473994306e+19,	"-5.92372E+19", "%+#.6G",
__LINE__, -5.929950428920404e-15,	"-5.929950e-15", "%+e",
__LINE__, -5.949552735665802e+26,	"-5.94955e+26", "%#g",
__LINE__, -5.949977081310732e-02,	"-0.059500", "%f",
__LINE__, -5.954520303889356e-07,	"-5.954520E-07", "%5E",
__LINE__, -5.978861337429145e-13,	"-6E-13", "%1.G",
__LINE__, -5.980539445081087e+15,	"-5.98054E+15", "%.6G",
__LINE__, -5.981724990853490e-03,	" -0.006", "%#7.g",
__LINE__, -5.989488907825821e+03,	"-6E+03", "%.2G",
__LINE__, -5.998272294890842e+06,	"-6.00E+06", "%4.2E",
__LINE__, -6.023775731455919e-29,	"-6.023776e-29", "%e",
__LINE__, -6.028153126666870e-05,	"-6.e-05", "%+#6.e",
__LINE__, -6.036200621484690e+25,	"-6e+25", "%2.2g",
__LINE__, -6.036400640928137e-14,	"-6.036401e-14", "%e",
__LINE__, -6.038198451098329e-20,	"-6.038198e-20", "%1.7g",
__LINE__, -6.045778975641123e-15,	"-6.04578E-15", "%G",
__LINE__, -6.046038904252073e+00,	"-6.04604", "%g",
__LINE__, -6.082158462782175e-06,	"-0.000006", "%+#f",
__LINE__, -6.106162726644904e+10,	"-6.10616e+10", "%g",
__LINE__, -6.126345215489182e+10,	"-6e+10", "%+1.g",
__LINE__, -6.131852309620571e+02,	"-6e+02", "%4.e",
__LINE__, -6.134589313243809e-01,	"-0.613459", "%+#f",
__LINE__, -6.142358153783462e-10,	"-6.14236E-10", "%4G",
__LINE__, -6.151524334856263e+27,	"-6151524334856262932191839354.345575", "%+6f",
__LINE__, -6.156818333724550e+04,	"-6.e+04", "%#.1g",
__LINE__, -6.166172551433993e+24,	"-6166172551433993120895138.4178", "%5.4f",
__LINE__, -6.169532428006014e-09,	"-6.16953e-09", "%3g",
__LINE__, -6.172019382601770e-28,	"-0.000000", "%+f",
__LINE__, -6.174496985807155e-09,	"-6.1745E-09", "%G",
__LINE__, -6.186771845105751e+04,	"-61867.7", "%G",
__LINE__, -6.200817973780066e+22,	"-6.20082E+22", "%3G",
__LINE__, -6.218004335456301e-22,	"-0.000000", "%+f",
__LINE__, -6.219009630546262e-18,	"-6.22e-18", "%6.3g",
__LINE__, -6.242532875230618e-06,	"-0.000006", "%7f",
__LINE__, -6.243612261280864e+14,	"-6.24361e+14", "%.6g",
__LINE__, -6.243689597320126e+10,	"-6e+10", "%.0e",
__LINE__, -6.244620667090527e+04,	"-6e+04", "%6.e",
__LINE__, -6.250789625572054e-09,	"-0.000000", "%+f",
__LINE__, -6.253537566219164e+01,	"-63.", "%#1.f",
__LINE__, -6.284420289484166e+21,	"-6.2844203e+21", "%7.7e",
__LINE__, -6.285939888202846e+27,	"-6e+27", "%+.0g",
__LINE__, -6.290025777678105e+13,	"-6E+13", "%2.E",
__LINE__, -6.291364254323924e+10,	"-6.3E+10", "%3.2G",
__LINE__, -6.292428812164449e+15,	"-6292428812164448.714839", "%.6f",
__LINE__, -6.292600606358002e+29,	"-6.29260E+29", "%#G",
__LINE__, -6.292739629144148e-15,	"-6.292740E-15", "%E",
__LINE__, -6.296471626465745e+28,	"-6.29647E+28", "%G",
__LINE__, -6.299575066640315e+27,	"-6.300E+27", "%.3E",
__LINE__, -6.315234679394876e-24,	"-6E-24", "%2.G",
__LINE__, -6.320883246383228e-01,	"-0.632088", "%2g",
__LINE__, -6.324938413548937e-11,	"-6e-11", "%.1g",
__LINE__, -6.336312983176250e+04,	"-6.336313e+04", "%e",
__LINE__, -6.341786787214541e+06,	"-6.341787E+06", "%+7.6E",
__LINE__, -6.360189291106185e-15,	"-0.0000000", "%#.7f",
__LINE__, -6.364818355457748e-15,	"-0.0000000", "%1.7f",
__LINE__, -6.366291103431814e+04,	"-63662.9", "%#G",
__LINE__, -6.366334042923153e-05,	"-6.37e-05", "%5.3g",
__LINE__, -6.370477455143194e-12,	"-0.000000", "%f",
__LINE__, -6.372829256546279e+23,	"-6.37283E+23", "%G",
__LINE__, -6.375208490193110e-23,	"-6.37521e-23", "%4.5e",
__LINE__, -6.382595100891736e-24,	"-6.3826E-24", "%5G",
__LINE__, -6.396882421146790e-22,	"-6.39688e-22", "%+g",
__LINE__, -6.407190354039938e+08,	"-6.40719e+08", "%+g",
__LINE__, -6.408581541430886e-10,	"-6.E-10", "%#0.0G",
__LINE__, -6.409206904981703e-03,	"-0.006", "%+.0G",
__LINE__, -6.416106714707772e+26,	"-641610671470777216285341637.558304", "%f",
__LINE__, -6.417436981761998e-04,	"-0.000642", "%+#f",
__LINE__, -6.429997249673124e+11,	"-642999724967.312414", "%#f",
__LINE__, -6.440827429825250e+16,	"-6.44083E+16", "%G",
__LINE__, -6.444869858444955e+02,	"-6e+02", "%6.g",
__LINE__, -6.471701890976228e-25,	" -6e-25", "%7.1g",
__LINE__, -6.485393161670371e-12,	"-6.485393e-12", "%.6e",
__LINE__, -6.487710907063584e+23,	"-6.E+23", "%#3.E",
__LINE__, -6.492942931343439e-08,	"-0.", "%+#2.0f",
__LINE__, -6.496010652113223e+18,	"-6.49601e+18", "%g",
__LINE__, -6.502856921840228e+22,	"-6.50286e+22", "%4g",
__LINE__, -6.523559906055000e-10,	"-6.52356E-10", "%.6G",
__LINE__, -6.525899074126662e+04,	"-6.5e+04", "%+.1e",
__LINE__, -6.532216801155521e-09,	"-6.53222E-09", "%G",
__LINE__, -6.544601787025684e-27,	"-0", "%+.0f",
__LINE__, -6.558968312132168e-01,	"    -1", "%+6.f",
__LINE__, -6.559654261655786e+08,	"-6.559654e+08", "%e",
__LINE__, -6.566562622196495e-21,	"-6.56656E-21", "%.6G",
__LINE__, -6.573486832071960e+04,	"-65734.9", "%G",
__LINE__, -6.573806290918275e+13,	"-6.57381E+13", "%G",
__LINE__, -6.578113771674787e+17,	"-6.57811E+17", "%+#G",
__LINE__, -6.584106931007506e+15,	"-6.584107E+15", "%E",
__LINE__, -6.590538844308877e+07,	"-65905388.443089", "%f",
__LINE__, -6.593708834068371e-07,	"-0.000001", "%f",
__LINE__, -6.597116446195875e+08,	"-6.5971164e+08", "%#1.7e",
__LINE__, -6.605813542127091e-04,	"-0.0007", "%+0.g",
__LINE__, -6.607491403866429e+07,	"-7e+07", "%3.g",
__LINE__, -6.616499847522278e+09,	"-6.61650E+09", "%+#G",
__LINE__, -6.618619768691332e+20,	"-7E+20", "%2.G",
__LINE__, -6.626748168962331e-22,	"-7.E-22", "%+#3.E",
__LINE__, -6.639335450348280e+12,	"-6.63934e+12", "%g",
__LINE__, -6.643910144912576e-03,	"-0.006644", "%f",
__LINE__, -6.650293872031870e-18,	"-6.65029e-18", "%+#g",
__LINE__, -6.654903858656310e-21,	"-0.000000", "%f",
__LINE__, -6.665834666726511e-12,	"-6.665835E-12", "%E",
__LINE__, -6.666428729917570e-19,	"-0.000000", "%+#f",
__LINE__, -6.668415789681128e+27,	"-6.66842E+27", "%+G",
__LINE__, -6.675214676269601e-28,	"-6.67521e-28", "%#g",
__LINE__, -6.679560072732262e+01,	"-66.7956", "%#g",
__LINE__, -6.692325075457020e-19,	"-0.000000", "%1f",
__LINE__, -6.697096655164652e+00,	"-6.70", "%#.3g",
__LINE__, -6.712436135928394e-28,	"-7e-28", "%0.g",
__LINE__, -6.720769486122685e-16,	"-7e-16", "%0.e",
__LINE__, -6.727196898490600e+26,	"-672719689849060031860972230.8", "%.1f",
__LINE__, -6.744132627576416e+02,	"-674.413", "%6G",
__LINE__, -6.757705576425288e+28,	"-6.7577056e+28", "%.7e",
__LINE__, -6.760554929237173e-02,	"-0.067606", "%+f",
__LINE__, -6.763538810629361e+10,	"-6.7635E+10", "%.4E",
__LINE__, -6.764712008860796e-29,	"-6.76471E-29", "%+G",
__LINE__, -6.767299719678443e+04,	"-67672.997197", "%f",
__LINE__, -6.768326491352134e+20,	"-676832649135213415547.70", "%+.2f",
__LINE__, -6.771116968952891e+03,	"-7E+03", "%3.1G",
__LINE__, -6.775218099238350e-30,	"-7.e-30", "%+#6.g",
__LINE__, -6.782142689928918e-18,	"-0.00", "%4.2f",
__LINE__, -6.795409770512149e+08,	"-7E+08", "%+5.0G",
__LINE__, -6.820966157097271e+14,	"-6.820966e+14", "%e",
__LINE__, -6.824972990592273e-22,	"-0.00", "%+#1.2f",
__LINE__, -6.830452914741750e+29,	"-6.8E+29", "%+7.2G",
__LINE__, -6.835797187132348e+10,	"-6.8358E+10", "%+5G",
__LINE__, -6.837040829636343e-03,	"-0.00683704", "%+g",
__LINE__, -6.852956218658224e+23,	"-6.85296e+23", "%3g",
__LINE__, -6.854102607287217e-26,	"-7e-26", "%5.e",
__LINE__, -6.865065870249438e+16,	"-6.86507E+16", "%#G",
__LINE__, -6.884819522625523e-13,	"-6.88482E-13", "%5G",
__LINE__, -6.916316600148513e-12,	"-0.000000", "%f",
__LINE__, -6.925312418761560e-05,	"-6.92531E-05", "%#G",
__LINE__, -6.929518694178331e+09,	"-6929518694.178", "%#.3f",
__LINE__, -6.936008056682024e+02,	"-6.936008E+02", "%E",
__LINE__, -6.944911117352400e+26,	"-6.944911E+26", "%1.6E",
__LINE__, -6.945829492125162e+05,	"-6.9e+05", "%+2.2g",
__LINE__, -6.946603162471856e-13,	"-6.94660E-13", "%#G",
__LINE__, -6.947529440406653e+22,	"-6.9475e+22", "%+6.5g",
__LINE__, -6.950167604854856e-30,	"-0.000000", "%7f",
__LINE__, -6.958122319262799e-26,	"-7E-26", "%+1.E",
__LINE__, -6.958978258390961e+16,	"-6.95898E+16", "%+5.6G",
__LINE__, -6.963780466334008e-06,	"-6.96378E-06", "%2G",
__LINE__, -6.965570896221966e+13,	"-6.965571E+13", "%5E",
__LINE__, -6.967741871945064e-10,	"-6.96774E-10", "%+#G",
__LINE__, -6.973815739524307e+19,	"-69738157395243067782.076", "%6.3f",
__LINE__, -6.982714545008106e+13,	"-6.98271e+13", "%g",
__LINE__, -6.985955885054476e+03,	"-6985.96", "%6G",
__LINE__, -6.986415266835747e+18,	"-6.98642e+18", "%#g",
__LINE__, -6.996461529596512e-08,	"-7.0E-08", "%#.1E",
__LINE__, -7.000144914012241e-05,	"-7.00014e-05", "%#g",
__LINE__, -7.001017894492730e-03,	"-0.00700102", "%+#.6G",
__LINE__, -7.003690685875917e+20,	"-7E+20", "%0.G",
__LINE__, -7.010454163965384e+00,	"-7.010454e+00", "%+e",
__LINE__, -7.011493550018082e-26,	"     -0", "%7.f",
__LINE__, -7.018018443394008e+21,	"-7.0E+21", "%+#1.1E",
__LINE__, -7.027253777387243e-05,	"-7.02725E-05", "%+G",
__LINE__, -7.043679213677740e-17,	"-0", "%1.f",
__LINE__, -7.051690489227881e-16,	"-7.052e-16", "%0.4g",
__LINE__, -7.063422475274161e-16,	"-7.063422E-16", "%E",
__LINE__, -7.065069592235558e-30,	"-7.06507e-30", "%+#g",
__LINE__, -7.068265283935834e-29,	"-7e-29", "%+5.e",
__LINE__, -7.068748224536295e-13,	"-0.000000", "%f",
__LINE__, -7.069621910708177e-04,	"-0.000707", "%1.3g",
__LINE__, -7.079725450964823e-12,	"-0.000000", "%f",
__LINE__, -7.087255464668218e+17,	"-7.1e+17", "%.1e",
__LINE__, -7.088715102009605e-09,	"-7e-09", "%6.0g",
__LINE__, -7.090414916270137e-15,	"-0.00000", "%.5f",
__LINE__, -7.091868311008428e-03,	" -0.0", "%5.1f",
__LINE__, -7.094242165237718e+21,	"-7.09424e+21", "%+g",
__LINE__, -7.094324305740325e-05,	"-7E-05", "%+3.G",
__LINE__, -7.104544752289144e+04,	"-71045.4", "%#g",
__LINE__, -7.105164644813694e-29,	"-0.000000", "%+f",
__LINE__, -7.114513164219487e-12,	"-7.11451e-12", "%+g",
__LINE__, -7.115778236604137e-12,	"-7.11578E-12", "%G",
__LINE__, -7.126217683410162e-27,	"-7.126218e-27", "%e",
__LINE__, -7.136214260967733e+28,	"-71362142609677334803564008325.338364", "%f",
__LINE__, -7.143452595522573e+19,	"-7.14345e+19", "%g",
__LINE__, -7.156042088843537e+27,	"-7156042088843537207765166385.7977837", "%4.7f",
__LINE__, -7.173687683710490e+24,	"-7.17369e+24", "%6g",
__LINE__, -7.190531162598206e+25,	"-71905311625982060164119503", "%4.f",
__LINE__, -7.201301831373747e-09,	"-7.2013e-09", "%g",
__LINE__, -7.209601436737306e+10,	"-7.2096e+10", "%g",
__LINE__, -7.211058997356655e-06,	"-7.211059E-06", "%E",
__LINE__, -7.226756177676272e-09,	"-7.22676E-09", "%+G",
__LINE__, -7.230870817566419e+19,	"-72308708175664193618.1040364", "%#.7f",
__LINE__, -7.231355992133345e-05,	"-7.231356E-05", "%#E",
__LINE__, -7.245999575278407e-12,	"-7.246e-12", "%g",
__LINE__, -7.247426403040390e-09,	"-7.2474E-09", "%+4.5G",
__LINE__, -7.257348680308567e-12,	"-7.3E-12", "%1.2G",
__LINE__, -7.258184256387366e-26,	"-7.25818E-26", "%+2G",
__LINE__, -7.262633672900126e+10,	"-7.26263e+10", "%#g",
__LINE__, -7.268887462426250e+03,	"-7.268887e+03", "%+#e",
__LINE__, -7.275284494682963e+08,	"-7.27528e+08", "%g",
__LINE__, -7.276335846256479e-07,	"  -0", "%4.f",
__LINE__, -7.312556378294452e+15,	"-7.31256e+15", "%+6g",
__LINE__, -7.334763752442417e-15,	"-0.0000", "%#.4f",
__LINE__, -7.354627097325888e-18,	"-7E-18", "%0.E",
__LINE__, -7.360087573342401e-25,	"-7.4E-25", "%6.2G",
__LINE__, -7.368533563361098e-29,	"-7.4E-29", "%3.1E",
__LINE__, -7.379267723540596e-06,	"-0.000007", "%f",
__LINE__, -7.384525781709565e-19,	"-0.000000", "%+#f",
__LINE__, -7.388940868679677e-09,	"-7.388941E-09", "%E",
__LINE__, -7.391602149099698e+00,	"-7.391602E+00", "%E",
__LINE__, -7.393159340196723e+22,	"-7.39316e+22", "%#2.6g",
__LINE__, -7.399783260198277e-16,	"-7.39978E-16", "%G",
__LINE__, -7.405609590448331e-06,	"-7.40561e-06", "%g",
__LINE__, -7.407396977847794e-11,	"-7.40740E-11", "%#G",
__LINE__, -7.433716848698637e+20,	"-7.43372e+20", "%+g",
__LINE__, -7.444176062769411e-01,	"-0.744418", "%#g",
__LINE__, -7.448314697244012e+12,	"-7448314697244.011739", "%f",
__LINE__, -7.449533988369018e+08,	"-7.449534e+08", "%+#7e",
__LINE__, -7.465682839758801e-01,	"-7E-01", "%4.E",
__LINE__, -7.466517843126368e-26,	"-7.5E-26", "%.1E",
__LINE__, -7.471385785539900e+24,	"-7471385785539899515583783.795591", "%f",
__LINE__, -7.478345583780341e+00,	"-7.478346e+00", "%e",
__LINE__, -7.524759284626724e-06,	"-7.52476e-06", "%2g",
__LINE__, -7.534831049342539e-19,	"-7.53483E-19", "%G",
__LINE__, -7.540546673179273e+15,	"-8e+15", "%.1g",
__LINE__, -7.543440436184003e-08,	"-7.54344E-08", "%6G",
__LINE__, -7.558224240835564e-06,	"-7.55822e-06", "%g",
__LINE__, -7.564132915154469e+23,	"-756413291515446850610260.298708", "%+f",
__LINE__, -7.566590720355392e+15,	"-7.566591e+15", "%1.6e",
__LINE__, -7.568565927479741e-01,	"-7.568566e-01", "%#6e",
__LINE__, -7.615574141973305e-17,	"-7.6156e-17", "%+.5g",
__LINE__, -7.641297631509318e-28,	"-8e-28", "%+.1g",
__LINE__, -7.661227834163450e+09,	"-7661227834.1634497", "%+#.7f",
__LINE__, -7.665934364070126e+11,	"-766593436407.0", "%.1f",
__LINE__, -7.682500068463102e-27,	"-0.000000", "%+#f",
__LINE__, -7.709363160273798e+15,	"-7.70936e+15", "%g",
__LINE__, -7.712596019255238e+26,	"-7.7e+26", "%.2g",
__LINE__, -7.730213358437991e+25,	"-7.7e+25", "%6.2g",
__LINE__, -7.744420019068976e+05,	"-7.74442E+05", "%.5E",
__LINE__, -7.745813181942296e+11,	"-7.7458132e+11", "%+.7e",
__LINE__, -7.751004379716307e+16,	"-7.751004e+16", "%e",
__LINE__, -7.759862226564527e-28,	"-7.75986e-28", "%g",
__LINE__, -7.767838880221207e-27,	"-7.76784e-27", "%g",
__LINE__, -7.776301142157532e-19,	"-0", "%2.f",
__LINE__, -7.783944257077553e-14,	"-8e-14", "%3.g",
__LINE__, -7.801587579382377e+28,	"-8e+28", "%+0.g",
__LINE__, -7.806685979552780e+25,	"-7.806686E+25", "%E",
__LINE__, -7.825968891331719e-05,	"-7.82597E-05", "%G",
__LINE__, -7.826834158664018e+12,	"-7.826834E+12", "%+#E",
__LINE__, -7.832536798726886e+24,	"-7.83254E+24", "%#1G",
__LINE__, -7.840485340202362e-18,	"-0.000000", "%.6f",
__LINE__, -7.843236212099233e+21,	"-7.84324e+21", "%g",
__LINE__, -7.906644052019278e-13,	"-7.906644E-13", "%E",
__LINE__, -7.908090440678874e-20,	"-7.90809E-20", "%#G",
__LINE__, -7.917588593012283e+08,	"-7.917589E+08", "%+E",
__LINE__, -7.929100086742454e+29,	"-792910008674245414539427656563.930213", "%f",
__LINE__, -7.933235286034290e+26,	"-7.933235E+26", "%E",
__LINE__, -7.943431966567875e-03,	"-0.0079434", "%+.5g",
__LINE__, -7.950872643572970e-22,	"-7.95087e-22", "%2g",
__LINE__, -7.971225555313069e-01,	"-0.797123", "%f",
__LINE__, -7.978310272676090e-12,	"-0.000000", "%#f",
__LINE__, -8.006805393896414e-29,	"-8.00681E-29", "%G",
__LINE__, -8.006906303018830e+25,	"-8.00691E+25", "%+G",
__LINE__, -8.008484654476057e+18,	"-8.008485e+18", "%5.6e",
__LINE__, -8.008943512904249e+27,	"-8008943512904249217854157905.0943", "%+.4f",
__LINE__, -8.016539743121665e+27,	"-8.01654E+27", "%G",
__LINE__, -8.018247227006128e-05,	" -8E-05", "%7.G",
__LINE__, -8.044391842561705e+21,	"-8.04439e+21", "%g",
__LINE__, -8.081902305002036e-02,	"-8.081902E-02", "%E",
__LINE__, -8.084193011936438e-03,	"-0.0080842", "%+5.5g",
__LINE__, -8.105813534846529e-27,	"-0.000000", "%f",
__LINE__, -8.128116892989251e+00,	"-8.12812", "%G",
__LINE__, -8.136119035731877e+05,	"-8e+05", "%+0.g",
__LINE__, -8.140584224052606e+14,	"-8E+14", "%5.G",
__LINE__, -8.145928897003907e+13,	"-8.15E+13", "%.3G",
__LINE__, -8.164495905907508e-02,	"-0.081645", "%G",
__LINE__, -8.169602113313905e+20,	"-8.16960e+20", "%#g",
__LINE__, -8.179181640418333e+24,	"-8.E+24", "%#.1G",
__LINE__, -8.184324492264231e-18,	"-8.18432E-18", "%G",
__LINE__, -8.186480473850516e-28,	"-0.000000", "%+f",
__LINE__, -8.196858948158896e+07,	"-8.1969E+07", "%.4E",
__LINE__, -8.213138534699043e-30,	"-0.000000", "%f",
__LINE__, -8.221181368676532e-21,	"-8.221181E-21", "%#1E",
__LINE__, -8.222605734191438e+16,	"-8.22261E+16", "%+G",
__LINE__, -8.223925661091432e-14,	"-8.223926e-14", "%0e",
__LINE__, -8.232281541044777e-01,	"-0.823228", "%f",
__LINE__, -8.245536794508725e+22,	"-8E+22", "%6.G",
__LINE__, -8.270687365305925e+25,	"-82706873653059247430974210.146815", "%f",
__LINE__, -8.288978945738204e+11,	"-8.28898e+11", "%5g",
__LINE__, -8.290628698333139e+02,	"-829.063", "%+G",
__LINE__, -8.292416206056451e-16,	"-8.29242e-16", "%+g",
__LINE__, -8.296322623746486e-13,	"-8.29632E-13", "%0.6G",
__LINE__, -8.298321941376933e-16,	"-0.000000", "%+f",
__LINE__, -8.302331258878365e+29,	"-8.30233E+29", "%0G",
__LINE__, -8.309022429255061e+06,	"-8309022.429255", "%+f",
__LINE__, -8.312786829254646e-23,	"-8.312787e-23", "%e",
__LINE__, -8.313852965178063e-15,	"-8.313853e-15", "%#7e",
__LINE__, -8.317529094827869e+16,	"-8.31753E+16", "%2G",
__LINE__, -8.322847660882248e-17,	"-0.000000", "%f",
__LINE__, -8.324060602752638e-30,	"-8.32406e-30", "%#g",
__LINE__, -8.325043500735461e+27,	"-8325043500735461066142306663.095951", "%#f",
__LINE__, -8.332432016286935e-02,	"-0.0833243", "%g",
__LINE__, -8.334251670232117e-09,	"-8.33425e-09", "%g",
__LINE__, -8.338076225141778e+02,	"-833.808", "%g",
__LINE__, -8.338349587571534e-23,	"-8.33835e-23", "%+2g",
__LINE__, -8.342420812231939e+23,	"-834242081223193920891390.00745", "%+0.5f",
__LINE__, -8.347404637940894e+17,	"-8.347405e+17", "%+e",
__LINE__, -8.367002601133880e-12,	"-0.000000", "%#2.6f",
__LINE__, -8.368579538210858e-17,	"-8.36858e-17", "%5g",
__LINE__, -8.392398522472401e-10,	"-0.0000", "%.4f",
__LINE__, -8.393029677635258e-29,	" -8E-29", "%7.G",
__LINE__, -8.393843230819225e-11,	"-8.393843E-11", "%E",
__LINE__, -8.397239871789148e-11,	"-8.39724e-11", "%g",
__LINE__, -8.402316358199041e-29,	"-0.000", "%3.3f",
__LINE__, -8.402910159034304e-14,	"-8.4e-14", "%+0.3g",
__LINE__, -8.414960962391726e+09,	"-8414960962.391726", "%#f",
__LINE__, -8.417512471384889e-28,	"-8.417512e-28", "%e",
__LINE__, -8.418719240222911e+21,	"-8418719240222911182058.851409", "%f",
__LINE__, -8.421210956044195e-09,	"-0.00000", "%.5f",
__LINE__, -8.422001733529095e+24,	"-8E+24", "%0.G",
__LINE__, -8.443614453772469e+21,	"-8.44361E+21", "%+G",
__LINE__, -8.445883044175737e-19,	"-0", "%+1.f",
__LINE__, -8.460545304711022e-01,	"-0.846055", "%G",
__LINE__, -8.470462532754567e+12,	"-8.47E+12", "%6.3G",
__LINE__, -8.478488782426476e-07,	"-8.478489E-07", "%E",
__LINE__, -8.478657582923923e+09,	"-8.5e+09", "%.2g",
__LINE__, -8.482732098043366e+12,	"-8482732098043", "%5.f",
__LINE__, -8.489112373854447e+07,	"-8.489e+07", "%#3.3e",
__LINE__, -8.494153144629106e+02,	"-849.415", "%+g",
__LINE__, -8.496331191616493e+28,	"-8E+28", "%+6.G",
__LINE__, -8.503711894495339e+05,	"-850371", "%g",
__LINE__, -8.505271893964268e+14,	"-8.505272E+14", "%E",
__LINE__, -8.509873985358741e+15,	"-9.e+15", "%#7.g",
__LINE__, -8.518336897898081e-20,	"-8.51834E-20", "%G",
__LINE__, -8.529588044136128e+21,	"-8.529588E+21", "%E",
__LINE__, -8.539706586811079e-23,	"-8.53971E-23", "%G",
__LINE__, -8.545924619642008e+10,	"-8.545925e+10", "%6e",
__LINE__, -8.572893681637353e+09,	"-8.57289E+09", "%G",
__LINE__, -8.585483717692345e+29,	"-8.58548E+29", "%+G",
__LINE__, -8.586092014292309e+27,	"-8.59e+27", "%.2e",
__LINE__, -8.604716827086833e-26,	"-8.60472e-26", "%g",
__LINE__, -8.621349224186615e-04,	"-0.000862", "%f",
__LINE__, -8.626097065201103e-21,	"   -0", "%5.f",
__LINE__, -8.631700514212522e-16,	"-8.631701E-16", "%+E",
__LINE__, -8.634703359975640e-09,	"-0.000000", "%+5f",
__LINE__, -8.639393025443855e-17,	"-8.63939e-17", "%g",
__LINE__, -8.640641942556812e-11,	"-8.64064e-11", "%#g",
__LINE__, -8.646260250525495e-09,	"-0.000", "%.3f",
__LINE__, -8.667322015806242e+09,	"-8667322015.806242", "%+#f",
__LINE__, -8.690705655554451e+10,	"-8.690706E+10", "%#E",
__LINE__, -8.714299893763934e-07,	"-8.7143E-07", "%.5G",
__LINE__, -8.715729756264988e+27,	"-8.71573E+27", "%+.6G",
__LINE__, -8.716518487180945e+16,	"-9e+16", "%3.e",
__LINE__, -8.744404488756237e+25,	"-87444044887562366596966967.335902", "%4f",
__LINE__, -8.754720498369242e+13,	"-8.75472e+13", "%g",
__LINE__, -8.763198097931010e-19,	"-8.76320e-19", "%#g",
__LINE__, -8.779007408852458e+28,	"-8.77901E+28", "%G",
__LINE__, -8.794576202907937e+11,	"-8.79458E+11", "%#2.6G",
__LINE__, -8.799091520612418e-11,	"-8.799E-11", "%3.4G",
__LINE__, -8.799246265524921e+11,	"-8.79925E+11", "%G",
__LINE__, -8.809010508550436e-04,	"-8.8090E-04", "%.4E",
__LINE__, -8.817389999872653e-10,	"-8.81739e-10", "%g",
__LINE__, -8.842022428985267e-28,	"-8.842022E-28", "%E",
__LINE__, -8.851265987586864e-07,	"-0.000001", "%f",
__LINE__, -8.861985131432196e+03,	"-8861.985", "%+.7G",
__LINE__, -8.874449013455113e-29,	"-8.874449e-29", "%e",
__LINE__, -8.878752609483453e+18,	"-8.87875E+18", "%G",
__LINE__, -8.882501665315313e-04,	"-0.00088825", "%+G",
__LINE__, -8.892056241505784e-14,	"-8.89206E-14", "%G",
__LINE__, -8.895327674961603e-30,	"-8.89533E-30", "%G",
__LINE__, -8.900059462213669e-30,	"-8.900059E-30", "%+#E",
__LINE__, -8.957100548759815e+18,	"-9e+18", "%3.0e",
__LINE__, -8.961352369869012e-30,	"-8.961352e-30", "%+#2e",
__LINE__, -8.962296474587800e+02,	"-896", "%4.f",
__LINE__, -8.962536469328530e-12,	"-8.96254E-12", "%G",
__LINE__, -8.963299420391932e+21,	"-8.9633e+21", "%g",
__LINE__, -8.967736672941522e-11,	"-8.96774e-11", "%g",
__LINE__, -8.994077362462679e+11,	"-8.9940774e+11", "%+#.7e",
__LINE__, -9.000452862345622e+15,	"-9e+15", "%2.e",
__LINE__, -9.007489135361462e+07,	"-9.0075E+07", "%+2.4E",
__LINE__, -9.036271805879910e+16,	"-9.03627E+16", "%G",
__LINE__, -9.036319073700248e+22,	"-9.03632e+22", "%1g",
__LINE__, -9.043207635989237e+11,	"-9.043208e+11", "%#e",
__LINE__, -9.043856598625815e-26,	"-9e-26", "%+1.g",
__LINE__, -9.052760561065698e+14,	"-9.052761E+14", "%E",
__LINE__, -9.066480297957160e-06,	"-9E-06", "%+1.G",
__LINE__, -9.070971376440752e-01,	"-0.907097", "%g",
__LINE__, -9.073301831888273e+09,	"-9.07330E+09", "%#G",
__LINE__, -9.091228662702147e+28,	"-9E+28", "%4.G",
__LINE__, -9.093652024983832e+04,	"-9.093652E+04", "%7.6E",
__LINE__, -9.098945831139295e-04,	"-9.098946E-04", "%+1.6E",
__LINE__, -9.124981449916591e+05,	"-912498", "%G",
__LINE__, -9.132038703003394e-02,	"-0.0913204", "%#G",
__LINE__, -9.138271437433964e-04,	"-0.000913827", "%5g",
__LINE__, -9.158186427463699e-04,	"-0.000915819", "%g",
__LINE__, -9.160846358172526e+16,	"-9.160846E+16", "%#E",
__LINE__, -9.160884330810163e+17,	"-9E+17", "%+5.G",
__LINE__, -9.190271387375542e+21,	"-9.19027e+21", "%+g",
__LINE__, -9.191651872412619e-04,	"-9.191652E-04", "%E",
__LINE__, -9.196426161984341e-10,	"-9E-10", "%4.G",
__LINE__, -9.201074139774962e+09,	"-9E+09", "%4.G",
__LINE__, -9.223294284802762e+09,	"-9.22329E+09", "%G",
__LINE__, -9.224740266754996e+02,	"-9E+02", "%6.0G",
__LINE__, -9.231583780512302e-01,	"  -0.9", "%6.g",
__LINE__, -9.241998826543689e+07,	"-92419988", "%1.f",
__LINE__, -9.243603351372128e+27,	"-9.243603e+27", "%#e",
__LINE__, -9.255922697415071e+11,	"-9.25592e+11", "%g",
__LINE__, -9.265734968114124e-02,	"-0.092657", "%f",
__LINE__, -9.273132068521061e+11,	"-9.27313E+11", "%G",
__LINE__, -9.276017912826685e+27,	"-9.E+27", "%+#5.G",
__LINE__, -9.279781279788505e+17,	"-9.27978E+17", "%7G",
__LINE__, -9.305057549822465e-19,	"-9.30506E-19", "%5G",
__LINE__, -9.313182384508469e+18,	"-9.31318E+18", "%G",
__LINE__, -9.313350925182641e-12,	"-9.31E-12", "%.3G",
__LINE__, -9.362202657509130e+08,	"-9e+08", "%.1g",
__LINE__, -9.367344757598381e+19,	"-9.36734e+19", "%g",
__LINE__, -9.374222399774300e+26,	"-9.37422e+26", "%4g",
__LINE__, -9.385734023305105e+02,	"-9.385734e+02", "%+0e",
__LINE__, -9.392042570618909e+17,	"-9.39204E+17", "%G",
__LINE__, -9.395742939311926e+20,	"-939574293931192627837.8451", "%.4f",
__LINE__, -9.409066155962469e+09,	"-9.40907E+09", "%#G",
__LINE__, -9.412851077799790e+23,	"-9.412851E+23", "%E",
__LINE__, -9.431808019049818e+08,	"-9.43181e+08", "%g",
__LINE__, -9.465236900519924e-27,	"-9.46524e-27", "%g",
__LINE__, -9.478330386415852e+17,	"-9.478330e+17", "%e",
__LINE__, -9.510393719697428e+15,	"-9.51039E+15", "%+G",
__LINE__, -9.534229599909890e-09,	"-0.000000", "%f",
__LINE__, -9.541731189284823e-17,	"-1.E-16", "%+#7.G",
__LINE__, -9.548861908445902e+24,	"-9548861908445902102471336.547751", "%f",
__LINE__, -9.578447281451794e+14,	"-957844728145179", "%5.f",
__LINE__, -9.580512736933464e+11,	"-9.58051E+11", "%G",
__LINE__, -9.596838169770637e-28,	"-1E-27", "%+6.G",
__LINE__, -9.597528852877852e-22,	"-1e-21", "%2.1g",
__LINE__, -9.599943658427051e+02,	"-9.599944E+02", "%E",
__LINE__, -9.603227991185260e-14,	"-1E-13", "%+0.E",
__LINE__, -9.606818733892343e+08,	"-960681873.389", "%1.3f",
__LINE__, -9.617442692720937e+16,	"-9.61744E+16", "%G",
__LINE__, -9.628685516961109e+29,	"-9.62869e+29", "%3g",
__LINE__, -9.638354750455226e-11,	"-0.000000", "%f",
__LINE__, -9.644266379029137e+16,	"-96442663790291369.707575", "%f",
__LINE__, -9.645563533575482e+06,	"-1E+07", "%1.G",
__LINE__, -9.645993536742941e-29,	"-9.64599e-29", "%+g",
__LINE__, -9.647147223548563e+00,	"-9.647147e+00", "%e",
__LINE__, -9.671225879906396e-11,	"-0", "%0.f",
__LINE__, -9.675000471729906e-09,	"-9.675000E-09", "%E",
__LINE__, -9.683992878297159e-26,	"-9.68e-26", "%2.2e",
__LINE__, -9.695491325144765e+10,	"-9.69549E+10", "%#G",
__LINE__, -9.695661526907136e-24,	"   -0.", "%#6.f",
__LINE__, -9.703124881970338e+07,	"-9.703e+07", "%0.4g",
__LINE__, -9.707701257031864e+26,	"-970770125703186437249314622.022212", "%f",
__LINE__, -9.709879792694702e+09,	"-9.709880E+09", "%E",
__LINE__, -9.736052226907940e+26,	"-9.73605e+26", "%+#g",
__LINE__, -9.745037157520795e+07,	"-9.74504e+07", "%#5.6g",
__LINE__, -9.757293950670832e-29,	"-9.757E-29", "%0.4G",
__LINE__, -9.762126832689880e+12,	"-9.76213E+12", "%G",
__LINE__, -9.801328150341989e-01,	"     -1", "%7.G",
__LINE__, -9.837332964629669e-20,	"-9.83733E-20", "%0G",
__LINE__, -9.837790327283010e+23,	"-1E+24", "%.1G",
__LINE__, -9.839636176463729e+23,	"-9.83964E+23", "%#6.5E",
__LINE__, -9.841454250618272e+11,	"-9.84E+11", "%+2.3G",
__LINE__, -9.852920805249280e-12,	"-9.852921e-12", "%.7g",
__LINE__, -9.854092850182351e+12,	"-9.85409e+12", "%0g",
__LINE__, -9.866796026839712e+02,	"-9.9E+02", "%#.1E",
__LINE__, -9.867413260289803e-21,	"-1e-20", "%.1g",
__LINE__, -9.882136052131983e-08,	"-9.88214e-08", "%g",
__LINE__, -9.882755697941866e+20,	"-9.882756E+20", "%E",
__LINE__, -9.897275811087050e+20,	"-9.9E+20", "%0.3G",
__LINE__, -9.899860651812364e-04,	"-9.899861e-04", "%e",
__LINE__, -9.906754113555550e-11,	"-9.90675e-11", "%3g",
__LINE__, -9.926067557389940e+11,	"-9.92607E+11", "%G",
__LINE__, -9.929638609014063e+17,	"-992963860901406292.214233", "%1f",
__LINE__, -9.941214552193284e-24,	"-0.000000", "%+#f",
__LINE__, -9.942875240256573e+14,	"-9.942875e+14", "%+1e",
__LINE__, -9.944492909695798e-01,	"-9.944E-01", "%.3E",
__LINE__, -9.954710507359939e-27,	"-1e-26", "%+0.2g",
__LINE__, -9.955410507742851e+03,	"-9955.41", "%+G",
__LINE__, -9.974437672251590e+02,	"-997.444", "%#G",
__LINE__, -9.975683165288929e-26,	"-9.97568E-26", "%6G",
__LINE__, 1.003827370583415e+06,	"1003827.370583", "%3f",
__LINE__, 1.004189065268560e-27,	"1.004189E-27", "%.7G",
__LINE__, 1.005840059175462e-28,	"+1.00584E-28", "%+G",
__LINE__, 1.006586790090557e-12,	"0.000000", "%#f",
__LINE__, 1.007598594773359e+18,	"1.0076E+18", "%G",
__LINE__, 1.007902307001894e+29,	"1.0079e+29", "%g",
__LINE__, 1.008607405036580e-15,	"1.00861E-15", "%6G",
__LINE__, 1.008769102466771e+16,	"+1.00877E+16", "%+G",
__LINE__, 1.009545698372534e-08,	"+1E-08", "%+0.0G",
__LINE__, 1.010173673945099e-12,	"+1.01017e-12", "%+#0g",
__LINE__, 1.011375000606627e+09,	"1011375000.606627", "%f",
__LINE__, 1.011944652221650e+15,	"1011944652221649.98", "%3.2f",
__LINE__, 1.013057788090379e-21,	"0.000000", "%#f",
__LINE__, 1.014525729953198e+15,	"1.01453e+15", "%3g",
__LINE__, 1.016760538234615e-21,	"+1.016761E-21", "%+3E",
__LINE__, 1.017052611781237e-29,	"0.000000", "%f",
__LINE__, 1.018471223361229e+14,	"1.01847E+14", "%G",
__LINE__, 1.021646959220873e+15,	"1021646959220872.6", "%4.1f",
__LINE__, 1.022304833976590e+27,	"1.0223e+27", "%g",
__LINE__, 1.022500312067325e-12,	"1.0225e-12", "%6g",
__LINE__, 1.023019285462627e-20,	"0.000000", "%f",
__LINE__, 1.024192579400824e+06,	"1.02419e+06", "%g",
__LINE__, 1.024517953555766e-28,	"1.02452E-28", "%G",
__LINE__, 1.026673589339585e+21,	"1.02667E+21", "%G",
__LINE__, 1.027231090958880e-19,	"1.E-19", "%#3.G",
__LINE__, 1.028249904956487e-27,	"1E-27", "%5.G",
__LINE__, 1.028570144661448e-28,	"+1.02857E-28", "%+G",
__LINE__, 1.028934898454705e-13,	"+1.028935E-13", "%+E",
__LINE__, 1.029071053545906e-26,	"1.029071E-26", "%E",
__LINE__, 1.032672895881148e-30,	"+1.032673E-30", "%+E",
__LINE__, 1.033502358979511e+06,	"1.0335E+06", "%.5G",
__LINE__, 1.036790427717847e+19,	"1e+19", "%4.g",
__LINE__, 1.037022928821648e+03,	"1037.02", "%5g",
__LINE__, 1.040551683941284e+14,	"1.04055E+14", "%G",
__LINE__, 1.044499252101308e-17,	"1.044499E-17", "%E",
__LINE__, 1.045791899570889e+15,	"+1.04579e+15", "%+g",
__LINE__, 1.048730383198703e+28,	"1.049e+28", "%.4g",
__LINE__, 1.050654419882509e-18,	"0.000000", "%f",
__LINE__, 1.052600569262127e-27,	"+0.000", "%+2.3f",
__LINE__, 1.053213014784149e+15,	"1E+15", "%4.G",
__LINE__, 1.057553916225948e-15,	"+0.000000", "%+4f",
__LINE__, 1.058191244482453e+19,	"1.058e+19", "%.3e",
__LINE__, 1.058746269793972e-26,	"+1.1E-26", "%+.2G",
__LINE__, 1.058793271960762e-01,	"+1.058793E-01", "%+4E",
__LINE__, 1.058869592738370e-19,	"1.05887e-19", "%3g",
__LINE__, 1.060402312803008e+15,	"1060402312803008.229025", "%f",
__LINE__, 1.061106284763095e+00,	"1.061106", "%0f",
__LINE__, 1.061180160987467e+09,	"1e+09", "%2.g",
__LINE__, 1.061181537176067e-06,	"+1.06118e-06", "%+g",
__LINE__, 1.065021381771174e+20,	"1.06502e+20", "%g",
__LINE__, 1.065464040401130e-16,	"1.065464e-16", "%e",
__LINE__, 1.065573419819459e-05,	"0.00001", "%.5f",
__LINE__, 1.066107764306644e+13,	"1.066108e+13", "%#e",
__LINE__, 1.071318759598956e+12,	"1.071319e+12", "%e",
__LINE__, 1.071564727222321e+10,	"1.072E+10", "%3.4G",
__LINE__, 1.074652481218139e+14,	"1.0747E+14", "%.4E",
__LINE__, 1.078453684911309e-02,	"0.0107845", "%g",
__LINE__, 1.078550811446675e-05,	"1.07855e-05", "%g",
__LINE__, 1.078780494515273e-04,	"0.000107878", "%4G",
__LINE__, 1.079467488876157e-16,	"+1.079467E-16", "%+E",
__LINE__, 1.080529722917934e-20,	"0.000000", "%f",
__LINE__, 1.082169127709439e+01,	"10.8217", "%#5g",
__LINE__, 1.087241285590951e+22,	"1E+22", "%4.G",
__LINE__, 1.091049208406195e-14,	"0.0000", "%.4f",
__LINE__, 1.095316064213237e+16,	"+1e+16", "%+0.g",
__LINE__, 1.095349083237975e-04,	"1.095349e-04", "%5e",
__LINE__, 1.098002465452836e+12,	"1098002465452.836205", "%f",
__LINE__, 1.098445764138997e+13,	"1.09845E+13", "%G",
__LINE__, 1.099968047892474e-13,	"1.1e-13", "%2.5g",
__LINE__, 1.101017598311363e-04,	"0.000110102", "%G",
__LINE__, 1.102776332077817e+18,	"1.103e+18", "%.3e",
__LINE__, 1.103734053887830e-01,	"0.110373", "%f",
__LINE__, 1.105730106869006e-03,	"0.00110573", "%g",
__LINE__, 1.106366781854058e-10,	"1.10637e-10", "%g",
__LINE__, 1.107354763213839e+15,	"1.107355e+15", "%6e",
__LINE__, 1.108151709609825e-10,	"+1.10815E-10", "%+G",
__LINE__, 1.110054501993647e+21,	"+1.11005E+21", "%+G",
__LINE__, 1.111574814737873e-17,	"+1.112E-17", "%+1.4G",
__LINE__, 1.111865512360108e-15,	"1E-15", "%.0G",
__LINE__, 1.112281568330498e-03,	"1.112282e-03", "%.6e",
__LINE__, 1.112625415174238e+21,	"+1.11263e+21", "%+g",
__LINE__, 1.112744974910395e-02,	"0.011127", "%f",
__LINE__, 1.114726566979885e-10,	"1.11473e-10", "%g",
__LINE__, 1.115395843055731e-20,	"+0.000000", "%+6f",
__LINE__, 1.115983414693121e+15,	"1.11598e+15", "%5.6g",
__LINE__, 1.116118842074266e+27,	"1.116119e+27", "%e",
__LINE__, 1.118386983012328e+19,	"11183869830123276400.968280", "%1f",
__LINE__, 1.119344607892718e-22,	"1.119345e-22", "%e",
__LINE__, 1.120560837110279e-19,	"0.000000", "%f",
__LINE__, 1.123620157906291e-02,	"0.0112362", "%G",
__LINE__, 1.126804857639478e+29,	"1.1268E+29", "%#0.5G",
__LINE__, 1.128962199461581e+11,	"1.12896e+11", "%g",
__LINE__, 1.129878714246809e-16,	"1E-16", "%0.0G",
__LINE__, 1.130331982972407e-06,	"+0.", "%+#1.f",
__LINE__, 1.134167332070028e-16,	"0", "%0.0f",
__LINE__, 1.134248080053598e-28,	"0.000000", "%f",
__LINE__, 1.136023160708119e-10,	"+0.000000", "%+1f",
__LINE__, 1.136167141059036e+23,	"113616714105903593434732.101741", "%f",
__LINE__, 1.136439499920164e+10,	"+1.13644E+10", "%+G",
__LINE__, 1.136859734932182e+24,	"1.13686e+24", "%g",
__LINE__, 1.138985939448731e+09,	"1.13899e+09", "%2g",
__LINE__, 1.139287324790407e-25,	"1e-25", "%.1g",
__LINE__, 1.140559912153251e+06,	"1.14056e+06", "%g",
__LINE__, 1.141318036027086e-26,	"1.14132E-26", "%G",
__LINE__, 1.142586049368452e-20,	"+1.14259E-20", "%+7.5E",
__LINE__, 1.143283863993333e-17,	"1.143284E-17", "%3E",
__LINE__, 1.144637911632432e-28,	"1.144638E-28", "%#3E",
__LINE__, 1.145791416532065e-10,	"1.14579e-10", "%g",
__LINE__, 1.146958047315780e-17,	"1.146958e-17", "%e",
__LINE__, 1.147898346886569e-08,	"1E-08", "%3.0E",
__LINE__, 1.149724744965608e-14,	"1.14972e-14", "%5g",
__LINE__, 1.155383721940441e-10,	"1e-10", "%1.g",
__LINE__, 1.157066617729094e-02,	"0", "%1.f",
__LINE__, 1.157893614537215e+05,	"1.157894E+05", "%E",
__LINE__, 1.160476344451928e-19,	"1.2e-19", "%.1e",
__LINE__, 1.161610499315966e-26,	"1.161610E-26", "%E",
__LINE__, 1.162345042181490e+29,	"116234504218148981813385489658.685401", "%5.6f",
__LINE__, 1.162376053722862e+23,	"1.16238e+23", "%g",
__LINE__, 1.162996084782483e+18,	"+1e+18", "%+0.g",
__LINE__, 1.163544861478966e+26,	"1.16354E+26", "%G",
__LINE__, 1.167300137450931e+06,	"1E+06", "%.0G",
__LINE__, 1.168693829096401e-30,	"+1.16869e-30", "%+g",
__LINE__, 1.172791369381396e+15,	"1.173E+15", "%.4G",
__LINE__, 1.174427110782028e-29,	"  1E-29", "%7.G",
__LINE__, 1.179498322112450e+27,	"1179498322112449759657692993.641831", "%f",
__LINE__, 1.179555606293547e+27,	"1.17956e+27", "%3g",
__LINE__, 1.180815814881269e+06,	"1.180816e+06", "%e",
__LINE__, 1.181494870072805e+20,	"1.181495e+20", "%5e",
__LINE__, 1.181524119225619e+12,	"+1181524119225.61917", "%+5.5f",
__LINE__, 1.182111212289243e-20,	"1e-20", "%4.g",
__LINE__, 1.184503315019769e-27,	"1.1845e-27", "%7g",
__LINE__, 1.186413646767670e+29,	"1.18641e+29", "%g",
__LINE__, 1.186852938885004e-13,	"1.18685e-13", "%4g",
__LINE__, 1.188837612473914e+05,	"1e+05", "%.0g",
__LINE__, 1.190317482928293e-29,	"1.190317e-29", "%e",
__LINE__, 1.190527491143987e+02,	"1.190527E+02", "%E",
__LINE__, 1.191823062060233e-30,	"1.2E-30", "%6.2G",
__LINE__, 1.191926974812428e-23,	"1.2e-23", "%.2g",
__LINE__, 1.193549622366544e-25,	"1E-25", "%4.1G",
__LINE__, 1.195517368629765e-21,	"1.195517e-21", "%1.7g",
__LINE__, 1.195573061651289e-27,	"1.19557e-27", "%#g",
__LINE__, 1.195806681188325e-03,	"+0.00120", "%+#.3G",
__LINE__, 1.196842275192189e-28,	"1.19684e-28", "%g",
__LINE__, 1.197307550969576e+04,	"1.1973E+04", "%.4E",
__LINE__, 1.197608525847607e+15,	"1197608525847606.8062805", "%4.7f",
__LINE__, 1.197801338159407e+04,	"11978", "%5G",
__LINE__, 1.197813329735025e+27,	"1.19781E+27", "%7G",
__LINE__, 1.199483904123253e-12,	"1.19948e-12", "%g",
__LINE__, 1.199535292169766e-09,	"1.199535e-09", "%e",
__LINE__, 1.201478067515135e+05,	"120147.806752", "%f",
__LINE__, 1.202054662662158e+17,	"1.20205E+17", "%#G",
__LINE__, 1.202111922368321e+07,	"+1.202112E+07", "%+#E",
__LINE__, 1.202536892743791e-01,	"0.120254", "%#g",
__LINE__, 1.205698674119882e-29,	"1.2057E-29", "%G",
__LINE__, 1.208091664701942e-13,	" 0.", "%#3.f",
__LINE__, 1.208942413954872e-17,	"1.20894E-17", "%G",
__LINE__, 1.209704891496613e+10,	"1.210e+10", "%2.3e",
__LINE__, 1.211355639334831e+29,	"1E+29", "%.0G",
__LINE__, 1.211447553804203e+17,	"  1E+17", "%7.E",
__LINE__, 1.212481583429790e-16,	"1.212482e-16", "%e",
__LINE__, 1.212849001551862e+26,	"121284900155186181613942153.4899157", "%6.7f",
__LINE__, 1.213057538677801e+06,	"1213057.538678", "%#.6f",
__LINE__, 1.214609592911893e+25,	"1.214610e+25", "%#e",
__LINE__, 1.216086266251665e+01,	"1e+01", "%5.e",
__LINE__, 1.216468565931026e-22,	"1.216469E-22", "%1E",
__LINE__, 1.216503126598765e+14,	"+1E+14", "%+0.E",
__LINE__, 1.216641013695553e-14,	"0.000000", "%f",
__LINE__, 1.223142246779504e-23,	"0.000000", "%f",
__LINE__, 1.223884786443274e+08,	"122388479", "%5.f",
__LINE__, 1.224012562770076e+29,	"1.22401e+29", "%0g",
__LINE__, 1.225098157528297e+14,	"1.22510e+14", "%#g",
__LINE__, 1.226306848505242e-22,	"1.22631E-22", "%G",
__LINE__, 1.227487485547996e-08,	"+1.22749e-08", "%+g",
__LINE__, 1.237206486909689e+02,	"+123.721", "%+#.6g",
__LINE__, 1.240281126177077e-02,	"+0.01", "%+3.g",
__LINE__, 1.241197211306994e-06,	"1.241197E-06", "%E",
__LINE__, 1.241776311097410e+07,	"1.241776E+07", "%E",
__LINE__, 1.245995986024999e-03,	"0.001246", "%g",
__LINE__, 1.246082428199607e+03,	"1246.082428", "%f",
__LINE__, 1.247021567954220e+05,	"  1e+05", "%7.g",
__LINE__, 1.248140089618390e-30,	"+1.24814E-30", "%+G",
__LINE__, 1.248403361652064e-30,	"+0.000000", "%+f",
__LINE__, 1.251098538918842e-26,	"+1.251099E-26", "%+E",
__LINE__, 1.251952633022061e+25,	"1.25195e+25", "%g",
__LINE__, 1.253029705843461e-04,	"+1.E-04", "%+#4.E",
__LINE__, 1.259562132729488e-09,	"1e-09", "%1.e",
__LINE__, 1.261702205492260e-27,	"0.000000", "%f",
__LINE__, 1.265910361926660e-19,	"+1.265910e-19", "%+e",
__LINE__, 1.267411912651087e+12,	"1.26741E+12", "%1G",
__LINE__, 1.267830718285980e-10,	"1.26783e-10", "%g",
__LINE__, 1.268238378987517e-23,	"1E-23", "%5.E",
__LINE__, 1.275543253354167e+10,	"1.27554E+10", "%G",
__LINE__, 1.277255234454465e-10,	"1.27726E-10", "%5G",
__LINE__, 1.280590949834150e-21,	"1.280591E-21", "%E",
__LINE__, 1.285570453788242e-02,	"1.285570E-02", "%E",
__LINE__, 1.287712130719031e+09,	"1287712130.719031", "%#f",
__LINE__, 1.290142876187105e+29,	"+1.290143E+29", "%+E",
__LINE__, 1.293129213191961e+21,	"1.29313E+21", "%G",
__LINE__, 1.293317101334714e-23,	"+0.000000", "%+f",
__LINE__, 1.294506813069071e-13,	"0.0", "%3.1f",
__LINE__, 1.295576232685739e-22,	"+0.000000", "%+f",
__LINE__, 1.296010470431800e-19,	"+0.000000", "%+6f",
__LINE__, 1.298798231947674e+19,	"1.2988E+19", "%2G",
__LINE__, 1.299521114379381e+09,	"1.29952E+09", "%G",
__LINE__, 1.299847637892712e+24,	"1.299848e+24", "%e",
__LINE__, 1.301269777843698e+29,	"130126977784369834978406288428.232074", "%f",
__LINE__, 1.302911786437618e-15,	"     0", "%6.f",
__LINE__, 1.303863159906719e+27,	"1303863159906719415559450681", "%0.f",
__LINE__, 1.304396472326846e-12,	"+1E-12", "%+1.0G",
__LINE__, 1.306180443528427e-30,	"+1e-30", "%+.1g",
__LINE__, 1.308469138968514e+22,	"1.30847E+22", "%0G",
__LINE__, 1.312700156826057e-11,	"1.3127e-11", "%g",
__LINE__, 1.315364075120764e+21,	"+1.31536E+21", "%+G",
__LINE__, 1.320376485288444e-09,	"+1.3204E-09", "%+6.5G",
__LINE__, 1.321434154364635e-08,	"1.32143e-08", "%1g",
__LINE__, 1.322777272579176e+19,	"+1e+19", "%+3.e",
__LINE__, 1.322861663428564e+00,	"1.322862E+00", "%#E",
__LINE__, 1.323566013489230e+14,	"+1.323566E+14", "%+1E",
__LINE__, 1.327446904132973e-20,	"+1.32745E-20", "%+4.6G",
__LINE__, 1.328226362528158e+19,	"1e+19", "%2.g",
__LINE__, 1.329167460803610e+08,	"1e+08", "%3.g",
__LINE__, 1.335371420823160e+14,	"1.33537E+14", "%7G",
__LINE__, 1.336116185095935e-21,	"0.000000", "%f",
__LINE__, 1.338766774704671e-22,	"+1.33877e-22", "%+g",
__LINE__, 1.339199373014647e-12,	"1E-12", "%1.E",
__LINE__, 1.344293357481519e+26,	"134429335748151945750805680.290796", "%#2f",
__LINE__, 1.344328188122843e+29,	"1.34433e+29", "%g",
__LINE__, 1.344382581316972e-05,	"1E-05", "%5.0E",
__LINE__, 1.349835616116184e+11,	"134983561611.6", "%2.1f",
__LINE__, 1.349955669989707e+20,	"134995566998970728533.890906", "%7f",
__LINE__, 1.350230411093841e+20,	"135023041109384145386.229648", "%f",
__LINE__, 1.353391369565576e+10,	"  1E+10", "%7.1G",
__LINE__, 1.356889483699471e+22,	"+1.35689E+22", "%+G",
__LINE__, 1.358141775798243e+24,	"+1358141775798242578687791.137781", "%+f",
__LINE__, 1.358547541975523e-15,	"1.35855e-15", "%g",
__LINE__, 1.363402539800791e+11,	"1.3634E+11", "%G",
__LINE__, 1.363676837988798e+16,	"+13636768379887982.4053", "%+2.4f",
__LINE__, 1.364592026494839e-24,	"1.36459e-24", "%g",
__LINE__, 1.366664212399413e-09,	"+1E-09", "%+6.G",
__LINE__, 1.367446193117463e-17,	"1.3674e-17", "%2.4e",
__LINE__, 1.368681648785823e-18,	"1.36868E-18", "%3G",
__LINE__, 1.370635189583606e+05,	"1.370635E+05", "%E",
__LINE__, 1.371395540772186e-18,	"+1.371396e-18", "%+e",
__LINE__, 1.371945318043159e+10,	"1E+10", "%0.E",
__LINE__, 1.373780604772988e-21,	"1e-21", "%3.g",
__LINE__, 1.374244970441862e-28,	"0.000000", "%7.6f",
__LINE__, 1.375874695067149e-25,	"1.37587E-25", "%#3G",
__LINE__, 1.377165614832621e+20,	"1.37717E+20", "%#G",
__LINE__, 1.381541864946684e-09,	"1.38154E-09", "%G",
__LINE__, 1.382901694835415e+00,	"1.382902E+00", "%E",
__LINE__, 1.384250577530184e-21,	"1.384e-21", "%.4g",
__LINE__, 1.385322753374640e-03,	" 1E-03", "%6.E",
__LINE__, 1.387026156054724e+19,	"1.387026E+19", "%E",
__LINE__, 1.388726735790498e-27,	"+1.388727E-27", "%+E",
__LINE__, 1.388819105742044e+16,	"1.38882e+16", "%g",
__LINE__, 1.389941086024951e-19,	"0.000000", "%f",
__LINE__, 1.390101174785536e+25,	"1.3901E+25", "%G",
__LINE__, 1.392210785638597e+24,	"+1.39221E+24", "%+G",
__LINE__, 1.396148856283474e-26,	"1.4e-26", "%7.3g",
__LINE__, 1.398153728631994e-21,	"1.39815E-21", "%G",
__LINE__, 1.398332446762342e-14,	"+1.39833E-14", "%+5G",
__LINE__, 1.400250919607987e+10,	"1.40025E+10", "%G",
__LINE__, 1.400662469019739e+03,	"1.E+03", "%#0.0E",
__LINE__, 1.401720273747805e-12,	"0.000000", "%#f",
__LINE__, 1.402151358748719e+22,	"1.402151e+22", "%e",
__LINE__, 1.402351913752357e-28,	"1.40235E-28", "%#1.6G",
__LINE__, 1.403285877973810e+13,	"+14032858779738.097255", "%+4f",
__LINE__, 1.404540981735861e+04,	"14045.409817", "%4f",
__LINE__, 1.406420622355064e+19,	"1.40642E+19", "%G",
__LINE__, 1.412552725962301e-29,	"+1e-29", "%+1.e",
__LINE__, 1.413266982485044e+10,	"1.41327e+10", "%g",
__LINE__, 1.413627189411456e+21,	"1.41363E+21", "%0G",
__LINE__, 1.416647216002592e-25,	"+0.000000", "%+#f",
__LINE__, 1.417107155080584e-10,	"1e-10", "%1.e",
__LINE__, 1.418829895346648e+19,	"14188298953466484952.912197", "%f",
__LINE__, 1.419404559267523e-11,	"1.4194e-11", "%g",
__LINE__, 1.422421321425472e+15,	"1.422421E+15", "%E",
__LINE__, 1.424858902008998e+18,	"1.42486E+18", "%2.5E",
__LINE__, 1.428863051254205e+22,	"1.428863e+22", "%e",
__LINE__, 1.429533727936725e-02,	"0.0142953", "%g",
__LINE__, 1.430982219743369e-19,	" 1E-19", "%6.G",
__LINE__, 1.431974118434703e+17,	"1E+17", "%3.G",
__LINE__, 1.432418341970152e+16,	"+1.432418e+16", "%+5e",
__LINE__, 1.433470281650523e+04,	"14334.7", "%g",
__LINE__, 1.434446243424653e+24,	" +1e+24", "%+7.g",
__LINE__, 1.435118019241039e+24,	"+1e+24", "%+4.g",
__LINE__, 1.435691648420278e-01,	"0.1435692", "%#4.7g",
__LINE__, 1.437569598098744e+27,	"1.437570E+27", "%#E",
__LINE__, 1.437633484061726e-25,	"+1.43763e-25", "%+7g",
__LINE__, 1.437866591230707e-13,	"1.43787e-13", "%g",
__LINE__, 1.440593154445915e-01,	"+0.144059", "%+1G",
__LINE__, 1.441368205977342e+16,	"1.441368E+16", "%#E",
__LINE__, 1.441825266684367e+28,	"1.44183e+28", "%g",
__LINE__, 1.442374183199456e+20,	"1.442374E+20", "%E",
__LINE__, 1.445101893951061e-24,	"0", "%0.f",
__LINE__, 1.446037835160094e-20,	"+1.44604E-20", "%+2G",
__LINE__, 1.449245376093616e+04,	"1.449245e+04", "%e",
__LINE__, 1.454126845620100e+09,	"1.45413E+09", "%G",
__LINE__, 1.455764608801107e+09,	"1.5e+09", "%6.1e",
__LINE__, 1.457176183149955e-12,	"1.45718e-12", "%#g",
__LINE__, 1.458821535020046e-05,	"1.45882e-05", "%#g",
__LINE__, 1.460179141161202e-19,	"1.460179E-19", "%#E",
__LINE__, 1.461701055446198e-20,	"1.461701e-20", "%#2.7g",
__LINE__, 1.462408181482172e+10,	"1.4624082E+10", "%3.7E",
__LINE__, 1.463706296748154e+24,	"1e+24", "%2.g",
__LINE__, 1.464891255780761e-19,	"+1.46489e-19", "%+g",
__LINE__, 1.467903978945872e+25,	"1.4679E+25", "%G",
__LINE__, 1.468585992857062e+22,	"14685859928570619281629.205943", "%f",
__LINE__, 1.469803528668286e+29,	"+1E+29", "%+6.G",
__LINE__, 1.469883002609266e-23,	"1.E-23", "%#2.E",
__LINE__, 1.469941481858809e+08,	"+146994148.185881", "%+f",
__LINE__, 1.470744493304611e+13,	"1.47074e+13", "%g",
__LINE__, 1.471857261085004e+23,	"1E+23", "%2.G",
__LINE__, 1.474419778873037e+06,	"1474419.7789", "%#.4f",
__LINE__, 1.483134762223381e-03,	"0", "%0.0f",
__LINE__, 1.483575501240724e-13,	"1.48358e-13", "%g",
__LINE__, 1.486068112294452e+20,	"1.486068e+20", "%e",
__LINE__, 1.488665528787761e-03,	"  +0", "%+4.f",
__LINE__, 1.492145267536713e+07,	"14921452.675367", "%f",
__LINE__, 1.492589762884761e-01,	"0.149259", "%f",
__LINE__, 1.494784286168215e+01,	"1.494784E+01", "%E",
__LINE__, 1.495945331501655e+04,	"1.5e+04", "%.2g",
__LINE__, 1.501383201904700e+14,	"2e+14", "%1.g",
__LINE__, 1.501387105011959e-02,	"0.0150139", "%g",
__LINE__, 1.505784488562271e+26,	"1.50578e+26", "%5g",
__LINE__, 1.506367986495534e+10,	"1.50637e+10", "%2g",
__LINE__, 1.507421710226296e+19,	"1.507422E+19", "%#E",
__LINE__, 1.507960881206134e+16,	"2e+16", "%.0g",
__LINE__, 1.508974301049424e+14,	"+1.508974E+14", "%+E",
__LINE__, 1.509204025111090e-18,	"1.509204E-18", "%E",
__LINE__, 1.511351799767759e+21,	"1511351799767759462866.93397", "%.5f",
__LINE__, 1.511712197184520e-06,	"+1.51171e-06", "%+1g",
__LINE__, 1.514703727491400e+02,	"151.47", "%.5g",
__LINE__, 1.514855355408287e+04,	"15148.6", "%g",
__LINE__, 1.516256896575301e+06,	"1.516257e+06", "%.6e",
__LINE__, 1.517712083681069e+14,	"1.51771e+14", "%0g",
__LINE__, 1.522102209167607e-18,	"1.52210e-18", "%#g",
__LINE__, 1.526264862895663e-12,	"0.000000", "%f",
__LINE__, 1.527165480858125e+10,	"1.527e+10", "%.4g",
__LINE__, 1.528363280308369e+00,	"+1.52836", "%+0G",
__LINE__, 1.529108490733420e-22,	"1.529108E-22", "%E",
__LINE__, 1.529783364474522e+19,	"15297833644745216119.531506", "%7f",
__LINE__, 1.530698363199346e-01,	"0.1531", "%#.4f",
__LINE__, 1.531520796537450e+22,	"1.53152E+22", "%G",
__LINE__, 1.533314559644813e+06,	"+1533314.559645", "%+f",
__LINE__, 1.534682791112854e+01,	"+15.3468", "%+0G",
__LINE__, 1.534714026386730e-11,	"0.000000", "%f",
__LINE__, 1.537145729498115e+00,	"1.537146E+00", "%E",
__LINE__, 1.538740040875751e-23,	"1.538740E-23", "%E",
__LINE__, 1.546248240596482e-03,	"0.001546", "%f",
__LINE__, 1.546808012239302e-09,	"+1.54681E-09", "%+G",
__LINE__, 1.546903877359107e+06,	"1.5e+06", "%.2g",
__LINE__, 1.550153973747718e-18,	"2e-18", "%.0g",
__LINE__, 1.551703460384378e+00,	"+1.5517", "%+.4f",
__LINE__, 1.553995673101369e+29,	"1.554E+29", "%G",
__LINE__, 1.555477017531899e+28,	"1.55548e+28", "%g",
__LINE__, 1.555548963448462e+12,	"1555548963448.46227", "%6.5f",
__LINE__, 1.558702451007712e+16,	"2e+16", "%5.1g",
__LINE__, 1.561641587723724e+29,	"1.561642e+29", "%e",
__LINE__, 1.561868589559509e-05,	"1.56187E-05", "%G",
__LINE__, 1.565229056438949e+13,	"1.56523e+13", "%1.6g",
__LINE__, 1.570074406600442e+14,	"+1.57007E+14", "%+4G",
__LINE__, 1.570951909913194e+13,	"1.57095E+13", "%.6G",
__LINE__, 1.572186421520727e-30,	"+1.57219e-30", "%+g",
__LINE__, 1.574374582066945e+12,	"1.57e+12", "%5.2e",
__LINE__, 1.577789404823585e+12,	"1.577789E+12", "%E",
__LINE__, 1.579641278389186e+04,	"15796.413", "%7.3f",
__LINE__, 1.581602330975388e+17,	"1.5816E+17", "%#.5G",
__LINE__, 1.587809692297490e-18,	"+1.58781e-18", "%+2g",
__LINE__, 1.588672954832388e-05,	"1.58867E-05", "%G",
__LINE__, 1.594548954259978e+25,	"+1.595e+25", "%+.3e",
__LINE__, 1.596653742160718e+10,	"15966537421.6072", "%.4f",
__LINE__, 1.597416186584641e+25,	"1.59742e+25", "%g",
__LINE__, 1.597810706039500e-04,	"0.000159781", "%g",
__LINE__, 1.601425691153542e+01,	"16.0143", "%G",
__LINE__, 1.601491150913706e-15,	"+1.60149e-15", "%+g",
__LINE__, 1.609357026469645e+02,	"160.936", "%0g",
__LINE__, 1.611064881461188e+06,	"+1.611065E+06", "%+E",
__LINE__, 1.611324319640770e-03,	"0.00161132", "%G",
__LINE__, 1.613202907940803e+19,	"1.6E+19", "%#.1E",
__LINE__, 1.613883500056636e-12,	"0.000000", "%5f",
__LINE__, 1.618254213010772e+07,	"16182542.130108", "%6f",
__LINE__, 1.620441271211248e-08,	"1.62044E-08", "%0G",
__LINE__, 1.622548435024803e-01,	"+0.162255", "%+5G",
__LINE__, 1.623740394555269e+19,	"16237403945552689066.289531", "%3f",
__LINE__, 1.625774250389937e+18,	"1.625774e+18", "%1e",
__LINE__, 1.626300864432426e-02,	"0.016263", "%G",
__LINE__, 1.626351146877694e-11,	"1.6263511e-11", "%2.7e",
__LINE__, 1.626568757587995e+25,	"16265687575879949733348439.62220", "%6.5f",
__LINE__, 1.626717482094360e-28,	"+1.626717e-28", "%+3e",
__LINE__, 1.630801585998995e-28,	"1.6308e-28", "%0g",
__LINE__, 1.631827173682962e+03,	"1632", "%1.4g",
__LINE__, 1.631907571243379e+18,	"1631907571243378818.337533", "%f",
__LINE__, 1.632058420447239e-14,	" +2E-14", "%+7.G",
__LINE__, 1.632847882621240e+18,	"+1.63285E+18", "%+2G",
__LINE__, 1.637329146233172e-09,	"+1.63733e-09", "%+g",
__LINE__, 1.638315287442427e-16,	"+1.63832E-16", "%+G",
__LINE__, 1.641284849351445e+15,	"1641284849351445.096488", "%f",
__LINE__, 1.644871927486929e+10,	"2e+10", "%1.e",
__LINE__, 1.645917293047431e-19,	"1.64592e-19", "%.6g",
__LINE__, 1.649201265647819e-07,	"0.000000", "%f",
__LINE__, 1.650169065733559e+23,	"165016906573355903731226.135278", "%3f",
__LINE__, 1.651217291298196e-30,	"2E-30", "%4.G",
__LINE__, 1.652680660160331e+08,	"2.e+08", "%#3.g",
__LINE__, 1.654171892948767e-15,	"1.65417e-15", "%g",
__LINE__, 1.655435863725412e+17,	"+1.655436e+17", "%+#e",
__LINE__, 1.656015606204101e+28,	"+1.7E+28", "%+3.2G",
__LINE__, 1.656814723110478e-21,	"+0.000000", "%+f",
__LINE__, 1.658632655199721e-19,	"2.E-19", "%#4.G",
__LINE__, 1.659915061311444e+27,	"1.66E+27", "%.3G",
__LINE__, 1.664258574522914e-29,	"+1.664259E-29", "%+E",
__LINE__, 1.667662840654469e-28,	"+2e-28", "%+0.g",
__LINE__, 1.673124993246863e-25,	"+0.000000", "%+f",
__LINE__, 1.677788498058833e-20,	"1.678e-20", "%.4g",
__LINE__, 1.681211731173386e-07,	"1.68121e-07", "%0.6g",
__LINE__, 1.686341560076196e+02,	"169", "%.0f",
__LINE__, 1.686507685287281e+08,	"1.686508E+08", "%E",
__LINE__, 1.689500448795801e+03,	"+1689.500449", "%+0f",
__LINE__, 1.690639426041009e-13,	"2e-13", "%5.0g",
__LINE__, 1.691554939595928e+16,	"+1.6916e+16", "%+.5g",
__LINE__, 1.698597126229626e-09,	"1.699e-09", "%3.4g",
__LINE__, 1.700093083173516e+16,	"17000930831735159", "%5.f",
__LINE__, 1.703653732982710e+13,	"+1.70365e+13", "%+g",
__LINE__, 1.705353380573352e-16,	"0.000000", "%f",
__LINE__, 1.705973328700179e-26,	"1.70597e-26", "%5g",
__LINE__, 1.717797289369145e+22,	"+1.717797E+22", "%+7E",
__LINE__, 1.722819196705361e-28,	"1.722819E-28", "%1.7G",
__LINE__, 1.723775772891202e+01,	"17.237758", "%f",
__LINE__, 1.723787102325353e-23,	"0.000000", "%2f",
__LINE__, 1.724551301171870e-13,	"0.000000", "%f",
__LINE__, 1.726098078655758e-20,	"0.0000000", "%7.7f",
__LINE__, 1.726302822039762e+18,	"+2E+18", "%+1.G",
__LINE__, 1.726659209108151e+18,	"+1.72666E+18", "%+6G",
__LINE__, 1.728324925097269e-25,	"1.728325e-25", "%7e",
__LINE__, 1.728357491215602e+02,	"172.836", "%G",
__LINE__, 1.729612227517587e+22,	"1.729612e+22", "%e",
__LINE__, 1.731753104740805e-06,	"1.73175e-06", "%2g",
__LINE__, 1.736066279733589e+18,	"+1.736066E+18", "%+3E",
__LINE__, 1.736626769480182e-19,	"2e-19", "%.0g",
__LINE__, 1.737445267713118e-13,	"  2e-13", "%7.g",
__LINE__, 1.739264683023077e+05,	"173926.468302", "%f",
__LINE__, 1.739423702667596e-16,	"+1.73942e-16", "%+g",
__LINE__, 1.741053616961658e-14,	"1.74105E-14", "%G",
__LINE__, 1.741085952255057e+29,	"1.7e+29", "%#.1e",
__LINE__, 1.743673705633426e+03,	"2E+03", "%5.0G",
__LINE__, 1.750940899205665e+27,	"1.75094e+27", "%g",
__LINE__, 1.753871003884151e-26,	"0.", "%#.0f",
__LINE__, 1.755237470854478e-14,	"1.755237e-14", "%4e",
__LINE__, 1.757491419837315e-03,	"0.002", "%1.G",
__LINE__, 1.758657797688126e+26,	"+1.75866E+26", "%+#G",
__LINE__, 1.760491452270889e+08,	"1.76049E+08", "%G",
__LINE__, 1.760816275862939e-10,	"2e-10", "%.1g",
__LINE__, 1.760905893493003e-22,	"1.76e-22", "%.2e",
__LINE__, 1.762101125986743e-12,	"2e-12", "%.0g",
__LINE__, 1.763855968659571e+27,	"1.763856E+27", "%E",
__LINE__, 1.764595217341348e-13,	"1.764595E-13", "%E",
__LINE__, 1.766737296048445e+08,	"+1.77e+08", "%+.3g",
__LINE__, 1.769916386969961e-05,	"+1.76992e-05", "%+g",
__LINE__, 1.773873506344176e-01,	"1.773874e-01", "%e",
__LINE__, 1.775392554371421e+03,	"+1775.39", "%+3.2f",
__LINE__, 1.776007623006870e+24,	"1776007623006870161930237.372871", "%f",
__LINE__, 1.777418921678653e-27,	"     0", "%6.f",
__LINE__, 1.780967607234234e-18,	"1.780968E-18", "%E",
__LINE__, 1.782510583486435e+24,	"+2e+24", "%+3.g",
__LINE__, 1.784002921603004e+14,	"1.784E+14", "%G",
__LINE__, 1.784231151778382e+11,	"1.7842E+11", "%.5G",
__LINE__, 1.785589091453195e+02,	" 179.", "%#5.f",
__LINE__, 1.786402639400039e+19,	"2e+19", "%0.g",
__LINE__, 1.786506485794647e-25,	"2E-25", "%.1G",
__LINE__, 1.787513971482493e-04,	"+0.000178751", "%+G",
__LINE__, 1.799765409320039e+23,	"179976540932003885586710", "%6.0f",
__LINE__, 1.800451864218989e+08,	"+1.80045e+08", "%+g",
__LINE__, 1.800743538258572e+04,	" +18007", "%+7.f",
__LINE__, 1.801583764453362e+25,	"1.8016e+25", "%0.5g",
__LINE__, 1.804502093739547e+14,	"2e+14", "%2.g",
__LINE__, 1.805600104488678e-17,	"1.805600E-17", "%E",
__LINE__, 1.811342448081048e+17,	"1.811342e+17", "%.6e",
__LINE__, 1.812252160066930e+19,	"2e+19", "%0.e",
__LINE__, 1.816287564395273e+02,	"182", "%2.f",
__LINE__, 1.817097386762552e-13,	"2E-13", "%3.1G",
__LINE__, 1.817881381387254e+06,	"1.81788E+06", "%G",
__LINE__, 1.818416380830953e-30,	"1.81842E-30", "%G",
__LINE__, 1.824788290177454e-23,	"1.82479e-23", "%g",
__LINE__, 1.827832506678437e-18,	"1.82783E-18", "%G",
__LINE__, 1.828048053242609e+01,	"18.2805", "%g",
__LINE__, 1.828939681844203e-21,	"1.82894E-21", "%.6G",
__LINE__, 1.829763900251753e+12,	"1829763900251.752773", "%1f",
__LINE__, 1.833100407114602e-05,	"0.000018", "%#f",
__LINE__, 1.833672780034284e-07,	"1.833673e-07", "%e",
__LINE__, 1.834307692387540e+21,	"2E+21", "%5.G",
__LINE__, 1.835119931666753e+14,	"+1.835120e+14", "%+e",
__LINE__, 1.835956566920861e-26,	"0.000000", "%#f",
__LINE__, 1.837784131899354e+22,	"1.83778E+22", "%G",
__LINE__, 1.842867094224664e-09,	"1.84287e-09", "%g",
__LINE__, 1.844234823805319e+28,	"2E+28", "%1.G",
__LINE__, 1.844877682008962e+12,	"1.84488e+12", "%g",
__LINE__, 1.846530424340488e-22,	"1.846530e-22", "%#.7g",
__LINE__, 1.849111603036448e-08,	"0.00", "%.2f",
__LINE__, 1.850158752678734e+04,	"+18502", "%+.5G",
__LINE__, 1.851431391104701e-06,	" +2e-06", "%+7.e",
__LINE__, 1.851487430609031e-04,	"0.000185149", "%G",
__LINE__, 1.853171650128773e+03,	"1853.17", "%G",
__LINE__, 1.854743263740068e-16,	"1.854743E-16", "%6.6E",
__LINE__, 1.864399020932753e-11,	"+0.000000", "%+f",
__LINE__, 1.865028568072397e-22,	"1.86503E-22", "%.6G",
__LINE__, 1.868128423759223e+14,	"1.86813E+14", "%4G",
__LINE__, 1.868453558435480e+21,	"1.86845E+21", "%G",
__LINE__, 1.870663011627498e-06,	"1.87E-06", "%.3G",
__LINE__, 1.873273487748907e+17,	"+1.873273E+17", "%+E",
__LINE__, 1.878885220839805e-04,	"0.000187889", "%G",
__LINE__, 1.879102515623569e+17,	"1.8791e+17", "%g",
__LINE__, 1.889343972100858e-10,	"2E-10", "%2.E",
__LINE__, 1.891833282879762e-24,	"+2e-24", "%+.1g",
__LINE__, 1.895148778941240e-07,	"0.000000", "%0f",
__LINE__, 1.896950834067578e-28,	"+1.89695e-28", "%+#g",
__LINE__, 1.898464546986629e-05,	"1.898465e-05", "%.7g",
__LINE__, 1.900851427578321e-19,	"1.90085e-19", "%6g",
__LINE__, 1.901171344577750e+27,	"1.901171e+27", "%7.7g",
__LINE__, 1.903563335316359e+02,	"190.356", "%0g",
__LINE__, 1.903817306004701e-16,	"+1.90e-16", "%+#6.2e",
__LINE__, 1.910606410246797e+21,	"1.91061E+21", "%2.5E",
__LINE__, 1.912537759564710e+29,	"1.91254E+29", "%G",
__LINE__, 1.913606675894566e+27,	"1.91361E+27", "%7.6G",
__LINE__, 1.916473734025505e-05,	"  2e-05", "%7.g",
__LINE__, 1.916507511720523e+23,	"+2E+23", "%+.0E",
__LINE__, 1.917688262248837e-28,	"1.918e-28", "%.4g",
__LINE__, 1.921375594217083e-12,	"1.92138E-12", "%G",
__LINE__, 1.923916000932815e-25,	"1.92392E-25", "%G",
__LINE__, 1.926303652776462e-01,	"+0.2", "%+0.G",
__LINE__, 1.929411084211293e+21,	"1.92941E+21", "%6G",
__LINE__, 1.929996820297491e-26,	"1.93e-26", "%.6g",
__LINE__, 1.937301472034748e-29,	"1.9373E-29", "%G",
__LINE__, 1.937301660220894e-11,	"+1.9373E-11", "%+G",
__LINE__, 1.939038538587083e-02,	"0.0193904", "%g",
__LINE__, 1.940575489112444e-09,	"1.94058E-09", "%G",
__LINE__, 1.946550455606677e-26,	"1.946550E-26", "%#1E",
__LINE__, 1.954250777559491e-14,	"1.95425E-14", "%G",
__LINE__, 1.955646327688473e-16,	"1.956E-16", "%#.3E",
__LINE__, 1.956999911995683e+20,	"2E+20", "%2.G",
__LINE__, 1.959125254298784e-21,	"1.95913E-21", "%#G",
__LINE__, 1.960330340481290e+26,	"1.96033e+26", "%.6g",
__LINE__, 1.964156478075422e+01,	"+19.6416", "%+g",
__LINE__, 1.964702507676036e+19,	"2.0e+19", "%2.1e",
__LINE__, 1.965762191674409e-30,	"2E-30", "%1.G",
__LINE__, 1.967492699686803e-29,	"+1.967493E-29", "%+#E",
__LINE__, 1.970072604062236e-11,	"+1.97007E-11", "%+G",
__LINE__, 1.975631055550387e+05,	"197563.105555", "%.6f",
__LINE__, 1.975722425389177e+28,	"+1.975722e+28", "%+5.6e",
__LINE__, 1.977938328895365e-05,	" 2e-05", "%6.e",
__LINE__, 1.981950849019640e+13,	"1.981951E+13", "%E",
__LINE__, 1.982543168856985e-26,	"1.98254e-26", "%4g",
__LINE__, 1.984873317384181e-20,	"1.98487E-20", "%4G",
__LINE__, 1.986146420877074e+02,	"+1.986146e+02", "%+0e",
__LINE__, 1.986465942785167e-28,	"1.98647e-28", "%g",
__LINE__, 1.988250323235468e-05,	"     +0", "%+7.f",
__LINE__, 1.989966623080645e-09,	"1.989967e-09", "%e",
__LINE__, 1.991243122514519e+11,	"199124312251", "%5.f",
__LINE__, 1.993287894645908e+25,	"+1.993288E+25", "%+E",
__LINE__, 1.995172329888890e-30,	"+1.99517e-30", "%+3g",
__LINE__, 1.997075127236432e+05,	"1.997E+05", "%#.4G",
__LINE__, 2.000651599487290e+04,	"2E+04", "%2.E",
__LINE__, 2.001429412876339e-28,	"0.000000", "%6f",
__LINE__, 2.003535646264196e+03,	"  2E+03", "%7.G",
__LINE__, 2.011751504116246e+06,	"2E+06", "%2.G",
__LINE__, 2.016361237694652e-30,	"2.01636e-30", "%4g",
__LINE__, 2.018266414065554e-08,	"0.00", "%2.2f",
__LINE__, 2.020706780608565e+03,	"2E+03", "%.0G",
__LINE__, 2.025098418552005e-16,	"+2.025098E-16", "%+2E",
__LINE__, 2.026100592518976e-11,	"2.026101e-11", "%6e",
__LINE__, 2.026167291572980e+11,	"2.02617E+11", "%G",
__LINE__, 2.026782170272331e+07,	"2.026782E+07", "%E",
__LINE__, 2.029133469449347e-06,	" 2e-06", "%6.g",
__LINE__, 2.031191570768443e-20,	"2.031192E-20", "%2.7G",
__LINE__, 2.031884221862863e-16,	"2.031884e-16", "%e",
__LINE__, 2.032992924118323e+29,	"203299292411832333016263874014.84", "%#0.2f",
__LINE__, 2.035799610097827e+28,	"+20357996100978272835391180706.2104344", "%+3.7f",
__LINE__, 2.038008183612069e+25,	"20380081836120691463065668", "%7.0f",
__LINE__, 2.041632205119365e-22,	"+2.04163e-22", "%+g",
__LINE__, 2.042769811159352e-10,	"2e-10", "%.1g",
__LINE__, 2.043034975847005e-08,	"2.043035e-08", "%e",
__LINE__, 2.045930666285880e+26,	"2.04593e+26", "%g",
__LINE__, 2.048377276651386e-21,	"0.00000", "%2.5f",
__LINE__, 2.051785787301292e-23,	"0.000000", "%f",
__LINE__, 2.055085792048183e-10,	"0.000000", "%f",
__LINE__, 2.055783028451040e-21,	"+0", "%+1.f",
__LINE__, 2.057641607509489e-17,	"+2E-17", "%+2.G",
__LINE__, 2.058348703001600e-15,	"2.05835E-15", "%#G",
__LINE__, 2.059594758787322e+24,	"2.05959E+24", "%1G",
__LINE__, 2.062710740295018e+01,	"20.6271", "%G",
__LINE__, 2.063240676447750e-11,	"0.000000", "%f",
__LINE__, 2.063799238238917e-09,	"+0.000000", "%+f",
__LINE__, 2.064564135160425e-17,	"2.06456E-17", "%G",
__LINE__, 2.066363476927650e-05,	"2.07E-05", "%.3G",
__LINE__, 2.066871450514214e-02,	"+2.066871e-02", "%+e",
__LINE__, 2.067258256169148e+07,	"2.06726e+07", "%g",
__LINE__, 2.068466590729350e-22,	"0.0000", "%.4f",
__LINE__, 2.068779510112540e-26,	"2.06878e-26", "%g",
__LINE__, 2.069258770387493e+19,	"20692587703874929516.700831", "%3f",
__LINE__, 2.069547778447951e+26,	"2.069548e+26", "%6e",
__LINE__, 2.070479507710941e-23,	"2.07048E-23", "%G",
__LINE__, 2.071809640061785e+22,	"2.071810E+22", "%E",
__LINE__, 2.073364463564950e-06,	"2.07336e-06", "%g",
__LINE__, 2.073478953644888e-10,	"+2.07E-10", "%+.3G",
__LINE__, 2.076039194312519e+12,	"2.07604E+12", "%G",
__LINE__, 2.081490398946229e-07,	"+2.08149e-07", "%+g",
__LINE__, 2.084941170287895e-07,	"2.084941E-07", "%7E",
__LINE__, 2.087035885023382e-18,	"+0.000000", "%+f",
__LINE__, 2.091025884363342e-09,	"2.09103E-09", "%G",
__LINE__, 2.091830555397864e+08,	"209183056", "%0.f",
__LINE__, 2.091998109232084e-22,	"0.000000", "%#f",
__LINE__, 2.093406473464940e-17,	"2.09341e-17", "%g",
__LINE__, 2.094646724039720e-26,	"2.094647e-26", "%0.7g",
__LINE__, 2.095218667083208e-22,	"2.09522e-22", "%.5e",
__LINE__, 2.096932364992728e-27,	"2.1E-27", "%.2G",
__LINE__, 2.097012452732083e+17,	"2.09701E+17", "%G",
__LINE__, 2.102022216908102e-07,	"0.000000", "%f",
__LINE__, 2.104648382618938e-04,	"0.00021", "%.3G",
__LINE__, 2.109159578853690e-19,	"2.10916e-19", "%6g",
__LINE__, 2.111732624641178e-13,	"+2.111733E-13", "%+7.7G",
__LINE__, 2.112676138351330e+21,	" 2e+21", "%6.g",
__LINE__, 2.117332904051741e-09,	"+0.000000", "%+f",
__LINE__, 2.118001353767757e-14,	"2.118E-14", "%4.3E",
__LINE__, 2.119413720893955e+12,	"2.119414E+12", "%.7G",
__LINE__, 2.119610992647014e+07,	"+21196109.9265", "%+.4f",
__LINE__, 2.120504022069221e+25,	"21205040220692210617414730.223", "%#.3f",
__LINE__, 2.120634617123718e-16,	"2.120635e-16", "%#e",
__LINE__, 2.128702437175385e+12,	"2128702437175.385", "%.3f",
__LINE__, 2.131148830213536e-12,	"2.131149e-12", "%e",
__LINE__, 2.132682622145255e+04,	"+21326.83", "%+#5.7G",
__LINE__, 2.133864841676473e-01,	"  +0.2", "%+6.g",
__LINE__, 2.133939058496273e+16,	"2E+16", "%4.G",
__LINE__, 2.135087006806302e-24,	"0.000000", "%f",
__LINE__, 2.138983961194584e-20,	"+2.138984e-20", "%+7e",
__LINE__, 2.146534189669224e+17,	"+2.147E+17", "%+.4G",
__LINE__, 2.147375595676503e+09,	"2.147376e+09", "%e",
__LINE__, 2.152994986418075e+02,	"2E+02", "%0.E",
__LINE__, 2.154127135896811e+06,	"2.15E+06", "%2.3G",
__LINE__, 2.154613053892588e-29,	"2.1546E-29", "%.4E",
__LINE__, 2.160830430730653e-12,	"2.16083E-12", "%#G",
__LINE__, 2.161740591663027e+28,	"2.161741e+28", "%e",
__LINE__, 2.167181665934011e-06,	"2e-06", "%1.e",
__LINE__, 2.167348761729060e-04,	"2.167349e-04", "%#e",
__LINE__, 2.170270852816708e-10,	"2.17027E-10", "%0G",
__LINE__, 2.173048229189370e-06,	"2.173e-06", "%.5g",
__LINE__, 2.175554537855024e+10,	"2.17555E+10", "%G",
__LINE__, 2.177447372527968e-30,	"+0.000000", "%+.6f",
__LINE__, 2.178591661569858e+05,	"2.1786e+05", "%1.5g",
__LINE__, 2.184700207174818e-29,	"0.000000", "%f",
__LINE__, 2.190817031437247e+03,	"2.E+03", "%#3.0E",
__LINE__, 2.191396212145558e-01,	"2.191E-01", "%6.3E",
__LINE__, 2.191786353372880e-23,	"2.19179e-23", "%.5e",
__LINE__, 2.193471126151079e+19,	"2.1935E+19", "%.4E",
__LINE__, 2.194750177630526e-15,	"2.194750e-15", "%e",
__LINE__, 2.196145170358973e+05,	"+219615", "%+g",
__LINE__, 2.199602360934320e-09,	"2.19960E-09", "%#6.6G",
__LINE__, 2.202913988776998e+17,	"+2.20291e+17", "%+g",
__LINE__, 2.207094560707703e-10,	"2.207095e-10", "%e",
__LINE__, 2.207557214621658e-13,	"   0", "%4.f",
__LINE__, 2.209428206272229e+13,	"2.20943e+13", "%g",
__LINE__, 2.212662463615175e-11,	"   0", "%4.0f",
__LINE__, 2.215732710968468e-30,	"2E-30", "%.1G",
__LINE__, 2.218490841936778e-10,	"2.21849e-10", "%2g",
__LINE__, 2.218850610567959e-01,	"+0.221885", "%+G",
__LINE__, 2.220796939261542e-03,	"0.002221", "%#f",
__LINE__, 2.221819894808024e+24,	"2.2e+24", "%5.1e",
__LINE__, 2.223804993235507e+27,	"2.223805e+27", "%1e",
__LINE__, 2.224715386046563e-17,	"0.00000", "%#.5f",
__LINE__, 2.224864709983882e-16,	"+2.224865e-16", "%+e",
__LINE__, 2.225764510969505e+16,	"2.E+16", "%#4.G",
__LINE__, 2.233229189161284e-07,	"+2.23323e-07", "%+6g",
__LINE__, 2.236522807209868e+17,	"2.23652e+17", "%g",
__LINE__, 2.236641620849775e+20,	"2E+20", "%0.G",
__LINE__, 2.237089952728626e-13,	"2E-13", "%5.E",
__LINE__, 2.238531255563381e-11,	"  2E-11", "%7.1G",
__LINE__, 2.242782296436871e+12,	"2242782296436.871103", "%f",
__LINE__, 2.249177852069393e-02,	"+2.249178E-02", "%+5E",
__LINE__, 2.250735782732076e+29,	"+2.25074e+29", "%+g",
__LINE__, 2.257455203557544e-11,	"+2e-11", "%+4.0g",
__LINE__, 2.258002527939529e+24,	"2.258e+24", "%g",
__LINE__, 2.266955929448160e+20,	"226695592944815960123.6056915", "%.7f",
__LINE__, 2.269019719123250e-23,	"0.000000", "%f",
__LINE__, 2.269022332502809e+02,	"+226.902233", "%+f",
__LINE__, 2.271165222038591e-03,	"0.002", "%1.1g",
__LINE__, 2.273965946408021e+14,	"+227396594640802.085507", "%+f",
__LINE__, 2.277221153386242e+22,	"22772211533862418697538.032575", "%#f",
__LINE__, 2.280214920187521e-01,	"0.2", "%2.G",
__LINE__, 2.280762993019740e+06,	"2.28076E+06", "%G",
__LINE__, 2.283479263040833e-24,	"+0.000000", "%+f",
__LINE__, 2.283686319235123e-07,	"2.2837E-07", "%5.5G",
__LINE__, 2.285842617231066e-26,	"0.000000", "%f",
__LINE__, 2.293145864755873e-02,	"0.02", "%.0g",
__LINE__, 2.293439381531532e+03,	"+2.293439E+03", "%+#1E",
__LINE__, 2.297972500660698e-22,	"2.29797e-22", "%g",
__LINE__, 2.298725366073681e+23,	"2.29873E+23", "%G",
__LINE__, 2.303151535483950e-29,	"2.30315E-29", "%G",
__LINE__, 2.308565313657699e-25,	"   0", "%4.f",
__LINE__, 2.309305373760733e-07,	"2.309305E-07", "%E",
__LINE__, 2.309693761334710e-19,	"2.30969e-19", "%g",
__LINE__, 2.312218220995774e-20,	"+2.31222E-20", "%+.6G",
__LINE__, 2.313115729670525e+24,	"2.31312E+24", "%G",
__LINE__, 2.315325159866773e-21,	"2.315325E-21", "%E",
__LINE__, 2.316932917620091e-19,	"0.000000", "%f",
__LINE__, 2.317548394633895e+13,	"2.31755E+13", "%0G",
__LINE__, 2.318951465093612e+02,	"+2.32e+02", "%+1.2e",
__LINE__, 2.319151794905482e-17,	"+0.000000", "%+0f",
__LINE__, 2.319708617851078e-27,	"0.000000", "%f",
__LINE__, 2.320019976591725e+20,	"2e+20", "%.1g",
__LINE__, 2.322859962551666e+06,	"2.32286e+06", "%g",
__LINE__, 2.326474568074649e-29,	"2.326e-29", "%.4g",
__LINE__, 2.328400844172053e-07,	"2.3284E-07", "%G",
__LINE__, 2.333695247698112e+16,	"2.3337e+16", "%g",
__LINE__, 2.333717120257130e-19,	"+0.000000", "%+f",
__LINE__, 2.334711793234782e-19,	"2.33471E-19", "%5G",
__LINE__, 2.335524987281242e+02,	"+233.55", "%+7.5g",
__LINE__, 2.335556767836369e-30,	"2.34e-30", "%.3g",
__LINE__, 2.337696964360052e-10,	"2.3377e-10", "%1g",
__LINE__, 2.337858249184500e-14,	"2.337858E-14", "%5.6E",
__LINE__, 2.339984354781169e-14,	"2.339984E-14", "%E",
__LINE__, 2.340849041430089e-04,	"0.00023", "%0.2G",
__LINE__, 2.342388410373363e-24,	"2.34239E-24", "%G",
__LINE__, 2.343933106737237e-22,	"2.34393e-22", "%g",
__LINE__, 2.344870855713960e-08,	"0.000000", "%.6f",
__LINE__, 2.347368965433808e+24,	"2347368965433808352116785", "%4.f",
__LINE__, 2.349417462171421e-02,	"+0.0234942", "%+G",
__LINE__, 2.351071111431207e+11,	"235107111143.12", "%.2f",
__LINE__, 2.352756222810670e+19,	"+2.e+19", "%+#4.g",
__LINE__, 2.355862529217003e-22,	"2.355863e-22", "%#4e",
__LINE__, 2.356804045401445e-30,	"2.3568E-30", "%G",
__LINE__, 2.362100710185559e-26,	"2.3621e-26", "%g",
__LINE__, 2.368330779173562e-12,	"   0", "%4.f",
__LINE__, 2.383329784369796e+22,	"2.38333E+22", "%G",
__LINE__, 2.386845229536477e+01,	"+23.868452", "%+#f",
__LINE__, 2.388207830036780e-05,	"0.000024", "%f",
__LINE__, 2.391809468802907e+21,	"+2.391809e+21", "%+e",
__LINE__, 2.395172908564692e-09,	"+0.000000", "%+f",
__LINE__, 2.395447167030886e-29,	"2.39545e-29", "%g",
__LINE__, 2.397292973389182e+16,	"23972929733891823", "%6.f",
__LINE__, 2.401749832237687e-30,	"2.401750E-30", "%E",
__LINE__, 2.403610502544347e-03,	"0.00240361", "%4G",
__LINE__, 2.404676421776132e+17,	"240467642177613206", "%6.f",
__LINE__, 2.406327689091479e+25,	"2.406328e+25", "%e",
__LINE__, 2.407341999590511e-02,	"0.024073", "%f",
__LINE__, 2.407352797581004e+05,	"240735.", "%#g",
__LINE__, 2.407903467439017e+13,	"2.4079E+13", "%G",
__LINE__, 2.407979635013539e+21,	" +2E+21", "%+7.G",
__LINE__, 2.409513517930790e+29,	"240951351793079027174826478585.600853", "%f",
__LINE__, 2.412530651221551e+10,	"+2.41253E+10", "%+G",
__LINE__, 2.419943224673811e+00,	"2.41994", "%#g",
__LINE__, 2.422474399040258e-15,	"0.000000", "%f",
__LINE__, 2.426060206689458e+18,	"2.42606E+18", "%1G",
__LINE__, 2.439982659679872e+14,	"+2.439983E+14", "%+E",
__LINE__, 2.440528851375447e+13,	"24405288513754.466173", "%f",
__LINE__, 2.441340473292679e+19,	"2.44134E+19", "%G",
__LINE__, 2.443521636943916e+19,	" 2.e+19", "%#7.g",
__LINE__, 2.445925211597624e-27,	"2.445925E-27", "%E",
__LINE__, 2.446966179060722e+25,	"2.446966e+25", "%5e",
__LINE__, 2.447714218717278e+11,	"2e+11", "%1.e",
__LINE__, 2.448339744613286e+06,	"2.4483e+06", "%3.5g",
__LINE__, 2.448772993496189e+03,	"2448.77", "%G",
__LINE__, 2.448857654325229e+22,	"+2.44886e+22", "%+g",
__LINE__, 2.450082452098890e-27,	"2.4501E-27", "%#3.5G",
__LINE__, 2.451293602221637e+05,	"245129.360222", "%f",
__LINE__, 2.454531490229426e+02,	"245.453", "%G",
__LINE__, 2.458958369944980e+14,	"2.5E+14", "%6.1E",
__LINE__, 2.463666680775038e+14,	"+246366668077503.80", "%+#.2f",
__LINE__, 2.471582990960795e+05,	"2.471583e+05", "%e",
__LINE__, 2.474107179274687e+22,	"2.47411e+22", "%g",
__LINE__, 2.474332114849132e-08,	"+2.47433e-08", "%+g",
__LINE__, 2.476956762431716e+18,	"+2476956762431715919.348107", "%+#f",
__LINE__, 2.479091221850607e-22,	"0.000000", "%f",
__LINE__, 2.479819586598431e-24,	"2.47982e-24", "%g",
__LINE__, 2.480006174601455e-05,	"2.48001E-05", "%G",
__LINE__, 2.482672677638334e-26,	"+0.000000", "%+f",
__LINE__, 2.492816492208918e-14,	"      0", "%7.f",
__LINE__, 2.492964173197140e-12,	"  2e-12", "%7.g",
__LINE__, 2.494646635961173e+02,	"249.465", "%g",
__LINE__, 2.494687818780545e+11,	"249468781878.054546", "%#7f",
__LINE__, 2.510083560147301e-13,	"+2.510084e-13", "%+#e",
__LINE__, 2.511186607989480e-30,	"2.51E-30", "%.3G",
__LINE__, 2.514164516133643e-11,	"2.51416e-11", "%g",
__LINE__, 2.517242520804735e+11,	"2.517243e+11", "%e",
__LINE__, 2.518526126400833e-26,	"2.51853e-26", "%g",
__LINE__, 2.520313416401176e+09,	"2520313416.401176", "%5f",
__LINE__, 2.521653160738683e-29,	"2.52165e-29", "%#g",
__LINE__, 2.521941342615338e-16,	"2.52194e-16", "%g",
__LINE__, 2.523554774354461e-03,	"+3E-03", "%+.0E",
__LINE__, 2.525434130825058e+06,	"+2.525434E+06", "%+E",
__LINE__, 2.527616380113364e+02,	"2.527616E+02", "%E",
__LINE__, 2.531871347913505e+09,	"+2.53187E+09", "%+#G",
__LINE__, 2.532167428661069e+06,	"2532167.428661", "%f",
__LINE__, 2.545585718405995e+14,	"+2.54559E+14", "%+G",
__LINE__, 2.546305097286406e+10,	"2.546305e+10", "%e",
__LINE__, 2.547467156069069e-30,	"+0.00", "%+3.2f",
__LINE__, 2.548728793004506e-14,	"2.54873E-14", "%G",
__LINE__, 2.560375602395090e+11,	"256037560239.509032", "%0f",
__LINE__, 2.560555687476687e+03,	"2561", "%.4g",
__LINE__, 2.561709077363443e-24,	"+0.000000", "%+f",
__LINE__, 2.563763849675242e+10,	"2.5637638E+10", "%.7E",
__LINE__, 2.567482414574355e+11,	"+2.567482e+11", "%+e",
__LINE__, 2.571575046303674e-17,	"3E-17", "%2.0E",
__LINE__, 2.572997971296986e+11,	"257299797129.698593", "%f",
__LINE__, 2.578625935900331e+22,	"25786259359003311786295.853381", "%f",
__LINE__, 2.579663282966370e+12,	"2.579663e+12", "%e",
__LINE__, 2.593141782397610e-08,	"0.000000", "%f",
__LINE__, 2.594386109584196e+04,	"3.E+04", "%#6.0E",
__LINE__, 2.598069318007816e-22,	"2.59807e-22", "%g",
__LINE__, 2.600910462290091e+09,	"2.600910E+09", "%6E",
__LINE__, 2.602580183614458e-03,	"2.602580e-03", "%e",
__LINE__, 2.606540360440264e+09,	"+2606540360.4", "%+#0.1f",
__LINE__, 2.610016419698116e-21,	"+3.e-21", "%+#3.g",
__LINE__, 2.612279323574882e-20,	"2.61228E-20", "%G",
__LINE__, 2.614157324336453e-14,	"2.61416e-14", "%g",
__LINE__, 2.614688721873993e-09,	"2.61e-09", "%6.2e",
__LINE__, 2.616661104472416e-15,	"    0", "%5.f",
__LINE__, 2.616742079283195e-09,	" +3E-09", "%+7.E",
__LINE__, 2.618075304717427e+24,	"2.618075e+24", "%e",
__LINE__, 2.624118573335769e+26,	"262411857333576925555007619.550452", "%1f",
__LINE__, 2.625718894274227e+24,	"+2625718894274227110940955.753904", "%+f",
__LINE__, 2.627081999477812e+03,	"2627.081999", "%f",
__LINE__, 2.631061062224705e+14,	"263106106222470.481626", "%f",
__LINE__, 2.631545877128814e+27,	"+2.63155e+27", "%+g",
__LINE__, 2.632694395848818e-11,	"2.63269e-11", "%g",
__LINE__, 2.636728891022008e-22,	"+2.63673e-22", "%+#4g",
__LINE__, 2.638495675008130e-28,	"+2.638496e-28", "%+e",
__LINE__, 2.639704195859799e-11,	"0.", "%#.0f",
__LINE__, 2.641645264652665e-20,	"0", "%0.f",
__LINE__, 2.642012075064497e-20,	"3E-20", "%0.E",
__LINE__, 2.648725869006487e-29,	" 3E-29", "%6.G",
__LINE__, 2.649060724417770e+12,	"3E+12", "%3.G",
__LINE__, 2.651188545120166e-17,	"0.000", "%.3f",
__LINE__, 2.652302152621621e+14,	"2.7E+14", "%.2G",
__LINE__, 2.653309718412604e-28,	"0.000000", "%f",
__LINE__, 2.658344750491858e-21,	" 3e-21", "%6.g",
__LINE__, 2.664625074612594e+15,	"3e+15", "%1.g",
__LINE__, 2.666953728270800e-15,	"3e-15", "%0.e",
__LINE__, 2.674515419678877e-11,	" 3E-11", "%6.E",
__LINE__, 2.680054917256578e+15,	"2680054917256577.5", "%#2.1f",
__LINE__, 2.680495609883415e-11,	"2.68E-11", "%#.3G",
__LINE__, 2.685757893641070e+23,	"268575789364107020418259.70809", "%1.5f",
__LINE__, 2.695551226058178e+16,	"26955512260581775.407786", "%f",
__LINE__, 2.696346377519671e+04,	"+26963.5", "%+G",
__LINE__, 2.714262310601257e+17,	"+2.714262E+17", "%+E",
__LINE__, 2.719227450016317e-01,	"0.271923", "%G",
__LINE__, 2.724135433346056e-30,	"+2.72414e-30", "%+g",
__LINE__, 2.725143224130276e+14,	"272514322413027.576530", "%6f",
__LINE__, 2.729355189648310e-03,	"+0.00273", "%+.5f",
__LINE__, 2.732872167724945e+11,	"2.73287E+11", "%G",
__LINE__, 2.737709476435412e+17,	"273770947643541218.141650", "%f",
__LINE__, 2.739299356074967e-15,	"2.7E-15", "%.2G",
__LINE__, 2.740793612304798e-27,	"2.740794E-27", "%.7G",
__LINE__, 2.742030156175960e+20,	"2.74203e+20", "%2.6g",
__LINE__, 2.744455324096085e+11,	"2.74446E+11", "%G",
__LINE__, 2.745179546531160e+07,	"2.7452E+07", "%.5G",
__LINE__, 2.747470562525333e+04,	"3E+04", "%2.E",
__LINE__, 2.750243314674629e+21,	"2.75024E+21", "%#G",
__LINE__, 2.750250224436030e+20,	"+2.750250e+20", "%+0.6e",
__LINE__, 2.752712858561084e-22,	"2.752713e-22", "%e",
__LINE__, 2.756982987656667e-03,	"0.002756983", "%#.7G",
__LINE__, 2.761841188479590e+13,	"3e+13", "%1.g",
__LINE__, 2.769498440434419e+00,	"+3e+00", "%+0.e",
__LINE__, 2.769993785786379e+10,	"27699937857.863794", "%f",
__LINE__, 2.772900256376753e-06,	"+2.7729E-06", "%+7.6G",
__LINE__, 2.774401482467457e-06,	"2.8e-06", "%3.2g",
__LINE__, 2.777691370374757e-02,	"+0.027777", "%+f",
__LINE__, 2.779836227365899e-09,	"3e-09", "%5.0g",
__LINE__, 2.780481651765741e+01,	"2.780482E+01", "%E",
__LINE__, 2.782228478714809e-26,	"2.782228E-26", "%4.7G",
__LINE__, 2.790457781719376e+13,	"+2.8e+13", "%+.2g",
__LINE__, 2.792026581166417e-30,	" 3.e-30", "%#7.0g",
__LINE__, 2.792396278299615e-08,	"0.00", "%#.2f",
__LINE__, 2.793658047689995e-10,	"2.794e-10", "%#0.4g",
__LINE__, 2.795707358229888e-25,	"0.000000", "%f",
__LINE__, 2.796253091758523e-06,	"2.796E-06", "%.4G",
__LINE__, 2.796756564788716e-24,	"2.796757e-24", "%e",
__LINE__, 2.798730444798773e-14,	"2.79873e-14", "%g",
__LINE__, 2.799108397670447e-24,	"3E-24", "%.0G",
__LINE__, 2.799389008872835e+06,	"2799389.", "%#0.f",
__LINE__, 2.800413998518039e-14,	"0.000000", "%f",
__LINE__, 2.803237602587100e+15,	"+2803237602587100.418816", "%+5f",
__LINE__, 2.803474415574551e-04,	"0.0002803", "%.7f",
__LINE__, 2.804957468647181e+25,	"2.80496e+25", "%g",
__LINE__, 2.809345112788226e+09,	"2809345112.788226", "%.6f",
__LINE__, 2.811518239408899e+10,	"3e+10", "%1.g",
__LINE__, 2.813188439967416e-16,	"0.0000000", "%5.7f",
__LINE__, 2.813497118051755e+08,	"2.8135e+08", "%.5g",
__LINE__, 2.815748256510577e-29,	"0.000000", "%2f",
__LINE__, 2.816076365485207e-01,	"0.281608", "%0G",
__LINE__, 2.816083345772131e+24,	"2.8161e+24", "%6.4e",
__LINE__, 2.818686957605178e+12,	"2.8187E+12", "%.5G",
__LINE__, 2.821903538737691e+20,	"2.8219E+20", "%G",
__LINE__, 2.823659589845680e+26,	"2.82366e+26", "%2g",
__LINE__, 2.823685630865012e+22,	"2.82369E+22", "%G",
__LINE__, 2.828826386007914e+21,	"2.828826E+21", "%7E",
__LINE__, 2.830997901034349e+04,	"+3e+04", "%+0.e",
__LINE__, 2.833886731091353e-26,	"+2.833887e-26", "%+4e",
__LINE__, 2.839965144893913e+28,	"28399651448939131626048038015.1421", "%.4f",
__LINE__, 2.840651452049947e-09,	"2.841E-09", "%#.3E",
__LINE__, 2.843388001911757e-01,	"0.284339", "%g",
__LINE__, 2.846122151080671e+14,	"2.84612E+14", "%.5E",
__LINE__, 2.851257828837595e+05,	"+285126", "%+5.f",
__LINE__, 2.853823884459520e+07,	"+2.85382E+07", "%+G",
__LINE__, 2.853870068368765e-06,	"2.854E-06", "%4.3E",
__LINE__, 2.856687358149867e+01,	"+28.567", "%+6.5G",
__LINE__, 2.858946600073752e+06,	"2.8589466e+06", "%3.7e",
__LINE__, 2.861525727138818e+24,	"2.8615257e+24", "%2.7e",
__LINE__, 2.865104175886071e-24,	"0.000000", "%f",
__LINE__, 2.870678920363198e-14,	"2.87068E-14", "%G",
__LINE__, 2.873298537233691e+09,	"+2.8733e+09", "%+g",
__LINE__, 2.877939609444375e-02,	"0.028779", "%f",
__LINE__, 2.878253985341728e+13,	"2.87825E+13", "%G",
__LINE__, 2.879299244903946e+29,	"287929924490394597569320467301", "%0.f",
__LINE__, 2.885516225515485e-26,	"0.000000", "%f",
__LINE__, 2.886013724129579e+20,	"+3e+20", "%+4.g",
__LINE__, 2.887032786975506e-30,	"0.000000", "%f",
__LINE__, 2.890415456531026e-29,	"2.89042E-29", "%G",
__LINE__, 2.893177360548214e-13,	"2.893E-13", "%#6.3E",
__LINE__, 2.895265536458195e+26,	"2.89527e+26", "%5g",
__LINE__, 2.903844533810152e+23,	"290384453381015195105874.23", "%.2f",
__LINE__, 2.909060558287504e+27,	"2.90906e+27", "%g",
__LINE__, 2.911615480973172e-05,	"2.91162E-05", "%3G",
__LINE__, 2.912692297221896e+09,	"2912692297.221896", "%#f",
__LINE__, 2.913595662485813e-24,	"2.9136E-24", "%G",
__LINE__, 2.915960840341896e-27,	"0.000000", "%f",
__LINE__, 2.920451095973991e-16,	"2.92e-16", "%2.2e",
__LINE__, 2.920528295810925e+06,	"2.92053E+06", "%#G",
__LINE__, 2.921564671017147e+20,	"2.921565E+20", "%#6E",
__LINE__, 2.921628350942189e+01,	"2.921628E+01", "%E",
__LINE__, 2.921843377455232e+20,	"2.921843E+20", "%#E",
__LINE__, 2.930156950319384e+29,	"2.930E+29", "%1.3E",
__LINE__, 2.931229858895071e-30,	"2.9e-30", "%4.2g",
__LINE__, 2.931753029689166e+20,	"2.93175e+20", "%g",
__LINE__, 2.933023693079342e+15,	"3.E+15", "%#.1G",
__LINE__, 2.933078733225520e+26,	"2.93308E+26", "%G",
__LINE__, 2.933528170896643e-14,	"+2.93353e-14", "%+g",
__LINE__, 2.938648437428148e+00,	"2.938648e+00", "%e",
__LINE__, 2.940752238221344e+26,	"+2.94075E+26", "%+G",
__LINE__, 2.942836470459675e+20,	"2.9428e+20", "%6.4e",
__LINE__, 2.943218333254941e+29,	"294321833325494086608387078740.634024", "%f",
__LINE__, 2.943690574007512e-27,	"0.000000", "%f",
__LINE__, 2.945452907046501e+09,	"+2.9455E+09", "%+.5G",
__LINE__, 2.946648725966953e+16,	"29466487259669534.637396", "%4f",
__LINE__, 2.955119322417825e+29,	"2.95512E+29", "%G",
__LINE__, 2.966481197538973e+24,	"2.96648e+24", "%#g",
__LINE__, 2.969362862661362e+08,	"+2.969363e+08", "%+7e",
__LINE__, 2.970062459990078e+21,	"+2.97006E+21", "%+G",
__LINE__, 2.971059959019791e+10,	"  3E+10", "%7.G",
__LINE__, 2.973020205606034e-29,	"0.000000", "%f",
__LINE__, 2.977223210301426e+04,	"2.977223e+04", "%#e",
__LINE__, 2.977467832772786e-26,	"0.000000", "%f",
__LINE__, 2.981433606423384e+18,	"2981433606423384397.032805", "%f",
__LINE__, 2.981615513287404e-17,	"2.98162e-17", "%g",
__LINE__, 2.983880743847276e+19,	"  3e+19", "%7.e",
__LINE__, 2.983927792297305e-28,	"2.983928e-28", "%e",
__LINE__, 2.984807359492058e-17,	" 0", "%2.f",
__LINE__, 2.985123412933032e+09,	"+2.98512e+09", "%+g",
__LINE__, 2.991132955408629e-27,	"+2.99113e-27", "%+4g",
__LINE__, 2.992345635923643e+19,	"3E+19", "%4.G",
__LINE__, 2.993024238285395e-05,	"2.99302e-05", "%2g",
__LINE__, 2.995303406756363e+16,	"+2.995303E+16", "%+E",
__LINE__, 2.995492577854335e+19,	"+29954925778543346481.797016", "%+f",
__LINE__, 2.996856271675341e-25,	"+3e-25", "%+0.e",
__LINE__, 2.997813968112619e+12,	"2.99781e+12", "%#5g",
__LINE__, 3.002097486457961e-17,	"3.00210e-17", "%5.5e",
__LINE__, 3.006538123158692e+28,	"+3.00654E+28", "%+#G",
__LINE__, 3.007293721729544e+04,	"30072.937217", "%f",
__LINE__, 3.008301791944493e-07,	"3.008e-07", "%.3e",
__LINE__, 3.011742184603817e-17,	"3.011742E-17", "%#E",
__LINE__, 3.024641547299177e-30,	"3.02464e-30", "%g",
__LINE__, 3.026525135110198e-28,	"3e-28", "%.0e",
__LINE__, 3.026768160756558e+20,	"3.02677E+20", "%G",
__LINE__, 3.031928829940975e+18,	"3031928829940975234.1", "%0.1f",
__LINE__, 3.039787705138620e+24,	"+3.E+24", "%+#5.G",
__LINE__, 3.039803824423916e-02,	"0.030398", "%5f",
__LINE__, 3.041236293199133e-26,	"3.04124e-26", "%g",
__LINE__, 3.045634954037886e+04,	"30456.3", "%g",
__LINE__, 3.047528114241850e+25,	"3e+25", "%0.e",
__LINE__, 3.047958193737501e-24,	"3.04796E-24", "%#G",
__LINE__, 3.049537324414302e-16,	"3.04954E-16", "%G",
__LINE__, 3.050500637681798e-30,	"3.0505E-30", "%G",
__LINE__, 3.051769626625307e-01,	"0.305177", "%f",
__LINE__, 3.057280201971847e+11,	"+3.05728E+11", "%+.5E",
__LINE__, 3.060046173306881e-10,	"+3.060046e-10", "%+e",
__LINE__, 3.069732667347204e+27,	"+3069732667347204291274920251.453295", "%+f",
__LINE__, 3.075060836786916e-14,	"0.000000", "%f",
__LINE__, 3.078175179670964e+13,	"3.07818E+13", "%G",
__LINE__, 3.080305344303183e-21,	"3.08031e-21", "%6g",
__LINE__, 3.088881497064043e+27,	"+3.088881E+27", "%+3E",
__LINE__, 3.089196877931209e-20,	"3.089197e-20", "%e",
__LINE__, 3.091400888880487e-08,	"3e-08", "%2.e",
__LINE__, 3.093410684178904e+16,	"3.09341e+16", "%g",
__LINE__, 3.104225344208216e-21,	"0.000000", "%f",
__LINE__, 3.105843728248599e+13,	"3.e+13", "%#.0g",
__LINE__, 3.106463071390893e-07,	"0.0000", "%.4f",
__LINE__, 3.107784123569379e+02,	"+310.778", "%+G",
__LINE__, 3.110605148983672e-20,	"3.1106051E-20", "%.7E",
__LINE__, 3.111702418162670e-04,	"0.00031117", "%.5G",
__LINE__, 3.117610675303153e-17,	"3.11761e-17", "%g",
__LINE__, 3.123620125717981e+07,	"3.1236e+07", "%2.5g",
__LINE__, 3.125648558809832e-24,	"+3.125649E-24", "%+#0.6E",
__LINE__, 3.129025163659283e+10,	"31290251636.592825", "%#f",
__LINE__, 3.130689119412709e-29,	"+3.131E-29", "%+#.4G",
__LINE__, 3.135681222132527e+13,	"3.13568E+13", "%G",
__LINE__, 3.138290485073330e-10,	"3.13829E-10", "%G",
__LINE__, 3.141255250155306e-12,	"3.14126E-12", "%G",
__LINE__, 3.143224520918429e+25,	"3.14322E+25", "%#1G",
__LINE__, 3.144746921366173e-16,	"      0", "%7.f",
__LINE__, 3.151336678241994e+19,	"+3.15134E+19", "%+G",
__LINE__, 3.161752935716549e+24,	"3.2E+24", "%2.1E",
__LINE__, 3.167106521258172e-10,	"+3.167107e-10", "%+e",
__LINE__, 3.167266522824146e-04,	"3E-04", "%3.E",
__LINE__, 3.169995217131489e+27,	"3169995217131488907114089670.358226", "%f",
__LINE__, 3.172117220467692e-21,	"3.1721E-21", "%.5G",
__LINE__, 3.173824170351611e+02,	" 3e+02", "%6.e",
__LINE__, 3.186291452544739e-28,	" 0", "%2.f",
__LINE__, 3.194750094186063e+03,	"+3.194750E+03", "%+E",
__LINE__, 3.195001037118137e-20,	"0", "%0.0f",
__LINE__, 3.199271564719560e+02,	"319.927", "%g",
__LINE__, 3.212803450638544e+20,	"3.2128e+20", "%.6g",
__LINE__, 3.214502877263883e+24,	"3214502877263882840708220", "%2.f",
__LINE__, 3.214658414074286e-01,	"+0.321466", "%+#g",
__LINE__, 3.217627975823673e+00,	"3.217628", "%f",
__LINE__, 3.218257328710536e-07,	"3.21826e-07", "%6.5e",
__LINE__, 3.221949479347008e+02,	"322.194948", "%f",
__LINE__, 3.222862935507443e-14,	"3.222863E-14", "%E",
__LINE__, 3.223750247261608e+19,	"3.22375e+19", "%g",
__LINE__, 3.236030335782375e+05,	"3.236030e+05", "%e",
__LINE__, 3.241078803072735e+19,	"3.24108e+19", "%g",
__LINE__, 3.248069569167045e-06,	"0.000003", "%#f",
__LINE__, 3.248148973717269e-15,	"3.24815E-15", "%G",
__LINE__, 3.251150704311790e+25,	"+3.25115e+25", "%+5g",
__LINE__, 3.254498593372140e+15,	"+3.2545e+15", "%+g",
__LINE__, 3.254949399612861e-13,	"+3.255E-13", "%+7.3E",
__LINE__, 3.255490928554106e-17,	"3.255491e-17", "%e",
__LINE__, 3.262333894422112e+17,	"326233389442211185.738074", "%0f",
__LINE__, 3.263923577545217e-24,	"0.0000000", "%.7f",
__LINE__, 3.267125289609703e+23,	"3.26713e+23", "%#.5e",
__LINE__, 3.267906049108331e+27,	"3.267906E+27", "%6E",
__LINE__, 3.269885039157328e+14,	"326988503915732.797722", "%f",
__LINE__, 3.296011393609953e-27,	"  3E-27", "%7.E",
__LINE__, 3.296452164568996e+29,	"3.296452E+29", "%E",
__LINE__, 3.296544736555325e+10,	"+3.29654E+10", "%+.6G",
__LINE__, 3.301861835798572e+03,	"3301.862", "%4.7g",
__LINE__, 3.311292283423002e+21,	" 3E+21", "%6.G",
__LINE__, 3.314868440076262e-10,	"3.3149E-10", "%.5G",
__LINE__, 3.318057982247451e-13,	"3.3181e-13", "%0.5g",
__LINE__, 3.318139218410071e-22,	"0.000000", "%f",
__LINE__, 3.326769904839351e-11,	"+3.3268e-11", "%+0.4e",
__LINE__, 3.327483659787219e+27,	"+3.32748e+27", "%+g",
__LINE__, 3.332666889640198e+17,	"333266688964019763.830038", "%f",
__LINE__, 3.333807449377253e+10,	"+3.33e+10", "%+.3g",
__LINE__, 3.334572302792625e-09,	"3.334572E-09", "%E",
__LINE__, 3.337567126586765e-17,	"0.0000000", "%#3.7f",
__LINE__, 3.340512607683786e-04,	"+3E-04", "%+1.E",
__LINE__, 3.344911557516870e+04,	"33449.1", "%G",
__LINE__, 3.346464302017296e+26,	"+3.E+26", "%+#3.G",
__LINE__, 3.348503166628953e+00,	"+3.348503e+00", "%+e",
__LINE__, 3.350025157778138e-19,	"3.35003e-19", "%6g",
__LINE__, 3.352826233035342e+11,	"335282623303.534200", "%7f",
__LINE__, 3.357174089765502e+10,	"3.35717E+10", "%G",
__LINE__, 3.369253166475501e+03,	"+3369.25", "%+G",
__LINE__, 3.371385975046735e+02,	"337.", "%#.0f",
__LINE__, 3.372532650462104e-04,	"+0.000", "%+.3f",
__LINE__, 3.376498162710442e-26,	"3.376498e-26", "%e",
__LINE__, 3.383510307689135e-12,	"  3e-12", "%7.0e",
__LINE__, 3.388427914080631e-04,	"0.0003", "%2.4f",
__LINE__, 3.390757423408097e+29,	"3.3908E+29", "%.4E",
__LINE__, 3.393963140962879e-11,	"3.39396e-11", "%g",
__LINE__, 3.399245742994444e+24,	"3.399246E+24", "%E",
__LINE__, 3.417690405546708e-26,	"0.00000", "%4.5f",
__LINE__, 3.421159360472045e-30,	"3.42116E-30", "%G",
__LINE__, 3.421973947898887e-06,	"3.42197E-06", "%4G",
__LINE__, 3.425949002482817e-10,	"+3.42595E-10", "%+G",
__LINE__, 3.428355150377972e+08,	"3.42836E+08", "%G",
__LINE__, 3.445035158951526e+15,	"3445035158951526.454985", "%f",
__LINE__, 3.447363996077534e+28,	"+3e+28", "%+2.e",
__LINE__, 3.451571062654907e-03,	"0.00345157", "%G",
__LINE__, 3.452787236877688e+09,	"3.45279e+09", "%g",
__LINE__, 3.454114826574939e-22,	"3.e-22", "%#3.e",
__LINE__, 3.455241965974631e-03,	"0.003455", "%#f",
__LINE__, 3.456190496554365e-18,	"3.E-18", "%#5.E",
__LINE__, 3.456804565717233e-19,	"+0.000", "%+2.3f",
__LINE__, 3.457077651539715e-28,	"3.457078E-28", "%E",
__LINE__, 3.472025705376229e+22,	"3.472e+22", "%7.4g",
__LINE__, 3.473308270919079e+03,	"3.473308e+03", "%e",
__LINE__, 3.474468013243007e-30,	"3.47447e-30", "%g",
__LINE__, 3.477976957097698e+22,	"3.47798e+22", "%g",
__LINE__, 3.501174631980057e-06,	"4e-06", "%4.g",
__LINE__, 3.501808481702140e+20,	"3.50181E+20", "%G",
__LINE__, 3.511760000705324e+14,	"351176000070532.357000", "%f",
__LINE__, 3.511870226306087e+29,	"3.51187e+29", "%.5e",
__LINE__, 3.518846859147841e+02,	"+351.885", "%+G",
__LINE__, 3.521659149753418e+25,	"35216591497534182053641416", "%5.f",
__LINE__, 3.521721228178747e+21,	"4e+21", "%2.e",
__LINE__, 3.526696007281458e+22,	"3.5267e+22", "%g",
__LINE__, 3.535631031379084e-11,	"4e-11", "%5.0g",
__LINE__, 3.537219665456759e-01,	"0.353722", "%f",
__LINE__, 3.537252728287785e-09,	"3.537253E-09", "%E",
__LINE__, 3.542561277796815e-19,	"3.542561E-19", "%E",
__LINE__, 3.548942336915745e+13,	"3.54894E+13", "%.5E",
__LINE__, 3.574385715121768e-24,	"3.57439E-24", "%#G",
__LINE__, 3.578068067760211e-13,	"3.578068E-13", "%E",
__LINE__, 3.583296432862266e-13,	"3.5833e-13", "%g",
__LINE__, 3.591567367115590e+19,	"3.59157e+19", "%1g",
__LINE__, 3.594902312287635e-24,	"3.5949E-24", "%G",
__LINE__, 3.602929486764515e+12,	"3602929486764.514522", "%#f",
__LINE__, 3.606699462631472e-01,	"+0.360670", "%+f",
__LINE__, 3.608605968319811e+17,	"3.60861e+17", "%g",
__LINE__, 3.608780761567885e+24,	"4e+24", "%0.e",
__LINE__, 3.623857274715022e-15,	"3.62386E-15", "%1G",
__LINE__, 3.627346251764432e-22,	"3.627e-22", "%.4g",
__LINE__, 3.652610391698086e-16,	"0.000000", "%3f",
__LINE__, 3.657463146689917e-19,	"   0", "%4.0f",
__LINE__, 3.658538858712938e-15,	"4E-15", "%5.G",
__LINE__, 3.660337267266058e+16,	"+36603372672660579.034698", "%+f",
__LINE__, 3.661588742065142e-01,	"0.366159", "%g",
__LINE__, 3.662296387211376e-25,	"0.000000", "%f",
__LINE__, 3.668511100303393e-29,	"0.000000", "%7f",
__LINE__, 3.669499303661920e+06,	"3.6695e+06", "%1.5g",
__LINE__, 3.676856420121343e-23,	"3.6769e-23", "%0.4e",
__LINE__, 3.677197473476901e-19,	"+3.6772e-19", "%+g",
__LINE__, 3.677281754506453e+12,	"+3677281754506.452671", "%+f",
__LINE__, 3.678420802401506e-19,	"3.67842E-19", "%G",
__LINE__, 3.679970245325769e+07,	"3.67997e+07", "%g",
__LINE__, 3.682528947621349e+05,	"4.e+05", "%#5.e",
__LINE__, 3.688257471304210e+22,	"36882574713042104441740.320908", "%f",
__LINE__, 3.689129734472166e-01,	"0.368913", "%0.6G",
__LINE__, 3.693483801463324e+12,	"4E+12", "%3.E",
__LINE__, 3.694612396584729e-21,	"+3.69461E-21", "%+G",
__LINE__, 3.706150073392112e-19,	"0.000000", "%2f",
__LINE__, 3.706824819530577e+21,	"3706824819530576853310.321894", "%f",
__LINE__, 3.709583789659276e+19,	"+3.709584E+19", "%+#E",
__LINE__, 3.711137503697284e+22,	"3.7111E+22", "%.5G",
__LINE__, 3.717307412969522e-22,	"3.717307E-22", "%#E",
__LINE__, 3.717434999853808e+24,	" 4E+24", "%6.G",
__LINE__, 3.720761662524312e+14,	"+372076166252431.2285", "%+1.4f",
__LINE__, 3.721613815237707e-10,	"3.72161e-10", "%g",
__LINE__, 3.725086467464346e+14,	"3.72509E+14", "%G",
__LINE__, 3.727427083626536e-15,	"+4E-15", "%+.0G",
__LINE__, 3.731138322599465e-13,	"3.73114e-13", "%5g",
__LINE__, 3.732248129614146e-04,	"  4E-04", "%7.E",
__LINE__, 3.744422223926118e-24,	"3.744422E-24", "%E",
__LINE__, 3.745595428897916e+21,	"+3745595428897916079336.027906", "%+f",
__LINE__, 3.751308304055989e-08,	"+3.751308e-08", "%+e",
__LINE__, 3.755395417696132e-02,	"0.037554", "%f",
__LINE__, 3.769103881505159e+09,	"3.7691e+09", "%g",
__LINE__, 3.769535572757430e+00,	"3.769536", "%6.7G",
__LINE__, 3.770823872348274e-28,	"+0.000000", "%+f",
__LINE__, 3.771160653578178e+29,	"3.77116e+29", "%g",
__LINE__, 3.776563752716444e-12,	"4E-12", "%.0E",
__LINE__, 3.777953798674786e-28,	"3.77795e-28", "%g",
__LINE__, 3.785994690686598e+28,	"4E+28", "%5.G",
__LINE__, 3.787487488835162e+01,	"+37.874875", "%+5f",
__LINE__, 3.788249311173359e-18,	"3.788249E-18", "%E",
__LINE__, 3.798728360791314e-08,	"3.798728E-08", "%2E",
__LINE__, 3.799038238867092e+05,	"3.79904E+05", "%.5E",
__LINE__, 3.799822564549600e+06,	"3.79982E+06", "%.5E",
__LINE__, 3.804862840499834e-16,	"0", "%1.f",
__LINE__, 3.805375156822481e+12,	"3805375156822.4814861", "%.7f",
__LINE__, 3.821612790153376e-17,	"3.821613e-17", "%e",
__LINE__, 3.825193659558693e+14,	"3.82519E+14", "%#G",
__LINE__, 3.834180638680996e+17,	"+383418063868099565.638659", "%+f",
__LINE__, 3.834759760605814e-12,	"3.83476E-12", "%G",
__LINE__, 3.839786235582770e+16,	"+3.84e+16", "%+0.3g",
__LINE__, 3.843164462248778e+28,	"3.84316e+28", "%#g",
__LINE__, 3.845599697858050e+22,	"3.8456E+22", "%G",
__LINE__, 3.850147271017228e-21,	"3.85e-21", "%.4g",
__LINE__, 3.850283557812101e+07,	"3.85028E+07", "%G",
__LINE__, 3.854235609725703e+03,	"3854.24", "%G",
__LINE__, 3.864901885489405e-15,	"3.8649E-15", "%G",
__LINE__, 3.868630187629983e-24,	"3.868630e-24", "%e",
__LINE__, 3.876764606134972e-03,	"+3.8767646e-03", "%+#0.7e",
__LINE__, 3.884553592855422e+08,	"+3.8845536e+08", "%+4.7e",
__LINE__, 3.887417494351062e+03,	"3887.42", "%0g",
__LINE__, 3.887561018972304e+03,	"3887.56", "%G",
__LINE__, 3.888554801724658e-24,	"3.888555e-24", "%e",
__LINE__, 3.892806891909861e-01,	"0.389281", "%f",
__LINE__, 3.914459791345755e+15,	"+3.914460E+15", "%+E",
__LINE__, 3.918383209642759e+01,	"39.1838", "%#G",
__LINE__, 3.923970658741865e-10,	"3.92397E-10", "%G",
__LINE__, 3.928163650272335e+18,	"3928163650272335161.162118", "%f",
__LINE__, 3.933053127721002e-20,	"3.933053e-20", "%e",
__LINE__, 3.939306552155218e-29,	"3.93931E-29", "%G",
__LINE__, 3.953007066379472e+07,	"3.953007E+07", "%E",
__LINE__, 3.954924824986267e-01,	"3.954925E-01", "%E",
__LINE__, 3.956156072067987e+15,	"3.956E+15", "%0.4G",
__LINE__, 3.957756196797224e+22,	"4.0E+22", "%4.1E",
__LINE__, 3.960011413261009e+27,	"+3960011413261008783592842519.283295", "%+f",
__LINE__, 3.961789076323378e+20,	"396178907632337828914.614875", "%f",
__LINE__, 3.961985468081708e-28,	"3.96199E-28", "%1G",
__LINE__, 3.975007582283812e-27,	"0.000000", "%0.6f",
__LINE__, 3.987586813142132e+15,	"+3.98759e+15", "%+g",
__LINE__, 3.992250836957379e+21,	"3.99225E+21", "%0G",
__LINE__, 3.992985048620057e+00,	"3.9930", "%.4f",
__LINE__, 4.000000000000000e+02,	"400.00", "%.2f",
__LINE__, 4.000145414240556e+14,	"4.00015e+14", "%#6g",
__LINE__, 4.000774453529974e-25,	"4E-25", "%.0E",
__LINE__, 4.002041494804383e+17,	"4.002041E+17", "%E",
__LINE__, 4.005505415013214e+17,	" 4E+17", "%6.2G",
__LINE__, 4.008960306876491e-28,	"0.000", "%.3f",
__LINE__, 4.032337828117640e+16,	"4.03234E+16", "%G",
__LINE__, 4.035414597530057e+26,	"403541459753005682387083652.429283", "%f",
__LINE__, 4.037065874793069e-01,	"0.403707", "%f",
__LINE__, 4.047856284449970e-14,	"4.04786E-14", "%#G",
__LINE__, 4.049037221323070e-04,	"4.049037e-04", "%e",
__LINE__, 4.053458853142009e-07,	"4E-07", "%2.0E",
__LINE__, 4.056455443275955e-22,	"4.056455e-22", "%e",
__LINE__, 4.058158020771355e-22,	"4.05816e-22", "%#2g",
__LINE__, 4.067283508945137e+02,	"+4.07e+02", "%+5.2e",
__LINE__, 4.072155715199509e+11,	"4.072e+11", "%.4g",
__LINE__, 4.074643403755990e-22,	"4e-22", "%0.g",
__LINE__, 4.077450352325251e+08,	"4.1e+08", "%3.2g",
__LINE__, 4.081492619284916e-08,	"4.081493E-08", "%E",
__LINE__, 4.083271801996951e-10,	"4.083272E-10", "%#E",
__LINE__, 4.090188547940879e-15,	"4.090189E-15", "%#E",
__LINE__, 4.091167728938537e-11,	"4e-11", "%1.g",
__LINE__, 4.091916745541154e+15,	"4091916745541153.588306", "%f",
__LINE__, 4.092366122921161e+23,	"4E+23", "%0.E",
__LINE__, 4.094638368212577e-11,	"4.09464E-11", "%#G",
__LINE__, 4.097148443124199e-16,	"0.000000", "%f",
__LINE__, 4.101057893946401e+06,	"4e+06", "%4.g",
__LINE__, 4.101209521231476e+28,	"41012095212314756409455185348.633677", "%f",
__LINE__, 4.105683659045903e+05,	"+4.E+05", "%+#1.G",
__LINE__, 4.111553717385758e-16,	"4.11155e-16", "%g",
__LINE__, 4.112186409918593e+14,	"+4.11219e+14", "%+g",
__LINE__, 4.117782144860865e+25,	"4.117782E+25", "%5E",
__LINE__, 4.119420921722146e-27,	"4.11942e-27", "%g",
__LINE__, 4.134953783635018e+14,	"+4.1349538e+14", "%+.7e",
__LINE__, 4.136990822648468e+11,	"4.136991E+11", "%E",
__LINE__, 4.140475788523046e+14,	"+4E+14", "%+5.G",
__LINE__, 4.149589679915584e+24,	"4.14959E+24", "%2G",
__LINE__, 4.151240342256744e-22,	" 0", "%2.f",
__LINE__, 4.155533104307272e-04,	"+0.000416", "%+f",
__LINE__, 4.155890511880097e+25,	"4.155891e+25", "%e",
__LINE__, 4.159907901074450e-19,	"4.159908E-19", "%7E",
__LINE__, 4.171899783464252e+18,	"4E+18", "%.0E",
__LINE__, 4.177920266276382e-17,	"+0.0000", "%+1.4f",
__LINE__, 4.181728014477237e-20,	"4.18173e-20", "%.6g",
__LINE__, 4.203600495086497e-30,	" 4E-30", "%6.G",
__LINE__, 4.211166112605717e-08,	"4E-08", "%5.1G",
__LINE__, 4.219513437404614e+18,	"+4E+18", "%+.0E",
__LINE__, 4.221426315236785e+08,	"4.221426E+08", "%#E",
__LINE__, 4.226224756005934e-13,	" 4.e-13", "%#7.g",
__LINE__, 4.226979046489921e-01,	"4.226979e-01", "%#.6e",
__LINE__, 4.236283521629158e-08,	"+4.23628E-08", "%+G",
__LINE__, 4.239850628514233e-07,	"4.23985E-07", "%.6G",
__LINE__, 4.241177358638621e+04,	"42411.773586", "%2f",
__LINE__, 4.245306724398964e-13,	"0.000000", "%#f",
__LINE__, 4.246194290300334e+16,	"42461942903003340.177293", "%2f",
__LINE__, 4.251238996137952e-05,	"4.25124E-05", "%3G",
__LINE__, 4.262432542017438e+13,	"42624325420174.375978", "%1f",
__LINE__, 4.266383084300715e+16,	"4E+16", "%4.G",
__LINE__, 4.292963398931474e-11,	"4.292963E-11", "%E",
__LINE__, 4.296530271399131e-29,	"0.000000", "%6f",
__LINE__, 4.303753949741171e+19,	"4.30375E+19", "%2G",
__LINE__, 4.303767633827431e-28,	"4.30377e-28", "%g",
__LINE__, 4.316181911403991e-30,	"4.3162e-30", "%#7.5g",
__LINE__, 4.318654697213126e-18,	"4.31865e-18", "%g",
__LINE__, 4.320618603119499e+05,	"432061.860312", "%3f",
__LINE__, 4.322443609118441e+21,	"4.32244E+21", "%7.5E",
__LINE__, 4.322522446810708e-15,	"4.32252e-15", "%.6g",
__LINE__, 4.334728493589115e-18,	"0.000000", "%f",
__LINE__, 4.335342531476346e-19,	"4.33534E-19", "%G",
__LINE__, 4.340579325084176e-30,	"4.34058e-30", "%#0.6g",
__LINE__, 4.340775659883185e+04,	"43407.756599", "%6f",
__LINE__, 4.361131891528634e-14,	" 4E-14", "%6.G",
__LINE__, 4.366662624371249e-02,	"+0.04", "%+4.g",
__LINE__, 4.369919308458348e+28,	"+4.36992e+28", "%+2g",
__LINE__, 4.369930393192433e-24,	"4.369930e-24", "%e",
__LINE__, 4.376283118322521e-01,	"0.437628", "%g",
__LINE__, 4.386868840825930e+19,	"4.3869E+19", "%.5G",
__LINE__, 4.389349113395235e+05,	"+4.389349e+05", "%+e",
__LINE__, 4.392447466753053e-08,	"+4.392E-08", "%+.4G",
__LINE__, 4.394068619246889e-13,	"4.39407e-13", "%6g",
__LINE__, 4.404889573700147e-09,	"4.404890E-09", "%E",
__LINE__, 4.410531039373014e+05,	"+4.41e+05", "%+.2e",
__LINE__, 4.412466606726400e-08,	"   0.0", "%6.1f",
__LINE__, 4.414693719279123e+17,	"4.414694e+17", "%e",
__LINE__, 4.417050329080679e-01,	"+0.441705", "%+g",
__LINE__, 4.419509841929196e-10,	"4.4195098E-10", "%.7E",
__LINE__, 4.421012777695611e+07,	"+4.42101E+07", "%+0.6G",
__LINE__, 4.426387732151208e+11,	"4.42639e+11", "%g",
__LINE__, 4.439567017550398e+26,	"4.439567E+26", "%E",
__LINE__, 4.446479816166258e-21,	"4.446480e-21", "%0e",
__LINE__, 4.453486178424380e+05,	"445348.617842", "%f",
__LINE__, 4.455733696043438e+06,	"4.45573e+06", "%3g",
__LINE__, 4.455870606312063e+16,	"4.45587e+16", "%g",
__LINE__, 4.458776435431700e+22,	"4e+22", "%1.g",
__LINE__, 4.466448605584151e-30,	"0.000000", "%f",
__LINE__, 4.471063097005706e+16,	"4.47106E+16", "%G",
__LINE__, 4.482001890035190e-22,	"+4.482E-22", "%+G",
__LINE__, 4.493246870093631e+05,	"449325", "%1G",
__LINE__, 4.496089639281023e+17,	"4.49609e+17", "%g",
__LINE__, 4.515066070117557e+15,	"4.51507e+15", "%g",
__LINE__, 4.518296460916194e+24,	"+4.5183E+24", "%+G",
__LINE__, 4.526548719445596e+02,	"452.655", "%6.3f",
__LINE__, 4.532756455106440e-26,	"4.53e-26", "%4.2e",
__LINE__, 4.534466782633055e-14,	"4.53447E-14", "%G",
__LINE__, 4.541313061854649e-14,	"4.54131E-14", "%G",
__LINE__, 4.541848265404338e+02,	"  5E+02", "%7.G",
__LINE__, 4.546603085406363e-26,	"5E-26", "%3.G",
__LINE__, 4.557349604829375e+28,	"+45573496048293753446500886639.", "%+#1.f",
__LINE__, 4.560736449944898e-27,	"4.56074e-27", "%g",
__LINE__, 4.563726230559341e-15,	"+0.0", "%+2.1f",
__LINE__, 4.572650965532532e-26,	"+5E-26", "%+4.G",
__LINE__, 4.574369572115099e-10,	"+0.000000", "%+2.6f",
__LINE__, 4.576480601519729e+28,	"+4.576481e+28", "%+e",
__LINE__, 4.587487640650499e+02,	"+458.75", "%+3.2f",
__LINE__, 4.598365231538559e-27,	"4.59837E-27", "%G",
__LINE__, 4.599348244725009e-28,	"+4.5993482e-28", "%+#3.7e",
__LINE__, 4.599897524047587e+22,	"45998975240475870052136.997401", "%#f",
__LINE__, 4.605415604725077e-25,	"0.000000", "%f",
__LINE__, 4.613055015797716e+28,	"4.613055E+28", "%E",
__LINE__, 4.618715275814238e-10,	"4.618715E-10", "%E",
__LINE__, 4.619044579489540e-14,	"0.00", "%.2f",
__LINE__, 4.633693310095410e-20,	"+0.000000", "%+f",
__LINE__, 4.648505395281916e-28,	"0.000000", "%f",
__LINE__, 4.651232770446398e+21,	"4.65e+21", "%.2e",
__LINE__, 4.659743589975352e+28,	"+4.65974e+28", "%+g",
__LINE__, 4.660181457075208e-13,	"4.66018e-13", "%g",
__LINE__, 4.669787018529686e+20,	"4.66979e+20", "%g",
__LINE__, 4.672649286126732e-21,	"4.6726E-21", "%4.5G",
__LINE__, 4.675431901120643e-11,	"  0", "%3.f",
__LINE__, 4.684404068169945e+26,	"468440406816994503458317922.2", "%6.1f",
__LINE__, 4.685438834234642e+19,	"5.E+19", "%#6.G",
__LINE__, 4.688915890732712e+00,	"+5e+00", "%+2.e",
__LINE__, 4.692999432046297e+00,	"4.692999E+00", "%E",
__LINE__, 4.708690772584701e+11,	"4.70869e+11", "%g",
__LINE__, 4.711821455782105e-11,	"+4.71182e-11", "%+1g",
__LINE__, 4.712413965116830e-01,	"4.712414E-01", "%E",
__LINE__, 4.719504715401049e-08,	"0.000000", "%f",
__LINE__, 4.719767896031655e+27,	"4.71977e+27", "%#g",
__LINE__, 4.722493017411588e-05,	"0.000047", "%4f",
__LINE__, 4.729482386761477e+08,	"4.72948e+08", "%1g",
__LINE__, 4.730102169800602e-06,	"0.000005", "%f",
__LINE__, 4.743951614209393e+24,	"4.743952E+24", "%#E",
__LINE__, 4.746077075605921e-16,	"4.746E-16", "%.3E",
__LINE__, 4.747802537919248e+24,	"4747802537919247889419694", "%4.f",
__LINE__, 4.754727690703025e-26,	"0", "%0.f",
__LINE__, 4.756952432926979e-29,	" 0.", "%#3.f",
__LINE__, 4.758335147956709e+03,	"4758.335148", "%f",
__LINE__, 4.760141880810268e-25,	"4.760142e-25", "%e",
__LINE__, 4.767079423650815e-07,	"5.E-07", "%#0.G",
__LINE__, 4.785662728343338e-28,	"4.78566e-28", "%g",
__LINE__, 4.787146245774150e-13,	"+4.78715E-13", "%+G",
__LINE__, 4.787415449888824e-17,	"4.78742e-17", "%3g",
__LINE__, 4.794589807429657e-05,	"4.79459E-05", "%6G",
__LINE__, 4.794948299666205e+08,	"4.79495e+08", "%g",
__LINE__, 4.802292865915992e-04,	"4.802293e-04", "%e",
__LINE__, 4.802513688198601e+07,	"+4.8e+07", "%+2.3g",
__LINE__, 4.810456746192536e+06,	"5E+06", "%0.0G",
__LINE__, 4.820631660081696e+20,	"+4.82063E+20", "%+G",
__LINE__, 4.827865857270075e-20,	"4.82787e-20", "%g",
__LINE__, 4.835054268490970e+21,	"4835054268490970308391.752042", "%#f",
__LINE__, 4.838136770808465e-18,	"4.83814E-18", "%G",
__LINE__, 4.839342397882353e-26,	"4.839342E-26", "%E",
__LINE__, 4.845130210072029e-16,	"0", "%1.f",
__LINE__, 4.845161043167169e-12,	"+4.845e-12", "%+.4g",
__LINE__, 4.857425142494964e+01,	"48.574251", "%f",
__LINE__, 4.858118337285513e-10,	"+4.8581e-10", "%+.5g",
__LINE__, 4.867478343525339e-15,	"+4.867478E-15", "%+E",
__LINE__, 4.886137001331278e-11,	"0.000000", "%f",
__LINE__, 4.886835850687998e-20,	"     0", "%6.0f",
__LINE__, 4.886880737482383e+26,	"488688073748238327453918827.814050", "%4f",
__LINE__, 4.888812049144075e-22,	"4.888812E-22", "%E",
__LINE__, 4.895869618002905e+02,	"+489.587", "%+.7g",
__LINE__, 4.902046593298549e+09,	"  5e+09", "%7.g",
__LINE__, 4.907918627564751e-05,	"4.91e-05", "%.3g",
__LINE__, 4.916048355579009e+19,	"49160483555790088772", "%2.f",
__LINE__, 4.917197806128638e+14,	"+5e+14", "%+5.g",
__LINE__, 4.918303274189911e+13,	"4.918303e+13", "%e",
__LINE__, 4.922687970321108e+26,	"492268797032110771993984599.2485", "%0.4f",
__LINE__, 4.929263362431195e+14,	"4.92926e+14", "%g",
__LINE__, 4.933385398543267e-17,	"0.000000", "%#f",
__LINE__, 4.942367126455025e+00,	"    +5", "%+6.f",
__LINE__, 4.947687486717652e-04,	"0.000495", "%.6f",
__LINE__, 4.960855200003128e-08,	"+4.960855e-08", "%+e",
__LINE__, 4.968485435774085e-21,	"0.0000", "%#2.4f",
__LINE__, 4.972088381506133e+01,	"49.7", "%.1f",
__LINE__, 4.977561524480392e-15,	"4.977562E-15", "%7E",
__LINE__, 4.984592111249502e-13,	"5.0e-13", "%.1e",
__LINE__, 4.997502335602838e-14,	"4.998e-14", "%6.4g",
__LINE__, 5.001731554335935e-09,	"5.00173e-09", "%g",
__LINE__, 5.006231697107042e-17,	"5.0062e-17", "%1.5g",
__LINE__, 5.008035801093423e+24,	"5.008036E+24", "%#E",
__LINE__, 5.008756965733827e-28,	"5.009E-28", "%.4G",
__LINE__, 5.009774027622812e+20,	"+5.00977E+20", "%+G",
__LINE__, 5.010576312346293e+29,	"5.01058E+29", "%G",
__LINE__, 5.012335250996786e+29,	"5.012335e+29", "%.7g",
__LINE__, 5.012404365186907e+20,	"5E+20", "%3.2G",
__LINE__, 5.024670103250229e-01,	"+5.024670E-01", "%+E",
__LINE__, 5.025765369164560e+03,	"5025.77", "%g",
__LINE__, 5.027173841003918e+11,	"+5.02717E+11", "%+G",
__LINE__, 5.032093817639893e-26,	"5e-26", "%3.e",
__LINE__, 5.039636818525848e-02,	"0.050396", "%#f",
__LINE__, 5.040626671307691e+23,	"5.040627E+23", "%E",
__LINE__, 5.040788233368296e-11,	"+5.04079e-11", "%+g",
__LINE__, 5.040903321336150e-28,	"5.0409E-28", "%G",
__LINE__, 5.042078512958994e+12,	"5.04208E+12", "%G",
__LINE__, 5.045957900223303e+15,	"5045957900223303", "%0.f",
__LINE__, 5.048298764352134e-14,	"5.048299e-14", "%1e",
__LINE__, 5.048827326763192e+28,	"50488273267631917917697137454.524636", "%f",
__LINE__, 5.049714558347361e-23,	"5e-23", "%5.0g",
__LINE__, 5.051509904923853e+16,	"50515099049238534", "%5.f",
__LINE__, 5.052789863743305e-10,	"5.05279E-10", "%6G",
__LINE__, 5.057429728861999e-29,	"0.000", "%#1.3f",
__LINE__, 5.075313093968501e-13,	"+5.07531e-13", "%+g",
__LINE__, 5.075874503501582e+29,	"5e+29", "%2.e",
__LINE__, 5.079468079020803e+01,	"50.795", "%.5G",
__LINE__, 5.086214826494080e-28,	" 0.0", "%4.1f",
__LINE__, 5.096054881114421e+13,	"5.096e+13", "%.4g",
__LINE__, 5.099045274853458e-23,	"5.09905E-23", "%0G",
__LINE__, 5.100248195124433e+00,	"5.100248", "%f",
__LINE__, 5.101016114276598e-20,	"5e-20", "%4.1g",
__LINE__, 5.103213528670269e+07,	"51032135.286703", "%6f",
__LINE__, 5.108373625126768e+08,	"+510837362.512677", "%+f",
__LINE__, 5.113097157183416e+07,	"5.1131E+07", "%#.4E",
__LINE__, 5.114452611789777e+08,	"+5.11445E+08", "%+G",
__LINE__, 5.117099184715288e-16,	"5.1171E-16", "%G",
__LINE__, 5.119910534665511e-13,	"+5.11991E-13", "%+G",
__LINE__, 5.121320931953720e+23,	"+5.121321e+23", "%+#e",
__LINE__, 5.121900318443998e+06,	"5.121900e+06", "%e",
__LINE__, 5.135698679084286e+00,	"5.1357", "%2g",
__LINE__, 5.146355903104154e-10,	"+5.14636E-10", "%+.6G",
__LINE__, 5.148754210958986e-24,	"+5.148754e-24", "%+e",
__LINE__, 5.156238368448428e+26,	"5e+26", "%5.g",
__LINE__, 5.159924520667922e-19,	"+5E-19", "%+0.1G",
__LINE__, 5.159938266135425e-27,	"0.000000", "%f",
__LINE__, 5.165915205175676e-01,	"5.165915e-01", "%e",
__LINE__, 5.190205499401547e-11,	"5e-11", "%2.1g",
__LINE__, 5.193260005542003e+26,	"5.19326e+26", "%#g",
__LINE__, 5.194732077318269e+08,	"519473207.731827", "%f",
__LINE__, 5.196394616633798e-19,	"0", "%.0f",
__LINE__, 5.206753628035638e+19,	"5.20675e+19", "%6.6g",
__LINE__, 5.207364136540851e-23,	" 0.000", "%6.3f",
__LINE__, 5.210672737132108e-09,	"5.21067E-09", "%G",
__LINE__, 5.211423933057123e-20,	"+5.21142E-20", "%+G",
__LINE__, 5.219749528363367e-27,	"5.219750e-27", "%e",
__LINE__, 5.228031587478653e-06,	"+5.2E-06", "%+3.1E",
__LINE__, 5.229303095005359e-25,	"+0.000000", "%+#f",
__LINE__, 5.234703511938320e-06,	"      0", "%7.f",
__LINE__, 5.235655046937822e-20,	"5.235655E-20", "%.6E",
__LINE__, 5.237924986002288e-01,	"+0.52379", "%+.5f",
__LINE__, 5.249148093603826e+20,	"5.24915E+20", "%0G",
__LINE__, 5.262680920244596e+16,	"5.26268E+16", "%G",
__LINE__, 5.267944704715845e-06,	"5.e-06", "%#3.g",
__LINE__, 5.268543533730505e-08,	"5.26854E-08", "%G",
__LINE__, 5.275727269515247e-02,	"0.0527573", "%.6g",
__LINE__, 5.279215316873723e+24,	"5279215316873722585455652.733799", "%f",
__LINE__, 5.284326985680811e+16,	"52843269856808108.286828", "%6f",
__LINE__, 5.286192957344040e-10,	"5.3E-10", "%.1E",
__LINE__, 5.289451976001091e-23,	"5.28945E-23", "%G",
__LINE__, 5.289512908209300e+09,	"+5.289513e+09", "%+e",
__LINE__, 5.295696957972123e+11,	"5.296E+11", "%#.3E",
__LINE__, 5.303584684011050e+16,	"53035846840110503.208621", "%f",
__LINE__, 5.310315581980172e+23,	"531031558198017172855998", "%4.f",
__LINE__, 5.317492728410062e-14,	"5.31749e-14", "%7g",
__LINE__, 5.324506949499409e+18,	"5.3245E+18", "%.5G",
__LINE__, 5.329238068668336e-20,	"5e-20", "%4.g",
__LINE__, 5.336050125161774e+14,	"5.33605e+14", "%g",
__LINE__, 5.349921315003169e-17,	"5.34992E-17", "%.6G",
__LINE__, 5.355648481782587e-20,	"5.355648e-20", "%e",
__LINE__, 5.358945557589489e-26,	"+5e-26", "%+0.g",
__LINE__, 5.359638846465574e+21,	"5.359639E+21", "%E",
__LINE__, 5.377048469393900e+14,	"5.377E+14", "%.5G",
__LINE__, 5.387471194156434e+23,	"5.387471E+23", "%.7G",
__LINE__, 5.401622578962497e-03,	"+0.0054", "%+5.2g",
__LINE__, 5.406882732497444e-16,	"5.406883E-16", "%E",
__LINE__, 5.421474560523198e-11,	"+5.42147e-11", "%+g",
__LINE__, 5.440249323479418e-26,	"5.44025E-26", "%7G",
__LINE__, 5.440922682921101e-05,	"5e-05", "%.1g",
__LINE__, 5.444400103673185e-01,	"0.54444", "%G",
__LINE__, 5.449339470916152e+09,	"5449339470.9162", "%.4f",
__LINE__, 5.451583259558706e-15,	"5.e-15", "%#4.e",
__LINE__, 5.460153018660573e+26,	"+546015301866057267687892817.775719", "%+f",
__LINE__, 5.477591210511918e+08,	"+5.47759E+08", "%+0.5E",
__LINE__, 5.481665401407188e-02,	"5.481665e-02", "%e",
__LINE__, 5.482670784411319e-16,	"5E-16", "%4.G",
__LINE__, 5.487494580636099e+12,	"5.48749e+12", "%g",
__LINE__, 5.508630369473937e-10,	"5.508630e-10", "%e",
__LINE__, 5.528898001438273e+20,	"6e+20", "%4.g",
__LINE__, 5.530331734443152e-24,	" 6e-24", "%6.g",
__LINE__, 5.531704398969656e-24,	"0.000000", "%f",
__LINE__, 5.539906569043238e+05,	"+553990.656904", "%+f",
__LINE__, 5.554571854756323e-08,	"+0.00000", "%+4.5f",
__LINE__, 5.555155069925145e-28,	"5.55516e-28", "%g",
__LINE__, 5.555302705075539e-08,	"+5.5553e-08", "%+g",
__LINE__, 5.563805076159055e-05,	"5.563805e-05", "%e",
__LINE__, 5.565063508995002e+07,	"5.565E+07", "%.3E",
__LINE__, 5.566281664807526e-08,	"5.56628E-08", "%G",
__LINE__, 5.575245679736338e-08,	"5.575246e-08", "%e",
__LINE__, 5.578254777281501e-21,	"0.", "%#.0f",
__LINE__, 5.582389275770848e-01,	"  0.6", "%5.G",
__LINE__, 5.592215029176133e-04,	"0.00056", "%.2g",
__LINE__, 5.593536789867047e-25,	"5.59354e-25", "%g",
__LINE__, 5.605652054074862e-03,	"   0.006", "%8.G",
__LINE__, 5.606982382643258e+20,	"+5.60698E+20", "%+G",
__LINE__, 5.614646821116853e-18,	"5.6E-18", "%.2G",
__LINE__, 5.625586848606565e-11,	"+5.62559E-11", "%+G",
__LINE__, 5.626300428046732e+26,	"  6e+26", "%7.g",
__LINE__, 5.638236626881086e-17,	" 6E-17", "%6.G",
__LINE__, 5.645744817075691e+04,	"5.645745E+04", "%E",
__LINE__, 5.651410004691736e+06,	"6.E+06", "%#3.E",
__LINE__, 5.659582345929256e-11,	"+0.000000", "%+f",
__LINE__, 5.670968861413510e+16,	"+5.67097E+16", "%+G",
__LINE__, 5.672476851235796e+01,	"+56.724769", "%+0f",
__LINE__, 5.674563779921248e+28,	" 6E+28", "%6.0G",
__LINE__, 5.675558529939025e+19,	"5.67556e+19", "%3g",
__LINE__, 5.676326888314589e-08,	"  6e-08", "%7.g",
__LINE__, 5.677928507840897e-30,	"5.67793e-30", "%0g",
__LINE__, 5.686622552402630e-15,	"5.69E-15", "%1.3G",
__LINE__, 5.710441686922142e-14,	"5.710442E-14", "%E",
__LINE__, 5.713234603280163e-21,	"0.00000", "%0.5f",
__LINE__, 5.714968959046963e+12,	"5.71497e+12", "%g",
__LINE__, 5.722025141555638e-23,	"5.72e-23", "%.2e",
__LINE__, 5.725398571007033e-09,	"5.7254E-09", "%.6G",
__LINE__, 5.751604813862738e+18,	"6E+18", "%.1G",
__LINE__, 5.761025444751985e+20,	"5.76103e+20", "%g",
__LINE__, 5.762315767948593e+15,	"5.76232e+15", "%4g",
__LINE__, 5.764528858586032e-15,	"5.764529E-15", "%6.7G",
__LINE__, 5.766408541535810e-07,	" 6E-07", "%6.1G",
__LINE__, 5.771831571087174e-01,	"0.577183", "%f",
__LINE__, 5.790102497364865e-15,	"+5.790102e-15", "%+e",
__LINE__, 5.790222335547785e-08,	"5.79022e-08", "%0.6g",
__LINE__, 5.794082127091130e+21,	"5794082127091130018925.468903", "%f",
__LINE__, 5.804568463644165e+28,	"5.80457e+28", "%g",
__LINE__, 5.827356651901066e+20,	"582735665190106555400.006982", "%f",
__LINE__, 5.837553387436408e+18,	"5.837553E+18", "%3E",
__LINE__, 5.844458110907209e+22,	"5.84446e+22", "%g",
__LINE__, 5.851672125746866e-19,	"5.85167e-19", "%g",
__LINE__, 5.868843476784172e-12,	"5.868843e-12", "%1.7g",
__LINE__, 5.870854146748864e-04,	"0.000587", "%2.3g",
__LINE__, 5.877787821470433e+01,	"+58.77788", "%+#3.5f",
__LINE__, 5.881333514866498e+04,	"5.881334E+04", "%E",
__LINE__, 5.908427816128965e+28,	"+5.908428E+28", "%+E",
__LINE__, 5.918139800007388e+07,	"59181398.000074", "%f",
__LINE__, 5.925587467475260e+21,	"5925587467475259551008.548442", "%f",
__LINE__, 5.930403502679683e-22,	"5.9304E-22", "%.6G",
__LINE__, 5.961572644847521e+02,	"+596.157", "%+G",
__LINE__, 5.968917715225198e-21,	"5.96892e-21", "%4g",
__LINE__, 5.982184454670110e-08,	"0", "%0.f",
__LINE__, 5.988414319040855e+09,	"6E+09", "%0.G",
__LINE__, 5.996263783103995e-10,	"5.996264e-10", "%e",
__LINE__, 6.004634162276014e-18,	"6.00463e-18", "%g",
__LINE__, 6.018734975519166e-08,	"6.01873E-08", "%G",
__LINE__, 6.029071822986717e-14,	"0.0000000", "%.7f",
__LINE__, 6.030392278117406e+23,	"6.030392e+23", "%e",
__LINE__, 6.034553399237175e-27,	"+6.03455e-27", "%+g",
__LINE__, 6.034938873443862e+24,	"6034938873443861595546877.651941", "%f",
__LINE__, 6.038929148003457e-16,	"6.03893e-16", "%g",
__LINE__, 6.039149626573702e-13,	"6.0391E-13", "%3.5G",
__LINE__, 6.041247664739301e+29,	"6.041248E+29", "%3E",
__LINE__, 6.044220746789781e+20,	"+6.04422e+20", "%+g",
__LINE__, 6.045775647107433e+19,	"6E+19", "%2.G",
__LINE__, 6.051917010461611e-05,	"6.05192E-05", "%G",
__LINE__, 6.059773181566425e+17,	"+605977318156642486", "%+5.f",
__LINE__, 6.082239575475813e+01,	"+6E+01", "%+.1G",
__LINE__, 6.093984174629151e+18,	"6.093984e+18", "%e",
__LINE__, 6.102368380479137e+22,	"6.1E+22", "%.2G",
__LINE__, 6.103097446204007e+25,	"61030974462040070704915706.301108", "%#0f",
__LINE__, 6.105244994410556e-24,	"0.0000000", "%2.7f",
__LINE__, 6.110828906801633e-14,	"+6.110829e-14", "%+3e",
__LINE__, 6.124439072468681e-30,	"6.12444e-30", "%g",
__LINE__, 6.127714703273447e-15,	"0", "%0.f",
__LINE__, 6.128539582408870e-15,	"6.12854e-15", "%g",
__LINE__, 6.145470264744349e+24,	"6145470264744348654062378.045637", "%f",
__LINE__, 6.159177701667455e+26,	"615917770166745537352426254.074089", "%#f",
__LINE__, 6.159348213337442e+17,	"6.15935e+17", "%g",
__LINE__, 6.161953891020492e-21,	"0.000000", "%f",
__LINE__, 6.169474192777305e+29,	"+6.169E+29", "%+.4G",
__LINE__, 6.198519761010651e-15,	"+0", "%+1.f",
__LINE__, 6.201381824304919e-27,	"    0", "%5.f",
__LINE__, 6.204387065736372e-18,	"6.204387E-18", "%7E",
__LINE__, 6.209270088144063e-24,	"0.000000", "%f",
__LINE__, 6.209871738353546e-20,	"6.20987E-20", "%G",
__LINE__, 6.222733191871026e+14,	"+6.22273e+14", "%+g",
__LINE__, 6.234670085354310e+04,	"+62346.700854", "%+f",
__LINE__, 6.258389346602224e-09,	"6E-09", "%.0G",
__LINE__, 6.263326582587503e+12,	"6263326582588.", "%#5.f",
__LINE__, 6.272768026763922e+03,	"+6272.77", "%+g",
__LINE__, 6.287747868625765e+00,	"6E+00", "%.0E",
__LINE__, 6.297724027388795e-17,	"+6E-17", "%+3.G",
__LINE__, 6.309940679156400e+27,	"6.30994e+27", "%6.5e",
__LINE__, 6.312960327030170e+06,	"+6.312960E+06", "%+E",
__LINE__, 6.317658179632976e+02,	"+631.766", "%+g",
__LINE__, 6.321255960699571e-27,	"0.000000", "%f",
__LINE__, 6.323069932833900e+03,	"6323", "%.4G",
__LINE__, 6.337027835933034e+21,	"6.33703e+21", "%#g",
__LINE__, 6.343583177899838e-03,	"0.00634358", "%7G",
__LINE__, 6.347464241733904e-03,	"6.e-03", "%#0.e",
__LINE__, 6.352038720353924e+07,	"63520387.203539", "%f",
__LINE__, 6.355292378565109e+23,	"+635529237856510942350496.407016", "%+f",
__LINE__, 6.377901944439164e-29,	"0.000", "%2.3f",
__LINE__, 6.378660255554053e-04,	"6.37866E-04", "%.5E",
__LINE__, 6.382838195255167e-18,	"0.000000", "%f",
__LINE__, 6.391046303581911e+22,	"6E+22", "%.0G",
__LINE__, 6.404812348309621e+22,	"6.404812E+22", "%.7G",
__LINE__, 6.406154091357119e+16,	"6.40615E+16", "%G",
__LINE__, 6.419414726557980e+21,	"+6.41941e+21", "%+g",
__LINE__, 6.432166563008504e+10,	" +6e+10", "%+7.g",
__LINE__, 6.438463704193190e+19,	"6.438464e+19", "%e",
__LINE__, 6.445270237908565e+15,	"+6.445270E+15", "%+E",
__LINE__, 6.445536770502964e+09,	"6.446e+09", "%.3e",
__LINE__, 6.446614224811444e+28,	"64466142248114444157636171439.662576", "%f",
__LINE__, 6.457046289718297e+18,	"6457046289718297416.015957", "%4f",
__LINE__, 6.457682856890173e+01,	"6.457683E+01", "%2E",
__LINE__, 6.471026352792729e-16,	"+6.47103e-16", "%+g",
__LINE__, 6.474527749567342e+19,	"6E+19", "%.1G",
__LINE__, 6.481178401781131e-24,	"+6.48E-24", "%+6.3G",
__LINE__, 6.490736647261461e-15,	"+6.49074e-15", "%+g",
__LINE__, 6.493196535069719e+23,	"+6.4932E+23", "%+G",
__LINE__, 6.500296992935538e-20,	"+0.0", "%+.1f",
__LINE__, 6.502867735895890e-19,	"+0.000000", "%+6f",
__LINE__, 6.506627529164683e+14,	"650662752916468", "%5.f",
__LINE__, 6.511909298966434e-15,	"+6.51191E-15", "%+G",
__LINE__, 6.514463062693312e+01,	"65.1446", "%G",
__LINE__, 6.520721469484543e+16,	"6.52072E+16", "%G",
__LINE__, 6.528064508731680e-05,	"6.528065E-05", "%7E",
__LINE__, 6.529007214194039e-24,	"0.000000", "%f",
__LINE__, 6.537822760557410e-23,	"0.000000", "%f",
__LINE__, 6.552222096390805e+29,	"+6.55222E+29", "%+G",
__LINE__, 6.554569862717104e+12,	"6.55457E+12", "%G",
__LINE__, 6.563440840359989e-30,	"7E-30", "%4.G",
__LINE__, 6.586246985535526e+17,	"6.58625E+17", "%#4G",
__LINE__, 6.593339522442827e+16,	"6.6E+16", "%#4.1E",
__LINE__, 6.611179030024350e+02,	"7E+02", "%4.E",
__LINE__, 6.617541638586767e-10,	"6.617542E-10", "%E",
__LINE__, 6.619147920886991e-28,	"7e-28", "%.1g",
__LINE__, 6.622304444772819e-21,	"6.62230E-21", "%#4G",
__LINE__, 6.634766655157910e+12,	"6634766655158", "%2.f",
__LINE__, 6.635639771921218e+25,	"+6.63564E+25", "%+G",
__LINE__, 6.644575305929087e+17,	"+6.64458e+17", "%+g",
__LINE__, 6.648697591328432e+04,	"6.648698E+04", "%3E",
__LINE__, 6.665426012448100e+09,	"6.66543E+09", "%G",
__LINE__, 6.675222780441723e-23,	"6.67522e-23", "%1g",
__LINE__, 6.689765053880623e+00,	"6.6898", "%.5g",
__LINE__, 6.693874943680238e+25,	"7.e+25", "%#1.g",
__LINE__, 6.695033453546435e+19,	"6.695033E+19", "%E",
__LINE__, 6.720131534244976e+03,	"+6720.132", "%+.3f",
__LINE__, 6.725287004784564e+19,	"+6.72529e+19", "%+g",
__LINE__, 6.743599626906313e-18,	"0.0000000", "%7.7f",
__LINE__, 6.755534260704152e+29,	"7.e+29", "%#5.e",
__LINE__, 6.761855244766418e-18,	"6.8E-18", "%.2G",
__LINE__, 6.764974143681080e-02,	"6.765E-02", "%2.3E",
__LINE__, 6.766924477711975e-17,	"0.000000", "%4f",
__LINE__, 6.772195434106330e-19,	"6.7722E-19", "%G",
__LINE__, 6.779433073319225e-23,	"0.00", "%.2f",
__LINE__, 6.790317710068964e+05,	"6.8e+05", "%.1e",
__LINE__, 6.791378160292960e+02,	"679.137816", "%f",
__LINE__, 6.798381262104190e-27,	"0.000000", "%f",
__LINE__, 6.804165939424860e-14,	"7e-14", "%4.g",
__LINE__, 6.810668670623699e+11,	"681066867062.369852", "%f",
__LINE__, 6.838942637635821e-17,	"+6.84e-17", "%+.2e",
__LINE__, 6.868523988329111e-09,	"+6.868524e-09", "%+e",
__LINE__, 6.873228061403223e-15,	"6.873228E-15", "%3E",
__LINE__, 6.879370500093334e-12,	"+0.000000", "%+f",
__LINE__, 6.891525498686674e-10,	"7e-10", "%0.g",
__LINE__, 6.923027319286220e+21,	"7.e+21", "%#1.g",
__LINE__, 6.923565533024560e-11,	"+6.92357e-11", "%+g",
__LINE__, 6.931415640770737e-24,	"+6.93142e-24", "%+g",
__LINE__, 6.936582619246057e+09,	"6.936583e+09", "%7e",
__LINE__, 6.938661496670582e+05,	"693866.1496671", "%2.7f",
__LINE__, 6.946115378286550e-25,	"0.000000", "%f",
__LINE__, 6.955823211921219e-09,	"6.95582e-09", "%g",
__LINE__, 6.962365243425770e+29,	"696236524342577034474288666388.019919", "%7f",
__LINE__, 6.970432274812882e+05,	"+7e+05", "%+1.0e",
__LINE__, 6.975784942897122e-13,	"6.975785e-13", "%e",
__LINE__, 6.976786489904214e-07,	"6.97679E-07", "%3G",
__LINE__, 6.985245976357042e-05,	"0.00", "%.2f",
__LINE__, 6.993402879410720e-21,	"6.9934e-21", "%g",
__LINE__, 7.012183985341519e+28,	"+70121839853415188770213717362", "%+2.f",
__LINE__, 7.028670648856025e-15,	"7.028671e-15", "%.7g",
__LINE__, 7.034042985683665e-03,	" 0", "%2.f",
__LINE__, 7.044054273278726e+18,	"7.044e+18", "%7.4g",
__LINE__, 7.049706744250734e-06,	"7E-06", "%0.E",
__LINE__, 7.061982657056197e+13,	"+7.061983e+13", "%+e",
__LINE__, 7.066873668945899e+21,	"7.06687E+21", "%G",
__LINE__, 7.087941418633258e+26,	"7.08794E+26", "%G",
__LINE__, 7.108268134631547e+22,	"7.108268E+22", "%E",
__LINE__, 7.112095848565475e-19,	"7.1121e-19", "%g",
__LINE__, 7.116326241291862e+16,	"7.116326e+16", "%e",
__LINE__, 7.118854843597607e-22,	"0.000000", "%f",
__LINE__, 7.121423043456375e-27,	"0.000000", "%f",
__LINE__, 7.131415427096460e-03,	"0.007131", "%3f",
__LINE__, 7.132023279679892e+22,	"7.e+22", "%#3.e",
__LINE__, 7.146250280189992e-18,	"0.000000", "%f",
__LINE__, 7.150059058390724e+03,	"7150.06", "%g",
__LINE__, 7.161081578177381e-02,	"+0.0716108", "%+G",
__LINE__, 7.164935125149336e-27,	"7.2E-27", "%#6.2G",
__LINE__, 7.173125717489549e-10,	"7.173126e-10", "%e",
__LINE__, 7.174199549624193e+00,	"7.1741995", "%.7f",
__LINE__, 7.192493588077649e+27,	"7.19249e+27", "%g",
__LINE__, 7.215209568601445e-06,	"7.215210e-06", "%e",
__LINE__, 7.238322284100497e+03,	"7238.3", "%.1f",
__LINE__, 7.239203871123613e+06,	"7239204", "%4.f",
__LINE__, 7.245809072577019e-09,	"+7.245809E-09", "%+E",
__LINE__, 7.256275686433336e+03,	"7.256276e+03", "%e",
__LINE__, 7.265774291605193e+27,	"+7.26577E+27", "%+G",
__LINE__, 7.287968172227119e-21,	"+7.287968e-21", "%+e",
__LINE__, 7.306020169678527e+12,	"7E+12", "%2.E",
__LINE__, 7.315587463572568e-04,	"0.", "%#.0f",
__LINE__, 7.324627764547963e+09,	"7.324628E+09", "%#E",
__LINE__, 7.331904966719081e-06,	"+7.3319E-06", "%+G",
__LINE__, 7.334448152798243e-02,	"0.07", "%0.g",
__LINE__, 7.334487195961240e-01,	"+0.733449", "%+#g",
__LINE__, 7.381283575515707e+13,	"7.381284E+13", "%E",
__LINE__, 7.394854567245476e-11,	"0.000000", "%7f",
__LINE__, 7.401950211415377e-08,	" 7e-08", "%6.e",
__LINE__, 7.409023867864680e+03,	"7409.023868", "%#3f",
__LINE__, 7.411912956257733e-20,	"7e-20", "%0.g",
__LINE__, 7.445275019272160e+11,	"744527501927.2159511", "%.7f",
__LINE__, 7.450279765616891e-16,	"7.45028e-16", "%.6g",
__LINE__, 7.467047411334495e+14,	"7.46705E+14", "%G",
__LINE__, 7.485628870972725e+28,	"7E+28", "%.0G",
__LINE__, 7.495391782588563e+11,	"749539178258.856253", "%f",
__LINE__, 7.495824101611911e+06,	"7.49582e+06", "%.6g",
__LINE__, 7.499759867592402e+20,	"+749975986759240154100.3", "%+.1f",
__LINE__, 7.508983397140368e+04,	"75089.8", "%g",
__LINE__, 7.512585199581016e-27,	"7.512585E-27", "%.6E",
__LINE__, 7.516831372212545e-29,	"+7.516831e-29", "%+e",
__LINE__, 7.525789465978582e+00,	"7.52579", "%G",
__LINE__, 7.528655653725963e+06,	"7.5287e+06", "%3.4e",
__LINE__, 7.533217421035612e+28,	"75332174210356122046050586504.861712", "%f",
__LINE__, 7.534147071756384e+03,	"7534.15", "%g",
__LINE__, 7.542648637430919e-25,	"+0.000000", "%+#f",
__LINE__, 7.554380140947798e-15,	"  8e-15", "%7.g",
__LINE__, 7.557366996007743e+25,	"  8E+25", "%7.G",
__LINE__, 7.579228950138068e+08,	"8e+08", "%3.e",
__LINE__, 7.579773904052487e-13,	"0.000000", "%3f",
__LINE__, 7.580377544554059e+27,	"7.58038e+27", "%#g",
__LINE__, 7.589615147875915e-15,	"7.59E-15", "%.3G",
__LINE__, 7.593317194045158e-12,	"+0.", "%+#1.f",
__LINE__, 7.605535657484387e-07,	"7.60554E-07", "%G",
__LINE__, 7.609171121278006e-08,	"    0", "%5.f",
__LINE__, 7.612033900317304e-14,	"7.61203e-14", "%g",
__LINE__, 7.628040858080326e+23,	"+7.62804e+23", "%+g",
__LINE__, 7.632109382948695e-01,	"0.763211", "%#f",
__LINE__, 7.633415922627254e+28,	"76334159226272539910951309138.908982", "%#f",
__LINE__, 7.636190400774419e+22,	"+7.636190E+22", "%+E",
__LINE__, 7.636228368661314e-23,	"0.000000", "%f",
__LINE__, 7.653292362739654e-17,	"7.65329E-17", "%#G",
__LINE__, 7.664044705231460e+03,	"7.664045E+03", "%5E",
__LINE__, 7.664257283149626e-05,	"7.66426E-05", "%0G",
__LINE__, 7.668996632821614e-19,	" 0.0", "%4.1f",
__LINE__, 7.674502669497263e-24,	"7.6745e-24", "%g",
__LINE__, 7.681870119755193e+12,	"+7.68187e+12", "%+#g",
__LINE__, 7.693453198401315e+02,	"769.3453198", "%5.7f",
__LINE__, 7.705080073293603e-29,	"7.705080E-29", "%1E",
__LINE__, 7.707244083934683e-07,	"7.71E-07", "%2.3G",
__LINE__, 7.749445584970652e-17,	"7.75E-17", "%6.3G",
__LINE__, 7.755369447889403e+09,	"7.8e+09", "%#4.2g",
__LINE__, 7.760378169707072e-06,	"7.76038e-06", "%g",
__LINE__, 7.763518882114968e-10,	"0.000000", "%f",
__LINE__, 7.764720069569677e-18,	"0.000000", "%0f",
__LINE__, 7.768821339438552e-03,	"0.00776882", "%g",
__LINE__, 7.774767835990679e-29,	"7.774768E-29", "%7E",
__LINE__, 7.805567188246987e-04,	"0.000780557", "%2G",
__LINE__, 7.825157442935941e-26,	"0.000000", "%f",
__LINE__, 7.833373563161910e+29,	"+783337356316190991378789476584.643126", "%+f",
__LINE__, 7.875872661746674e-16,	"7.875873E-16", "%E",
__LINE__, 7.880664458920439e-28,	"7.881E-28", "%#0.3E",
__LINE__, 7.893084198630288e+18,	"7893084198630288206", "%1.f",
__LINE__, 7.912222737877417e+04,	"79122.2", "%G",
__LINE__, 7.913004582748724e-26,	"0.000000", "%f",
__LINE__, 7.913749944463836e+17,	"791374994446383617.230367", "%f",
__LINE__, 7.923881665760883e-24,	"0.000000", "%f",
__LINE__, 7.926699779993694e-03,	"0.007927", "%5.6f",
__LINE__, 7.941991860623354e-20,	"7.941992e-20", "%e",
__LINE__, 7.942700358097138e+17,	"794270035809713803.587329", "%2f",
__LINE__, 7.945451569935757e-16,	"7.94545E-16", "%#4.6G",
__LINE__, 7.948277588625241e-04,	"0", "%.0f",
__LINE__, 7.952265062569124e+21,	"+7.95227e+21", "%+#g",
__LINE__, 7.959953534668040e+11,	"8e+11", "%2.e",
__LINE__, 7.962059154424500e-22,	"7.96206E-22", "%G",
__LINE__, 7.962856142535673e-26,	"7.9629E-26", "%#.5G",
__LINE__, 7.966528574505771e+12,	"7.96653e+12", "%g",
__LINE__, 8.006496880305429e-21,	"8.0065E-21", "%G",
__LINE__, 8.023374861440542e+06,	"+8023375", "%+6.f",
__LINE__, 8.041139717082990e-20,	"8.04114e-20", "%g",
__LINE__, 8.044201752824126e+15,	"8.04420E+15", "%.5E",
__LINE__, 8.044262927409321e-10,	"+8E-10", "%+2.2G",
__LINE__, 8.058285708061202e+02,	"+8.058286e+02", "%+e",
__LINE__, 8.104422320765144e+10,	"8.10442e+10", "%#4g",
__LINE__, 8.104572628022330e-11,	"0.000000", "%f",
__LINE__, 8.112156369917432e+15,	"+8.11216E+15", "%+G",
__LINE__, 8.114566569709531e-18,	"8.11457E-18", "%G",
__LINE__, 8.114795069552519e+13,	"8.114795E+13", "%E",
__LINE__, 8.121382719830660e+03,	"8121.382720", "%f",
__LINE__, 8.125179335533733e-12,	"+8.125179e-12", "%+e",
__LINE__, 8.126383949107055e+19,	"81263839491070548604.056967", "%f",
__LINE__, 8.129961701307842e-04,	"+0.00081", "%+5.2g",
__LINE__, 8.143780077390936e+15,	"8.14378E+15", "%G",
__LINE__, 8.149891507777399e+16,	"+8E+16", "%+1.G",
__LINE__, 8.167395708830107e+03,	"8167", "%3.f",
__LINE__, 8.167703619221975e+01,	"81.677", "%G",
__LINE__, 8.178463030771759e+06,	"+8.17846E+06", "%+G",
__LINE__, 8.188188531273697e+12,	"8.18819E+12", "%G",
__LINE__, 8.189094866416537e+11,	"+8E+11", "%+.1G",
__LINE__, 8.205086844365809e-18,	"+8.205087E-18", "%+#E",
__LINE__, 8.205762333408320e-26,	"0.000000", "%f",
__LINE__, 8.212370598174696e-10,	"8.2124E-10", "%.5G",
__LINE__, 8.228054316085489e-14,	"0.000000", "%3f",
__LINE__, 8.244313484402404e-16,	"8.24431e-16", "%g",
__LINE__, 8.244472235472472e+19,	"8.24447E+19", "%G",
__LINE__, 8.245421473302411e-09,	"+8.2454e-09", "%+1.5g",
__LINE__, 8.252286626634840e-22,	"8E-22", "%3.G",
__LINE__, 8.259969177912707e-19,	"0.000000", "%f",
__LINE__, 8.265769991725211e+18,	"8.26577e+18", "%.5e",
__LINE__, 8.293986939496488e+25,	"8.3E+25", "%.1E",
__LINE__, 8.310348813512608e-23,	"+8.31035e-23", "%+g",
__LINE__, 8.316951996533247e-20,	"0.000000", "%f",
__LINE__, 8.318818016883803e+05,	" 8e+05", "%6.1g",
__LINE__, 8.324896920131877e-13,	"+8.324897e-13", "%+e",
__LINE__, 8.325228630004624e-03,	"0.0083252", "%5.7f",
__LINE__, 8.332538660129034e+14,	"8.3e+14", "%5.2g",
__LINE__, 8.343325212751775e+07,	"8.34333e+07", "%#4g",
__LINE__, 8.363117398136236e+20,	"+8.36e+20", "%+.3g",
__LINE__, 8.364181324448165e+27,	"8.36418e+27", "%#g",
__LINE__, 8.372159259848738e+10,	"8.37216e+10", "%4g",
__LINE__, 8.379252006152759e-26,	"8.37925e-26", "%g",
__LINE__, 8.392670395720252e+09,	"8392670395.720252", "%f",
__LINE__, 8.423360059147756e+05,	"+842336.", "%+#G",
__LINE__, 8.425921213167943e+09,	"8.425921e+09", "%1.7g",
__LINE__, 8.431664412515776e-16,	"8.43166E-16", "%#G",
__LINE__, 8.448608859842500e+02,	"844.861", "%1.3f",
__LINE__, 8.456292247478771e-14,	"8.45629E-14", "%G",
__LINE__, 8.460077225296853e-04,	"0.000846008", "%G",
__LINE__, 8.478635925746218e-10,	"0.000000", "%f",
__LINE__, 8.492455774427448e+06,	"8.49246e+06", "%g",
__LINE__, 8.494450528380746e-07,	"8.494451e-07", "%e",
__LINE__, 8.516435842947605e-23,	"+0.000000", "%+1f",
__LINE__, 8.519057789029134e-18,	"0.000000", "%0f",
__LINE__, 8.522602111109066e+18,	" 9.e+18", "%#7.g",
__LINE__, 8.529176788022152e-24,	"8.529E-24", "%0.4G",
__LINE__, 8.534979605642793e-07,	"0.000001", "%f",
__LINE__, 8.546859563634342e-07,	"8.546860E-07", "%E",
__LINE__, 8.552370027054106e+12,	"9e+12", "%.0g",
__LINE__, 8.561781328234041e+10,	"8.56178e+10", "%4g",
__LINE__, 8.562688793145107e-20,	"8.562689e-20", "%1.7g",
__LINE__, 8.573130147270046e-07,	"  9E-07", "%7.G",
__LINE__, 8.584571984387802e-18,	"8.5846e-18", "%.5g",
__LINE__, 8.596407996491291e+11,	"8.596408E+11", "%#E",
__LINE__, 8.604843726850381e+10,	" 9E+10", "%6.G",
__LINE__, 8.626884271938994e-23,	"8.62688e-23", "%g",
__LINE__, 8.631140282429168e+24,	"8631140282429168308908629.", "%#.0f",
__LINE__, 8.635194331917948e-16,	"8.63519E-16", "%G",
__LINE__, 8.641417311588688e-24,	"+0.000000", "%+f",
__LINE__, 8.649120264278466e+26,	"8.65E+26", "%1.3G",
__LINE__, 8.649745523383894e+06,	"8.649746e+06", "%e",
__LINE__, 8.654720740091021e+16,	"8.65472e+16", "%g",
__LINE__, 8.655445556834509e-08,	"9e-08", "%4.g",
__LINE__, 8.658954696751902e+06,	"8.65895E+06", "%G",
__LINE__, 8.665712368800818e-10,	"+8.66571E-10", "%+G",
__LINE__, 8.666937057116442e-10,	"8.666937e-10", "%e",
__LINE__, 8.670981239765155e+05,	"867098", "%G",
__LINE__, 8.679631934294932e-25,	"+9.E-25", "%+#0.G",
__LINE__, 8.683595173050962e-21,	"8.68360E-21", "%#G",
__LINE__, 8.684938704958039e+25,	"8.684939E+25", "%E",
__LINE__, 8.686745463281227e-12,	"8.686745E-12", "%5.7G",
__LINE__, 8.700227628706534e-12,	"8.700228e-12", "%#e",
__LINE__, 8.705101179577200e+04,	"87051.011796", "%#2f",
__LINE__, 8.707824829984700e-24,	"9e-24", "%.1g",
__LINE__, 8.717654041009233e+21,	"+9E+21", "%+6.0E",
__LINE__, 8.741736299906572e-11,	"8.74174E-11", "%#0G",
__LINE__, 8.742228350419966e+18,	"+8742228350419965821.060941", "%+f",
__LINE__, 8.743045146087558e-17,	"+8.74305E-17", "%+2G",
__LINE__, 8.747820269457588e+18,	"8.74782E+18", "%G",
__LINE__, 8.756274717008537e-28,	"8.756275E-28", "%E",
__LINE__, 8.769782309254687e-24,	"+8.769782E-24", "%+2.6E",
__LINE__, 8.788151659193398e-16,	" 9E-16", "%6.E",
__LINE__, 8.789514812202340e-07,	"9E-07", "%0.G",
__LINE__, 8.792657843164822e-07,	"8.79266e-07", "%0g",
__LINE__, 8.810976223440985e+05,	"881097.622344", "%f",
__LINE__, 8.822553973113614e+10,	"8.82255E+10", "%G",
__LINE__, 8.839440421530611e-04,	"0.000883944", "%G",
__LINE__, 8.842539073558434e-12,	"0", "%1.f",
__LINE__, 8.882818021261782e-13,	"+8.9e-13", "%+4.2g",
__LINE__, 8.899833909201039e+05,	"8.8998E+05", "%.5G",
__LINE__, 8.903167498000181e-13,	"9e-13", "%0.g",
__LINE__, 8.933727737932164e+09,	"+8933727738", "%+4.f",
__LINE__, 8.946226267100711e+06,	"8.946E+06", "%1.4G",
__LINE__, 8.953203780849794e-21,	"8.9532E-21", "%G",
__LINE__, 8.959934262635649e+28,	"+8.959934e+28", "%+e",
__LINE__, 8.969485341781558e-25,	"0.000000", "%#f",
__LINE__, 8.970058187654221e+02,	"897.005819", "%f",
__LINE__, 8.979846508565979e+02,	"8.979847E+02", "%E",
__LINE__, 8.984561117901212e+01,	"8.984561E+01", "%E",
__LINE__, 8.992157765875611e-12,	"8.99216e-12", "%g",
__LINE__, 9.004487016708012e+01,	"9.004487e+01", "%#e",
__LINE__, 9.007306978283218e-24,	"9.007307e-24", "%e",
__LINE__, 9.014546375043562e+17,	"901454637504356171.007203", "%#3f",
__LINE__, 9.028177786002161e-12,	"9.02818E-12", "%G",
__LINE__, 9.029635986381795e-02,	"0.09", "%.1g",
__LINE__, 9.032389962233431e-07,	"+0.000001", "%+f",
__LINE__, 9.038466945070887e+10,	"+9.038467E+10", "%+E",
__LINE__, 9.040166964322772e-27,	"9.04017e-27", "%g",
__LINE__, 9.044627673694681e-11,	"9.04463E-11", "%G",
__LINE__, 9.045906217628948e+17,	"904590621762894819.823941", "%1f",
__LINE__, 9.051764975661710e+11,	"9.05176e+11", "%#g",
__LINE__, 9.053142913711405e+29,	"9.053143e+29", "%#e",
__LINE__, 9.073185209160657e-19,	"+9.07319e-19", "%+g",
__LINE__, 9.074372574441451e+02,	"907.437", "%g",
__LINE__, 9.084624602048136e+08,	"9.084625E+08", "%E",
__LINE__, 9.088839346363631e+18,	"9.09e+18", "%.2e",
__LINE__, 9.091945159170871e-15,	"9.09195e-15", "%5g",
__LINE__, 9.115304318083716e+10,	"9.115304e+10", "%e",
__LINE__, 9.115978352902710e+28,	"9.11598E+28", "%G",
__LINE__, 9.121415008221017e-17,	"9.E-17", "%#6.G",
__LINE__, 9.127270978060388e+18,	"9.E+18", "%#5.G",
__LINE__, 9.143941729069086e+08,	"9.143942E+08", "%#E",
__LINE__, 9.162740105978580e-19,	" 9.E-19", "%#7.G",
__LINE__, 9.221509957559626e-18,	"9.22151e-18", "%g",
__LINE__, 9.227419774250317e-28,	" 0.", "%#3.f",
__LINE__, 9.230846660807540e-21,	"0.000000", "%f",
__LINE__, 9.238091727277130e-06,	"+0.00001", "%+.5f",
__LINE__, 9.244337357684406e+10,	"9E+10", "%5.G",
__LINE__, 9.259179793993285e-19,	"  9E-19", "%7.0G",
__LINE__, 9.274068541525759e-17,	"9.274069e-17", "%e",
__LINE__, 9.283833535882367e+16,	"9.28383e+16", "%#g",
__LINE__, 9.295693096364605e+11,	"+9.295693E+11", "%+E",
__LINE__, 9.301820438602407e+05,	"930182", "%G",
__LINE__, 9.322805251555376e-29,	"9e-29", "%1.e",
__LINE__, 9.358443042421307e-27,	"9.35844e-27", "%g",
__LINE__, 9.372658444745124e-23,	"9.372658e-23", "%e",
__LINE__, 9.380302971355292e+05,	"938030.3", "%.7g",
__LINE__, 9.381976354968076e-26,	"+9.382E-26", "%+5.4G",
__LINE__, 9.391072061980585e-15,	"9.391072E-15", "%E",
__LINE__, 9.403554117166546e-06,	"0.000009", "%f",
__LINE__, 9.403712900426614e-28,	"9.40371e-28", "%g",
__LINE__, 9.419046629820578e+03,	"9419.046630", "%f",
__LINE__, 9.422344695378412e+22,	"94223446953784115720509.362291", "%f",
__LINE__, 9.433327680467576e+01,	"9.433328e+01", "%e",
__LINE__, 9.443975205260596e+20,	"9.44398e+20", "%g",
__LINE__, 9.445134851965593e-04,	"+9.445135E-04", "%+E",
__LINE__, 9.448403585149890e+24,	"9e+24", "%0.g",
__LINE__, 9.463149430113036e+18,	"9.46315e+18", "%g",
__LINE__, 9.465735160722534e+27,	"+9465735160722534402566452627.070248", "%+f",
__LINE__, 9.495210794344892e-04,	"0.000950", "%f",
__LINE__, 9.501916506373814e-25,	"9.50192E-25", "%#G",
__LINE__, 9.514641335897739e+29,	"9.51464E+29", "%G",
__LINE__, 9.524633436992819e-04,	" 0.001", "%6.G",
__LINE__, 9.530925101873022e-18,	"9.530925e-18", "%2e",
__LINE__, 9.557903833216979e-22,	"9.557904E-22", "%E",
__LINE__, 9.587709102390903e-01,	" 1", "%2.f",
__LINE__, 9.592723000828453e-02,	"9.592723E-02", "%5E",
__LINE__, 9.603430008794172e+27,	"9.60343e+27", "%g",
__LINE__, 9.622648414989433e-18,	"9.622648e-18", "%1e",
__LINE__, 9.633326171289319e-23,	"9.633326e-23", "%e",
__LINE__, 9.662064616152408e+19,	"96620646161524081918.5146393", "%1.7f",
__LINE__, 9.668544846563163e-23,	"9.668545e-23", "%e",
__LINE__, 9.691014191346685e+28,	"9.69101E+28", "%G",
__LINE__, 9.693075414840598e+02,	"+969.308", "%+G",
__LINE__, 9.695013453291907e-30,	"9.695013e-30", "%5e",
__LINE__, 9.705983477801926e-24,	"9.70598e-24", "%g",
__LINE__, 9.709022568030226e-17,	"0.000000", "%f",
__LINE__, 9.715194901854826e+20,	"9.715195e+20", "%e",
__LINE__, 9.721011821337717e+16,	"1E+17", "%0.G",
__LINE__, 9.734895542899672e+14,	"9.734896e+14", "%e",
__LINE__, 9.741486438769710e-29,	" 1e-28", "%6.g",
__LINE__, 9.766657482315475e-24,	"9.76666E-24", "%7G",
__LINE__, 9.767283293054552e-02,	"0.09767", "%5.5f",
__LINE__, 9.769553159146005e-20,	"9.76955E-20", "%G",
__LINE__, 9.777220880605434e-10,	"0.00", "%4.2f",
__LINE__, 9.790290569034575e+20,	"979029056903457473027.", "%#6.f",
__LINE__, 9.793128245822718e-01,	"0.979313", "%G",
__LINE__, 9.804758536498200e+08,	"980475853.650", "%.3f",
__LINE__, 9.816883664191066e-02,	"0.1", "%.0g",
__LINE__, 9.836109821010300e+25,	"9.83611e+25", "%g",
__LINE__, 9.846197559631225e+03,	"1E+04", "%2.G",
__LINE__, 9.863289416819924e+12,	"9.86329e+12", "%g",
__LINE__, 9.865893798657353e+12,	"9.866e+12", "%0.4g",
__LINE__, 9.868248446640862e-15,	"0.000000", "%#f",
__LINE__, 9.869973080775134e+04,	"98699.7", "%G",
__LINE__, 9.899444006312953e+20,	"1E+21", "%.1G",
__LINE__, 9.904083146074285e-08,	"9.904083e-08", "%6e",
__LINE__, 9.909790408255471e+15,	"9909790408255471.305665", "%f",
__LINE__, 9.930297455798394e-13,	"+9.930297E-13", "%+5.6E",
__LINE__, 9.933314448709083e-15,	"9.93331E-15", "%#.6G",
__LINE__, 9.938714530509870e+29,	"9.938715e+29", "%e",
__LINE__, 9.953892603540162e+07,	"9.95389E+07", "%G",
__LINE__, 9.962084643867200e+14,	"+996208464386720.038419", "%+f",
__LINE__, 9.977706708809947e-09,	"9.9777E-09", "%#.4E",
#endif
__LINE__, 9.978034352999867e+15,	"9.978034e+15", "%2.6e",
__LINE__, 9.998315286730175e-30,	"9.998315e-30", "%6e",

0
};

/* matches(s1, s2) is true if s1 is "approximately" equal to s2.
   Any digits after the first required_precision digits do not have to match.
 */

int required_precision = 13;

#if defined(__STDC__) || defined(__cplusplus)
int matches(register char *result, register char *desired)
#else
int matches(result, desired)
     register char *result; register char *desired;
#endif
{
    int digits_seen = 0;
    for (;; result++, desired++) {
	if (*result == *desired) {
	    if (*result == 0)
		return 1;
	    else if (*result >= '0' && *result <= '9')
		digits_seen++;
	}
	else if (digits_seen >= required_precision
		 && *result >= '0' && *result <= '9'
		 && *desired >= '0' && *desired <= '9')
	    continue;
	else
	    return 0;
    }
}

extern void dump_stats();

int main()
{
  int errcount = 0;
  int testcount = 0;
  double d;
#define BSIZE 1024
  char buffer[BSIZE];
  sprint_double_type *dptr;

  /* This test demands more precision than a 32bit floating
     point format can provide.  So only run it if doubles
     are last least 64bits wide.  */
  if (sizeof (double) < 8)
    exit (0);

#if defined(__cplusplus) && !defined(TEST_LIBIO)

  strstream sstr(buffer, BSIZE, ios::in|ios::out);

  for (dptr = sprint_doubles; dptr->line; dptr++)
    {

#ifdef SLOW_SIMULATOR
      /* We only run half the tests if we have a slow simulator to
	 avoid dejagnu timeouts.  */
      if (testcount % 2)
	{
	  testcount++;
	  continue;
	}
#endif

      sstr.seekp(0);
      sstr.form(dptr->format_string, dptr->value);
      sstr << ends;
      if (!matches(buffer, dptr->result))
	{
	  errcount++;
	  cerr << "Error in line " << dptr->line;
	  cerr << " using \"" << dptr->format_string;
	  cerr << "\".  Result is \"" << buffer << "\"; should be: \"";
	  cerr << dptr->result << "\".\n";
	}

#ifdef TEST_EXACTNESS
      sstr.seekp(0);
      sstr.form("%.999g", dptr->value);
      sstr << ends;

      sstr.seekg(0);
      sstr.scan("%lg", &d);

      if (dptr->value != d)
	{
	  errcount++;
	  cerr << "Error in line " << dptr->line;
	  cerr << ".  String is \"" << buffer << "\", value is " << d << ".\n";
	}
#endif
      testcount++;
    }

#ifdef SLOW_SIMULATOR
  testcount /= 2;
#endif

  if (errcount == 0)
    {
      cerr << "Encountered no errors in " << testcount << " tests.\n";
      return 0;
    }
  else
    {
      cerr << "Encountered " << errcount << " errors in "
	<< testcount << " tests.\n";
      return 1;
    }
#else
  for (dptr = sprint_doubles; dptr->line; dptr++)
    {
#ifdef SLOW_SIMULATOR
      /* We only run half the tests if we have a slow simulator to
	 avoid dejagnu timeouts.  */
      if (testcount % 2)
	{
	  testcount++;
	  continue;
	}
#endif

      sprintf (buffer, dptr->format_string, dptr->value);
      if (!matches(buffer, dptr->result))
	{
	  errcount++;
	  fprintf(stderr,
   "Error in line %d using \"%s\".  Result is \"%s\"; should be: \"%s\".\n",
		  dptr->line, dptr->format_string, buffer, dptr->result);
	}

#ifdef TEST_EXACTNESS
      sprintf (buffer, "%.999g", dptr->value);
      sscanf (buffer, "%lg", &d);
      if (dptr->value != d)
	{
	  errcount++;
	  fprintf (stderr,
		   "Error in line %d.  String is \"%s\", value is %g.\n",
		   dptr->line, buffer, d);
	}
#endif
      testcount++;
    }

#ifdef SLOW_SIMULATOR
  testcount /= 2;
#endif

  if (errcount == 0)
    {
      fprintf(stderr, "Encountered no errors in %d tests.\n", testcount);
      return 0;
    }
  else
    {
      fprintf(stderr, "Encountered %d errors in %d tests.\n",
	      errcount, testcount);
      return 1;
    }
#endif
}
